/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.layoutsupport.DefaultLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class LayoutSupportRegistry {
    private static HashMap containerToLayoutDelegate;
    private static HashMap layoutToLayoutDelegate;
    private static boolean needPaletteRescan;
    public static final String DEFAULT_SUPPORT = "<default>";
    private static DataFolder paletteFolder;
    private static FileChangeListener paletteListener;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$netbeans$modules$form$layoutsupport$LayoutSupportDelegate;
    static /* synthetic */ Class class$java$awt$LayoutManager;
    static /* synthetic */ Class class$java$awt$Container;

    public static Class getSupportClassForContainer(Class containerClass) {
        String className = (String)LayoutSupportRegistry.getContainersMap().get(containerClass.getName());
        if (className == null) {
            className = LayoutSupportRegistry.findSuperClass(LayoutSupportRegistry.getContainersMap(), containerClass);
        }
        if (className != null) {
            try {
                return LayoutSupportRegistry.loadClass(className);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getSupportNameForContainer(String containerClassName) {
        String className = (String)LayoutSupportRegistry.getContainersMap().get(containerClassName);
        if (className == null) {
            Class containerClass;
            try {
                containerClass = LayoutSupportRegistry.loadClass(containerClassName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            className = LayoutSupportRegistry.findSuperClass(LayoutSupportRegistry.getContainersMap(), containerClass);
        }
        return className;
    }

    public static Class getSupportClassForLayout(Class layoutClass) {
        String className = (String)LayoutSupportRegistry.getLayoutsMap().get(layoutClass.getName());
        if (className == null && (className = LayoutSupportRegistry.findSuperClass(LayoutSupportRegistry.getLayoutsMap(), layoutClass)) == null && needPaletteRescan && (className = LayoutSupportRegistry.scanPalette(layoutClass.getName())) == null) {
            className = LayoutSupportRegistry.findSuperClass(LayoutSupportRegistry.getContainersMap(), layoutClass);
        }
        if (className != null) {
            try {
                return LayoutSupportRegistry.loadClass(className);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getSupportNameForLayout(String layoutClassName) {
        String className = (String)LayoutSupportRegistry.getLayoutsMap().get(layoutClassName);
        if (className == null) {
            Class layoutClass;
            try {
                layoutClass = LayoutSupportRegistry.loadClass(layoutClassName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            className = LayoutSupportRegistry.findSuperClass(LayoutSupportRegistry.getLayoutsMap(), layoutClass);
            if (className == null && needPaletteRescan && (className = LayoutSupportRegistry.scanPalette(layoutClassName)) == null) {
                className = LayoutSupportRegistry.findSuperClass(LayoutSupportRegistry.getContainersMap(), layoutClass);
            }
        }
        return className;
    }

    public static void registerSupportForContainer(Class containerClass, Class layoutDelegateClass) {
        LayoutSupportRegistry.getContainersMap().put(containerClass.getName(), layoutDelegateClass.getName());
    }

    public static void registerSupportForContainer(String containerClassName, String layoutDelegateClassName) {
        LayoutSupportRegistry.getContainersMap().put(containerClassName, layoutDelegateClassName);
    }

    public static void registertSupportForLayout(Class layoutClass, Class layoutDelegateClass) {
        LayoutSupportRegistry.getLayoutsMap().put(layoutClass.getName(), layoutDelegateClass.getName());
    }

    public static void registerSupportForLayout(String layoutClassName, String layoutDelegateClassName) {
        LayoutSupportRegistry.getLayoutsMap().put(layoutClassName, layoutDelegateClassName);
    }

    public static LayoutSupportDelegate createSupportForContainer(Class containerClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class delegateClass = LayoutSupportRegistry.getSupportClassForContainer(containerClass);
        if (delegateClass == null) {
            return null;
        }
        return (LayoutSupportDelegate)delegateClass.newInstance();
    }

    public static LayoutSupportDelegate createSupportForLayout(Class layoutClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String delegateClassName = LayoutSupportRegistry.getSupportNameForLayout(layoutClass.getName());
        if (delegateClassName == null) {
            return null;
        }
        if (delegateClassName == DEFAULT_SUPPORT) {
            return new DefaultLayoutSupport(layoutClass);
        }
        return (LayoutSupportDelegate)LayoutSupportRegistry.loadClass(delegateClassName).newInstance();
    }

    public static LayoutSupportDelegate createSupportInstance(Class layoutDelegateClass) throws InstantiationException, IllegalAccessException {
        return (LayoutSupportDelegate)layoutDelegateClass.newInstance();
    }

    private static String findSuperClass(Map map, Class subClass) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry en = it.next();
            String className = (String)en.getKey();
            try {
                Class keyClass = LayoutSupportRegistry.loadClass(className);
                if (!keyClass.isAssignableFrom(subClass)) continue;
                return (String)en.getValue();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static String scanPalette(String wantedClassName) {
        boolean newPaletteListener;
        if (LayoutSupportRegistry.getPaletteFolder() == null) {
            return null;
        }
        boolean bl = newPaletteListener = paletteListener == null;
        if (newPaletteListener) {
            paletteListener = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fe) {
                    needPaletteRescan = true;
                }

                public void fileFolderCreated(FileEvent fe) {
                    needPaletteRescan = true;
                    fe.getFile().addFileChangeListener((FileChangeListener)this);
                }

                public void fileDeleted(FileEvent fe) {
                    fe.getFile().removeFileChangeListener((FileChangeListener)this);
                }
            };
            paletteFolder.getPrimaryFile().addFileChangeListener(paletteListener);
        }
        String foundSupportClassName = null;
        DataObject[] paletteCategories = paletteFolder.getChildren();
        int i = 0;
        while (i < paletteCategories.length) {
            block19: {
                DataFolder categoryFolder;
                DataFolder dataFolder = categoryFolder = paletteCategories[i] instanceof DataFolder ? (DataFolder)paletteCategories[i] : null;
                if (categoryFolder == null) break block19;
                if (newPaletteListener) {
                    categoryFolder.getPrimaryFile().addFileChangeListener(paletteListener);
                }
                DataObject[] items = categoryFolder.getChildren();
                int j = 0;
                while (j < items.length) {
                    block18: {
                        Map map;
                        Class supportedClass;
                        Class delegateClass;
                        block21: {
                            block20: {
                                block17: {
                                    InstanceCookie ic = (InstanceCookie)items[j].getCookie(class$org$openide$cookies$InstanceCookie == null ? LayoutSupportRegistry.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                                    if (ic == null) break block18;
                                    Class itemClass = null;
                                    try {
                                        itemClass = LayoutSupportRegistry.loadClass(ic.instanceClass().getName());
                                    }
                                    catch (Exception ex) {
                                        // empty catch block
                                    }
                                    if (itemClass == null) break block18;
                                    delegateClass = null;
                                    supportedClass = null;
                                    if ((class$org$netbeans$modules$form$layoutsupport$LayoutSupportDelegate == null ? LayoutSupportRegistry.class$("org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate") : class$org$netbeans$modules$form$layoutsupport$LayoutSupportDelegate).isAssignableFrom(itemClass)) {
                                        delegateClass = itemClass;
                                        try {
                                            LayoutSupportDelegate delegate = (LayoutSupportDelegate)delegateClass.newInstance();
                                            supportedClass = delegate.getSupportedClass();
                                            break block17;
                                        }
                                        catch (Exception ex) {
                                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                                            break block18;
                                        }
                                    }
                                    if ((class$java$awt$LayoutManager == null ? LayoutSupportRegistry.class$("java.awt.LayoutManager") : class$java$awt$LayoutManager).isAssignableFrom(itemClass)) {
                                        supportedClass = itemClass;
                                    }
                                }
                                if (supportedClass == null) break block18;
                                if (!(class$java$awt$Container == null ? LayoutSupportRegistry.class$("java.awt.Container") : class$java$awt$Container).isAssignableFrom(supportedClass)) break block20;
                                map = LayoutSupportRegistry.getContainersMap();
                                break block21;
                            }
                            if (!(class$java$awt$LayoutManager == null ? LayoutSupportRegistry.class$("java.awt.LayoutManager") : class$java$awt$LayoutManager).isAssignableFrom(supportedClass)) break block18;
                            map = LayoutSupportRegistry.getLayoutsMap();
                        }
                        String supportedClassName = supportedClass.getName();
                        if (map.get(supportedClassName) == null) {
                            String delegateClassName = delegateClass != null ? delegateClass.getName() : DEFAULT_SUPPORT;
                            map.put(supportedClassName, delegateClassName);
                            if (supportedClassName.equals(wantedClassName)) {
                                foundSupportClassName = delegateClassName;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        needPaletteRescan = false;
        return foundSupportClassName;
    }

    private static DataFolder getPaletteFolder() {
        FileObject fo;
        if (paletteFolder == null && (fo = Repository.getDefault().getDefaultFileSystem().findResource("Palette")) != null) {
            paletteFolder = DataFolder.findFolder((FileObject)fo);
        }
        return paletteFolder;
    }

    private static Class loadClass(String className) throws ClassNotFoundException {
        return FormUtils.getClassLoader().loadClass(className);
    }

    private static Map getContainersMap() {
        if (containerToLayoutDelegate == null) {
            containerToLayoutDelegate = new HashMap();
            containerToLayoutDelegate.put("javax.swing.JScrollPane", "org.netbeans.modules.form.layoutsupport.delegates.JScrollPaneSupport");
            containerToLayoutDelegate.put("java.awt.ScrollPane", "org.netbeans.modules.form.layoutsupport.delegates.ScrollPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JSplitPane", "org.netbeans.modules.form.layoutsupport.delegates.JSplitPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JTabbedPane", "org.netbeans.modules.form.layoutsupport.delegates.JTabbedPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JLayeredPane", "org.netbeans.modules.form.layoutsupport.delegates.JLayeredPaneSupport");
            containerToLayoutDelegate.put("javax.swing.JToolBar", "org.netbeans.modules.form.layoutsupport.delegates.JToolBarSupport");
        }
        return containerToLayoutDelegate;
    }

    private static Map getLayoutsMap() {
        if (layoutToLayoutDelegate == null) {
            layoutToLayoutDelegate = new HashMap();
            layoutToLayoutDelegate.put("java.awt.BorderLayout", "org.netbeans.modules.form.layoutsupport.delegates.BorderLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.FlowLayout", "org.netbeans.modules.form.layoutsupport.delegates.FlowLayoutSupport");
            layoutToLayoutDelegate.put("javax.swing.BoxLayout", "org.netbeans.modules.form.layoutsupport.delegates.BoxLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.GridBagLayout", "org.netbeans.modules.form.layoutsupport.delegates.GridBagLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.GridLayout", "org.netbeans.modules.form.layoutsupport.delegates.GridLayoutSupport");
            layoutToLayoutDelegate.put("java.awt.CardLayout", "org.netbeans.modules.form.layoutsupport.delegates.CardLayoutSupport");
            layoutToLayoutDelegate.put("org.netbeans.lib.awtextra.AbsoluteLayout", "org.netbeans.modules.form.layoutsupport.delegates.AbsoluteLayoutSupport");
        }
        return layoutToLayoutDelegate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        needPaletteRescan = true;
    }
}

