/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.FormCodeSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.openide.nodes.Node;

public class BoxLayoutSupport
extends AbstractLayoutSupport {
    private int axis = 0;
    private Node.PropertySet propertySet;
    private FormProperty[] properties;
    private static Constructor boxLayoutConstructor;
    static /* synthetic */ Class class$javax$swing$BoxLayout;
    static /* synthetic */ Class class$java$awt$Container;

    public Class getSupportedClass() {
        return class$javax$swing$BoxLayout == null ? (class$javax$swing$BoxLayout = BoxLayoutSupport.class$("javax.swing.BoxLayout")) : class$javax$swing$BoxLayout;
    }

    public void acceptContainerLayoutChange(PropertyChangeEvent ev) throws PropertyVetoException {
        this.updateLayoutInstance();
        super.acceptContainerLayoutChange(ev);
    }

    public int getNewIndex(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        if (!(containerDelegate.getLayout() instanceof BoxLayout)) {
            return -1;
        }
        Component[] components = containerDelegate.getComponents();
        int i = 0;
        while (i < components.length) {
            Rectangle b = components[i].getBounds();
            if (this.axis == 0 ? posInCont.x < b.x + b.width / 2 : posInCont.y < b.y + b.height / 2) {
                return i;
            }
            ++i;
        }
        return components.length;
    }

    public boolean paintDragFeedback(Container container, Container containerDelegate, Component component, LayoutConstraints newConstraints, int newIndex, Graphics g) {
        Rectangle rect;
        if (!(containerDelegate.getLayout() instanceof BoxLayout)) {
            return false;
        }
        Component[] components = containerDelegate.getComponents();
        if (components.length == 0) {
            Insets ins = containerDelegate.getInsets();
            rect = this.axis == 0 ? new Rectangle(ins.left, ins.top + (containerDelegate.getHeight() - ins.top - ins.bottom - 20) / 2, 30, 20) : new Rectangle(ins.left + (containerDelegate.getWidth() - ins.left - ins.right - 30) / 2, ins.top, 30, 20);
        } else if (newIndex < 0 || newIndex >= components.length) {
            Rectangle b = components[components.length - 1].getBounds();
            rect = this.axis == 0 ? new Rectangle(b.x + b.width - 10, b.y, 20, b.height) : new Rectangle(b.x, b.y + b.height - 10, b.width, 20);
        } else {
            Rectangle b = components[newIndex].getBounds();
            rect = this.axis == 0 ? new Rectangle(b.x - 10, b.y, 20, b.height) : new Rectangle(b.x, b.y - 10, b.width, 20);
        }
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
        return true;
    }

    public void setLayoutToContainer(Container container, Container containerDelegate) {
        containerDelegate.setLayout(this.cloneLayoutInstance(container, containerDelegate));
    }

    protected LayoutManager createDefaultLayoutInstance() {
        return new BoxLayout(new JPanel(), 0);
    }

    protected LayoutManager cloneLayoutInstance(Container container, Container containerDelegate) {
        return new BoxLayout(containerDelegate, this.axis);
    }

    protected void readInitLayoutCode(CodeExpression layoutExp, CodeGroup layoutCode) {
        CodeExpression[] params = layoutExp.getOrigin().getCreationParameters();
        if (params.length == 2) {
            FormCodeSupport.readPropertyExpression(params[1], this.getProperties()[0], false);
            this.updateLayoutInstance();
        }
    }

    protected CodeExpression createInitLayoutCode(CodeGroup layoutCode) {
        CodeStructure codeStructure = this.getCodeStructure();
        CodeExpression[] params = new CodeExpression[]{this.getLayoutContext().getContainerDelegateCodeExpression(), codeStructure.createExpression(FormCodeSupport.createOrigin(this.getProperties()[0]))};
        return codeStructure.createExpression(BoxLayoutSupport.getBoxLayoutConstructor(), params);
    }

    protected FormProperty[] getProperties() {
        if (this.properties == null) {
            this.properties = new FormProperty[1];
            this.properties[0] = new FormProperty("axis", Integer.TYPE, AbstractLayoutSupport.getBundle().getString("PROP_axis"), AbstractLayoutSupport.getBundle().getString("HINT_axis")){

                public Object getTargetValue() {
                    return new Integer(BoxLayoutSupport.this.axis);
                }

                public void setTargetValue(Object value) {
                    int ax = (Integer)value;
                    if (ax == 0 || ax == 1) {
                        BoxLayoutSupport.this.axis = ax;
                    }
                }

                public boolean supportsDefaultValue() {
                    return true;
                }

                public Object getDefaultValue() {
                    return new Integer(0);
                }

                public PropertyEditor getExpliciteEditor() {
                    return new BoxAxisEditor();
                }
            };
        }
        return this.properties;
    }

    protected Node.Property getProperty(String propName) {
        return "axis".equals(propName) ? this.getProperties()[0] : null;
    }

    private static Constructor getBoxLayoutConstructor() {
        if (boxLayoutConstructor == null) {
            try {
                boxLayoutConstructor = (class$javax$swing$BoxLayout == null ? (class$javax$swing$BoxLayout = BoxLayoutSupport.class$("javax.swing.BoxLayout")) : class$javax$swing$BoxLayout).getConstructor(class$java$awt$Container == null ? (class$java$awt$Container = BoxLayoutSupport.class$("java.awt.Container")) : class$java$awt$Container, Integer.TYPE);
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
        return boxLayoutConstructor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ ResourceBundle access$101() {
        return AbstractLayoutSupport.getBundle();
    }

    static /* synthetic */ ResourceBundle access$201() {
        return AbstractLayoutSupport.getBundle();
    }

    public static final class BoxAxisEditor
    extends PropertyEditorSupport {
        private final String[] tags = new String[]{BoxLayoutSupport.access$101().getString("VALUE_axis_x"), BoxLayoutSupport.access$201().getString("VALUE_axis_y")};
        private final Integer[] values = new Integer[]{new Integer(0), new Integer(1)};
        private final String[] javaInitStrings = new String[]{"javax.swing.BoxLayout.X_AXIS", "javax.swing.BoxLayout.Y_AXIS"};

        public String[] getTags() {
            return this.tags;
        }

        public String getAsText() {
            Object value = this.getValue();
            if (this.values[0].equals(value)) {
                return this.tags[0];
            }
            if (this.values[1].equals(value)) {
                return this.tags[1];
            }
            return null;
        }

        public void setAsText(String str) {
            if (this.tags[0].equals(str)) {
                this.setValue(this.values[0]);
            } else if (this.tags[1].equals(str)) {
                this.setValue(this.values[1]);
            }
        }

        public String getJavaInitializationString() {
            Object value = this.getValue();
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i].equals(value)) {
                    return this.javaInitStrings[i];
                }
                ++i;
            }
            return null;
        }
    }
}

