/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;

public class GridLayoutSupport
extends AbstractLayoutSupport {
    static /* synthetic */ Class class$java$awt$GridLayout;

    public Class getSupportedClass() {
        return class$java$awt$GridLayout == null ? (class$java$awt$GridLayout = GridLayoutSupport.class$("java.awt.GridLayout")) : class$java$awt$GridLayout;
    }

    public int getNewIndex(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        if (!(containerDelegate.getLayout() instanceof GridLayout)) {
            return -1;
        }
        Component[] components = containerDelegate.getComponents();
        GridLayout layout = (GridLayout)containerDelegate.getLayout();
        int nrows = layout.getRows();
        int ncols = layout.getColumns();
        if (nrows <= 0 && ncols <= 0 || components.length == 0) {
            return components.length;
        }
        if (nrows != 0) {
            ncols = (components.length + nrows - 1) / nrows;
        } else {
            nrows = (components.length + ncols - 1) / ncols;
        }
        Dimension sz = containerDelegate.getSize();
        Insets insets = containerDelegate.getInsets();
        sz.width -= insets.left + insets.right;
        sz.height -= insets.top + insets.bottom;
        int colwidth = sz.width / ncols;
        if (colwidth <= 0) {
            return components.length;
        }
        int col = (posInCont.x - insets.left + colwidth / 2) / colwidth;
        int rowheight = sz.height / nrows;
        if (rowheight <= 0) {
            return components.length;
        }
        int row = (posInCont.y - insets.top) / rowheight;
        int newIndex = row * ncols + col;
        return newIndex >= components.length ? components.length : newIndex;
    }

    public boolean paintDragFeedback(Container container, Container containerDelegate, Component component, LayoutConstraints newConstraints, int newIndex, Graphics g) {
        if (!(containerDelegate.getLayout() instanceof GridLayout)) {
            return false;
        }
        Component[] components = containerDelegate.getComponents();
        GridLayout layout = (GridLayout)containerDelegate.getLayout();
        int dx = 12 + layout.getHgap() / 2;
        int x = 0;
        int w = 24;
        int y = 0;
        int h = 0;
        if (newIndex <= 0) {
            if (components.length > 0) {
                Rectangle b = components[0].getBounds();
                x = b.x - dx;
                y = b.y;
                h = b.height;
            } else {
                Insets ins = containerDelegate.getInsets();
                x = ins.left + 1;
                w = containerDelegate.getWidth() - ins.right - ins.left - 2;
                y = ins.top + 1;
                h = containerDelegate.getHeight() - ins.bottom - ins.top - 2;
            }
        } else if (newIndex >= components.length) {
            Rectangle b = components[components.length - 1].getBounds();
            x = b.x + b.width - dx;
            y = b.y;
            h = b.height;
        } else {
            Rectangle b = components[newIndex].getBounds();
            x = b.x - dx;
            y = b.y;
            h = b.height;
        }
        g.drawRect(x, y, w, h);
        return true;
    }

    protected void readInitLayoutCode(CodeExpression layoutExp, CodeGroup initLayoutCode) {
        Object rowsValue;
        CodeExpression[] params = layoutExp.getOrigin().getCreationParameters();
        if (params.length > 0 && (rowsValue = params[0].getOrigin().getValue()) instanceof Integer && (Integer)rowsValue == 0) {
            try {
                this.getProperty("columns").setValue((Object)new Integer(1));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        super.readInitLayoutCode(layoutExp, initLayoutCode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

