/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.form.palette.AlignedListUI;

public class AlignedList
extends JList {
    public static final int HORIZONTAL_ALIGN_STYLE = 0;
    public static final int VERTICAL_ALIGN_STYLE = 1;
    private int rolloverIndex = -1;
    private int alignStyle = 1;
    private int visibleColumnCount = 8;

    public AlignedList() {
    }

    public AlignedList(Object[] items) {
        super(items);
    }

    public void updateUI() {
        this.setUI(new AlignedListUI());
        this.invalidate();
    }

    public void setRolloverIndex(int index) {
        int oldValue = this.rolloverIndex;
        this.rolloverIndex = index;
        this.firePropertyChange("rolloverIndex", oldValue, this.rolloverIndex);
    }

    public int getRolloverIndex() {
        return this.rolloverIndex;
    }

    public void setAlignStyle(int style) {
        switch (style) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid alignStyle");
            }
        }
        int oldValue = this.alignStyle;
        this.alignStyle = style;
        this.firePropertyChange("alignStyle", oldValue, this.alignStyle);
    }

    public int getAlignStyle() {
        return this.alignStyle;
    }

    public void setVisibleColumnCount(int columnCount) {
        int oldValue = this.visibleColumnCount;
        this.visibleColumnCount = Math.max(0, columnCount);
        this.firePropertyChange("visibleColumnCount", oldValue, this.visibleColumnCount);
    }

    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public String getToolTipText(MouseEvent event) {
        if (event != null) {
            Component rendererComp;
            Point p = event.getPoint();
            int index = this.locationToIndex(p);
            ListCellRenderer renderer = this.getCellRenderer();
            if (index != -1 && renderer != null && (rendererComp = renderer.getListCellRendererComponent(this, this.getModel().getElementAt(index), index, this.isSelectedIndex(index), this.hasFocus() && index == this.getLeadSelectionIndex())) instanceof JComponent) {
                Rectangle cellBounds = this.getCellBounds(index, index);
                p.translate(-cellBounds.x, -cellBounds.y);
                MouseEvent newEvent = new MouseEvent(rendererComp, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
                return ((JComponent)rendererComp).getToolTipText(newEvent);
            }
        }
        return null;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.alignStyle == 0) {
            return true;
        }
        return super.getScrollableTracksViewportWidth();
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.alignStyle == 1) {
            return true;
        }
        return super.getScrollableTracksViewportHeight();
    }

    public Dimension getPreferredScrollableViewportSize() {
        Insets insets = this.getInsets();
        int dx = insets.left + insets.right;
        int dy = insets.top + insets.bottom;
        int visibleRowCount = this.getVisibleRowCount();
        int visibleColumnCount = this.getVisibleColumnCount();
        int fixedCellWidth = this.getFixedCellWidth();
        int fixedCellHeight = this.getFixedCellHeight();
        if (fixedCellWidth > 0 && fixedCellHeight > 0) {
            int width = visibleColumnCount * fixedCellWidth + dx;
            int height = visibleRowCount * fixedCellHeight + dy;
            return new Dimension(width, height);
        }
        if (this.getModel().getSize() > 0) {
            Rectangle r = this.getCellBounds(0, 0);
            int width = visibleColumnCount * r.width + dx;
            int height = visibleRowCount * r.height + dy;
            return new Dimension(width, height);
        }
        fixedCellWidth = fixedCellWidth > 0 ? fixedCellWidth : 256;
        fixedCellHeight = fixedCellHeight > 0 ? fixedCellHeight : 16;
        return new Dimension(fixedCellWidth * visibleColumnCount, fixedCellHeight * visibleRowCount);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int index = this.getFirstVisibleIndex();
        Rectangle r = this.getCellBounds(index, index);
        if (r == null) {
            return 0;
        }
        int increment = 0;
        increment = orientation == 0 ? r.width : r.height;
        return increment;
    }
}

