/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import org.netbeans.modules.form.palette.AlignedList;

public class AlignedListUI
extends BasicListUI {
    int lastDimension;
    int rowCount;
    int columnCount;

    public void paint(Graphics g, JComponent c) {
        int firstIndex;
        Rectangle rowBounds;
        this.maybeUpdateLayoutState();
        ListCellRenderer<Object> renderer = this.list.getCellRenderer();
        ListModel<Object> dataModel = this.list.getModel();
        ListSelectionModel selModel = this.list.getSelectionModel();
        if (renderer == null || dataModel.getSize() == 0) {
            return;
        }
        Rectangle paintBounds = g.getClipBounds();
        int firstPaintRow = this.convertYToRow(paintBounds.y);
        int lastPaintRow = this.convertYToRow(paintBounds.y + paintBounds.height - 1);
        int firstPaintColumn = this.convertXToColumn(paintBounds.x);
        int lastPaintColumn = this.convertXToColumn(paintBounds.x + paintBounds.width - 1);
        if (firstPaintRow == -1) {
            firstPaintRow = 0;
        }
        if (lastPaintRow == -1) {
            lastPaintRow = this.rowCount - 1;
        }
        if (firstPaintColumn == -1) {
            firstPaintColumn = 0;
        }
        if (lastPaintColumn == -1) {
            lastPaintColumn = this.columnCount - 1;
        }
        if ((rowBounds = this.getCellBounds((JList)this.list, firstIndex = this.convertCellToIndex(firstPaintColumn, firstPaintRow), firstIndex)) == null) {
            return;
        }
        int leadIndex = this.list.getLeadSelectionIndex();
        int rowStart = rowBounds.y;
        int column = firstPaintColumn;
        while (column <= lastPaintColumn) {
            int row = firstPaintRow;
            while (row <= lastPaintRow) {
                int index = this.convertCellToIndex(column, row);
                if (index == -1) break;
                rowBounds.height = this.getRowHeight(row);
                g.setClip(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
                g.clipRect(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                this.paintCell(g, index, rowBounds, renderer, dataModel, selModel, leadIndex);
                rowBounds.y += rowBounds.height;
                ++row;
            }
            rowBounds.y = rowStart;
            rowBounds.width = this.getColumnWidth(column);
            rowBounds.x += rowBounds.width;
            ++column;
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        this.maybeUpdateLayoutState();
        int lastIndex = this.list.getModel().getSize() - 1;
        if (lastIndex < 0) {
            return new Dimension(0, 0);
        }
        Insets insets = this.list.getInsets();
        return new Dimension(this.columnCount * this.cellWidth + insets.left + insets.right, this.rowCount * this.cellHeight + insets.top + insets.bottom);
    }

    public static ComponentUI createUI(JComponent list) {
        return new AlignedListUI();
    }

    public int locationToIndex(JList list, Point location) {
        this.maybeUpdateLayoutState();
        return this.convertCellToIndex(this.convertXToColumn(location.x), this.convertYToRow(location.y));
    }

    public Point indexToLocation(JList list, int index) {
        this.maybeUpdateLayoutState();
        int x = this.convertColumnToX(this.convertIndexToColumn(index));
        int y = this.convertRowToY(this.convertIndexToRow(index));
        return y == -1 || x == -1 ? null : new Point(x, y);
    }

    public Rectangle getCellBounds(JList list, int index1, int index2) {
        this.maybeUpdateLayoutState();
        int minIndex = Math.min(index1, index2);
        int maxIndex = Math.max(index1, index2);
        int minY = this.convertRowToY(this.convertIndexToRow(minIndex));
        int maxY = this.convertRowToY(this.convertIndexToRow(maxIndex));
        int minX = this.convertColumnToX(this.convertIndexToColumn(minIndex));
        int maxX = this.convertColumnToX(this.convertIndexToColumn(maxIndex));
        if (minY == -1 || maxY == -1 || minX == -1 || maxX == -1) {
            return null;
        }
        Insets insets = list.getInsets();
        int x = minX;
        int y = minY;
        int w = maxX + this.getColumnWidth(this.convertIndexToColumn(maxIndex)) - minX;
        int h = maxY + this.getRowHeight(this.convertIndexToRow(maxIndex)) - minY;
        return new Rectangle(x, y, w, h);
    }

    protected int getRowHeight(int row) {
        if (row < 0 || row >= this.rowCount) {
            return -1;
        }
        return this.cellHeight;
    }

    protected int getColumnWidth(int column) {
        if (column < 0 || column >= this.columnCount) {
            return -1;
        }
        return this.cellWidth;
    }

    protected int convertIndexToRow(int index) {
        if (index < 0 || index >= this.list.getModel().getSize()) {
            return -1;
        }
        if (((AlignedList)this.list).getAlignStyle() == 1) {
            return this.rowCount <= 0 ? -1 : index % this.rowCount;
        }
        return this.columnCount <= 0 ? -1 : index / this.columnCount;
    }

    protected int convertIndexToColumn(int index) {
        if (index < 0 || index >= this.list.getModel().getSize()) {
            return -1;
        }
        if (((AlignedList)this.list).getAlignStyle() == 1) {
            return this.rowCount <= 0 ? -1 : index / this.rowCount;
        }
        return this.columnCount <= 0 ? -1 : index % this.columnCount;
    }

    protected int convertCellToIndex(int column, int row) {
        if (column < 0 || column >= this.columnCount || row < 0 || row >= this.rowCount) {
            return -1;
        }
        int index = ((AlignedList)this.list).getAlignStyle() == 1 ? column * this.rowCount + row : row * this.columnCount + column;
        return index < this.list.getModel().getSize() ? index : -1;
    }

    protected int convertYToRow(int y0) {
        if (y0 < 0) {
            return -1;
        }
        int row = this.cellHeight == 0 ? -1 : (y0 - this.list.getInsets().top) / this.cellHeight;
        return row >= 0 && row < this.rowCount ? row : -1;
    }

    protected int convertXToColumn(int x0) {
        if (x0 < 0) {
            return -1;
        }
        int column = this.cellWidth == 0 ? -1 : (x0 - this.list.getInsets().left) / this.cellWidth;
        return column >= 0 && column < this.columnCount ? column : -1;
    }

    protected int convertRowToY(int row) {
        if (row < 0 || row >= this.rowCount) {
            return -1;
        }
        return this.list.getInsets().top + row * this.cellHeight;
    }

    protected int convertColumnToX(int column) {
        if (column < 0 || column >= this.columnCount) {
            return -1;
        }
        return this.list.getInsets().left + column * this.cellWidth;
    }

    protected void maybeUpdateLayoutState() {
        int newDimension;
        int n = newDimension = ((AlignedList)this.list).getAlignStyle() == 1 ? this.list.getHeight() : this.list.getWidth();
        if (this.lastDimension != newDimension) {
            this.lastDimension = newDimension;
            this.updateLayoutState();
        } else {
            super.maybeUpdateLayoutState();
        }
    }

    protected void updateLayoutState() {
        int fixedCellHeight = this.list.getFixedCellHeight();
        int fixedCellWidth = this.list.getFixedCellWidth();
        this.cellWidth = fixedCellWidth != -1 ? fixedCellWidth : -1;
        this.cellHeight = fixedCellHeight != -1 ? fixedCellHeight : -1;
        this.cellHeight = fixedCellHeight != -1 ? fixedCellHeight : -1;
        this.cellHeight = fixedCellWidth != -1 ? fixedCellWidth : -1;
        if (fixedCellWidth == -1 || fixedCellHeight == -1) {
            ListModel<Object> dataModel = this.list.getModel();
            int dataModelSize = dataModel.getSize();
            ListCellRenderer<Object> renderer = this.list.getCellRenderer();
            if (renderer != null) {
                int index = 0;
                while (index < dataModelSize) {
                    Object value = dataModel.getElementAt(index);
                    Component c = renderer.getListCellRendererComponent(this.list, value, index, false, false);
                    this.rendererPane.add(c);
                    Dimension cellSize = c.getPreferredSize();
                    if (fixedCellWidth == -1) {
                        this.cellWidth = Math.max(cellSize.width, this.cellWidth);
                    }
                    if (fixedCellHeight == -1) {
                        this.cellHeight = Math.max(cellSize.height, this.cellHeight);
                    }
                    ++index;
                }
            } else {
                if (this.cellWidth == -1) {
                    this.cellWidth = 0;
                }
                if (this.cellHeight == -1) {
                    this.cellHeight = 0;
                }
            }
        }
        if (this.updateAlignment()) {
            this.list.revalidate();
        } else {
            this.list.invalidate();
        }
    }

    private boolean updateAlignment() {
        int size = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        if (((AlignedList)this.list).getAlignStyle() == 1) {
            int listHeight = this.list.getHeight() - (insets.top + insets.bottom);
            this.rowCount = this.cellHeight <= 0 ? 0 : (listHeight < this.cellHeight ? 1 : listHeight / this.cellHeight);
            this.rowCount = Math.min(size, this.rowCount);
            int oldColumnCount = this.columnCount;
            this.columnCount = this.rowCount == 0 ? 0 : (size + this.rowCount - 1) / this.rowCount;
            return oldColumnCount != this.columnCount;
        }
        int listWidth = this.list.getWidth() - (insets.left + insets.right);
        this.columnCount = this.cellWidth <= 0 ? 0 : (listWidth < this.cellWidth ? 1 : listWidth / this.cellWidth);
        this.columnCount = Math.min(size, this.columnCount);
        int oldRowCount = this.rowCount;
        this.rowCount = this.columnCount == 0 ? 0 : (size + this.columnCount - 1) / this.columnCount;
        return oldRowCount != this.rowCount;
    }

    protected MouseInputListener createMouseInputListener() {
        return new AlignedListMouseInputHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new AlignedListSelectionHandler();
    }

    private void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    protected ListDataListener createListDataListener() {
        return new AlignedListDataHandler();
    }

    private void repaintList(int minIndex, int maxIndex) {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        minIndex = minIndex == -1 ? 0 : minIndex;
        int n = maxIndex = maxIndex == -1 ? this.list.getModel().getSize() - 1 : maxIndex;
        if (((AlignedList)this.list).getAlignStyle() == 1) {
            x = Math.max(0, this.convertColumnToX(this.convertIndexToColumn(minIndex)));
            int maxColumn = this.convertIndexToColumn(maxIndex);
            w = Math.min(this.list.getWidth(), this.convertColumnToX(maxColumn) + this.getColumnWidth(maxColumn)) - x;
            h = this.list.getHeight();
        } else {
            y = Math.max(0, this.convertRowToY(this.convertIndexToRow(minIndex)));
            int maxRow = this.convertIndexToRow(maxIndex);
            h = Math.min(this.list.getHeight(), this.convertRowToY(maxRow) + this.getRowHeight(maxRow)) - y;
            w = this.list.getWidth();
        }
        this.list.revalidate();
        this.list.repaint(x, y, w, h);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new AlignedListPropertyChangeHandler();
    }

    public class AlignedListPropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        public AlignedListPropertyChangeHandler() {
            super(AlignedListUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("rolloverIndex")) {
                int index0 = (Integer)e.getNewValue();
                int index1 = (Integer)e.getOldValue();
                AlignedListUI.this.repaintList(Math.min(index0, index1), Math.max(index0, index1));
            } else if (propertyName.equals("alignStyle")) {
                AlignedListUI.this.redrawList();
            } else {
                super.propertyChange(e);
            }
        }
    }

    public class AlignedListDataHandler
    extends BasicListUI.ListDataHandler {
        public AlignedListDataHandler() {
            super(AlignedListUI.this);
        }

        public void intervalAdded(ListDataEvent e) {
            AlignedListUI.this.updateLayoutStateNeeded = 1;
            int minIndex = Math.min(e.getIndex0(), e.getIndex1());
            int maxIndex = Math.max(e.getIndex0(), e.getIndex1());
            ListSelectionModel sm = AlignedListUI.this.list.getSelectionModel();
            if (sm != null) {
                sm.insertIndexInterval(minIndex, maxIndex - minIndex, true);
            }
            AlignedListUI.this.repaintList(minIndex, AlignedListUI.this.list.getModel().getSize() - 1);
        }

        public void intervalRemoved(ListDataEvent e) {
            AlignedListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel sm = AlignedListUI.this.list.getSelectionModel();
            if (sm != null) {
                sm.removeIndexInterval(e.getIndex0(), e.getIndex1());
            }
            AlignedListUI.this.repaintList(Math.min(e.getIndex0(), e.getIndex1()), AlignedListUI.this.list.getModel().getSize() - 1);
        }
    }

    public class AlignedListSelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            AlignedListUI.this.maybeUpdateLayoutState();
            AlignedListUI.this.repaintList(e.getFirstIndex(), e.getLastIndex());
        }
    }

    public class AlignedListMouseInputHandler
    extends BasicListUI.MouseInputHandler {
        public AlignedListMouseInputHandler() {
            super(AlignedListUI.this);
        }

        public void mousePressed(MouseEvent e) {
            int index;
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (!AlignedListUI.this.list.isEnabled()) {
                return;
            }
            if (!AlignedListUI.this.list.hasFocus()) {
                AlignedListUI.this.list.requestFocus();
            }
            if ((index = AlignedListUI.this.convertCellToIndex(AlignedListUI.this.convertXToColumn(e.getX()), AlignedListUI.this.convertYToRow(e.getY()))) != -1) {
                AlignedListUI.this.list.setValueIsAdjusting(true);
                int anchorIndex = AlignedListUI.this.list.getAnchorSelectionIndex();
                if (e.isControlDown()) {
                    if (AlignedListUI.this.list.isSelectedIndex(index)) {
                        AlignedListUI.this.list.removeSelectionInterval(index, index);
                    } else {
                        AlignedListUI.this.list.addSelectionInterval(index, index);
                    }
                } else if (e.isShiftDown() && anchorIndex != -1) {
                    AlignedListUI.this.list.setSelectionInterval(anchorIndex, index);
                } else {
                    AlignedListUI.this.list.setSelectionInterval(index, index);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            Rectangle cellBounds;
            if (!AlignedListUI.this.list.isEnabled()) {
                return;
            }
            ((AlignedList)AlignedListUI.this.list).setRolloverIndex(-1);
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (e.isShiftDown() || e.isControlDown()) {
                return;
            }
            int index = AlignedListUI.this.convertCellToIndex(AlignedListUI.this.convertXToColumn(e.getX()), AlignedListUI.this.convertYToRow(e.getY()));
            if (index != -1 && (cellBounds = AlignedListUI.this.getCellBounds(AlignedListUI.this.list, index, index)) != null) {
                AlignedListUI.this.list.scrollRectToVisible(cellBounds);
                AlignedListUI.this.list.setSelectionInterval(index, index);
            }
        }

        public void mouseMoved(MouseEvent e) {
            this.mouseEntered(e);
        }

        public void mouseEntered(MouseEvent e) {
            if (!AlignedListUI.this.list.isEnabled()) {
                return;
            }
            ((AlignedList)AlignedListUI.this.list).setRolloverIndex(AlignedListUI.this.locationToIndex(AlignedListUI.this.list, e.getPoint()));
        }

        public void mouseExited(MouseEvent e) {
            if (!AlignedListUI.this.list.isEnabled()) {
                return;
            }
            ((AlignedList)AlignedListUI.this.list).setRolloverIndex(-1);
        }

        public void mouseReleased(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            AlignedListUI.this.list.setValueIsAdjusting(false);
        }
    }
}

