/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.GlobalJarFileSystem;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class BeanInstaller {
    private static File lastDirectory;
    static String JAR_EXT;
    static /* synthetic */ Class class$org$netbeans$modules$form$palette$BeanInstaller;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    public static void installBean() {
        String cat;
        File jarFile = BeanInstaller.selectJarModule();
        if (jarFile == null) {
            return;
        }
        JarFileSystem jar = BeanInstaller.createJarForFile(jarFile);
        if (jar == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CPManager.getBundle().getString("MSG_ErrorInFile"), 0));
            return;
        }
        Collection beans = BeanInstaller.findJavaBeans(jar);
        if (beans.size() == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)CPManager.getBundle().getString("MSG_noBeansInJar"), 1));
            return;
        }
        BeanSelector sel = new BeanSelector(beans);
        DialogDescriptor desc = new DialogDescriptor((Object)sel, CPManager.getBundle().getString("CTL_SelectJB"), true, null);
        desc.setHelpCtx(new HelpCtx((class$org$netbeans$modules$form$palette$BeanInstaller == null ? (class$org$netbeans$modules$form$palette$BeanInstaller = BeanInstaller.class$("org.netbeans.modules.form.palette.BeanInstaller")) : class$org$netbeans$modules$form$palette$BeanInstaller).getName() + ".installBean"));
        DialogDisplayer.getDefault().createDialog(desc).show();
        if (desc.getValue() == NotifyDescriptor.OK_OPTION && (cat = BeanInstaller.selectPaletteCategory()) != null) {
            BeanInstaller.installBeans(jar, sel.getSelectedBeans(), cat);
        }
    }

    public static void installBeans(Node[] nodes) {
        String cat = BeanInstaller.selectPaletteCategory();
        if (cat == null) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>(nodes.length);
        int i = 0;
        while (i < nodes.length) {
            DataObject dobj = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? BeanInstaller.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            InstanceCookie ic = (InstanceCookie)nodes[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? BeanInstaller.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
            if (dobj != null && ic != null) {
                FileObject fo = dobj.getPrimaryFile();
                if ("instance".equals(fo.getExt()) || "java".equals(fo.getExt()) || "class".equals(fo.getExt())) {
                    list.add(ic);
                } else {
                    list.add(fo);
                }
            }
            ++i;
        }
        BeanInstaller.installBeans(null, list, cat);
    }

    private static Collection findJavaBeans(JarFileSystem jar) {
        LinkedList<FileObject> beans = new LinkedList<FileObject>();
        Manifest manifest = jar.getManifest();
        Map<String, Attributes> entries = manifest.getEntries();
        Iterator<String> it = entries.keySet().iterator();
        while (it.hasNext()) {
            String value;
            String key = it.next();
            if (!key.endsWith(".class") && !key.endsWith(".ser") || (value = entries.get(key).getValue("Java-Bean")) == null || !value.equalsIgnoreCase("True")) continue;
            String[] exts = new String[]{".class", ".ser"};
            int i = 0;
            while (i < exts.length) {
                String resourcePath;
                FileObject fo;
                String ext = exts[i];
                if (key.endsWith(ext) && (fo = jar.findResource(resourcePath = key.replace('\\', '/'))) != null) {
                    beans.add(fo);
                }
                ++i;
            }
        }
        return beans;
    }

    private static void installBeans(JarFileSystem jar, Collection beans, String cat) {
        FileSystem fs;
        FileObject root;
        FileObject paletteFolder;
        if (jar != null) {
            BeanInstaller.addJarFileSystem(jar);
        }
        if (cat == null) {
            cat = "Beans";
        }
        if ((paletteFolder = (root = (fs = Repository.getDefault().getDefaultFileSystem()).getRoot()).getFileObject("Palette")) == null) {
            return;
        }
        FileObject category = paletteFolder.getFileObject(cat);
        if (category == null) {
            try {
                category = paletteFolder.createFolder(cat);
            }
            catch (IOException e) {
                if (System.getProperty("netbeans.debug.exceptions") != null) {
                    e.printStackTrace();
                }
                return;
            }
        }
        final FileObject categoryFolder = category;
        final Iterator it = beans.iterator();
        LinkedList paletteNodes = new LinkedList();
        try {
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    while (it.hasNext()) {
                        Object obj = it.next();
                        String name = null;
                        if (obj instanceof FileObject) {
                            if ("class".equals(((FileObject)obj).getExt())) {
                                name = ((FileObject)obj).getPackageName('.');
                                if (name == null) continue;
                                BeanInstaller.createInstance(categoryFolder, name);
                                continue;
                            }
                            BeanInstaller.createShadow(categoryFolder, (FileObject)obj);
                            continue;
                        }
                        if (!(obj instanceof InstanceCookie) || (name = ((InstanceCookie)obj).instanceName()) == null) continue;
                        BeanInstaller.createInstance(categoryFolder, name);
                    }
                }
            });
        }
        catch (IOException cannotHappen) {
            // empty catch block
        }
    }

    private static void addJarFileSystem(JarFileSystem jar) {
        boolean alreadyInstalled = false;
        if (jar != null) {
            Repository rep = Repository.getDefault();
            JarFileSystem jar2 = (JarFileSystem)rep.findFileSystem(jar.getSystemName());
            if (jar2 != null) {
                alreadyInstalled = true;
                jar = jar2;
            }
            if (!alreadyInstalled) {
                jar.setHidden(true);
                rep.addFileSystem((FileSystem)jar);
            }
        }
    }

    static void createShadow(FileObject folder, FileObject original) {
        try {
            DataObject originalDO = DataObject.find((FileObject)original);
            if (originalDO != null) {
                DataShadow.create((DataFolder)DataFolder.findFolder((FileObject)folder), (DataObject)originalDO);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    static void createInstance(FileObject folder, String className) {
        try {
            Class.forName(className, true, FormUtils.getClassLoader());
        }
        catch (Throwable ex) {
            if (ex instanceof ThreadDeath) {
                throw (ThreadDeath)ex;
            }
            ErrorManager manager = ErrorManager.getDefault();
            String message = MessageFormat.format(CPManager.getBundle().getString("FMT_ERR_CannotLoadClass"), className);
            manager.annotate(ex, 16, null, message, null, null);
            manager.notify(ex);
            return;
        }
        String fileName = BeanInstaller.formatName(className);
        try {
            FileObject fo;
            DataObject dobj;
            if (folder.getFileObject(fileName + ".instance") == null && (dobj = DataObject.find((FileObject)(fo = folder.createData(fileName, "instance")))) != null) {
                dobj.getNodeDelegate();
            }
        }
        catch (IOException e) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            t.printStackTrace();
        }
    }

    private static String formatName(String className) {
        return className.replace('.', '-');
    }

    private static String selectPaletteCategory() {
        CategorySelector sel = new CategorySelector();
        DialogDescriptor desc = new DialogDescriptor((Object)sel, CPManager.getBundle().getString("CTL_SelectPalette"), true, null);
        desc.setHelpCtx(new HelpCtx((class$org$netbeans$modules$form$palette$BeanInstaller == null ? (class$org$netbeans$modules$form$palette$BeanInstaller = BeanInstaller.class$("org.netbeans.modules.form.palette.BeanInstaller")) : class$org$netbeans$modules$form$palette$BeanInstaller).getName() + ".selectPaletteCategory"));
        DialogDisplayer.getDefault().createDialog(desc).show();
        if (desc.getValue() == NotifyDescriptor.OK_OPTION) {
            return sel.getSelectedCategory();
        }
        return null;
    }

    private static File selectJarModule() {
        JFileChooser chooser = new JFileChooser();
        final ResourceBundle bundle = CPManager.getBundle();
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(JAR_EXT);
            }

            public String getDescription() {
                return bundle.getString("CTL_JarArchivesMask");
            }
        });
        if (lastDirectory == null) {
            try {
                File defDir = new File(System.getProperty("user.home"));
                if (Utilities.isUnix()) {
                    lastDirectory = defDir;
                } else if (Utilities.isWindows()) {
                    while ((defDir = defDir.getParentFile()) != null && defDir.getParentFile() != null) {
                    }
                    if (defDir != null) {
                        lastDirectory = defDir;
                    }
                }
            }
            catch (Exception ex) {
                lastDirectory = null;
            }
        }
        if (lastDirectory != null) {
            chooser.setCurrentDirectory(lastDirectory);
        }
        chooser.setDialogTitle(bundle.getString("CTL_SelectJar"));
        while (chooser.showDialog(WindowManager.getDefault().getMainWindow(), bundle.getString("CTL_Select_Approve_Button")) == 0) {
            File f = chooser.getSelectedFile();
            lastDirectory = chooser.getCurrentDirectory();
            if (f != null && f.isFile() && f.getName().endsWith(JAR_EXT)) {
                return f;
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)bundle.getString("MSG_noValidFile"), 2));
        }
        return null;
    }

    private static JarFileSystem createJarForFile(File jarFile) {
        try {
            GlobalJarFileSystem jar = new GlobalJarFileSystem();
            jar.setJarFile(jarFile);
            return jar;
        }
        catch (PropertyVetoException e) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                e.printStackTrace();
            }
            return null;
        }
        catch (IOException e) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                e.printStackTrace();
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JAR_EXT = ".jar";
    }

    private static class FileObjectRenderer
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = 832555965217675765L;
        private static final Border hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public FileObjectRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof FileObject)) {
                return this;
            }
            FileObject fo = (FileObject)value;
            this.setText(fo.getName());
            if (isSelected) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBorder(cellHasFocus ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }

    private static class BeanSelector
    extends JPanel {
        static final long serialVersionUID = -6038414545631774041L;
        private JList list;

        public BeanSelector(Collection beans) {
            this.list = new JList<Object>(beans.toArray());
            this.list.setCellRenderer(new FileObjectRenderer());
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
            this.setLayout(new BorderLayout(0, 2));
            JLabel label = new JLabel(CPManager.getBundle().getString("CTL_SelectBeans"));
            label.setLabelFor(this.list);
            label.setDisplayedMnemonic(CPManager.getBundle().getString("CTL_SelectBeans_Mnemonic").charAt(0));
            this.list.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_CTL_SelectBeans"));
            this.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_SelectBeansDialog"));
            this.add((Component)label, "North");
            this.add((Component)new JScrollPane(this.list), "Center");
        }

        Collection getSelectedBeans() {
            Object[] sel = this.list.getSelectedValues();
            ArrayList<Object> al = new ArrayList<Object>(sel.length);
            int i = 0;
            while (i < sel.length) {
                al.add(sel[i]);
                ++i;
            }
            return al;
        }

        public Dimension getPreferredSize() {
            Dimension ret = super.getPreferredSize();
            ret.width = Math.max(ret.width, 350);
            ret.height = Math.max(ret.height, 250);
            return ret;
        }
    }

    private static class CategorySelector
    extends JPanel {
        private JList list;
        private String[] catNames;
        static final long serialVersionUID = 936459317386043582L;

        public CategorySelector() {
            DataObject[] catFolders = PaletteNode.getPaletteFolder().getChildren();
            ArrayList<String> dispList = new ArrayList<String>(catFolders.length);
            ArrayList<String> nameList = new ArrayList<String>(catFolders.length);
            int i = 0;
            while (i < catFolders.length) {
                Node node;
                if (catFolders[i] instanceof DataFolder && (node = catFolders[i].getNodeDelegate()) != null) {
                    dispList.add(node.getDisplayName());
                    nameList.add(node.getName());
                }
                ++i;
            }
            String[] catDisplayNames = new String[dispList.size()];
            dispList.toArray(catDisplayNames);
            this.catNames = new String[nameList.size()];
            nameList.toArray(this.catNames);
            this.list = new JList<String>(catDisplayNames);
            this.list.setSelectionMode(0);
            this.setLayout(new BorderLayout(0, 5));
            JLabel categoryLabel = new JLabel(CPManager.getBundle().getString("CTL_PaletteCategories"));
            categoryLabel.setDisplayedMnemonic(CPManager.getBundle().getString("CTL_PaletteCategories_Mnemonic").charAt(0));
            categoryLabel.setLabelFor(this.list);
            this.list.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_CTL_PaletteCategories"));
            this.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_PaletteCategoriesSelector"));
            this.add((Component)categoryLabel, "North");
            this.add((Component)new JScrollPane(this.list), "Center");
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
        }

        public String getSelectedCategory() {
            int i = this.list.getSelectedIndex();
            return i >= 0 ? this.catNames[i] : null;
        }

        public Dimension getPreferredSize() {
            Dimension ret = super.getPreferredSize();
            ret.width = Math.max(ret.width, 350);
            ret.height = Math.max(ret.height, 250);
            return ret;
        }
    }
}

