/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.form.palette.CPElements;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.CPManagerInterface;
import org.netbeans.modules.form.palette.PaletteCategoryNode;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteNode;
import org.netbeans.modules.form.palette.ScrollPopupMenu;
import org.openide.awt.JMenuPlus;
import org.openide.awt.JPopupMenuPlus;
import org.openide.awt.MouseUtils;
import org.openide.awt.ToolbarToggleButton;
import org.openide.explorer.view.MenuView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public abstract class CPComponent
extends JPanel {
    static final long serialVersionUID = 7249158494688903041L;
    protected CPManagerInterface manager = null;
    protected Node paletteNode;
    protected ToolbarToggleButton selectionButton;
    protected ToolbarToggleButton connectionButton;
    protected ToolbarToggleButton beansButton;
    protected JLabel statusLabel;
    PaletteMenuView beansMenuView;
    private Listener listener;
    private static final boolean TRACE = false;

    protected CPComponent(CPManagerInterface cpm) {
        CPComponent.t("<init>-BEG");
        this.manager = cpm;
        this.paletteNode = this.manager.getRootNode();
        HelpCtx.setHelpIDString((JComponent)this, (String)"gui.components.palette");
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        CPComponent.t("<init>-END");
    }

    public void addNotify() {
        super.addNotify();
        this.updateSelectedItem();
        this.updateMode();
        this.manager.addPropertyChangeListener(this.listener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.manager.removePropertyChangeListener(this.listener);
    }

    protected void createControls() {
        this.selectionButton = new ToolbarToggleButton((Icon)new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/selectionMode.gif")), false);
        this.selectionButton.addActionListener(this.listener);
        this.selectionButton.addMouseListener(this.listener);
        this.selectionButton.setToolTipText(CPManager.getBundle().getString("CTL_SelectionButtonHint"));
        HelpCtx.setHelpIDString((JComponent)this.selectionButton, (String)"gui.components.palette");
        this.connectionButton = new ToolbarToggleButton((Icon)new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/connectionMode.gif")), false);
        this.connectionButton.addActionListener(this.listener);
        this.connectionButton.addMouseListener(this.listener);
        this.connectionButton.setToolTipText(CPManager.getBundle().getString("CTL_ConnectionButtonHint"));
        HelpCtx.setHelpIDString((JComponent)this.connectionButton, (String)"gui.connecting.intro");
        this.beansButton = new ToolbarToggleButton((Icon)new ImageIcon(this.getClass().getResource("/org/netbeans/modules/form/resources/beansButton.gif")), false);
        this.beansButton.setToolTipText(CPManager.getBundle().getString("CTL_BeansButtonHint"));
        this.beansButton.addActionListener(this.listener);
        this.beansButton.addMouseListener(this.listener);
        HelpCtx.setHelpIDString((JComponent)this.beansButton, (String)"gui.components.adding");
        ButtonGroup g = new ButtonGroup();
        g.add((AbstractButton)this.selectionButton);
        g.add((AbstractButton)this.connectionButton);
        g.add((AbstractButton)this.beansButton);
        this.statusLabel = new JLabel();
        this.statusLabel.addMouseListener(this.listener);
        this.connectionButton.getAccessibleContext().setAccessibleName(this.connectionButton.getToolTipText());
        this.selectionButton.getAccessibleContext().setAccessibleName(this.selectionButton.getToolTipText());
        this.beansButton.getAccessibleContext().setAccessibleName(this.beansButton.getToolTipText());
        this.connectionButton.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_ConnectionMode"));
        this.selectionButton.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_SelectionMode"));
        this.beansButton.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_AddMode"));
    }

    protected void setStatusLabelSize() {
        this.statusLabel.setText(CPManager.getBundle().getString("CTL_ConnectionMode"));
        Dimension prefSize1 = this.statusLabel.getPreferredSize();
        this.statusLabel.setText(CPManager.getBundle().getString("CTL_SelectionMode"));
        Dimension prefSize2 = this.statusLabel.getPreferredSize();
        if (prefSize1.width < prefSize2.width) {
            prefSize1.width = prefSize2.width;
        }
        prefSize1.width += 10;
        if (prefSize1.width < 90) {
            prefSize1.width = 90;
        } else if (prefSize1.width > 130) {
            prefSize1.width = 130;
        }
        prefSize1.height = Math.max(16, ((Component)this.statusLabel).getFontMetrics(this.statusLabel.getFont()).getHeight());
        this.statusLabel.setPreferredSize(prefSize1);
        this.statusLabel.setMaximumSize(prefSize1);
    }

    protected void updateSelectedItem() {
        this.updateSelectedItem(this.manager.getSelectedItem());
    }

    protected void updateSelectedItem(PaletteItem item) {
        if (item == null) {
            this.statusLabel.setIcon(null);
        } else {
            this.statusLabel.setIcon(new ImageIcon(item.getItemNode().getIcon(1)));
            this.statusLabel.setText(item.getName());
        }
    }

    protected void updateMode() {
        this.updateMode(this.manager.getMode());
    }

    protected void updateMode(int mode) {
        if (mode == 0) {
            this.manager.setSelectedItem(null);
            this.selectionButton.setSelected(true);
            this.statusLabel.setText(CPManager.getBundle().getString("CTL_SelectionMode"));
            this.statusLabel.setToolTipText(CPManager.getBundle().getString("CTL_SelectionModeHint"));
        } else if (mode == 1) {
            this.manager.setSelectedItem(null);
            this.connectionButton.setSelected(true);
            this.statusLabel.setText(CPManager.getBundle().getString("CTL_ConnectionMode"));
            this.statusLabel.setToolTipText(CPManager.getBundle().getString("CTL_ConnectionModeHint"));
        } else {
            this.beansButton.setSelected(true);
            this.statusLabel.setToolTipText(CPManager.getBundle().getString("CTL_AddModeHint"));
        }
    }

    private void createBeansMenu() {
        CPComponent.t("create beans menu");
        this.beansMenuView = new PaletteMenuView(this.paletteNode, this.listener);
        this.beansMenuView.getPopupMenu().addPopupMenuListener(this.listener);
    }

    private void showBeansMenu() {
        Point p = this.selectionButton.getLocation();
        p.y += this.selectionButton.getHeight() + 2;
        if (this.beansMenuView == null) {
            this.createBeansMenu();
        }
        this.beansMenuView.getPopupMenu().show(this.beansButton.getParent(), p.x, p.y);
    }

    void showPaletteVisibilityMenu(Component comp, Point pos) {
        JPopupMenuPlus menu = new JPopupMenuPlus();
        CPElements.Palette[] palettes = this.manager.getRegisteredPalettes();
        CPElements.Palette selectedPalette = this.manager.getSelectedPalette();
        int i = 0;
        while (i < palettes.length) {
            JMenuItem item = new JMenuItem(palettes[i].displayName);
            item.addActionListener(new PaletteVisibilityMenuListener(palettes[i]));
            item.setEnabled(palettes[i] != selectedPalette);
            menu.add(item);
            ++i;
        }
        menu.show(comp, pos.x, pos.y);
    }

    protected static void t(String str) {
    }

    private class Listener
    extends MouseAdapter
    implements NodeAcceptor,
    ActionListener,
    PropertyChangeListener,
    PopupMenuListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("mode".equals(evt.getPropertyName())) {
                CPComponent.this.updateMode((Integer)evt.getNewValue());
            } else if ("selectedItem".equals(evt.getPropertyName())) {
                CPComponent.this.updateSelectedItem((PaletteItem)evt.getNewValue());
            }
        }

        public void actionPerformed(ActionEvent evt) {
            ToolbarToggleButton pressedButton = (ToolbarToggleButton)evt.getSource();
            if (pressedButton == CPComponent.this.selectionButton) {
                CPComponent.this.manager.setSelectedItem(null);
                CPComponent.this.manager.setMode(0);
            } else if (pressedButton == CPComponent.this.connectionButton) {
                CPComponent.this.manager.setSelectedItem(null);
                CPComponent.this.manager.setMode(1);
            } else if (pressedButton == CPComponent.this.beansButton) {
                CPComponent.this.showBeansMenu();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (MouseUtils.isRightMouseButton((MouseEvent)e)) {
                CPComponent.this.showPaletteVisibilityMenu(e.getComponent(), e.getPoint());
            }
        }

        public boolean acceptNodes(Node[] nodes) {
            if (nodes.length == 0) {
                return false;
            }
            PaletteItem item = CPManager.createPaletteItem(nodes[0]);
            CPComponent.this.manager.setSelectedItem(item);
            CPComponent.this.manager.setMode(2);
            return true;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            CPComponent.this.updateSelectedItem();
            CPComponent.this.updateMode();
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private class PaletteVisibilityMenuListener
    implements ActionListener {
        private CPElements.Palette newSelectedPalette;

        public PaletteVisibilityMenuListener(CPElements.Palette newSelectedPalette) {
            this.newSelectedPalette = newSelectedPalette;
        }

        public void actionPerformed(ActionEvent evt) {
            CPComponent.this.manager.setSelectedPalette(this.newSelectedPalette);
        }
    }

    public static class PaletteMenuView
    extends JMenuPlus {
        private Node menuNode;
        private NodeAcceptor menuAction;
        private boolean hacked = false;
        private boolean filled = false;
        private static int maxHeight = Utilities.getUsableScreenBounds().height - 25;
        static /* synthetic */ Class class$javax$swing$JMenu;

        public PaletteMenuView(Node node, NodeAcceptor acceptor) {
            this.menuNode = node;
            this.menuAction = acceptor;
            ((AbstractButton)((Object)this)).setText(node.getDisplayName());
            this.getSubNodes();
        }

        public JPopupMenu getPopupMenu() {
            if (!this.hacked) {
                try {
                    Field f = (class$javax$swing$JMenu == null ? (class$javax$swing$JMenu = PaletteMenuView.class$("javax.swing.JMenu")) : class$javax$swing$JMenu).getDeclaredField("popupMenu");
                    ((AccessibleObject)f).setAccessible(true);
                    if (f.get((Object)this) == null) {
                        ScrollPopupMenu popup = new ScrollPopupMenu(maxHeight);
                        popup.setInvoker((Component)((Object)this));
                        f.set((Object)this, popup);
                    }
                    this.hacked = true;
                }
                catch (Exception ex) {
                    System.out.println("[WARNING] Cannot create scrollable popup menu.");
                }
            }
            JPopupMenu popup = super.getPopupMenu();
            this.fillSubMenu(popup);
            return popup;
        }

        private void fillSubMenu(JPopupMenu popup) {
            if (!this.filled) {
                this.filled = true;
                popup.addPopupMenuListener(new PopupListener(popup));
                ((JMenu)((Object)this)).removeAll();
                Node[] nodes = this.getSubNodes();
                if (nodes.length > 0) {
                    int i = 0;
                    while (i < nodes.length) {
                        ((JMenu)((Object)this)).add((JMenuItem)(nodes[i].isLeaf() ? new MenuView.MenuItem(nodes[i], this.menuAction) : new PaletteMenuView(nodes[i], this.menuAction)));
                        ++i;
                    }
                } else {
                    JMenuItem empty = new JMenuItem(CPManager.getBundle().getString("CTL_EmptyPaletteMenu"));
                    empty.setEnabled(false);
                    ((JMenu)((Object)this)).add(empty);
                }
            }
        }

        private Node[] getSubNodes() {
            if (this.menuNode instanceof PaletteNode) {
                return ((PaletteNode)this.menuNode).getCategoryNodes();
            }
            if (this.menuNode instanceof PaletteCategoryNode) {
                return ((PaletteCategoryNode)this.menuNode).getValidItemNodes();
            }
            return this.menuNode.getChildren().getNodes();
        }

        protected Point getPopupMenuOrigin() {
            int x = 0;
            int y = 0;
            JPopupMenu pm = this.getPopupMenu();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension s = ((Component)((Object)this)).getSize();
            Dimension pmSize = pm.getSize();
            if (pmSize.width == 0) {
                pmSize = pm.getPreferredSize();
            }
            if (pmSize.height > maxHeight) {
                pmSize.height = maxHeight + 2;
                pmSize.width += 14;
            }
            Point position = ((Component)((Object)this)).getLocationOnScreen();
            Container parent = ((Component)((Object)this)).getParent();
            if (parent instanceof JPopupMenu) {
                x = ((Component)((Object)this)).getComponentOrientation().isLeftToRight() ? (position.x + s.width + pmSize.width < screenSize.width ? s.width : 0 - pmSize.width) : (position.x < pmSize.width ? s.width : 0 - pmSize.width);
                if (position.y + pmSize.height < screenSize.height) {
                    y = 0;
                } else {
                    y = s.height - pmSize.height;
                    if (y < -position.y) {
                        y = -position.y + 6;
                    }
                }
            } else {
                x = ((Component)((Object)this)).getComponentOrientation().isLeftToRight() ? (position.x + pmSize.width < screenSize.width ? 0 : s.width - pmSize.width) : (position.x + s.width < pmSize.width ? 0 : s.width - pmSize.width);
                y = position.y + s.height + pmSize.height < screenSize.height ? s.height : -pmSize.height;
            }
            return new Point(x, y);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        private class PopupListener
        implements PopupMenuListener {
            private JPopupMenu popup;

            PopupListener(JPopupMenu popup) {
                this.popup = popup;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                PaletteMenuView.this.filled = false;
                this.popup.removePopupMenuListener(this);
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        }
    }
}

