/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.actions.TestAction;
import org.netbeans.modules.form.palette.AlignedList;
import org.netbeans.modules.form.palette.CPComponent;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.CPManagerInterface;
import org.netbeans.modules.form.palette.CPManagerListener;
import org.netbeans.modules.form.palette.CategoryPopupMenu;
import org.netbeans.modules.form.palette.ItemPopupMenu;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PalettePopupMenu;
import org.openide.awt.MouseUtils;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class CPComponentLarge
extends CPComponent {
    protected static CPComponent instance;
    protected JTabbedPane tabbedPane;
    protected ArrayList alignedLists = new ArrayList();
    private Listener listener;
    private Set categories = new HashSet();
    private static String SHOW_NAMES;
    private PaletteListRenderer listRenderer;
    static /* synthetic */ Class class$org$netbeans$modules$form$actions$TestAction;

    private CPComponentLarge(CPManagerInterface cpm) {
        super(cpm);
        this.createControls();
        this.setStatusLabelSize();
        JPanel buttPanel = new JPanel();
        buttPanel.setLayout(new BoxLayout(buttPanel, 0));
        buttPanel.add((Component)this.selectionButton);
        buttPanel.add((Component)this.connectionButton);
        buttPanel.add(Box.createHorizontalStrut(5));
        TestAction testAction = (TestAction)SystemAction.get((Class)(class$org$netbeans$modules$form$actions$TestAction == null ? (class$org$netbeans$modules$form$actions$TestAction = CPComponentLarge.class$("org.netbeans.modules.form.actions.TestAction")) : class$org$netbeans$modules$form$actions$TestAction));
        buttPanel.add(testAction.getToolbarPresenter());
        buttPanel.add(Box.createHorizontalStrut(5));
        this.add(buttPanel);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setPreferredSize(new Dimension(410, 50));
        this.tabbedPane.getAccessibleContext().setAccessibleName(CPManager.getBundle().getString("ACS_PaletteTabbedPane"));
        this.tabbedPane.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_PaletteTabbedPane"));
        this.add(this.tabbedPane);
        this.setLayout(new PaletteLayout(buttPanel, this.tabbedPane));
    }

    public void addNotify() {
        super.addNotify();
        if (this.listener == null) {
            this.listener = new Listener();
            this.manager.addPropertyChangeListener(this.listener);
            this.manager.addManagerListener(this.listener);
            this.tabbedPane.addChangeListener(this.listener);
            this.tabbedPane.addMouseListener(this.listener);
        }
        this.fillTabbedPane();
        this.updateShowNames(this.manager.getShowComponentsNames());
    }

    private void fillTabbedPane() {
        this.tabbedPane.removeAll();
        this.alignedLists.clear();
        this.categories.clear();
        Node[] nodes = this.manager.getCategoryNodes();
        int i = 0;
        while (i < nodes.length) {
            Node categoryNode = nodes[i];
            this.categories.add(categoryNode);
            Component tab = this.createPaletteTab(i, categoryNode);
            this.tabbedPane.addTab(categoryNode.getDisplayName(), null, tab);
            ++i;
        }
    }

    private Component createPaletteTab(int index, Node node) {
        CPComponent.t("creating palette tab");
        AlignedList list = this.createCategoryList(node);
        this.alignedLists.add(index, list);
        JScrollPane scrollList = new JScrollPane(){

            public void setBorder(Border border) {
            }
        };
        scrollList.setViewportView(list);
        return scrollList;
    }

    private AlignedList createCategoryList(Node node) {
        AlignedList list = new AlignedList();
        list.setListData(this.manager.getItemNodes(node));
        list.setOpaque(false);
        list.setAlignStyle(0);
        list.setVisibleRowCount(2);
        list.setSelectionMode(0);
        list.addListSelectionListener(this.listener);
        list.addMouseListener(this.listener);
        if (this.listRenderer == null) {
            this.listRenderer = new PaletteListRenderer();
            this.listRenderer.setShowNames(this.manager.getShowComponentsNames());
        }
        list.setCellRenderer(this.listRenderer);
        ToolTipManager.sharedInstance().registerComponent(list);
        list.getAccessibleContext().setAccessibleName(MessageFormat.format(CPManager.getBundle().getString("ACS_PaletteBeansList"), node.getDisplayName()));
        list.getAccessibleContext().setAccessibleDescription(CPManager.getBundle().getString("ACSD_PaletteBeansList"));
        return list;
    }

    private void clearSelection() {
        int i = 0;
        while (i < this.alignedLists.size()) {
            ((AlignedList)this.alignedLists.get(i)).clearSelection();
            ++i;
        }
    }

    protected void updateSelectedItem(PaletteItem item) {
        super.updateSelectedItem(item);
        if (item == null) {
            this.clearSelection();
        } else {
            List<Node> categories = Arrays.asList(this.manager.getCategoryNodes());
            int index = categories.indexOf(item.getCategoryNode());
            if (index > -1) {
                this.tabbedPane.removeChangeListener(this.listener);
                this.tabbedPane.setSelectedIndex(index);
                this.tabbedPane.addChangeListener(this.listener);
                ((AlignedList)this.alignedLists.get(index)).setSelectedValue(item.getItemNode(), true);
            }
        }
    }

    void showMenuOnCategory(Component comp, Point pos) {
        int i = this.tabbedPane.getSelectedIndex();
        Node[] nodes = this.manager.getCategoryNodes();
        if (i < 0 || nodes == null || i >= nodes.length) {
            return;
        }
        new CategoryPopupMenu(nodes[i]).show(comp, pos.x, pos.y);
    }

    void showMenuOnPalette(Component comp, Point pos) {
        new PalettePopupMenu().show(comp, pos.x, pos.y);
    }

    void showMenuOnItem(Node itemNode, Component comp, Point pos) {
        ItemPopupMenu popup = new ItemPopupMenu(itemNode);
        ((Container)((Object)popup)).add(new JSeparator());
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(CPManager.getBundle().getString("CTL_ShowNames"));
        menuItem.setSelected(this.listRenderer.isShowNames());
        menuItem.setActionCommand(SHOW_NAMES);
        menuItem.addActionListener(this.listener);
        ((JPopupMenu)((Object)popup)).add(menuItem);
        ((JPopupMenu)((Object)popup)).show(comp, pos.x, pos.y);
    }

    public static boolean isCreated() {
        return instance != null;
    }

    public static synchronized JComponent getComponent(CPManagerInterface cpm) {
        CPComponent.t("Large: getComponent");
        if (instance == null) {
            instance = new CPComponentLarge(cpm);
        }
        return instance;
    }

    private void revalidateLists() {
        int i = 0;
        while (i < this.alignedLists.size()) {
            AlignedList list = (AlignedList)this.alignedLists.get(i);
            list.setSize(0, 0);
            ++i;
        }
        int index = this.tabbedPane.getSelectedIndex();
        AlignedList list = (AlignedList)this.alignedLists.get(index);
        list.revalidate();
        list.repaint();
    }

    private void updateShowNames(boolean show) {
        if (this.listRenderer != null) {
            this.listRenderer.setShowNames(show);
            this.revalidateLists();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SHOW_NAMES = "SHOW_NAMES";
    }

    private static class PaletteLayout
    implements LayoutManager {
        Component buttons;
        Component tabs;

        public PaletteLayout(Component buttons, Component tabs) {
            this.buttons = buttons;
            this.tabs = tabs;
        }

        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int top = insets.top;
                int bottom = parent.getHeight() - insets.bottom;
                int left = insets.left;
                int right = parent.getWidth() - insets.right;
                int height = bottom - top;
                int width = right - left;
                if (this.buttons != null) {
                    Dimension buttonSize = this.buttons.getPreferredSize();
                    if (buttonSize.width * height >= buttonSize.height * width) {
                        this.buttons.setBounds(left, top, width, buttonSize.height);
                        top += buttonSize.height;
                        height -= buttonSize.height;
                    } else {
                        this.buttons.setBounds(left, top + 5, buttonSize.width, height - 5);
                        left += buttonSize.width;
                        width -= buttonSize.width;
                    }
                }
                if (this.tabs != null) {
                    this.tabs.setBounds(left, top, width, height);
                }
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension dim = new Dimension();
                if (this.buttons != null) {
                    Dimension buttonSize = this.buttons.getPreferredSize();
                    dim.width += buttonSize.width;
                }
                if (this.tabs != null) {
                    Dimension tabSize = this.tabs.getPreferredSize();
                    dim.width += tabSize.width;
                    dim.height = tabSize.height;
                }
                Insets insets = parent.getInsets();
                dim.width += insets.left + insets.right;
                dim.height += insets.top + insets.bottom;
                Dimension dimension = dim;
                return dimension;
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    ListSelectionListener,
    ChangeListener,
    PropertyChangeListener,
    CPManagerListener {
        private Listener() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            JList list = (JList)evt.getSource();
            int index = list.getSelectedIndex();
            if (index == -1) {
                if (CPComponentLarge.this.tabbedPane.getSelectedIndex() == CPComponentLarge.this.alignedLists.indexOf(list)) {
                    CPComponentLarge.this.manager.setSelectedItem(null);
                    CPComponentLarge.this.manager.setMode(0);
                }
            } else if (!evt.getValueIsAdjusting()) {
                Node node = (Node)list.getModel().getElementAt(index);
                PaletteItem item = CPManager.createPaletteItem(node);
                CPComponentLarge.this.manager.setSelectedItem(item);
                CPComponentLarge.this.manager.setMode(2);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!MouseUtils.isRightMouseButton((MouseEvent)e)) {
                return;
            }
            if (e.getSource() == CPComponentLarge.this.tabbedPane) {
                int i = CPComponentLarge.this.tabbedPane.getSelectedIndex();
                if (i >= 0) {
                    Rectangle r = CPComponentLarge.this.tabbedPane.getBoundsAt(i);
                    Point p = e.getPoint();
                    if (p.y < r.y || p.y < r.y + r.height && (p.x < r.x || p.x >= r.x + r.width)) {
                        CPComponentLarge.this.showMenuOnPalette(e.getComponent(), p);
                        return;
                    }
                }
                CPComponentLarge.this.showMenuOnCategory(e.getComponent(), e.getPoint());
            } else if (e.getSource() instanceof AlignedList) {
                AlignedList list = (AlignedList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                if (index == -1) {
                    CPComponentLarge.this.showMenuOnCategory(e.getComponent(), e.getPoint());
                } else {
                    CPComponentLarge.this.showMenuOnItem((Node)list.getModel().getElementAt(index), e.getComponent(), e.getPoint());
                }
            }
        }

        public void actionPerformed(ActionEvent evt) {
            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)evt.getSource();
            if (evt.getActionCommand().equals(SHOW_NAMES)) {
                CPComponentLarge.this.listRenderer.setShowNames(menuItem.isSelected());
                CPComponentLarge.this.manager.setShowComponentsNames(menuItem.isSelected());
            }
            CPComponentLarge.this.revalidateLists();
        }

        public void stateChanged(ChangeEvent evt) {
            CPComponentLarge.this.manager.setSelectedItem(null);
            CPComponentLarge.this.manager.setMode(0);
            int index = CPComponentLarge.this.tabbedPane.getSelectedIndex();
            if (index >= 0) {
                JList list = (JList)CPComponentLarge.this.alignedLists.get(index);
                list.setListData(CPComponentLarge.this.manager.getItemNodes(CPComponentLarge.this.manager.getCategoryNodes()[index]));
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("showComponentsNames".equals(evt.getPropertyName())) {
                CPComponentLarge.this.updateShowNames((Boolean)evt.getNewValue());
            }
        }

        public void categoriesAdded(Node[] nodes, int[] indices) {
            CPComponentLarge.this.manager.setSelectedItem(null);
            CPComponentLarge.this.manager.setMode(0);
            int i = 0;
            while (i < nodes.length) {
                Node categoryNode = nodes[i];
                if (!CPComponentLarge.this.categories.contains(categoryNode)) {
                    int index = indices[i];
                    if (index > CPComponentLarge.this.tabbedPane.getTabCount()) {
                        index = CPComponentLarge.this.tabbedPane.getTabCount();
                    }
                    Component tab = CPComponentLarge.this.createPaletteTab(index, categoryNode);
                    CPComponentLarge.this.tabbedPane.insertTab(categoryNode.getDisplayName(), null, tab, null, index);
                }
                ++i;
            }
            CPComponentLarge.this.revalidate();
            CPComponentLarge.this.repaint();
        }

        public void categoriesRemoved(Node[] nodes, int[] indices) {
            CPComponentLarge.this.manager.setSelectedItem(null);
            CPComponentLarge.this.manager.setMode(0);
            int i = nodes.length - 1;
            while (i >= 0) {
                int index = indices[i];
                CPComponentLarge.this.tabbedPane.removeTabAt(index);
                CPComponentLarge.this.alignedLists.remove(index);
                CPComponentLarge.this.categories.remove(nodes[i]);
                --i;
            }
            CPComponentLarge.this.revalidate();
            CPComponentLarge.this.repaint();
        }

        public void categoriesReordered() {
            CPComponentLarge.this.manager.setSelectedItem(null);
            CPComponentLarge.this.manager.setMode(0);
            int sel = CPComponentLarge.this.tabbedPane.getSelectedIndex();
            String selectedTab = sel >= 0 ? CPComponentLarge.this.tabbedPane.getTitleAt(sel) : null;
            CPComponentLarge.this.fillTabbedPane();
            if (selectedTab != null) {
                int i = 0;
                int n = CPComponentLarge.this.tabbedPane.getTabCount();
                while (i < n) {
                    if (selectedTab.equals(CPComponentLarge.this.tabbedPane.getTitleAt(i))) {
                        CPComponentLarge.this.tabbedPane.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
            }
            CPComponentLarge.this.tabbedPane.revalidate();
            CPComponentLarge.this.tabbedPane.repaint();
        }

        public void categoryChanged(Node catNode) {
            Node[] cats = CPComponentLarge.this.manager.getCategoryNodes();
            int i = 0;
            while (i < cats.length) {
                if (catNode == cats[i]) {
                    CPComponentLarge.this.manager.setSelectedItem(null);
                    CPComponentLarge.this.manager.setMode(0);
                    CPComponentLarge.this.tabbedPane.setTitleAt(i, catNode.getDisplayName());
                    JList list = (JList)CPComponentLarge.this.alignedLists.get(i);
                    list.setListData(CPComponentLarge.this.manager.getItemNodes(catNode));
                    CPComponentLarge.this.tabbedPane.revalidate();
                    CPComponentLarge.this.tabbedPane.repaint();
                    break;
                }
                ++i;
            }
        }
    }

    private static class PaletteListRenderer
    implements ListCellRenderer {
        private JToggleButton button = new JToggleButton();
        private Border buttonBorder;
        private Border emptyBorder;
        private int iconSize;
        private boolean showNames = false;

        public PaletteListRenderer() {
            this.button.setMargin(new Insets(1, 1, 1, 1));
            this.buttonBorder = this.button.getBorder();
            if (this.buttonBorder != null) {
                this.emptyBorder = new EmptyBorder(this.buttonBorder.getBorderInsets(this.button));
            }
            this.setIconSize(1);
            this.setShowNames(false);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected || index == ((AlignedList)list).getRolloverIndex()) {
                this.button.setBorder(this.buttonBorder);
            } else {
                this.button.setBorder(this.emptyBorder);
            }
            Node node = (Node)value;
            if (this.showNames) {
                this.button.setText(node.getDisplayName());
            }
            this.button.setIcon(new ImageIcon(node.getIcon(this.iconSize)));
            this.button.setSelected(isSelected);
            this.button.setToolTipText(node.getShortDescription().replace('-', '.'));
            return this.button;
        }

        public void setIconSize(int size) {
            if (size == 1) {
                this.button.setHorizontalAlignment(this.isShowNames() ? 2 : 0);
                this.button.setVerticalTextPosition(0);
                this.button.setHorizontalTextPosition(4);
            } else {
                this.button.setHorizontalAlignment(0);
                this.button.setVerticalTextPosition(3);
                this.button.setHorizontalTextPosition(0);
            }
            this.iconSize = size;
        }

        public int getIconSize() {
            return this.iconSize;
        }

        public void setShowNames(boolean show) {
            if (!show) {
                this.button.setText(null);
            }
            this.showNames = show;
            this.setIconSize(this.getIconSize());
        }

        public boolean isShowNames() {
            return this.showNames;
        }
    }
}

