/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.palette.CPElements;
import org.netbeans.modules.form.palette.CPManagerInterface;
import org.netbeans.modules.form.palette.CPManagerListener;
import org.netbeans.modules.form.palette.PaletteCategoryNode;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CPManager
implements CPManagerInterface {
    private static CPManager instance;
    private int paletteMode = 0;
    private PaletteItem selectedPaletteItem = null;
    private static final int CATEGORIES_ADDED = 1;
    private static final int CATEGORIES_REMOVED = 2;
    private static final int CATEGORIES_REORDERED = 3;
    private static final int ITEMS_CHANGED = 4;
    private static final int ITEMS_REORDERED = 5;
    private static final int SWITCH_UI = 6;
    private static final String PALETTE_UI_FOLDER_NAME = "PaletteUI";
    private PropertyChangeSupport propertySupport;
    private transient Vector listeners;
    private Set updateNodes = new HashSet();
    private NodeListener categoryNodeListener;
    private PaletteNode paletteNode;
    private JComponent palette = new JPanel();
    private JComponent component;
    private CPElements.Palette[] registeredPalettes = null;
    private CPElements.Palette selectedPalette = null;
    private PaletteItem[] allItems = null;
    private static final boolean TRACE = false;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$netbeans$modules$form$palette$CPManager;

    private CPManager() {
        CPManager.t("<init>-BEG");
        this.propertySupport = new PropertyChangeSupport(this);
        this.paletteNode = PaletteNode.getPaletteNode();
        this.createListener4FormSettings();
        this.createListeners4PaletteNodes();
        boolean foundAnyPalette = this.checkAvailablePalettes();
        if (foundAnyPalette) {
            this.loadPalette(FormEditor.getFormSettings().getSelectedPalette());
        } else {
            InternalError e = new InternalError("Any palette was not found!");
            ErrorManager.getDefault().notify((Throwable)e);
        }
        CPManager.t("<init>-END");
    }

    public static synchronized CPManager getDefault() {
        if (instance == null) {
            instance = new CPManager();
        }
        return instance;
    }

    private boolean loadSelectedPalette(CPElements.Palette selectedPalette) {
        CPManager.t("registerCPComponent-BEG");
        try {
            ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = CPManager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            Class<?> target = Class.forName(selectedPalette.clazz, true, cl);
            String sourceClazzName = "org.netbeans.modules.form.palette.CPManagerInterface";
            Class<?> source = Class.forName(sourceClazzName, true, cl);
            Method m = target.getMethod("getComponent", source);
            this.component = null;
            this.component = (JComponent)m.invoke(null, this);
        }
        catch (ClassNotFoundException ex) {
            CPManager.t("registerCPComponent-ClassNotFoundException-END");
            return false;
        }
        catch (IllegalAccessException ex) {
            CPManager.t("registerCPComponent-IllegalAccessException-END");
            return false;
        }
        catch (NoSuchMethodException ex) {
            CPManager.t("registerCPComponent-NoSuchMethodException-END");
            return false;
        }
        catch (SecurityException ex) {
            CPManager.t("registerCPComponent-SecurityException-END");
            return false;
        }
        catch (InvocationTargetException ex) {
            CPManager.t("registerCPComponent-InvocationTargetException-END");
            return false;
        }
        this.runInEventQueue(6, null);
        this.selectedPalette = selectedPalette;
        CPManager.t("registerCPComponent-END");
        return true;
    }

    public void setSelectedPalette(CPElements.Palette selectedPalette) {
        CPManager.t("setSelectedPalette-BEG");
        int i = 0;
        while (i < this.registeredPalettes.length) {
            if (this.registeredPalettes[i].getPaletteName().equals(selectedPalette.getPaletteName())) {
                FormEditor.getFormSettings().setSelectedPalette(i);
                return;
            }
            ++i;
        }
        FormEditor.getFormSettings().setSelectedPalette(0);
        CPManager.t("setSelectedPalette-END");
    }

    public CPElements.Palette getSelectedPalette() {
        return this.selectedPalette;
    }

    public CPElements.Palette[] getRegisteredPalettes() {
        return this.registeredPalettes;
    }

    public void setShowComponentsNames(boolean value) {
        FormEditor.getFormSettings().setShowComponentsNames(value);
    }

    public boolean getShowComponentsNames() {
        return FormEditor.getFormSettings().getShowComponentsNames();
    }

    public Node getRootNode() {
        CPManager.t("getPaletteRoot");
        return this.paletteNode;
    }

    public Node[] getCategoryNodes() {
        return this.paletteNode.getChildren().getNodes();
    }

    public Node[] getItemNodes(Node categoryNode) {
        if (!(categoryNode instanceof PaletteCategoryNode)) {
            return new Node[0];
        }
        return ((PaletteCategoryNode)categoryNode).getValidItemNodes();
    }

    public JComponent getComponent() {
        CPManager.t("getComponent");
        return this.palette;
    }

    public PaletteItem getSelectedItem() {
        return this.selectedPaletteItem;
    }

    public void setSelectedItem(PaletteItem newItem) {
        if (newItem == this.selectedPaletteItem) {
            return;
        }
        PaletteItem oldItem = this.selectedPaletteItem;
        this.selectedPaletteItem = newItem;
        this.propertySupport.firePropertyChange("selectedItem", oldItem, newItem);
    }

    public int getMode() {
        return this.paletteMode;
    }

    public void setMode(int newMode) {
        if (newMode == this.paletteMode) {
            return;
        }
        int oldMode = this.paletteMode;
        this.paletteMode = newMode;
        FormDesigner designer = this.getDesigner();
        if (designer != null) {
            designer.resetConnection();
            if (newMode == 1) {
                designer.clearSelection();
            }
        }
        this.propertySupport.firePropertyChange("mode", oldMode, newMode);
    }

    public PaletteItem[] getAllItems() {
        if (this.allItems == null) {
            Node[] categoryNodes = this.paletteNode.getCategoryNodes();
            ArrayList<PaletteItem> items = new ArrayList<PaletteItem>(80);
            HashSet<String> keys = new HashSet<String>(80);
            int i = 0;
            while (i < categoryNodes.length) {
                PaletteCategoryNode catNode = (PaletteCategoryNode)categoryNodes[i];
                Node[] itemsNodes = catNode.getValidItemNodes();
                int j = 0;
                while (j < itemsNodes.length) {
                    Class cls;
                    Node itemNode = itemsNodes[j];
                    PaletteItem item = CPManager.createPaletteItem(itemNode);
                    if (item != null && (cls = item.getItemClass()) != null && !keys.contains(cls.getName())) {
                        keys.add(cls.getName());
                        items.add(item);
                    }
                    ++j;
                }
                ++i;
            }
            this.allItems = new PaletteItem[items.size()];
            items.toArray(this.allItems);
        }
        return this.allItems;
    }

    public static ResourceBundle getBundle() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$form$palette$CPManager == null ? (class$org$netbeans$modules$form$palette$CPManager = CPManager.class$("org.netbeans.modules.form.palette.CPManager")) : class$org$netbeans$modules$form$palette$CPManager));
    }

    public static PaletteItem createPaletteItem(Node itemNode) {
        try {
            return new PaletteItem(itemNode);
        }
        catch (ClassNotFoundException ex) {
            CPManager.t("createPaletteItem-ClassNotFoundException");
        }
        catch (InstantiationException ex) {
            CPManager.t("createPaletteItem-InstantiationException");
        }
        catch (IOException ex) {
            CPManager.t("createPaletteItem-IOException");
        }
        return null;
    }

    private DataFolder getPaletteUIFolder() {
        DataFolder paletteFolder = null;
        try {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(PALETTE_UI_FOLDER_NAME);
            if (fo == null) {
                fo = Repository.getDefault().getDefaultFileSystem().getRoot().createFolder(PALETTE_UI_FOLDER_NAME);
            }
            paletteFolder = DataFolder.findFolder((FileObject)fo);
            return paletteFolder;
        }
        catch (IOException ex) {
            throw new InternalError("Folder not found and cannot be created: PaletteUI");
        }
    }

    private boolean checkAvailablePalettes() {
        DataObject[] dobjs = null;
        DataFolder df = null;
        df = this.getPaletteUIFolder();
        if (df == null) {
            return false;
        }
        dobjs = df.getChildren();
        if (dobjs == null) {
            return false;
        }
        ArrayList<CPElements.Palette> palettesList = new ArrayList<CPElements.Palette>();
        int size = 0;
        int i = 0;
        while (i < dobjs.length) {
            Node node = dobjs[i].getNodeDelegate();
            if (node != null) {
                String clazzName = node.getName();
                String paletteName = node.getDisplayName();
                FileObject fo = dobjs[i].getPrimaryFile();
                Object attr = fo.getAttribute("defaultDisplayName");
                if ("instance".equals(fo.getExt()) && attr != null) {
                    if (clazzName.equals(paletteName)) {
                        paletteName = attr.toString();
                    }
                    clazzName = clazzName.replace('-', '.');
                    if (paletteName != null && clazzName != null && !paletteName.equals("") && !clazzName.equals("")) {
                        palettesList.add(size, new CPElements.Palette(paletteName, clazzName));
                        ++size;
                    }
                }
            }
            ++i;
        }
        if (size < 1) {
            return false;
        }
        this.registeredPalettes = new CPElements.Palette[size];
        int i2 = 0;
        while (i2 < size) {
            this.registeredPalettes[i2] = (CPElements.Palette)palettesList.get(i2);
            ++i2;
        }
        return true;
    }

    private void loadPalette(int index) {
        CPElements.Palette selectedPalette = index < this.registeredPalettes.length ? this.registeredPalettes[index] : this.registeredPalettes[0];
        boolean result = this.loadSelectedPalette(selectedPalette);
        if (result) {
            CPManager.t("Palette successfully loaded!");
            this.paletteNode.getChildren().getNodes();
        } else {
            CPManager.t("Palette loading failed!");
            InternalError e = new InternalError("Palette loading failed!");
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void switchUI() {
        CPManager.t("switchUI-BEG");
        this.setSelectedItem(null);
        this.setMode(0);
        this.palette.removeAll();
        this.palette.setLayout(new BorderLayout());
        this.palette.add(this.component);
        this.palette.revalidate();
        this.palette.repaint();
        CPManager.t("switchUI-END");
    }

    private FormDesigner getDesigner() {
        Node root = ComponentInspector.getInstance().getExplorerManager().getRootContext();
        if (!(root instanceof FormNode)) {
            return null;
        }
        return ((FormNode)root).getFormModel().getFormDesigner();
    }

    private void createListener4FormSettings() {
        FormEditor.getFormSettings().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedPalette".equals(evt.getPropertyName())) {
                    CPManager.this.loadPalette((Integer)evt.getNewValue());
                } else if ("showComponentsNames".equals(evt.getPropertyName())) {
                    CPManager.this.propertySupport.firePropertyChange("showComponentsNames", evt.getOldValue(), evt.getNewValue());
                }
            }
        });
    }

    private void createListeners4PaletteNodes() {
        CPManager.t("createListeners4PaletteNodes-BEG");
        this.categoryNodeListener = new NodeAdapter(){

            public void childrenAdded(NodeMemberEvent evt) {
                Node node = (Node)evt.getSource();
                CPManager.t("items added to: " + node.getName());
                if (node instanceof PaletteCategoryNode) {
                    CPManager.this.updateCategoryInEventQueue(node);
                }
            }

            public void childrenRemoved(NodeMemberEvent evt) {
                Node node = (Node)evt.getSource();
                CPManager.t("items removed from: " + node.getName());
                if (node instanceof PaletteCategoryNode) {
                    CPManager.this.updateCategoryInEventQueue(node);
                }
            }

            public void childrenReordered(NodeReorderEvent evt) {
                Node node = (Node)evt.getSource();
                CPManager.t("items reordered in: " + node.getName());
                if (node instanceof PaletteCategoryNode) {
                    CPManager.this.updateCategoryInEventQueue(node);
                }
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if ("name".equals(evt.getPropertyName()) || "displayName".equals(evt.getPropertyName())) {
                    Node node = (Node)evt.getSource();
                    CPManager.t("category node " + evt.getOldValue() + " renamed to " + evt.getNewValue());
                    if (node instanceof PaletteCategoryNode) {
                        CPManager.this.updateCategoryInEventQueue(node);
                    }
                }
            }
        };
        this.paletteNode.addNodeListener((NodeListener)new NodeAdapter(){

            public void childrenAdded(NodeMemberEvent evt) {
                CPManager.t("categories added");
                Node[] nodes = evt.getDelta();
                evt.getDeltaIndices();
                int i = 0;
                while (i < nodes.length) {
                    if (nodes[i] instanceof PaletteCategoryNode) {
                        nodes[i].addNodeListener(CPManager.this.categoryNodeListener);
                    }
                    ++i;
                }
                CPManager.this.runInEventQueue(1, evt);
            }

            public void childrenRemoved(NodeMemberEvent evt) {
                CPManager.t("categories removed");
                Node[] nodes = evt.getDelta();
                evt.getDeltaIndices();
                int i = 0;
                while (i < nodes.length) {
                    nodes[i].removeNodeListener(CPManager.this.categoryNodeListener);
                    ++i;
                }
                CPManager.this.runInEventQueue(2, evt);
            }

            public void childrenReordered(NodeReorderEvent evt) {
                CPManager.t("categories reordered");
                CPManager.this.runInEventQueue(3, null);
            }
        });
        CPManager.t("createListeners4PaletteNodes-END");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public void addManagerListener(CPManagerListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(l);
    }

    public void removeManagerListener(CPManagerListener l) {
        if (this.listeners != null) {
            this.listeners.removeElement(l);
        }
    }

    private void updateCategoryInEventQueue(Node node) {
        Set nodes = this.updateNodes;
        boolean noRefreshTask = this.updateNodes.size() == 0;
        this.updateNodes.add(node);
        CPManager.t("added category to update: " + node.getName());
        if (noRefreshTask || nodes != this.updateNodes) {
            this.runInEventQueue(4, null);
        }
        this.allItems = null;
    }

    private void runInEventQueue(int toDo, Object param) {
        CPManager.t("placing task, id: " + toDo);
        EventQueue.invokeLater(new PaletteTask(toDo, param));
    }

    private static void t(String str) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PaletteTask
    implements Runnable {
        int whatToDo;
        Object parameter;

        PaletteTask(int toDo, Object param) {
            this.whatToDo = toDo;
            this.parameter = param;
        }

        public void run() {
            Vector l;
            Set changedNodes;
            CPManager.t("performing task, id: " + this.whatToDo);
            if (this.whatToDo == 6) {
                CPManager.this.switchUI();
                CPManager.t(null);
                return;
            }
            if (this.whatToDo == 4) {
                changedNodes = CPManager.this.updateNodes;
                CPManager.this.updateNodes = new HashSet();
            } else {
                changedNodes = null;
            }
            if (CPManager.this.listeners == null) {
                return;
            }
            PaletteTask paletteTask = this;
            synchronized (paletteTask) {
                l = (Vector)CPManager.this.listeners.clone();
            }
            Iterator it = ((AbstractList)l).iterator();
            while (it.hasNext()) {
                CPManagerListener cpml = (CPManagerListener)it.next();
                if (this.whatToDo == 4) {
                    Iterator itr = changedNodes.iterator();
                    while (itr.hasNext()) {
                        Node node = (Node)itr.next();
                        cpml.categoryChanged(node);
                    }
                    continue;
                }
                if (this.parameter instanceof NodeMemberEvent) {
                    Node[] nodes = ((NodeMemberEvent)this.parameter).getDelta();
                    int[] indices = ((NodeMemberEvent)this.parameter).getDeltaIndices();
                    if (this.whatToDo == 1) {
                        cpml.categoriesAdded(nodes, indices);
                        continue;
                    }
                    if (this.whatToDo != 2) continue;
                    cpml.categoriesRemoved(nodes, indices);
                    continue;
                }
                if (this.whatToDo != 3) continue;
                cpml.categoriesReordered();
            }
            CPManager.t(null);
        }
    }
}

