/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.form.palette.CPManager;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.JPopupMenuPlus;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.PasteType;

class CategoryPopupMenu
extends JPopupMenuPlus {
    private Node catNode;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$util$datatransfer$ExClipboard;

    public CategoryPopupMenu(Node node) {
        this.catNode = node;
        Node parent = this.catNode.getParentNode();
        Index indexCookie = parent != null ? (Index)parent.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = CategoryPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index) : null;
        ResourceBundle bundle = CPManager.getBundle();
        JMenuItem menuItem = new JMenuItem(bundle.getString("CTL_MoveLeft"));
        menuItem.setEnabled(indexCookie != null && indexCookie.indexOf(this.catNode) > 0);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CategoryPopupMenu.this.moveLeft();
            }
        });
        ((JPopupMenu)((Object)this)).add(menuItem);
        menuItem = new JMenuItem(bundle.getString("CTL_MoveRight"));
        if (indexCookie != null) {
            int ind = indexCookie.indexOf(this.catNode);
            menuItem.setEnabled(ind >= 0 && ind + 1 < indexCookie.getNodesCount());
        } else {
            menuItem.setEnabled(false);
        }
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CategoryPopupMenu.this.moveRight();
            }
        });
        ((JPopupMenu)((Object)this)).add(menuItem);
        menuItem = new JMenuItem(bundle.getString("CTL_OrderBeans"));
        menuItem.setEnabled(this.catNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = CategoryPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index) != null);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CategoryPopupMenu.this.reorderBeans();
            }
        });
        ((JPopupMenu)((Object)this)).add(menuItem);
        ((JPopupMenu)((Object)this)).addSeparator();
        menuItem = new JMenuItem(bundle.getString("CTL_Paste"));
        menuItem.setEnabled(this.getPasteType() != null);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CategoryPopupMenu.this.pasteBean();
            }
        });
        ((JPopupMenu)((Object)this)).add(menuItem);
        ((JPopupMenu)((Object)this)).addSeparator();
        menuItem = new JMenuItem(bundle.getString("CTL_DeleteCategory"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CategoryPopupMenu.this.deleteNode();
            }
        });
        ((JPopupMenu)((Object)this)).add(menuItem);
        menuItem = new JMenuItem(bundle.getString("CTL_RenameCategory"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CategoryPopupMenu.this.renameNode();
            }
        });
        ((JPopupMenu)((Object)this)).add(menuItem);
    }

    private void pasteBean() {
        PasteType type = this.getPasteType();
        if (type != null) {
            try {
                Transferable trans = type.paste();
                if (trans != null) {
                    ClipboardOwner owner = trans instanceof ClipboardOwner ? (ClipboardOwner)((Object)trans) : new StringSelection("");
                    Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = CategoryPopupMenu.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
                    clipboard.setContents(trans, owner);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private PasteType getPasteType() {
        PasteType[] pasteTypes;
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = CategoryPopupMenu.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
        Transferable trans = clipboard.getContents((Object)this);
        if (trans != null && (pasteTypes = this.catNode.getPasteTypes(trans)) != null && pasteTypes.length != 0) {
            return pasteTypes[0];
        }
        return null;
    }

    private void moveLeft() {
        Node parent = this.catNode.getParentNode();
        if (parent == null) {
            return;
        }
        Index indexCookie = (Index)parent.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = CategoryPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (indexCookie == null) {
            return;
        }
        int ind = indexCookie.indexOf(this.catNode);
        if (indexCookie != null && indexCookie.indexOf(this.catNode) > 0) {
            indexCookie.moveUp(ind);
        }
    }

    private void moveRight() {
        Node parent = this.catNode.getParentNode();
        if (parent == null) {
            return;
        }
        Index indexCookie = (Index)parent.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = CategoryPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (indexCookie == null) {
            return;
        }
        int ind = indexCookie.indexOf(this.catNode);
        if (ind >= 0 && ind + 1 < indexCookie.getNodesCount()) {
            indexCookie.moveDown(ind);
        }
    }

    private void reorderBeans() {
        Index order = (Index)this.catNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = CategoryPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (order != null) {
            order.reorder();
        }
    }

    private void deleteNode() {
        String message = MessageFormat.format(CPManager.getBundle().getString("FMT_ConfirmCategoryDelete"), this.catNode.getName());
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, CPManager.getBundle().getString("CTL_ConfirmCategoryTitle"), 0);
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
            try {
                this.catNode.destroy();
            }
            catch (IOException e) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    e.printStackTrace();
                }
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private void renameNode() {
        ResourceBundle bundle = CPManager.getBundle();
        NotifyDescriptor.InputLine dlg = new NotifyDescriptor.InputLine(bundle.getString("CTL_NewName"), bundle.getString("CTL_Rename"));
        dlg.setInputText(this.catNode.getName());
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg))) {
            String newName = null;
            try {
                newName = dlg.getInputText();
                if (!"".equals(newName)) {
                    this.catNode.setName(newName);
                }
            }
            catch (IllegalArgumentException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

