/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteItemNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.JPopupMenuPlus;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

class ItemPopupMenu
extends JPopupMenuPlus {
    private Node itemNode;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$util$datatransfer$ExClipboard;

    public ItemPopupMenu(Node node) {
        this.itemNode = node;
        Node parent = this.itemNode.getParentNode();
        ResourceBundle bundle = CPManager.getBundle();
        JMenuItem menuItem = new JMenuItem(bundle.getString("CTL_MoveLeft"));
        menuItem.setEnabled(!this.itemFirstOrLast(true));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ItemPopupMenu.this.moveLeft();
            }
        });
        ((JPopupMenu)((Object)this)).add(menuItem);
        menuItem = new JMenuItem(bundle.getString("CTL_MoveRight"));
        menuItem.setEnabled(!this.itemFirstOrLast(false));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ItemPopupMenu.this.moveRight();
            }
        });
        ((JPopupMenu)((Object)this)).add(menuItem);
        ((JPopupMenu)((Object)this)).addSeparator();
        menuItem = new JMenuItem(bundle.getString("CTL_Cut"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ItemPopupMenu.this.cutNode();
            }
        });
        ((JPopupMenu)((Object)this)).add(menuItem);
        menuItem = new JMenuItem(bundle.getString("CTL_Copy"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ItemPopupMenu.this.copyNode();
            }
        });
        ((JPopupMenu)((Object)this)).add(menuItem);
        ((JPopupMenu)((Object)this)).addSeparator();
        menuItem = new JMenuItem(bundle.getString("CTL_Delete"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ItemPopupMenu.this.deleteNode();
            }
        });
        ((JPopupMenu)((Object)this)).add(menuItem);
    }

    private void moveLeft() {
        Node parent = this.itemNode.getParentNode();
        if (parent == null) {
            return;
        }
        Index indexCookie = (Index)parent.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = ItemPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (indexCookie == null) {
            return;
        }
        int ind = indexCookie.indexOf(this.itemNode);
        if (indexCookie != null && indexCookie.indexOf(this.itemNode) > 0) {
            indexCookie.moveUp(ind);
        }
    }

    private void moveRight() {
        Node parent = this.itemNode.getParentNode();
        if (parent == null) {
            return;
        }
        Index indexCookie = (Index)parent.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = ItemPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (indexCookie == null) {
            return;
        }
        int ind = indexCookie.indexOf(this.itemNode);
        if (ind >= 0 && ind + 1 < indexCookie.getNodesCount()) {
            indexCookie.moveDown(ind);
        }
    }

    private void cutNode() {
        try {
            Transferable trans = this.itemNode.clipboardCut();
            if (trans != null) {
                Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = ItemPopupMenu.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
                clipboard.setContents(trans, new StringSelection(""));
            }
        }
        catch (IOException e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                e.printStackTrace();
            }
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void copyNode() {
        try {
            Transferable trans = this.itemNode.clipboardCopy();
            if (trans != null) {
                Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = ItemPopupMenu.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
                clipboard.setContents(trans, new StringSelection(""));
            }
        }
        catch (IOException e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                e.printStackTrace();
            }
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void deleteNode() {
        String message = MessageFormat.format(CPManager.getBundle().getString("FMT_ConfirmBeanDelete"), this.itemNode.getDisplayName());
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, CPManager.getBundle().getString("CTL_ConfirmBeanTitle"), 0);
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
            try {
                this.itemNode.destroy();
            }
            catch (IOException e) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    e.printStackTrace();
                }
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private boolean itemFirstOrLast(boolean first) {
        Node parent = this.itemNode.getParentNode();
        if (parent == null) {
            return true;
        }
        boolean onTheLeft = true;
        Node[] nodes = parent.getChildren().getNodes();
        int i = 0;
        while (i < nodes.length) {
            Node node = nodes[i];
            if (node != this.itemNode) {
                if (onTheLeft ? first && node instanceof PaletteItemNode && ((PaletteItemNode)node).getItemClass() != null : node instanceof PaletteItemNode && ((PaletteItemNode)node).getItemClass() != null) {
                    return false;
                }
            } else {
                if (first) {
                    return true;
                }
                onTheLeft = false;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

