/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.form.palette.BeanInstaller;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteItemNode;
import org.netbeans.modules.form.palette.PaletteNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class PaletteCategoryNode
extends DataFolder.FolderNode {
    private static String iconURL = "org/netbeans/modules/form/resources/paletteCategory.gif";
    private static String icon32URL = "org/netbeans/modules/form/resources/paletteCategory32.gif";
    private static final String PALETTE_FOLDER_NAME = "Palette";
    private static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    private static SystemAction[] staticActions;
    private DataFolder folder;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
    static /* synthetic */ Class class$org$openide$actions$MoveDownAction;
    static /* synthetic */ Class class$org$openide$actions$ReorderAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    public PaletteCategoryNode(DataFolder folder) {
        super(folder, (Children)new PaletteCategoryNodeChildren(folder));
        this.folder = folder;
        Object catName = folder.getPrimaryFile().getAttribute("categoryName");
        if (catName != null && catName instanceof String) {
            this.setName((String)catName, false);
        } else {
            String displayName;
            String name = ((FeatureDescriptor)((Object)this)).getName();
            if (!name.equals(displayName = this.getDisplayName())) {
                this.setName(displayName, false);
            }
        }
    }

    public void setName(String name) {
        this.setName(name, true);
    }

    public void setName(String name, boolean rename) {
        if (rename) {
            if (!PaletteCategoryNode.checkCategoryName(name, (Node)this)) {
                return;
            }
            try {
                DataObject dobj = this.getDataObject();
                FileObject fobj = dobj.getPrimaryFile();
                String folderName = PaletteCategoryNode.convertToFolderName(name, fobj.getName());
                fobj.setAttribute("categoryName", null);
                dobj.rename(folderName);
                if (!folderName.equals(name)) {
                    fobj.setAttribute("categoryName", (Object)name);
                }
            }
            catch (IOException ex) {
                IllegalArgumentException e = new IllegalArgumentException();
                ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
                throw e;
            }
        }
        super.setName(name, false);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.options.component-palette");
    }

    public Node[] getValidItemNodes() {
        Node[] nodes = this.getChildren().getNodes();
        ArrayList<Node> validNodes = new ArrayList<Node>(nodes.length);
        int i = 0;
        while (i < nodes.length) {
            Node node = nodes[i];
            if (node instanceof PaletteItemNode && ((PaletteItemNode)node).getItemClass() != null) {
                validNodes.add(node);
            }
            ++i;
        }
        if (validNodes.size() != nodes.length) {
            nodes = new Node[validNodes.size()];
            validNodes.toArray(nodes);
        }
        return nodes;
    }

    public Node.Cookie getCookie(Class type) {
        DataFolder dataObj;
        if ((class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = PaletteCategoryNode.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index).isAssignableFrom(type) && (dataObj = (DataFolder)super.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = PaletteCategoryNode.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)) != null) {
            return new PaletteCategoryIndex(dataObj, (PaletteCategoryNodeChildren)this.getChildren());
        }
        return super.getCookie(type);
    }

    public Image getIcon(int type) {
        if (type == 1 || type == 3) {
            return Utilities.loadImage((String)iconURL);
        }
        return Utilities.loadImage((String)icon32URL);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public NewType[] getNewTypes() {
        return new NewType[0];
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = PaletteCategoryNode.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = PaletteCategoryNode.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction)), SystemAction.get((Class)(class$org$openide$actions$MoveDownAction == null ? (class$org$openide$actions$MoveDownAction = PaletteCategoryNode.class$("org.openide.actions.MoveDownAction")) : class$org$openide$actions$MoveDownAction)), SystemAction.get((Class)(class$org$openide$actions$ReorderAction == null ? (class$org$openide$actions$ReorderAction = PaletteCategoryNode.class$("org.openide.actions.ReorderAction")) : class$org$openide$actions$ReorderAction)), null, SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = PaletteCategoryNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = PaletteCategoryNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = PaletteCategoryNode.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction))};
        }
        return staticActions;
    }

    public Node.PropertySet[] getPropertySets() {
        return NO_PROPERTIES;
    }

    protected void createPasteTypes(Transferable t, List s) {
        boolean cut;
        Node[] nodes = NodeTransfer.nodes((Transferable)t, (int)6);
        if (nodes == null) {
            cut = false;
            nodes = NodeTransfer.nodes((Transferable)t, (int)1);
            if (nodes == null) {
                return;
            }
        } else {
            cut = true;
        }
        ArrayList<DataObject> list = new ArrayList<DataObject>();
        int i = 0;
        while (i < nodes.length) {
            FileObject fo;
            Node node = nodes[i];
            DataObject dobj = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? PaletteCategoryNode.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            InstanceCookie ic = (InstanceCookie)node.getCookie(class$org$openide$cookies$InstanceCookie == null ? PaletteCategoryNode.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
            FileObject fileObject = fo = dobj != null ? dobj.getPrimaryFile() : null;
            if (this.getChildren().findChild(node.getName()) == null && dobj != null && dobj.isValid() && ic != null && (!cut || "instance".equals(fo.getExt()) || "shadow".equals(fo.getExt()))) {
                list.add(dobj);
            }
            ++i;
        }
        if (!list.isEmpty()) {
            s.add(new BeanPaste(list, cut, false));
            if (!cut) {
                s.add(new BeanPaste(list, cut, true));
            }
        }
    }

    static boolean checkCategoryName(String name, Node namedNode) {
        boolean invalid = false;
        if (name == null || "".equals(name)) {
            invalid = true;
        } else {
            int i = 0;
            int n = name.length();
            while (i < n) {
                char ch = name.charAt(i);
                if (ch == '.' || ch == ' ' && i + 1 == n) {
                    invalid = true;
                    break;
                }
                if (ch != ' ') break;
                ++i;
            }
        }
        if (invalid) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(CPManager.getBundle().getString("ERR_InvalidName"), name), 1));
            return false;
        }
        Node[] nodes = PaletteNode.getPaletteNode().getChildren().getNodes();
        int i = 0;
        while (i < nodes.length) {
            if (name.equals(nodes[i].getName()) && nodes[i] != namedNode) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(CPManager.getBundle().getString("FMT_CategoryExists"), name), 1));
                return false;
            }
            ++i;
        }
        return true;
    }

    static String convertToFolderName(String name, String currentName) {
        int i;
        if (name == null || "".equals(name)) {
            return null;
        }
        int n = name.length();
        StringBuffer nameBuff = new StringBuffer(n);
        char ch = name.charAt(0);
        if (Character.isJavaIdentifierStart(ch)) {
            nameBuff.append(ch);
            i = 1;
        } else {
            nameBuff.append('_');
            i = 0;
        }
        while (i < n) {
            ch = name.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                nameBuff.append(ch);
            }
            ++i;
        }
        String fName = nameBuff.toString();
        if ("_".equals(fName)) {
            fName = "Category";
        }
        if (fName.equals(currentName)) {
            return fName;
        }
        FileObject paletteFO = PaletteNode.getPaletteFolder().getPrimaryFile();
        String freeName = null;
        boolean nameOK = false;
        i = 0;
        while (!nameOK) {
            String string = freeName = i > 0 ? fName + "_" + i : fName;
            if (Utilities.isWindows()) {
                nameOK = true;
                Enumeration en = paletteFO.getChildren(false);
                while (en.hasMoreElements()) {
                    FileObject fo = (FileObject)en.nextElement();
                    String fn = fo.getName();
                    String fe = fo.getExt();
                    if (fe != null && !"".equals(fe) || !fn.equalsIgnoreCase(freeName)) continue;
                    nameOK = false;
                    break;
                }
            } else {
                nameOK = paletteFO.getFileObject(freeName) == null;
            }
            ++i;
        }
        return freeName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class BeanPaste
    extends PasteType {
        private List dataObjs;
        private boolean cut;
        private boolean createLink;
        static /* synthetic */ Class class$org$netbeans$modules$form$palette$PaletteCategoryNode$BeanPaste;
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

        public BeanPaste(List dataObjs, boolean cut, boolean link) {
            this.dataObjs = dataObjs;
            this.cut = cut;
            this.createLink = link;
        }

        public String getName() {
            return this.createLink ? CPManager.getBundle().getString("CTL_PasteLink") : CPManager.getBundle().getString("CTL_PasteBean");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx((class$org$netbeans$modules$form$palette$PaletteCategoryNode$BeanPaste == null ? (class$org$netbeans$modules$form$palette$PaletteCategoryNode$BeanPaste = BeanPaste.class$("org.netbeans.modules.form.palette.PaletteCategoryNode$BeanPaste")) : class$org$netbeans$modules$form$palette$PaletteCategoryNode$BeanPaste).getName());
        }

        public final Transferable paste() throws IOException {
            DataFolder df = PaletteCategoryNode.this.folder;
            Iterator it = this.dataObjs.iterator();
            while (it.hasNext()) {
                DataObject dobj = (DataObject)it.next();
                FileObject fo = dobj.getPrimaryFile();
                if (!this.createLink && ("instance".equals(fo.getExt()) || "shadow".equals(fo.getExt()))) {
                    Object iconAttr = fo.getAttribute("SystemFileSystem.icon");
                    Object beaninfoAttr = fo.getAttribute("beaninfo");
                    if (this.cut) {
                        if (dobj.isMoveAllowed()) {
                            dobj.move(df);
                        } else {
                            dobj = null;
                        }
                    } else {
                        dobj = dobj.copy(df);
                    }
                    if (dobj == null) continue;
                    if (iconAttr != null) {
                        dobj.getPrimaryFile().setAttribute("SystemFileSystem.icon", iconAttr);
                    }
                    if (beaninfoAttr == null) continue;
                    dobj.getPrimaryFile().setAttribute("beaninfo", beaninfoAttr);
                    continue;
                }
                if (this.cut) continue;
                if (!this.createLink && ("java".equals(fo.getExt()) || "class".equals(fo.getExt()))) {
                    InstanceCookie ic = (InstanceCookie)dobj.getCookie(class$org$openide$cookies$InstanceCookie == null ? BeanPaste.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                    if (ic == null) continue;
                    BeanInstaller.createInstance(df.getPrimaryFile(), ic.instanceName());
                    continue;
                }
                dobj.createShadow(df);
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static final class PaletteCategoryIndex
    extends DataFolder.Index {
        PaletteCategoryNodeChildren children;

        PaletteCategoryIndex(DataFolder df, PaletteCategoryNodeChildren children) {
            super(df);
            this.children = children;
        }

        public int getNodesCount() {
            return this.children.getNodesCount();
        }

        public Node[] getNodes() {
            return this.children.getNodes();
        }
    }

    private static class PaletteCategoryNodeChildren
    extends FilterNode.Children {
        static /* synthetic */ Class class$org$openide$loaders$DataObject;
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

        public PaletteCategoryNodeChildren(DataFolder folder) {
            super(folder.getNodeDelegate());
        }

        protected Node copyNode(Node node) {
            if (node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = PaletteCategoryNodeChildren.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject) != null && node.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = PaletteCategoryNodeChildren.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie) != null) {
                return new PaletteItemNode(node);
            }
            return node.cloneNode();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

