/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteCategoryNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public class PaletteNode
extends DataFolder.FolderNode {
    private static PaletteNode sharedPaletteNode;
    private static String iconURL;
    private static String icon32URL;
    private static final String PALETTE_FOLDER_NAME = "Palette";
    private static final Node.PropertySet[] NO_PROPERTIES;
    private static SystemAction[] staticActions;
    private static DataFolder paletteFolder;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
    static /* synthetic */ Class class$org$openide$actions$MoveDownAction;
    static /* synthetic */ Class class$org$openide$actions$ReorderAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;

    public PaletteNode() {
        this(PaletteNode.getPaletteFolder());
    }

    PaletteNode(DataFolder folder) {
        super(folder, (Children)new PaletteNodeChildren(folder));
        this.setDisplayName(CPManager.getBundle().getString("CTL_Component_palette"));
        if (sharedPaletteNode == null) {
            sharedPaletteNode = this;
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.options.component-palette");
    }

    public static PaletteNode getPaletteNode() {
        if (sharedPaletteNode == null) {
            new PaletteNode();
        }
        return sharedPaletteNode;
    }

    public Node[] getCategoryNodes() {
        Node[] categories = this.getChildren().getNodes();
        ArrayList<Node> list = new ArrayList<Node>(categories.length);
        int i = 0;
        while (i < categories.length) {
            if (categories[i] instanceof PaletteCategoryNode) {
                list.add(categories[i]);
            }
            ++i;
        }
        return (Node[])list.toArray(new PaletteCategoryNode[list.size()]);
    }

    static DataFolder getPaletteFolder() {
        if (paletteFolder != null) {
            return paletteFolder;
        }
        try {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(PALETTE_FOLDER_NAME);
            if (fo == null) {
                fo = Repository.getDefault().getDefaultFileSystem().getRoot().createFolder(PALETTE_FOLDER_NAME);
            }
            paletteFolder = DataFolder.findFolder((FileObject)fo);
            return paletteFolder;
        }
        catch (IOException ex) {
            throw new InternalError("Folder not found and cannot be created: Palette");
        }
    }

    public Node.Cookie getCookie(Class type) {
        DataFolder dataObj;
        if ((class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = PaletteNode.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index).isAssignableFrom(type) && (dataObj = (DataFolder)super.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = PaletteNode.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)) != null) {
            return new PaletteIndex(dataObj, (PaletteNodeChildren)this.getChildren());
        }
        return super.getCookie(type);
    }

    public Image getIcon(int type) {
        if (type == 1 || type == 3) {
            return Utilities.loadImage((String)iconURL);
        }
        return Utilities.loadImage((String)icon32URL);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewCategory()};
    }

    public SystemAction[] getActions() {
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = PaletteNode.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = PaletteNode.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction)), SystemAction.get((Class)(class$org$openide$actions$MoveDownAction == null ? (class$org$openide$actions$MoveDownAction = PaletteNode.class$("org.openide.actions.MoveDownAction")) : class$org$openide$actions$MoveDownAction)), SystemAction.get((Class)(class$org$openide$actions$ReorderAction == null ? (class$org$openide$actions$ReorderAction = PaletteNode.class$("org.openide.actions.ReorderAction")) : class$org$openide$actions$ReorderAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = PaletteNode.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction))};
        }
        return staticActions;
    }

    public Node.PropertySet[] getPropertySets() {
        return NO_PROPERTIES;
    }

    void createNewCategory() throws IOException {
        ResourceBundle bundle = CPManager.getBundle();
        NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(bundle.getString("CTL_NewCategoryName"), bundle.getString("CTL_NewCategoryTitle"));
        input.setInputText(bundle.getString("CTL_NewCategoryValue"));
        while (DialogDisplayer.getDefault().notify((NotifyDescriptor)input) == NotifyDescriptor.OK_OPTION) {
            String categoryName = input.getInputText();
            if (!PaletteCategoryNode.checkCategoryName(categoryName, null)) continue;
            String folderName = PaletteCategoryNode.convertToFolderName(categoryName, null);
            FileObject folder = PaletteNode.getPaletteFolder().getPrimaryFile().createFolder(folderName);
            if (folderName.equals(categoryName)) break;
            folder.setAttribute("categoryName", (Object)categoryName);
            break;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        iconURL = "org/netbeans/modules/form/resources/palette.gif";
        icon32URL = "org/netbeans/modules/form/resources/palette32.gif";
        NO_PROPERTIES = new Node.PropertySet[0];
    }

    private final class NewCategory
    extends NewType {
        static /* synthetic */ Class class$org$netbeans$modules$form$palette$PaletteNode$NewCategory;

        private NewCategory() {
        }

        public String getName() {
            return CPManager.getBundle().getString("CTL_NewCategory");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$form$palette$PaletteNode$NewCategory == null ? (class$org$netbeans$modules$form$palette$PaletteNode$NewCategory = NewCategory.class$("org.netbeans.modules.form.palette.PaletteNode$NewCategory")) : class$org$netbeans$modules$form$palette$PaletteNode$NewCategory);
        }

        public void create() throws IOException {
            PaletteNode.this.createNewCategory();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static final class PaletteIndex
    extends DataFolder.Index {
        PaletteNodeChildren children;

        PaletteIndex(DataFolder df, PaletteNodeChildren children) {
            super(df);
            this.children = children;
        }

        public int getNodesCount() {
            return this.children.getNodesCount();
        }

        public Node[] getNodes() {
            return this.children.getNodes();
        }
    }

    private static final class PaletteNodeChildren
    extends FilterNode.Children {
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;

        public PaletteNodeChildren(DataFolder folder) {
            super(folder.getNodeDelegate());
        }

        protected Node copyNode(Node node) {
            DataFolder df = (DataFolder)node.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = PaletteNodeChildren.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            if (df != null) {
                return new PaletteCategoryNode(df);
            }
            return node.cloneNode();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

