/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ColumnLayout
implements LayoutManager {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int CENTER = 3;
    public static final int FILL = 4;
    private int _align;
    private int _gap;

    public ColumnLayout() {
        this(0);
    }

    public ColumnLayout(int gap) {
        this(gap, 4);
    }

    public ColumnLayout(int gap, int align) {
        this._gap = gap;
        this._align = align;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension size = new Dimension();
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component[] comps = parent.getComponents();
            int i = 0;
            while (i < comps.length) {
                Dimension d = comps[i].getPreferredSize();
                size.height += d.height;
                size.width = Math.max(size.width, d.width);
                if (i < comps.length - 1) {
                    size.height += this._gap;
                }
                ++i;
            }
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
        }
        return size;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component[] comps = parent.getComponents();
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            int y = insets.top;
            int width = size.width - insets.left - insets.right;
            int i = 0;
            while (i < comps.length) {
                Component c = comps[i];
                Dimension d = c.getPreferredSize();
                int ofs = 0;
                int w = d.width;
                switch (this._align) {
                    case 1: {
                        ofs = 0;
                        break;
                    }
                    case 2: {
                        ofs = width - d.width;
                        break;
                    }
                    case 3: {
                        ofs = (width - d.width) / 2;
                        break;
                    }
                    case 4: {
                        ofs = 0;
                    }
                }
                c.setBounds(insets.left + ofs, y, w, d.height);
                y += d.height + this._gap;
                ++i;
            }
        }
    }
}

