/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class FormLayout
implements LayoutManager {
    public static final String LEFT = "Left";
    public static final String RIGHT = "Right";
    public static final String CENTER = "Center";
    public static final String FILL = "Fill";
    private int _hgap;
    private int _vgap;
    private Hashtable _constraints = new Hashtable();

    public FormLayout() {
        this(0, 0);
    }

    public FormLayout(int hgap, int vgap) {
        this._hgap = hgap;
        this._vgap = vgap;
    }

    public void setHgap(int hgap) {
        this._hgap = hgap;
    }

    public int getHgap() {
        return this._hgap;
    }

    public void setVgap(int vgap) {
        this._vgap = vgap;
    }

    public int getVgap() {
        return this._vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
        if (name == null) {
            name = LEFT;
        }
        this._constraints.put(comp, name);
    }

    public void removeLayoutComponent(Component comp) {
        this._constraints.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension size = new Dimension();
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component[] comps = parent.getComponents();
            Insets insets = parent.getInsets();
            int maxleft = 0;
            int maxright = 0;
            Dimension empty = new Dimension();
            int count = comps.length;
            int i = 0;
            while (i < count) {
                Dimension d = comps[i].getPreferredSize();
                Dimension d2 = i >= count - 1 ? empty : comps[i + 1].getPreferredSize();
                size.height += Math.max(d.height, d2.height);
                maxleft = Math.max(maxleft, d.width);
                maxright = Math.max(maxright, d2.width);
                if (i < count - 2) {
                    size.height += this._vgap;
                }
                i += 2;
            }
            size.width += insets.left + insets.right + this._hgap + maxleft + maxright;
            size.height += insets.top + insets.bottom;
        }
        return size;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component[] comps = parent.getComponents();
            int count = comps.length;
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            Dimension empty = new Dimension();
            int xalign = 0;
            int i = 0;
            while (i < count) {
                xalign = Math.max(xalign, comps[i].getPreferredSize().width);
                i += 2;
            }
            xalign += insets.left;
            int y = insets.top;
            int i2 = 0;
            while (i2 < count) {
                Dimension d2;
                Component c2;
                Component c = comps[i2];
                Dimension d = c.getPreferredSize();
                if (i2 < comps.length - 1) {
                    c2 = comps[i2 + 1];
                    d2 = c2.getPreferredSize();
                } else {
                    c2 = null;
                    d2 = empty;
                }
                int h = Math.max(d.height, d2.height);
                this.setComponentBounds(c, insets.left, y, xalign - insets.left, h);
                if (c2 != null) {
                    this.setComponentBounds(c2, xalign + this._hgap, y, size.width - (xalign + this._hgap + insets.right), h);
                }
                y += h + this._vgap;
                i2 += 2;
            }
        }
    }

    private void setComponentBounds(Component c, int x, int y, int w, int h) {
        String constraint = (String)this._constraints.get(c);
        Dimension sz = new Dimension(c.getPreferredSize());
        sz.width = Math.min(sz.width, w);
        sz.height = Math.min(sz.height, h);
        if (LEFT.equals(constraint)) {
            w = sz.width;
        } else if (RIGHT.equals(constraint)) {
            x = w - sz.width;
            w = sz.width;
        } else if (CENTER.equals(constraint)) {
            x += (w - sz.width) / 2;
            w = sz.width;
        }
        c.setBounds(x, y + (h - sz.height) / 2, w, sz.height);
    }
}

