/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class RowLayout
implements LayoutManager {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int CENTER = 3;
    public static final int FILL = 4;
    private int _align;
    private int _gap;

    public RowLayout() {
        this(0);
    }

    public RowLayout(int gap) {
        this(gap, 4);
    }

    public RowLayout(int gap, int align) {
        this._gap = gap;
        this._align = align;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension size = new Dimension();
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component[] comps = parent.getComponents();
            int i = 0;
            while (i < comps.length) {
                Dimension d = comps[i].getPreferredSize();
                size.width += d.width;
                size.height = Math.max(size.height, d.height);
                if (i < comps.length - 1) {
                    size.width += this._gap;
                }
                ++i;
            }
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
        }
        return size;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Component[] comps = parent.getComponents();
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            int x = insets.left;
            int height = size.height - insets.top - insets.bottom;
            int i = 0;
            while (i < comps.length) {
                Component c = comps[i];
                Dimension d = c.getPreferredSize();
                int ofs = 0;
                int h = d.height;
                switch (this._align) {
                    case 1: {
                        ofs = 0;
                        break;
                    }
                    case 2: {
                        ofs = height - d.height;
                        break;
                    }
                    case 3: {
                        ofs = (height - d.height) / 2;
                        break;
                    }
                    case 4: {
                        ofs = 0;
                        h = height;
                    }
                }
                c.setBounds(x, insets.top + ofs, d.width, h);
                x += d.width + this._gap;
                ++i;
            }
        }
    }
}

