/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyBundleListener;
import org.netbeans.modules.properties.PropertyBundleSupport;
import org.netbeans.modules.properties.StructHandler;
import org.openide.util.WeakListener;

public class BundleStructure {
    PropertiesDataObject obj;
    private PropertiesFileEntry[] entries;
    private ArrayList keyList;
    private KeyComparator comparator = new KeyComparator();
    private PropertyBundleSupport propBundleSupport = new PropertyBundleSupport(this);
    private PropertyChangeListener propListener;

    public BundleStructure(PropertiesDataObject obj) {
        this.obj = obj;
        this.updateEntries();
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("files")) {
                    BundleStructure.this.updateEntries();
                    BundleStructure.this.propBundleSupport.fireBundleStructureChanged();
                }
            }
        };
        obj.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propListener, (Object)((Object)obj)));
    }

    public PropertiesFileEntry getNthEntry(int i) {
        if (this.entries == null) {
            throw new IllegalStateException("Resource Bundles: Entries not initialized");
        }
        try {
            return this.entries[i];
        }
        catch (ArrayIndexOutOfBoundsException aibe) {
            return null;
        }
    }

    public int getEntryIndexByFileName(String fileName) {
        if (this.entries == null) {
            throw new IllegalStateException("Resource Bundles: Entries not initialized");
        }
        int i = 0;
        while (i < this.getEntryCount()) {
            if (this.entries[i].getFile().getName().equals(fileName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public PropertiesFileEntry getEntryByFileName(String fileName) {
        int index = this.getEntryIndexByFileName(fileName);
        return index == -1 ? null : this.entries[index];
    }

    public int getEntryCount() {
        if (this.entries == null) {
            throw new IllegalStateException("Resource Bundles: Entries not initialized");
        }
        return this.entries.length;
    }

    public String[] getKeys() {
        if (this.keyList == null) {
            throw new IllegalStateException("Resource Bundles: KeyList not initialized");
        }
        Object[] keyArray = this.keyList.toArray();
        String[] stringArray = new String[keyArray.length];
        System.arraycopy(keyArray, 0, stringArray, 0, keyArray.length);
        return stringArray;
    }

    public String keyAt(int keyIndex) {
        if (this.keyList == null) {
            throw new IllegalStateException("Resource Bundles: KeyList not initialized");
        }
        if (keyIndex >= this.keyList.size() || keyIndex < 0) {
            return null;
        }
        return (String)this.keyList.get(keyIndex);
    }

    public int getKeyIndexByName(String keyName) {
        return this.keyList.indexOf(keyName);
    }

    public Element.ItemElem getItem(int entryIndex, int keyIndex) {
        String key = this.keyAt(keyIndex);
        return this.getItem(entryIndex, key);
    }

    public Element.ItemElem getItem(int entryIndex, String key) {
        if (key == null) {
            return null;
        }
        PropertiesFileEntry pfe = this.getNthEntry(entryIndex);
        if (pfe == null) {
            return null;
        }
        PropertiesStructure ps = pfe.getHandler().getStructure();
        if (ps != null) {
            return ps.getItem(key);
        }
        return null;
    }

    public int getKeyCount() {
        if (this.keyList != null) {
            return this.keyList.size();
        }
        throw new IllegalStateException("Resource Bundles: KeyList not initialized");
    }

    public void sort(int index) {
        if (index >= 0) {
            this.comparator.setIndex(index);
        }
        Collections.sort(this.keyList, this.comparator);
        this.propBundleSupport.fireBundleDataChanged();
    }

    public int getSortIndex() {
        return this.comparator.getIndex();
    }

    public boolean getSortOrder() {
        return this.comparator.isAscending();
    }

    private void updateEntries() {
        TreeMap<String, PropertiesFileEntry> tm = new TreeMap<String, PropertiesFileEntry>(PropertiesDataObject.getSecondaryFilesComparator());
        Iterator it = this.obj.secondaryEntries().iterator();
        while (it.hasNext()) {
            PropertiesFileEntry pfe = (PropertiesFileEntry)((Object)it.next());
            tm.put(pfe.getFile().getName(), pfe);
        }
        BundleStructure bundleStructure = this;
        synchronized (bundleStructure) {
            this.entries = new PropertiesFileEntry[tm.size() + 1];
            this.entries[0] = (PropertiesFileEntry)this.obj.getPrimaryEntry();
            int index = 0;
            Iterator it2 = tm.keySet().iterator();
            while (it2.hasNext()) {
                this.entries[++index] = (PropertiesFileEntry)((Object)tm.get(it2.next()));
            }
        }
        this.buildKeySet();
    }

    private void buildKeySet() {
        this.keyList = new ArrayList(){

            public boolean equals(Object obj) {
                if (!(obj instanceof ArrayList)) {
                    return false;
                }
                ArrayList list2 = (ArrayList)obj;
                if (this.size() != list2.size()) {
                    return false;
                }
                int i = 0;
                while (i < this.size()) {
                    if (!this.contains(list2.get(i)) || !list2.contains(this.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
        int index = 0;
        while (index < this.getEntryCount()) {
            PropertiesFileEntry entry = this.getNthEntry(index);
            PropertiesStructure ps = entry.getHandler().getStructure();
            if (ps != null) {
                Iterator it = ps.allItems();
                while (it.hasNext()) {
                    String key;
                    Element.ItemElem item = (Element.ItemElem)it.next();
                    if (item == null || (key = item.getKey()) == null || this.keyList.contains(key)) continue;
                    this.keyList.add(item.getKey());
                }
            }
            ++index;
        }
        Collections.sort(this.keyList, this.comparator);
    }

    public void addPropertyBundleListener(PropertyBundleListener l) {
        this.propBundleSupport.addPropertyBundleListener(l);
    }

    public void removePropertyBundleListener(PropertyBundleListener l) {
        this.propBundleSupport.removePropertyBundleListener(l);
    }

    void itemChanged(Element.ItemElem item) {
        this.propBundleSupport.fireItemChanged(item.getParent().getParent().getEntry().getFile().getName(), item.getKey());
    }

    void oneFileChanged(StructHandler handler) {
        ArrayList oldKeyList = this.keyList;
        this.buildKeySet();
        if (!((AbstractList)this.keyList).equals(oldKeyList)) {
            this.propBundleSupport.fireBundleDataChanged();
        } else {
            this.propBundleSupport.fireFileChanged(handler.getEntry().getFile().getName());
        }
    }

    void oneFileChanged(StructHandler handler, Map itemsChanged, Map itemsAdded, Map itemsDeleted) {
        this.buildKeySet();
        this.propBundleSupport.fireBundleDataChanged();
    }

    private final class KeyComparator
    implements Comparator {
        private int index = -1;
        private boolean ascending = false;

        public void setIndex(int index) {
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            if (this.index == index) {
                if (this.ascending) {
                    this.ascending = false;
                } else {
                    index = -1;
                    this.ascending = true;
                }
            } else {
                this.ascending = true;
            }
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public int compare(Object o1, Object o2) {
            String str2;
            String str1;
            Element.ItemElem item2;
            Element.ItemElem item1;
            if (this.index < 0) {
                item1 = BundleStructure.this.getItem(0, (String)o1);
                item2 = BundleStructure.this.getItem(0, (String)o2);
                if (item1 != null && item2 != null) {
                    int i1 = item1.getBounds().getBegin().getOffset();
                    int i2 = item2.getBounds().getBegin().getOffset();
                    return i1 - i2;
                }
                if (item1 != null) {
                    return -1;
                }
                if (item2 != null) {
                    return 1;
                }
                str1 = (String)o1;
                str2 = (String)o2;
            }
            if (this.index == 0) {
                str1 = (String)o1;
                str2 = (String)o2;
            } else {
                item1 = BundleStructure.this.getItem(this.index - 1, (String)o1);
                item2 = BundleStructure.this.getItem(this.index - 1, (String)o2);
                if (item1 == null) {
                    if (item2 == null) {
                        return 0;
                    }
                    return this.ascending ? 1 : -1;
                }
                if (item2 == null) {
                    return this.ascending ? -1 : 1;
                }
                str1 = item1.getValue();
                str2 = item2.getValue();
            }
            if (str1 == null) {
                if (str2 == null) {
                    return 0;
                }
                return this.ascending ? 1 : -1;
            }
            if (str2 == null) {
                return this.ascending ? -1 : 1;
            }
            int res = str1.compareToIgnoreCase(str2);
            return this.ascending ? res : -res;
        }
    }
}

