/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.properties.PropertiesStructure;
import org.openide.nodes.Node;
import org.openide.text.PositionBounds;

public abstract class Element
implements Serializable {
    private transient PropertyChangeSupport support;
    protected PositionBounds bounds;

    protected Element(PositionBounds bounds) {
        this.bounds = bounds;
    }

    public PositionBounds getBounds() {
        return this.bounds;
    }

    void update(Element elem) {
        this.bounds = elem.bounds;
    }

    protected final void firePropertyChange(String name, Object o, Object n) {
        if (this.support != null) {
            this.support.firePropertyChange(name, o, n);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.support == null) {
            Element element = this;
            synchronized (element) {
                if (this.support == null) {
                    this.support = new PropertyChangeSupport(this);
                }
            }
        }
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.support != null) {
            this.support.removePropertyChangeListener(l);
        }
    }

    public void print() {
        if (this.bounds == null) {
            return;
        }
        try {
            this.bounds.setText(this.printString());
        }
        catch (BadLocationException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public abstract String printString();

    public String toString() {
        return this.bounds == null ? "(no bounds)" : "(" + this.bounds.getBegin().getOffset() + ", " + this.bounds.getEnd().getOffset() + ")";
    }

    public static class ItemElem
    extends Element
    implements Node.Cookie {
        private KeyElem key;
        private ValueElem value;
        private CommentElem comment;
        private PropertiesStructure parent;
        public static final String PROP_ITEM_KEY = "key";
        public static final String PROP_ITEM_VALUE = "value";
        public static final String PROP_ITEM_COMMENT = "comment";
        static final long serialVersionUID = 1078147817847520586L;

        protected ItemElem(PositionBounds bounds, KeyElem key, ValueElem value, CommentElem comment) {
            super(bounds);
            this.key = key;
            this.value = value;
            this.comment = comment;
        }

        void setParent(PropertiesStructure ps) {
            this.parent = ps;
        }

        public PropertiesStructure getParent() {
            if (this.parent == null) {
                throw new IllegalStateException("Resource Bundle: Parent is missing");
            }
            return this.parent;
        }

        public String toString() {
            return this.comment.toString() + "\n" + (this.key == null ? "" : this.key.toString()) + "\n" + (this.value == null ? "" : this.value.toString()) + "\n";
        }

        public KeyElem getKeyElem() {
            return this.key;
        }

        public ValueElem getValueElem() {
            return this.value;
        }

        public CommentElem getCommentElem() {
            return this.comment;
        }

        void update(Element elem) {
            super.update(elem);
            if (this.key == null) {
                this.key = ((ItemElem)elem).key;
            } else {
                this.key.update(((ItemElem)elem).key);
            }
            if (this.value == null) {
                this.value = ((ItemElem)elem).value;
            } else {
                this.value.update(((ItemElem)elem).value);
            }
            this.comment.update(((ItemElem)elem).comment);
        }

        public String printString() {
            return this.comment.printString() + (this.key == null ? "" : this.key.printString()) + (this.value == null ? "" : this.value.printString());
        }

        public String getKey() {
            return this.key == null ? null : this.key.getValue();
        }

        public void setKey(String newKey) {
            String oldKey = this.key.getValue();
            if (!oldKey.equals(newKey)) {
                this.key.setValue(newKey);
                this.getParent().itemKeyChanged(oldKey, this);
                this.firePropertyChange(PROP_ITEM_KEY, oldKey, newKey);
            }
        }

        public String getValue() {
            return this.value == null ? null : this.value.getValue();
        }

        public void setValue(String newValue) {
            String oldValue = this.value.getValue();
            if (!oldValue.equals(newValue)) {
                if (oldValue.equals("")) {
                    this.key.print();
                }
                this.value.setValue(newValue);
                this.getParent().itemChanged(this);
                this.firePropertyChange(PROP_ITEM_VALUE, oldValue, newValue);
            }
        }

        public String getComment() {
            return this.comment == null ? null : this.comment.getValue();
        }

        public void setComment(String newComment) {
            String oldComment = this.comment.getValue();
            if (!oldComment.equals(newComment)) {
                this.comment.setValue(newComment);
                this.getParent().itemChanged(this);
                this.firePropertyChange(PROP_ITEM_COMMENT, oldComment, newComment);
            }
        }

        public boolean equals(Object item) {
            if (item == null || !(item instanceof ItemElem)) {
                return false;
            }
            ItemElem ie = (ItemElem)item;
            return (this.key == null && ie.getKeyElem() == null || this.key != null && ie.getKeyElem() != null && this.getKey().equals(ie.getKey())) && (this.value == null && ie.getValueElem() == null || this.value != null && ie.getValueElem() != null && this.getValue().equals(ie.getValue())) && (this.comment == null && ie.getCommentElem() == null || this.comment != null && ie.getCommentElem() != null && this.getComment().equals(ie.getComment()));
        }
    }

    public static class CommentElem
    extends Basic {
        static final long serialVersionUID = 2418308580934815756L;

        protected CommentElem(PositionBounds bounds, String value) {
            super(bounds, value);
        }

        public String printString() {
            if (this.value == null || this.value.length() == 0) {
                return "";
            }
            int candidate = 0;
            StringBuffer sb = new StringBuffer(this.value);
            int i = 0;
            while (i < sb.length()) {
                char aChar;
                if ((aChar = sb.charAt(i++)) == '\n') {
                    candidate = i;
                    continue;
                }
                if (candidate == -1 || " \t\r\n\f".indexOf(aChar) != -1) continue;
                if (aChar != '#' && aChar != '!') {
                    sb.insert(candidate, '#');
                    ++i;
                }
                candidate = -1;
            }
            if (sb.charAt(sb.length() - 1) != '\n') {
                sb.append('\n');
            }
            return sb.toString();
        }
    }

    public static class ValueElem
    extends Basic {
        static final long serialVersionUID = 4662649023463958853L;

        protected ValueElem(PositionBounds bounds, String value) {
            super(bounds, value);
        }

        public String printString() {
            return this.getValue() + "\n";
        }
    }

    public static class KeyElem
    extends Basic {
        static final long serialVersionUID = 6828294289485744331L;

        protected KeyElem(PositionBounds bounds, String value) {
            super(bounds, value);
        }

        public String printString() {
            return this.getValue() + "=";
        }
    }

    public static abstract class Basic
    extends Element {
        protected String value;

        protected Basic(PositionBounds bounds, String value) {
            super(bounds);
            this.value = value;
        }

        void update(Element elem) {
            super.update(elem);
            this.value = ((Basic)elem).value;
        }

        public String toString() {
            return this.value + "   " + super.toString();
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
            this.print();
        }
    }
}

