/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.properties.FindPanel;
import org.netbeans.modules.properties.PropertiesTableCellEditor;
import org.netbeans.modules.properties.PropertiesTableModel;
import org.netbeans.modules.properties.TableViewSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;

public class FindPerformer
implements ActionPerformer,
PropertyChangeListener {
    private JTable table;
    private String findString;
    private int[] searchValues;
    private boolean highlightSearch = true;
    private boolean matchCaseSearch = false;
    private boolean backwardSearch = false;
    private boolean wrapSearch = true;
    private boolean rowSearch = true;
    private final ActionListener findNextActionListener;
    private final ActionListener findPreviousActionListener;
    private final ActionListener toggleHighlightListener;
    private HashSet history = new HashSet();
    private TableViewSettings settings;
    private static SoftReference softRef;
    private static JDialog findDialog;
    public static final String TABLE_SEARCH_RESULT = "table.search.result";
    static /* synthetic */ Class class$org$netbeans$modules$properties$FindPerformer;

    private FindPerformer(JTable table) {
        this.findNextActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (FindPerformer.this.searchValues != null) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        FindPerformer.this.backwardSearch = false;
                        FindPerformer.this.performSearch();
                    }
                }
            }
        };
        this.findPreviousActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (FindPerformer.this.searchValues != null) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        FindPerformer.this.backwardSearch = true;
                        FindPerformer.this.performSearch();
                    }
                }
            }
        };
        this.toggleHighlightListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindPerformer.this.highlightSearch = !FindPerformer.this.highlightSearch;
                FindPerformer.this.table.repaint();
            }
        };
        this.table = table;
        this.settings = TableViewSettings.getDefault();
        this.settings.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this, (Object)this.settings));
        this.registerKeyStrokes();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.registerKeyStrokes();
    }

    public static FindPerformer getFindPerformer(JTable table) {
        Object ob;
        if (softRef != null && (ob = softRef.get()) != null) {
            FindPerformer fp = (FindPerformer)ob;
            if (!fp.validateTable(table)) {
                fp.resetTable(table);
                fp.registerKeyStrokes();
            }
            return fp;
        }
        FindPerformer fp = new FindPerformer(table);
        softRef = new SoftReference<FindPerformer>(fp);
        return fp;
    }

    private void resetTable(JTable table) {
        this.table = table;
    }

    private boolean validateTable(JTable table) {
        return this.table != null && this.table.equals(table);
    }

    private synchronized void registerKeyStrokes() {
        KeyStroke[] keyStrokes = this.settings.getKeyStrokesFindNext();
        int i = 0;
        while (i < keyStrokes.length) {
            this.table.registerKeyboardAction(this.findNextActionListener, keyStrokes[i], 2);
            ++i;
        }
        keyStrokes = this.settings.getKeyStrokesFindPrevious();
        int i2 = 0;
        while (i2 < keyStrokes.length) {
            this.table.registerKeyboardAction(this.findPreviousActionListener, keyStrokes[i2], 2);
            ++i2;
        }
        keyStrokes = this.settings.getKeyStrokesToggleHighlight();
        int i3 = 0;
        while (i3 < keyStrokes.length) {
            this.table.registerKeyboardAction(this.toggleHighlightListener, keyStrokes[i3], 2);
            ++i3;
        }
    }

    public String getFindString() {
        return this.findString;
    }

    public boolean isHighlightSearch() {
        return this.highlightSearch;
    }

    public void performAction(SystemAction action) {
        if (findDialog == null) {
            this.createFindDialog();
        } else {
            ((Component)findDialog).setVisible(true);
            findDialog.requestFocus();
        }
    }

    private void createFindDialog() {
        final JDialog[] dialog = new JDialog[1];
        final FindPanel panel = new FindPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$FindPerformer == null ? (class$org$netbeans$modules$properties$FindPerformer = FindPerformer.class$("org.netbeans.modules.properties.FindPerformer")) : class$org$netbeans$modules$properties$FindPerformer)).getString("LBL_Title"), false, (Object[])new JButton[0], null, 0, null, null);
        dialog[0] = (JDialog)DialogDisplayer.getDefault().createDialog(dd);
        findDialog = dialog[0];
        dialog[0].getRootPane().setDefaultButton(panel.getButtons()[0]);
        panel.getButtons()[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindPerformer.this.findString = ((JTextField)panel.getComboBox().getEditor().getEditorComponent()).getText();
                FindPerformer.this.highlightSearch = panel.getHighlightCheck().isSelected();
                FindPerformer.this.matchCaseSearch = panel.getMatchCaseCheck().isSelected();
                FindPerformer.this.backwardSearch = panel.getBackwardCheck().isSelected();
                FindPerformer.this.wrapSearch = panel.getWrapCheck().isSelected();
                FindPerformer.this.rowSearch = panel.getRowCheck().isSelected();
                ((Component)dialog[0]).setVisible(false);
                dialog[0].dispose();
                findDialog = null;
                if (FindPerformer.this.findString != null && !FindPerformer.this.findString.trim().equals("")) {
                    FindPerformer.this.history.add(FindPerformer.this.findString.intern());
                    FindPerformer.this.performSearch();
                }
                FindPerformer.this.table.repaint();
            }
        });
        panel.getButtons()[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ((Component)dialog[0]).setVisible(false);
                dialog[0].dispose();
                findDialog = null;
            }
        });
        panel.getHighlightCheck().setSelected(this.highlightSearch);
        panel.getMatchCaseCheck().setSelected(this.matchCaseSearch);
        panel.getBackwardCheck().setSelected(this.backwardSearch);
        panel.getWrapCheck().setSelected(this.wrapSearch);
        panel.getRowCheck().setSelected(this.rowSearch);
        panel.getComboBox().setModel(new DefaultComboBoxModel<Object>(((AbstractCollection)this.history).toArray()));
        if (this.findString != null) {
            panel.getComboBox().setSelectedItem(this.findString);
        }
        panel.getComboBox().requestFocus();
        ((Component)dialog[0]).setVisible(true);
    }

    public void closeFindDialog() {
        if (findDialog != null) {
            JDialog jDialog = findDialog;
            synchronized (jDialog) {
                ((Component)findDialog).setVisible(false);
                findDialog.dispose();
                findDialog = null;
            }
        }
    }

    private void prepareSearch() {
        int row = this.table.getSelectedRow();
        int column = this.table.getSelectedColumn();
        if (this.searchValues != null && row == this.searchValues[0] && column == this.searchValues[1]) {
            return;
        }
        if (row != -1 || column != -1) {
            int endOffset;
            int startOffset = endOffset = ((JTextField)((PropertiesTableCellEditor)this.table.getCellEditor(row, column)).getComponent()).getCaretPosition();
            this.searchValues = new int[]{row, column, startOffset, endOffset};
        } else if (this.backwardSearch) {
            int endOffset;
            int lastRow = this.table.getRowCount() - 1;
            int lastColumn = this.table.getColumnCount() - 1;
            int startOffset = endOffset = ((PropertiesTableModel.StringPair)this.table.getValueAt(lastRow, lastColumn)).getValue().length() - 1;
            this.searchValues = new int[]{lastRow, lastColumn, startOffset, endOffset};
        } else {
            this.searchValues = new int[]{0, 0, 0, 0};
        }
    }

    private synchronized void performSearch() {
        this.prepareSearch();
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                boolean wrap = false;
                do {
                    int[] result = FindPerformer.this.search(FindPerformer.this.searchValues[0], FindPerformer.this.searchValues[1], FindPerformer.this.backwardSearch ? FindPerformer.this.searchValues[2] - 1 : FindPerformer.this.searchValues[3]);
                    if (FindPerformer.this.wrapSearch && !wrap && result == null) {
                        if (FindPerformer.this.backwardSearch) {
                            int lastRow = FindPerformer.this.table.getRowCount() - 1;
                            int lastColumn = FindPerformer.this.table.getColumnCount() - 1;
                            FindPerformer.access$002(FindPerformer.this, new int[]{lastRow, lastColumn, ((PropertiesTableModel.StringPair)FindPerformer.this.table.getValueAt(lastRow, lastColumn)).getValue().length() - 1, 0});
                        } else {
                            FindPerformer.access$002(FindPerformer.this, new int[]{0, 0, 0, 0});
                        }
                        wrap = true;
                        continue;
                    }
                    if (result != null) {
                        FindPerformer.access$002(FindPerformer.this, result);
                        SwingUtilities.invokeLater(new Runnable(this, result){
                            private final /* synthetic */ int[] val$result;
                            private final /* synthetic */ 6 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$result = val$result;
                            }

                            public void run() {
                                Rectangle cellRect;
                                if (FindPerformer.access$400(6.access$1200(this.this$1)).getAutoscrolls() && (cellRect = FindPerformer.access$400(6.access$1200(this.this$1)).getCellRect(this.val$result[0], this.val$result[1], false)) != null) {
                                    FindPerformer.access$400(6.access$1200(this.this$1)).scrollRectToVisible(cellRect);
                                }
                                FindPerformer.access$400(6.access$1200(this.this$1)).getColumnModel().getSelectionModel().setSelectionInterval(this.val$result[1], this.val$result[1]);
                                FindPerformer.access$400(6.access$1200(this.this$1)).getSelectionModel().setSelectionInterval(this.val$result[0], this.val$result[0]);
                                FindPerformer.access$400(6.access$1200(this.this$1)).editCellAt(this.val$result[0], this.val$result[1]);
                            }
                        });
                    }
                    FindPerformer.access$002(FindPerformer.this, result);
                    wrap = false;
                } while (wrap);
            }

            static /* synthetic */ FindPerformer access$1200(6 x0) {
                return x0.FindPerformer.this;
            }
        });
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private int[] search(int startRow, int startColumn, int startOffset) {
        boolean bl;
        boolean firstIteration = true;
        int i = this.rowSearch ? startRow : startColumn;
        boolean bl2 = true;
        do {
            if (!bl2 || (bl2 = false) || !true) {
                boolean bl3;
                int j = this.rowSearch ? startColumn : startRow;
                boolean bl4 = true;
                do {
                    if (!bl4 || (bl4 = false) || !true) {
                        int column;
                        int row = this.rowSearch ? i : j;
                        String str = ((PropertiesTableModel.StringPair)this.table.getValueAt(row, column = this.rowSearch ? j : i)).toString();
                        if (str != null && str.length() >= this.findString.length()) {
                            int offset;
                            if (!firstIteration) {
                                int n = startOffset = this.backwardSearch ? str.length() - this.findString.length() : 0;
                            }
                            if ((offset = this.containsFindString(str, startOffset)) >= 0) {
                                this.table.putClientProperty(TABLE_SEARCH_RESULT, new int[]{row, column, offset, offset + this.findString.length()});
                                return new int[]{row, column, offset, offset + this.findString.length()};
                            }
                            if (firstIteration) {
                                firstIteration = false;
                            }
                        }
                        int n = j = this.backwardSearch ? j - 1 : j + 1;
                    }
                    if (this.backwardSearch) {
                        if (j >= 0) {
                            bl3 = true;
                            continue;
                        }
                        bl3 = false;
                        continue;
                    }
                    bl3 = j < (this.rowSearch ? this.table.getColumnCount() : this.table.getRowCount());
                } while (bl3);
                if (this.rowSearch) {
                    startColumn = this.backwardSearch ? this.table.getColumnCount() - 1 : 0;
                } else {
                    startRow = this.backwardSearch ? this.table.getRowCount() - 1 : 0;
                }
                int n = i = this.backwardSearch ? i - 1 : i + 1;
            }
            if (this.backwardSearch) {
                if (i < 0) return null;
                bl = true;
                continue;
            }
            if (i >= (this.rowSearch ? this.table.getRowCount() : this.table.getColumnCount())) return null;
            bl = true;
        } while (bl);
        return null;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private int containsFindString(String str, int startOffset) {
        boolean bl;
        if (startOffset < 0) return -1;
        if (startOffset >= str.length()) {
            return -1;
        }
        int i = startOffset;
        boolean bl2 = true;
        do {
            if (!bl2 || (bl2 = false) || !true) {
                if (this.findString.regionMatches(!this.matchCaseSearch, 0, str, i, this.findString.length())) {
                    return i;
                }
                int n = i = this.backwardSearch ? i - 1 : i + 1;
            }
            if (this.backwardSearch) {
                if (i < 0) return -1;
                bl = true;
                continue;
            }
            if (i >= str.length() - this.findString.length() + 1) return -1;
            bl = true;
        } while (bl);
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ int[] access$002(FindPerformer x0, int[] x1) {
        x0.searchValues = x1;
        return x1;
    }
}

