/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public abstract class PresentableFileEntry
extends FileEntry
implements Node.Cookie {
    static final long serialVersionUID = 3328227388376142699L;
    private transient Node nodeDelegate;
    private boolean modif = false;
    private transient PropertyChangeSupport changeSupport;
    private ChangeListener cookieL = new ChangeListener(){

        public void stateChanged(ChangeEvent ev) {
            PresentableFileEntry.this.firePropertyChange("cookie", null, null);
        }
    };
    private transient CookieSet cookieSet;
    private transient Object nodeDelegateMutex = new Object();

    public PresentableFileEntry(MultiDataObject obj, FileObject fo) {
        super(obj, fo);
    }

    protected abstract Node createNodeDelegate();

    public final Node getNodeDelegate() {
        Object object = this.nodeDelegateMutex;
        synchronized (object) {
            if (this.nodeDelegate == null) {
                this.nodeDelegate = this.createNodeDelegate();
            }
            Node node = this.nodeDelegate;
            return node;
        }
    }

    private static boolean setTemplate(FileObject fo, boolean newTempl) throws IOException {
        boolean oldTempl = false;
        Object o = fo.getAttribute("template");
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            oldTempl = true;
        }
        if (oldTempl == newTempl) {
            return false;
        }
        fo.setAttribute("template", (Object)(newTempl ? Boolean.TRUE : null));
        return true;
    }

    public final void setTemplate(boolean newTempl) throws IOException {
        if (!PresentableFileEntry.setTemplate(this.getFile(), newTempl)) {
            return;
        }
        this.firePropertyChange("template", !newTempl ? Boolean.TRUE : Boolean.FALSE, newTempl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isTemplate() {
        Object o = this.getFile().getAttribute("template");
        boolean ret = false;
        if (o instanceof Boolean) {
            ret = (Boolean)o;
        }
        return ret;
    }

    public FileObject rename(String name) throws IOException {
        String oldName = this.getName();
        FileObject fo = super.rename(name);
        this.firePropertyChange("name", oldName, name);
        return fo;
    }

    public FileObject renameEntry(String name) throws IOException {
        return this.rename(name);
    }

    public void delete() throws IOException {
        super.delete();
        this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
    }

    public abstract boolean isDeleteAllowed();

    public abstract boolean isCopyAllowed();

    public abstract boolean isMoveAllowed();

    public boolean isShadowAllowed() {
        return true;
    }

    public abstract boolean isRenameAllowed();

    public boolean isModified() {
        return this.modif;
    }

    public void setModified(boolean modif) {
        if (this.modif != modif) {
            this.modif = modif;
            this.firePropertyChange("modified", !modif ? Boolean.TRUE : Boolean.FALSE, modif ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public abstract HelpCtx getHelpCtx();

    public String getName() {
        return this.getFile().getName();
    }

    public final DataFolder getFolder() {
        FileObject fo = this.getFile().getParent();
        return fo == null ? null : DataFolder.findFolder((FileObject)fo);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.getChangeSupport().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getChangeSupport().removePropertyChangeListener(l);
    }

    protected final void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.getChangeSupport().firePropertyChange(name, oldValue, newValue);
    }

    private final synchronized PropertyChangeSupport getChangeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport((Object)this);
        }
        return this.changeSupport;
    }

    protected final synchronized void setCookieSet(CookieSet s) {
        if (this.cookieSet != null) {
            this.cookieSet.removeChangeListener(this.cookieL);
        }
        s.addChangeListener(this.cookieL);
        this.cookieSet = s;
        this.firePropertyChange("cookie", null, null);
    }

    protected final CookieSet getCookieSet() {
        CookieSet s = this.cookieSet;
        if (s != null) {
            return s;
        }
        PresentableFileEntry presentableFileEntry = this;
        synchronized (presentableFileEntry) {
            if (this.cookieSet != null) {
                CookieSet cookieSet = this.cookieSet;
                return cookieSet;
            }
            this.setCookieSet(new CookieSet());
            CookieSet cookieSet = this.cookieSet;
            return cookieSet;
        }
    }

    public Node.Cookie getCookie(Class type) {
        Node.Cookie cookie;
        CookieSet c = this.cookieSet;
        if (c != null && (cookie = c.getCookie(type)) != null) {
            return cookie;
        }
        if (type.isInstance((Object)this)) {
            return this;
        }
        return null;
    }
}

