/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.WeakHashMap;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.Util;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public class PropertiesEditorSupport
extends CloneableEditorSupport
implements EditCookie,
EditorCookie.Observable,
PrintCookie,
CloseCookie,
Serializable {
    private static final byte NEW_LINE_N = 0;
    private static final byte NEW_LINE_R = 1;
    private static final byte NEW_LINE_RN = 2;
    private byte newLineType = 0;
    transient PropertiesFileEntry myEntry;
    static final long serialVersionUID = 1787354011149868490L;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesEditorSupport;

    public PropertiesEditorSupport(PropertiesFileEntry entry) {
        super((CloneableEditorSupport.Env)new Environment(entry));
        this.myEntry = entry;
        this.initialize();
    }

    public void initialize() {
        this.setMIMEType("text/x-properties");
    }

    public boolean close() {
        SaveCookie savec = (SaveCookie)this.myEntry.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = PropertiesEditorSupport.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
        if (savec != null && this.hasOpenedTableComponent()) {
            return false;
        }
        if (!super.close()) {
            return false;
        }
        if (this.myEntry.getFile().isValid() && !this.myEntry.getFile().isVirtual()) {
            this.myEntry.getHandler().reparseNowBlocking();
        }
        return true;
    }

    protected boolean canClose() {
        if (this.hasOpenedTableComponent()) {
            return true;
        }
        MultiDataObject propDO = this.myEntry.getDataObject();
        if (propDO == null || !propDO.isModified()) {
            return true;
        }
        return super.canClose();
    }

    protected CloneableEditor createCloneableEditor() {
        return new PropertiesEditor(this);
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        this.prepareDocument();
        PropertiesEditor editor = new PropertiesEditor(this);
        return editor;
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument document = super.createStyledDocument(kit);
        document.putProperty("title", this.myEntry.getFile().getPackageNameExt('/', '.'));
        document.putProperty("stream", this.myEntry.getDataObject());
        return document;
    }

    protected void loadFromStreamToKit(StyledDocument document, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        NewLineReader newLineReader = new NewLineReader(inputStream);
        try {
            editorKit.read(newLineReader, (Document)document, 0);
            this.newLineType = newLineReader.getNewLineType();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            newLineReader.close();
            throw throwable;
        }
        newLineReader.close();
    }

    protected void saveFromKitToStream(StyledDocument document, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        NewLineWriter writer = new NewLineWriter(outputStream, this.newLineType);
        try {
            editorKit.write(writer, (Document)document, 0, document.getLength());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ((Writer)writer).flush();
            ((Writer)writer).close();
            throw throwable;
        }
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    protected boolean notifyModified() {
        this.myEntry.getHandler().autoParse();
        if (super.notifyModified()) {
            ((Environment)((CloneableOpenSupport)this).env).addSaveCookie();
            return true;
        }
        return false;
    }

    protected Task reloadDocument() {
        Task tsk = super.reloadDocument();
        tsk.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                PropertiesEditorSupport.this.myEntry.getHandler().autoParse();
            }
        });
        return tsk;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        ((Environment)((CloneableOpenSupport)this).env).removeSaveCookie();
    }

    protected void notifyClosed() {
        if (!this.hasOpenedTableComponent()) {
            super.notifyClosed();
        }
    }

    protected String messageOpening() {
        String name = this.myEntry.getDataObject().getPrimaryFile().getName() + "(" + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ")";
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$properties$PropertiesEditorSupport == null ? (class$org$netbeans$modules$properties$PropertiesEditorSupport = PropertiesEditorSupport.class$("org.netbeans.modules.properties.PropertiesEditorSupport")) : class$org$netbeans$modules$properties$PropertiesEditorSupport), (String)"LBL_ObjectOpen", (Object)name);
    }

    protected String messageOpened() {
        String name = this.myEntry.getDataObject().getPrimaryFile().getName() + "(" + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ")";
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$properties$PropertiesEditorSupport == null ? (class$org$netbeans$modules$properties$PropertiesEditorSupport = PropertiesEditorSupport.class$("org.netbeans.modules.properties.PropertiesEditorSupport")) : class$org$netbeans$modules$properties$PropertiesEditorSupport), (String)"LBL_ObjectOpened", (Object)name);
    }

    protected String messageName() {
        String name = this.myEntry.getDataObject().getPrimaryFile().getName() + "(" + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ")";
        if (this.isModified()) {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$properties$PropertiesEditorSupport == null ? (class$org$netbeans$modules$properties$PropertiesEditorSupport = PropertiesEditorSupport.class$("org.netbeans.modules.properties.PropertiesEditorSupport")) : class$org$netbeans$modules$properties$PropertiesEditorSupport), (String)"LBL_EditorName_Modified", (Object)name);
        }
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$properties$PropertiesEditorSupport == null ? (class$org$netbeans$modules$properties$PropertiesEditorSupport = PropertiesEditorSupport.class$("org.netbeans.modules.properties.PropertiesEditorSupport")) : class$org$netbeans$modules$properties$PropertiesEditorSupport), (String)"LBL_EditorName_Uptodate", (Object)name);
    }

    protected String messageSave() {
        String name = this.myEntry.getDataObject().getPrimaryFile().getName() + "(" + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ")";
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$properties$PropertiesEditorSupport == null ? (class$org$netbeans$modules$properties$PropertiesEditorSupport = PropertiesEditorSupport.class$("org.netbeans.modules.properties.PropertiesEditorSupport")) : class$org$netbeans$modules$properties$PropertiesEditorSupport), (String)"MSG_SaveFile", (Object)name);
    }

    protected String messageToolTip() {
        FileObject fo = this.myEntry.getFile();
        try {
            File f = FileUtil.toFile((FileObject)fo);
            if (f != null) {
                return f.getAbsolutePath();
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$properties$PropertiesEditorSupport == null ? (class$org$netbeans$modules$properties$PropertiesEditorSupport = PropertiesEditorSupport.class$("org.netbeans.modules.properties.PropertiesEditorSupport")) : class$org$netbeans$modules$properties$PropertiesEditorSupport), (String)"LAB_EditorToolTip", (Object)fo.getPackageNameExt('/', '.'), (Object)fo.getFileSystem().getDisplayName());
        }
        catch (FileStateInvalidException fsie) {
            return fo.getPackageNameExt('/', '.');
        }
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new UndoRedoStampFlagManager();
    }

    UndoRedo.Manager getUndoRedoManager() {
        return super.getUndoRedo();
    }

    void forceNotifyClosed() {
        super.notifyClosed();
    }

    byte getNewLineType() {
        return this.newLineType;
    }

    private void saveThisEntry() throws IOException {
        super.saveDocument();
        if (!((CloneableOpenSupport)this).env.isModified()) {
            this.myEntry.setModified(false);
        }
    }

    private void setRef(CloneableTopComponent.Ref ref) {
        ((CloneableOpenSupport)this).allEditors = ref;
    }

    public synchronized boolean hasOpenedTableComponent() {
        return ((PropertiesDataObject)this.myEntry.getDataObject()).getOpenSupport().hasOpenedTableComponent();
    }

    public synchronized boolean hasOpenedEditorComponent() {
        Enumeration en = ((CloneableOpenSupport)this).allEditors.getComponents();
        return en.hasMoreElements();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class StampFlag {
        private long timeStamp;
        private Object atomicFlag;

        public StampFlag(long timeStamp, Object atomicFlag) {
            this.timeStamp = timeStamp;
            this.atomicFlag = atomicFlag;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public Object getAtomicFlag() {
            return this.atomicFlag;
        }
    }

    class UndoRedoStampFlagManager
    extends UndoRedo.Manager {
        WeakHashMap stampFlags = new WeakHashMap(5);

        UndoRedoStampFlagManager() {
        }

        public synchronized boolean addEdit(UndoableEdit anEdit) {
            this.stampFlags.put(anEdit, new StampFlag(System.currentTimeMillis(), ((PropertiesDataObject)PropertiesEditorSupport.this.myEntry.getDataObject()).getOpenSupport().atomicUndoRedoFlag));
            return super.addEdit(anEdit);
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            this.stampFlags.put(anEdit, new StampFlag(System.currentTimeMillis(), ((PropertiesDataObject)PropertiesEditorSupport.this.myEntry.getDataObject()).getOpenSupport().atomicUndoRedoFlag));
            return super.replaceEdit(anEdit);
        }

        public synchronized void undo() throws CannotUndoException {
            UndoableEdit anEdit = ((UndoManager)((Object)this)).editToBeUndone();
            if (anEdit != null) {
                Object atomicFlag = ((StampFlag)this.stampFlags.get(anEdit)).getAtomicFlag();
                super.undo();
                this.stampFlags.put(anEdit, new StampFlag(System.currentTimeMillis(), atomicFlag));
            }
        }

        public synchronized void redo() throws CannotRedoException {
            UndoableEdit anEdit = ((UndoManager)((Object)this)).editToBeRedone();
            if (anEdit != null) {
                Object atomicFlag = ((StampFlag)this.stampFlags.get(anEdit)).getAtomicFlag();
                super.redo();
                this.stampFlags.put(anEdit, new StampFlag(System.currentTimeMillis(), atomicFlag));
            }
        }

        public long getTimeStampOfEditToBeUndone() {
            UndoableEdit nextUndo = ((UndoManager)((Object)this)).editToBeUndone();
            if (nextUndo == null) {
                return 0L;
            }
            return ((StampFlag)this.stampFlags.get(nextUndo)).getTimeStamp();
        }

        public long getTimeStampOfEditToBeRedone() {
            UndoableEdit nextRedo = ((UndoManager)((Object)this)).editToBeRedone();
            if (nextRedo == null) {
                return 0L;
            }
            return ((StampFlag)this.stampFlags.get(nextRedo)).getTimeStamp();
        }

        public Object getAtomicFlagOfEditToBeUndone() {
            UndoableEdit nextUndo = ((UndoManager)((Object)this)).editToBeUndone();
            if (nextUndo == null) {
                return null;
            }
            return ((StampFlag)this.stampFlags.get(nextUndo)).getAtomicFlag();
        }

        public Object getAtomicFlagOfEditToBeRedone() {
            UndoableEdit nextRedo = ((UndoManager)((Object)this)).editToBeRedone();
            if (nextRedo == null) {
                return null;
            }
            return ((StampFlag)this.stampFlags.get(nextRedo)).getAtomicFlag();
        }
    }

    static class NewLineWriter
    extends BufferedWriter {
        byte newLineType;

        public NewLineWriter(OutputStream stream, byte newLineType) throws UnsupportedEncodingException {
            super(new OutputStreamWriter(stream, "8859_1"));
            this.newLineType = newLineType;
        }

        public void write(int character) throws IOException {
            if (character == 13) {
                return;
            }
            if (character == 10) {
                if (this.newLineType == 1) {
                    super.write(13);
                } else if (this.newLineType == 0) {
                    super.write(10);
                } else if (this.newLineType == 2) {
                    super.write(13);
                    super.write(10);
                }
            } else {
                super.write(character);
            }
        }
    }

    static class NewLineReader
    extends BufferedReader {
        int[] newLineTypes = new int[]{0, 0, 0};

        public NewLineReader(InputStream is) throws IOException {
            super(new InputStreamReader(is, "8859_1"));
        }

        public int read() throws IOException {
            int nextToRead = super.read();
            if (nextToRead == -1) {
                return -1;
            }
            if (nextToRead == 13) {
                nextToRead = super.read();
                while (nextToRead == 13) {
                    nextToRead = super.read();
                }
                if (nextToRead == 10) {
                    nextToRead = super.read();
                    this.newLineTypes[2] = this.newLineTypes[2] + 1;
                    return 10;
                }
                this.newLineTypes[1] = this.newLineTypes[1] + 1;
                return 10;
            }
            if (nextToRead == 10) {
                nextToRead = super.read();
                this.newLineTypes[0] = this.newLineTypes[0] + 1;
                return 10;
            }
            return nextToRead;
        }

        public byte getNewLineType() {
            if (this.newLineTypes[0] > this.newLineTypes[1]) {
                return this.newLineTypes[0] > this.newLineTypes[2] ? (byte)0 : 2;
            }
            return this.newLineTypes[1] > this.newLineTypes[2] ? (byte)1 : 2;
        }
    }

    public static class PropertiesEditor
    extends CloneableEditor {
        protected transient PropertiesFileEntry entry;
        private transient PropertyChangeListener saveCookieLNode;
        static final long serialVersionUID = -2702087884943509637L;

        public PropertiesEditor() {
        }

        public PropertiesEditor(PropertiesEditorSupport support) {
            super((CloneableEditorSupport)support);
            this.initialize();
        }

        private void initialize() {
            this.entry = ((PropertiesEditorSupport)this.cloneableEditorSupport()).myEntry;
            ((PropertiesEditorSupport)this.cloneableEditorSupport()).setRef(this.getReference());
            Node n = this.entry.getNodeDelegate();
            this.setActivatedNodes(new Node[]{n});
            this.updateName();
            this.saveCookieLNode = new PropertyChangeListener(this){
                private final /* synthetic */ PropertiesEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("cookie".equals(evt.getPropertyName()) || "name".equals(evt.getPropertyName())) {
                        PropertiesEditor.access$901(this.this$0);
                    }
                }
            };
            this.entry.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.saveCookieLNode, (Object)((Object)this.entry)));
        }

        protected boolean closeLast() {
            boolean canClose = super.closeLast();
            if (!canClose) {
                return false;
            }
            if (this.entry.getFile().isValid() && !this.entry.getFile().isVirtual() && !((PropertiesEditorSupport)this.cloneableEditorSupport()).hasOpenedTableComponent()) {
                this.entry.getHandler().reparseNowBlocking();
            }
            return true;
        }

        public Image getIcon() {
            return Utilities.loadImage((String)"org/netbeans/modules/properties/propertiesLocale.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("propfiles.editlocale");
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.initialize();
        }

        private JEditorPane getPane() {
            return this.pane;
        }

        static /* synthetic */ void access$901(PropertiesEditor x0) {
            super.updateName();
        }
    }

    public class PropertiesEditAt
    implements EditCookie {
        private String key;

        PropertiesEditAt(String key) {
            this.key = key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void edit() {
            PropertiesEditor editor = (PropertiesEditor)PropertiesEditorSupport.super.openCloneableTopComponent();
            editor.requestFocus();
            Element.ItemElem item = PropertiesEditorSupport.this.myEntry.getHandler().getStructure().getItem(this.key);
            if (item != null) {
                int offset = item.getKeyElem().getBounds().getBegin().getOffset();
                if (editor.getPane() != null && editor.getPane().getCaret() != null) {
                    editor.getPane().getCaret().setDot(offset);
                }
            }
        }
    }

    private static final class EnvironmentListener
    extends FileChangeAdapter {
        private Reference reference;

        public EnvironmentListener(Environment environment) {
            this.reference = new WeakReference<Environment>(environment);
        }

        public void fileChanged(FileEvent evt) {
            Environment environment = (Environment)this.reference.get();
            if (environment != null) {
                if (!environment.entry.getFile().equals(evt.getFile())) {
                    evt.getFile().removeFileChangeListener((FileChangeListener)this);
                    environment.entry.getFile().addFileChangeListener((FileChangeListener)new EnvironmentListener(environment));
                    return;
                }
                if (evt.getFile().isVirtual()) {
                    environment.entry.getFile().removeFileChangeListener((FileChangeListener)this);
                    environment.fileRemoved();
                    environment.entry.getFile().addFileChangeListener((FileChangeListener)this);
                } else {
                    environment.fileChanged(evt.isExpected(), evt.getTime());
                }
            }
        }
    }

    private static class Environment
    implements CloneableEditorSupport.Env,
    PropertyChangeListener,
    SaveCookie {
        static final long serialVersionUID = 354528097109874355L;
        protected PropertiesFileEntry entry;
        private transient FileLock fileLock;
        private transient PropertyChangeSupport propSupp;
        private transient VetoableChangeSupport vetoSupp;
        static /* synthetic */ Class class$org$openide$cookies$EditCookie;
        static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

        public Environment(PropertiesFileEntry entry) {
            this.entry = entry;
            entry.getFile().addFileChangeListener((FileChangeListener)new EnvironmentListener(this));
            entry.addPropertyChangeListener(this);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.prop().addPropertyChangeListener(l);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("valid".equals(evt.getPropertyName())) {
                if (Boolean.FALSE.equals(evt.getOldValue())) {
                    return;
                }
                PropertiesEditorSupport support = (PropertiesEditorSupport)this.findCloneableOpenSupport();
                if (support != null) {
                    this.unmarkModified();
                    PropertiesEditorSupport.super.close(false);
                }
            } else {
                this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.prop().removePropertyChangeListener(l);
        }

        public void addVetoableChangeListener(VetoableChangeListener l) {
            this.veto().addVetoableChangeListener(l);
        }

        public void removeVetoableChangeListener(VetoableChangeListener l) {
            this.veto().removeVetoableChangeListener(l);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (PropertiesEditorSupport)this.entry.getCookieSet().getCookie(class$org$openide$cookies$EditCookie == null ? (class$org$openide$cookies$EditCookie = Environment.class$("org.openide.cookies.EditCookie")) : class$org$openide$cookies$EditCookie);
        }

        public boolean isValid() {
            return this.entry.getDataObject().isValid();
        }

        public boolean isModified() {
            return this.entry.isModified();
        }

        public void markModified() throws IOException {
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.entry.takeLock();
            }
            this.entry.setModified(true);
        }

        public void unmarkModified() {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.releaseLock();
            }
            this.entry.setModified(false);
        }

        public String getMimeType() {
            return this.entry.getFile().getMIMEType();
        }

        public Date getTime() {
            this.entry.getFile().refresh(false);
            return this.entry.getFile().lastModified();
        }

        public InputStream inputStream() throws IOException {
            return this.entry.getFile().getInputStream();
        }

        public OutputStream outputStream() throws IOException {
            return this.entry.getFile().getOutputStream(this.fileLock);
        }

        public void save() throws IOException {
            ((PropertiesEditorSupport)this.findCloneableOpenSupport()).saveThisEntry();
        }

        private void firePropertyChange(String name, Object oldValue, Object newValue) {
            this.prop().firePropertyChange(name, oldValue, newValue);
        }

        private void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
            this.veto().fireVetoableChange(name, oldValue, newValue);
        }

        private PropertyChangeSupport prop() {
            if (this.propSupp == null) {
                Environment environment = this;
                synchronized (environment) {
                    if (this.propSupp == null) {
                        this.propSupp = new PropertyChangeSupport(this);
                    }
                }
            }
            return this.propSupp;
        }

        private VetoableChangeSupport veto() {
            if (this.vetoSupp == null) {
                Environment environment = this;
                synchronized (environment) {
                    if (this.vetoSupp == null) {
                        this.vetoSupp = new VetoableChangeSupport(this);
                    }
                }
            }
            return this.vetoSupp;
        }

        private void addSaveCookie() {
            if (this.entry.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = Environment.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) == null) {
                this.entry.getCookieSet().add((Node.Cookie)this);
            }
            ((PropertiesDataObject)this.entry.getDataObject()).updateModificationStatus();
        }

        private void removeSaveCookie() {
            SaveCookie sc = (SaveCookie)this.entry.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = Environment.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            if (sc != null && sc.equals(this)) {
                this.entry.getCookieSet().remove((Node.Cookie)this);
            }
            RequestProcessor.postRequest((Runnable)new Runnable(this){
                private final /* synthetic */ Environment this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    ((PropertiesDataObject)this.this$0.entry.getDataObject()).updateModificationStatus();
                }
            });
        }

        private void fileChanged(boolean expected, long time) {
            if (expected) {
                this.firePropertyChange("time", null, null);
            } else {
                this.firePropertyChange("time", null, new Date(time));
            }
        }

        private void fileRemoved() {
            try {
                this.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static final class Env
    extends Environment {
        static final long serialVersionUID = -9218186467757330339L;
        private PropertiesFileEntry entry;

        public Env(PropertiesFileEntry entry) {
            super(entry);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.entry != null) {
                ((Environment)this).entry = this.entry;
            }
        }
    }
}

