/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.KeyComparator;
import org.netbeans.modules.properties.KeyNode;
import org.netbeans.modules.properties.PresentableFileEntry;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesLocaleNode;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyBundleEvent;
import org.netbeans.modules.properties.PropertyBundleListener;
import org.netbeans.modules.properties.StructHandler;
import org.netbeans.modules.properties.Util;
import org.netbeans.modules.properties.WeakListenerPropertyBundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PropertiesFileEntry
extends PresentableFileEntry
implements CookieSet.Factory {
    private String basicName;
    private transient StructHandler propStruct;
    private transient PropertiesEditorSupport editorSupport;
    static final long serialVersionUID = -3882240297814143015L;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesEditorSupport;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesOpen;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesDataLoader;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesFileEntry;

    PropertiesFileEntry(MultiDataObject obj, FileObject file) {
        super(obj, file);
        FileObject fo = this.getDataObject().getPrimaryFile();
        this.basicName = fo == null ? this.getFile().getName() : fo.getName();
        this.getCookieSet().add(class$org$netbeans$modules$properties$PropertiesEditorSupport == null ? (class$org$netbeans$modules$properties$PropertiesEditorSupport = PropertiesFileEntry.class$("org.netbeans.modules.properties.PropertiesEditorSupport")) : class$org$netbeans$modules$properties$PropertiesEditorSupport, (CookieSet.Factory)this);
    }

    public FileObject copy(FileObject folder, String suffix) throws IOException {
        String pasteSuffix = ((PropertiesDataObject)this.getDataObject()).getPasteSuffix();
        if (pasteSuffix == null) {
            return super.copy(folder, suffix);
        }
        FileObject fileObject = this.getFile();
        String basicName = this.getDataObject().getPrimaryFile().getName();
        String newName = basicName + pasteSuffix + Util.getLocalePartOfFileName((MultiDataObject.Entry)this);
        return fileObject.copy(folder, newName, fileObject.getExt());
    }

    public void delete() throws IOException {
        this.getHandler().stopParsing();
        try {
            super.delete();
            Object var2_1 = null;
            this.getHandler().allowParsing();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.getHandler().allowParsing();
            throw throwable;
        }
    }

    public FileObject move(FileObject folder, String suffix) throws IOException {
        FileObject fileObject;
        String pasteSuffix = ((PropertiesDataObject)this.getDataObject()).getPasteSuffix();
        if (pasteSuffix == null) {
            return super.move(folder, suffix);
        }
        FileObject fileObject2 = this.getFile();
        FileLock lock = this.takeLock();
        try {
            String basicName = this.getDataObject().getPrimaryFile().getName();
            String newName = basicName + pasteSuffix + Util.getLocalePartOfFileName((MultiDataObject.Entry)this);
            fileObject = fileObject2.move(lock, folder, newName, fileObject2.getExt());
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
        return fileObject;
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(class$org$netbeans$modules$properties$PropertiesEditorSupport == null ? (class$org$netbeans$modules$properties$PropertiesEditorSupport = PropertiesFileEntry.class$("org.netbeans.modules.properties.PropertiesEditorSupport")) : class$org$netbeans$modules$properties$PropertiesEditorSupport)) {
            return this.getPropertiesEditor();
        }
        return null;
    }

    protected Node createNodeDelegate() {
        return new PropertiesLocaleNode(this);
    }

    public Children getChildren() {
        return new PropKeysChildren();
    }

    public StructHandler getHandler() {
        if (this.propStruct == null) {
            this.propStruct = new StructHandler(this);
        }
        return this.propStruct;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    protected PropertiesEditorSupport getPropertiesEditor() {
        this.getDataObject().getCookie(class$org$netbeans$modules$properties$PropertiesOpen == null ? (class$org$netbeans$modules$properties$PropertiesOpen = PropertiesFileEntry.class$("org.netbeans.modules.properties.PropertiesOpen")) : class$org$netbeans$modules$properties$PropertiesOpen);
        if (this.editorSupport == null) {
            PropertiesFileEntry propertiesFileEntry = this;
            synchronized (propertiesFileEntry) {
                if (this.editorSupport == null) {
                    this.editorSupport = new PropertiesEditorSupport(this);
                }
            }
        }
        return this.editorSupport;
    }

    public FileObject rename(String name) throws IOException {
        if (!this.getFile().getName().startsWith(this.basicName)) {
            throw new IllegalStateException("Resource Bundles: error in Properties loader/rename.");
        }
        FileObject fo = super.rename(name + this.getFile().getName().substring(this.basicName.length()));
        this.basicName = name;
        return fo;
    }

    public FileObject renameEntry(String name) throws IOException {
        if (!this.getFile().getName().startsWith(this.basicName)) {
            throw new IllegalStateException("Resource Bundles: error in Properties loader / rename");
        }
        if (this.basicName.equals(this.getFile().getName())) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$PropertiesDataLoader == null ? (class$org$netbeans$modules$properties$PropertiesDataLoader = PropertiesFileEntry.class$("org.netbeans.modules.properties.PropertiesDataLoader")) : class$org$netbeans$modules$properties$PropertiesDataLoader)).getString("MSG_AttemptToRenamePrimaryFile"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return this.getFile();
        }
        FileObject fo = super.rename(name);
        ((PropertiesDataObject)this.getDataObject()).getBundleStructure().oneFileChanged(this.getHandler());
        return fo;
    }

    /*
     * WARNING - void declaration
     */
    public FileObject createFromTemplate(FileObject folder, String name) throws IOException {
        String ext;
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$PropertiesFileEntry == null ? (class$org$netbeans$modules$properties$PropertiesFileEntry = PropertiesFileEntry.class$("org.netbeans.modules.properties.PropertiesFileEntry")) : class$org$netbeans$modules$properties$PropertiesFileEntry));
        if (!this.getFile().getName().startsWith(this.basicName)) {
            throw new IllegalStateException("Resource Bundles: error in Properties createFromTemplate");
        }
        String suffix = this.getFile().getName().substring(this.basicName.length());
        String nuename = name + suffix;
        FileObject existing = folder.getFileObject(nuename, ext = this.getFile().getExt());
        if (existing == null) {
            return super.createFromTemplate(folder, nuename);
        }
        String leaveAloneOpt = bundle.getString("OPT_leave_alone");
        String concatOpt = bundle.getString("OPT_concatenate");
        String overwriteOpt = bundle.getString("OPT_overwrite");
        String title = bundle.getString("LBL_ask_how_to_template");
        String message = MessageFormat.format(bundle.getString("MSG_ask_how_to_template"), nuename);
        NotifyDescriptor desc = new NotifyDescriptor((Object)message, title, -1, 3, new Object[]{concatOpt, leaveAloneOpt, overwriteOpt}, (Object)concatOpt);
        Object result = DialogDisplayer.getDefault().notify(desc);
        if (leaveAloneOpt.equals(result) || NotifyDescriptor.CLOSED_OPTION.equals(result)) {
            return existing;
        }
        if (concatOpt.equals(result)) {
            byte[] originalData2;
            int count;
            byte[] buf = new byte[4096];
            FileLock lock = existing.lock();
            try {
                InputStream is = existing.getInputStream();
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream((int)existing.getSize());
                    try {
                        while ((count = is.read(buf)) != -1) {
                            void var17_19;
                            baos.write(buf, 0, (int)var17_19);
                        }
                        Object var22_20 = null;
                        originalData2 = baos.toByteArray();
                    }
                    catch (Throwable throwable) {
                        Object var22_21 = null;
                        byte[] originalData2 = baos.toByteArray();
                        baos.close();
                        throw throwable;
                    }
                    baos.close();
                    Object var24_27 = null;
                }
                catch (Throwable throwable) {
                    Object var24_28 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                existing.delete(lock);
                Object var26_30 = null;
            }
            catch (Throwable throwable) {
                Object var26_31 = null;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
            FileObject nue = folder.createData(nuename, ext);
            lock = nue.lock();
            try {
                OutputStream os = nue.getOutputStream(lock);
                try {
                    os.write(originalData2);
                    InputStream is = this.getFile().getInputStream();
                    try {
                        while ((count = is.read(buf)) != -1) {
                            os.write(buf, 0, count);
                        }
                        Object var28_33 = null;
                    }
                    catch (Throwable throwable) {
                        Object var28_34 = null;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    Object var30_36 = null;
                }
                catch (Throwable throwable) {
                    Object var30_37 = null;
                    os.close();
                    throw throwable;
                }
                os.close();
                Object var32_39 = null;
            }
            catch (Throwable throwable) {
                Object var32_40 = null;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
            return nue;
        }
        if (overwriteOpt.equals(result)) {
            FileLock lock = existing.lock();
            try {
                existing.delete(lock);
                Object var34_42 = null;
            }
            catch (Throwable throwable) {
                Object var34_43 = null;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
            return super.createFromTemplate(folder, nuename);
        }
        throw new IOException("unrecognized result option: " + result);
    }

    public boolean isDeleteAllowed() {
        return !this.getFile().isReadOnly() && !this.basicName.equals(this.getFile().getName());
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getFile().isReadOnly() && this.getDataObject().getPrimaryEntry() != this;
    }

    public boolean isRenameAllowed() {
        return !this.getFile().isReadOnly();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("propfiles.creating");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PropKeysChildren
    extends Children.Keys {
        private PropertyBundleListener bundleListener = null;

        PropKeysChildren() {
        }

        private void mySetKeys() {
            TreeSet<String> keys = new TreeSet<String>(new KeyComparator());
            PropertiesStructure propStructure = PropertiesFileEntry.this.getHandler().getStructure();
            if (propStructure != null) {
                Iterator iterator = propStructure.allItems();
                while (iterator.hasNext()) {
                    Element.ItemElem item = (Element.ItemElem)iterator.next();
                    if (item == null || item.getKey() == null) continue;
                    keys.add(item.getKey());
                }
            }
            this.setKeys(keys);
        }

        protected void addNotify() {
            this.mySetKeys();
            this.bundleListener = new PropertyBundleListener(this){
                private final /* synthetic */ PropKeysChildren this$1;
                {
                    this.this$1 = this$1;
                }

                public void bundleChanged(PropertyBundleEvent evt) {
                    int changeType = evt.getChangeType();
                    if (changeType == 1 || changeType == 2) {
                        PropKeysChildren.access$000(this.this$1);
                    } else if (changeType == 3 && evt.getEntryName().equals(PropKeysChildren.access$100(this.this$1).getFile().getName())) {
                        PropKeysChildren.access$000(this.this$1);
                    }
                }
            };
            ((PropertiesDataObject)PropertiesFileEntry.this.getDataObject()).getBundleStructure().addPropertyBundleListener(new WeakListenerPropertyBundle(this.bundleListener));
        }

        protected void removeNotify() {
            this.setKeys(new ArrayList());
        }

        protected Node[] createNodes(Object key) {
            String itemKey = (String)key;
            return new Node[]{new KeyNode(PropertiesFileEntry.this.getHandler().getStructure(), itemKey)};
        }

        static /* synthetic */ void access$000(PropKeysChildren x0) {
            x0.mySetKeys();
        }

        static /* synthetic */ PropertiesFileEntry access$100(PropKeysChildren x0) {
            return x0.PropertiesFileEntry.this;
        }
    }
}

