/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.EventQueue;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.netbeans.modules.properties.BundleEditPanel;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyBundleEvent;
import org.netbeans.modules.properties.PropertyBundleListener;
import org.netbeans.modules.properties.Util;
import org.netbeans.modules.properties.UtilConvert;
import org.netbeans.modules.properties.WeakListenerPropertyBundle;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public class PropertiesTableModel
extends AbstractTableModel {
    static final long serialVersionUID = -7882925922830244768L;
    PropertiesDataObject obj;
    private PropertyBundleListener bundleListener;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesTableModel$StringPair;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesTableModel;

    public PropertiesTableModel(PropertiesDataObject obj) {
        this.obj = obj;
        this.bundleListener = new TablePropertyBundleListener();
        obj.getBundleStructure().addPropertyBundleListener(new WeakListenerPropertyBundle(this.bundleListener));
    }

    public Class getColumnClass(int columnIndex) {
        return class$org$netbeans$modules$properties$PropertiesTableModel$StringPair == null ? (class$org$netbeans$modules$properties$PropertiesTableModel$StringPair = PropertiesTableModel.class$("org.netbeans.modules.properties.PropertiesTableModel$StringPair")) : class$org$netbeans$modules$properties$PropertiesTableModel$StringPair;
    }

    public int getRowCount() {
        return this.obj.getBundleStructure().getKeyCount();
    }

    public int getColumnCount() {
        return this.obj.getBundleStructure().getEntryCount() + 1;
    }

    public Object getValueAt(int row, int column) {
        Element.ItemElem item;
        BundleStructure bs = this.obj.getBundleStructure();
        if (column == 0) {
            return this.stringPairForKey(row);
        }
        try {
            item = bs.getItem(column - 1, bs.keyAt(row));
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            item = null;
        }
        return this.stringPairForValue(item);
    }

    private StringPair stringPairForKey(int row) {
        BundleStructure bs = this.obj.getBundleStructure();
        Element.ItemElem item = bs.getItem(0, bs.keyAt(row));
        StringPair sp = item == null ? new StringPair("", bs.keyAt(row), true) : new StringPair(item.getComment(), bs.keyAt(row), true);
        if (this.obj.getBundleStructure().getEntryCount() > 1) {
            sp.setCommentEditable(false);
        }
        return sp;
    }

    private StringPair stringPairForValue(Element.ItemElem item) {
        if (item == null) {
            return new StringPair(null, null);
        }
        return new StringPair(item.getComment(), item.getValue());
    }

    public String getColumnName(int column) {
        String leading = column == this.obj.getBundleStructure().getSortIndex() ? "     " : " ";
        if (column == 0) {
            return leading + NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$PropertiesTableModel == null ? (class$org$netbeans$modules$properties$PropertiesTableModel = PropertiesTableModel.class$("org.netbeans.modules.properties.PropertiesTableModel")) : class$org$netbeans$modules$properties$PropertiesTableModel)).getString("LAB_KeyColumnLabel");
        }
        if (this.obj.getBundleStructure().getEntryCount() == 1) {
            return leading + NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$PropertiesTableModel == null ? (class$org$netbeans$modules$properties$PropertiesTableModel = PropertiesTableModel.class$("org.netbeans.modules.properties.PropertiesTableModel")) : class$org$netbeans$modules$properties$PropertiesTableModel)).getString("LBL_ColumnValue");
        }
        PropertiesFileEntry entry = this.obj.getBundleStructure().getNthEntry(column - 1);
        return entry == null ? "" : leading + Util.getLocaleLabel((MultiDataObject.Entry)entry);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue.equals(this.getValueAt(rowIndex, columnIndex))) {
            return;
        }
        if (columnIndex == 0) {
            BundleStructure bs = this.obj.getBundleStructure();
            String oldValue = bs.keyAt(rowIndex);
            if (oldValue == null) {
                return;
            }
            String newValue = ((StringPair)aValue).getValue();
            if (newValue == null) {
                return;
            }
            int i = 0;
            while (i < this.obj.getBundleStructure().getEntryCount()) {
                PropertiesStructure ps;
                PropertiesFileEntry entry = this.obj.getBundleStructure().getNthEntry(i);
                if (entry != null && (ps = entry.getHandler().getStructure()) != null) {
                    Element.ItemElem item;
                    if (!oldValue.equals(newValue)) {
                        ps.renameItem(oldValue, UtilConvert.escapePropertiesSpecialChars(newValue));
                        this.obj.getBundleStructure().sort(-1);
                    }
                    if (i == 0 && (item = ps.getItem(newValue)) != null && ((StringPair)aValue).isCommentEditable() && !item.getComment().equals(((StringPair)aValue).getComment())) {
                        item.setComment(((StringPair)aValue).getComment());
                    }
                }
                ++i;
            }
        } else {
            PropertiesStructure ps;
            PropertiesFileEntry entry = this.obj.getBundleStructure().getNthEntry(columnIndex - 1);
            String key = this.obj.getBundleStructure().keyAt(rowIndex);
            if (entry != null && key != null && (ps = entry.getHandler().getStructure()) != null) {
                Element.ItemElem item = ps.getItem(key);
                if (item != null) {
                    item.setValue(UtilConvert.escapeLineContinuationChar(UtilConvert.escapeOutsideSpaces(((StringPair)aValue).getValue())));
                    item.setComment(((StringPair)aValue).getComment());
                    this.obj.getBundleStructure().sort(-1);
                } else if (((StringPair)aValue).getValue().length() > 0 || ((StringPair)aValue).getComment().length() > 0) {
                    ps.addItem(key, UtilConvert.escapeLineContinuationChar(UtilConvert.escapeOutsideSpaces(((StringPair)aValue).getValue())), ((StringPair)aValue).getComment());
                    this.obj.getBundleStructure().sort(-1);
                }
            }
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void fireTableColumnChanged(int index) {
        int columnModelIndex = index;
        Object[] list = this.listenerList.getListenerList();
        int i = 0;
        while (i < list.length) {
            if (list[i] instanceof JTable) {
                JTable jt = (JTable)list[i];
                try {
                    TableColumn column = jt.getColumnModel().getColumn(index);
                    columnModelIndex = column.getModelIndex();
                    column.setHeaderValue(jt.getModel().getColumnName(columnModelIndex));
                }
                catch (ArrayIndexOutOfBoundsException abe) {
                    // empty catch block
                }
                jt.getTableHeader().repaint();
            }
            ++i;
        }
        this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1, columnModelIndex));
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("------------------------------ TABLE MODEL DUMP -----------------------\n");
        int row = 0;
        while (row < this.getRowCount()) {
            int column = 0;
            while (column < this.getColumnCount()) {
                StringPair sp = (StringPair)this.getValueAt(row, column);
                result.append("[" + sp.getValue() + "]");
                if (column == 0) {
                    result.append(" : ");
                } else if (column == this.getColumnCount() - 1) {
                    result.append("\n");
                } else {
                    result.append(",");
                }
                ++column;
            }
            ++row;
        }
        result.append("---------------------------- END TABLE MODEL DUMP ---------------------\n");
        return result.toString();
    }

    private void cancelEditingInTables(CancelSelector can) {
        Object[] list = this.listenerList.getListenerList();
        int i = 0;
        while (i < list.length) {
            BundleEditPanel.BundleTable jt;
            if (list[i] instanceof BundleEditPanel.BundleTable && can.doCancelEditing((jt = (BundleEditPanel.BundleTable)list[i]).getEditingRow(), jt.getEditingColumn())) {
                jt.removeEditorSilent();
            }
            ++i;
        }
    }

    private CancelSelector getDefaultCancelSelector() {
        return new CancelSelector(){

            public boolean doCancelEditing(int row, int column) {
                return row >= 0 && row < PropertiesTableModel.this.getRowCount() && column >= 0 && column < PropertiesTableModel.this.getColumnCount();
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class StringPair
    implements Serializable {
        private String comment;
        private String value;
        private boolean keyType;
        private boolean commentEditable;
        static final long serialVersionUID = -463968846283787181L;

        public StringPair() {
            this(null, "", false);
        }

        public StringPair(String v) {
            this(null, v, true);
        }

        public StringPair(String c, String v) {
            this(c, v, false);
        }

        public StringPair(String c, String v, boolean kt) {
            this.comment = c;
            this.value = v;
            this.keyType = kt;
            this.commentEditable = true;
        }

        public String getComment() {
            return this.comment;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            String str2;
            if (obj == null || !(obj instanceof StringPair)) {
                return false;
            }
            StringPair compared = (StringPair)obj;
            if (this.comment == null && compared.getComment() != null) {
                return false;
            }
            String str1 = UtilConvert.unicodesToChars(this.comment);
            if (!str1.equals(str2 = UtilConvert.unicodesToChars(compared.getComment()))) {
                return false;
            }
            if (this.value == null && compared.getValue() != null) {
                return false;
            }
            str1 = UtilConvert.unicodesToChars(this.value);
            str2 = UtilConvert.unicodesToChars(compared.getValue());
            return str1.equals(str2);
        }

        public String toString() {
            return this.value;
        }

        public boolean isKeyType() {
            return this.keyType;
        }

        public boolean isCommentEditable() {
            return this.commentEditable;
        }

        public void setCommentEditable(boolean newEditable) {
            this.commentEditable = newEditable;
        }
    }

    private class TablePropertyBundleListener
    implements PropertyBundleListener {
        private TablePropertyBundleListener() {
        }

        public void bundleChanged(PropertyBundleEvent evt) {
            if (EventQueue.isDispatchThread()) {
                this.doBundleChanged(evt);
            } else {
                EventQueue.invokeLater(new Runnable(this, evt){
                    private final /* synthetic */ PropertyBundleEvent val$evt;
                    private final /* synthetic */ TablePropertyBundleListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$evt = val$evt;
                    }

                    public void run() {
                        TablePropertyBundleListener.access$100(this.this$1, this.val$evt);
                    }
                });
            }
        }

        private void doBundleChanged(PropertyBundleEvent evt) {
            int changeType = evt.getChangeType();
            if (changeType == 1) {
                Object[] list = PropertiesTableModel.this.listenerList.getListenerList();
                int i = 0;
                while (i < list.length) {
                    if (list[i] instanceof JTable) {
                        ((JTable)list[i]).setModel(new PropertiesTableModel(PropertiesTableModel.this.obj));
                    }
                    ++i;
                }
            } else if (changeType == 2) {
                PropertiesTableModel.this.cancelEditingInTables(PropertiesTableModel.this.getDefaultCancelSelector());
                Object[] list = PropertiesTableModel.this.listenerList.getListenerList();
                int i = 0;
                while (i < list.length) {
                    if (list[i] instanceof JTable) {
                        JTable jt = (JTable)list[i];
                        int j = 0;
                        while (j < jt.getColumnModel().getColumnCount()) {
                            TableColumn column = jt.getColumnModel().getColumn(j);
                            column.setHeaderValue(jt.getModel().getColumnName(column.getModelIndex()));
                            ++j;
                        }
                    }
                    ++i;
                }
                PropertiesTableModel.this.fireTableDataChanged();
            } else if (changeType == 3) {
                int index = PropertiesTableModel.this.obj.getBundleStructure().getEntryIndexByFileName(evt.getEntryName());
                if (index == -1) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        new Exception("Changed file not found").printStackTrace();
                    }
                    return;
                }
                PropertiesTableModel.this.cancelEditingInTables(new CancelSelector(this, index){
                    private final /* synthetic */ int val$index;
                    private final /* synthetic */ TablePropertyBundleListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$index = val$index;
                    }

                    public boolean doCancelEditing(int row, int column) {
                        if (row < 0 || row >= TablePropertyBundleListener.access$600(this.this$1).getRowCount() || column < 0 || column >= TablePropertyBundleListener.access$600(this.this$1).getColumnCount()) {
                            return false;
                        }
                        return column == this.val$index + 1;
                    }
                });
                PropertiesTableModel.this.fireTableColumnChanged(index + 1);
            } else if (changeType == 4) {
                int index2 = PropertiesTableModel.this.obj.getBundleStructure().getEntryIndexByFileName(evt.getEntryName());
                int keyIndex = PropertiesTableModel.this.obj.getBundleStructure().getKeyIndexByName(evt.getItemName());
                if (index2 == -1 || keyIndex == -1) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        new Exception("Changed file not found").printStackTrace();
                    }
                    return;
                }
                PropertiesTableModel.this.cancelEditingInTables(new CancelSelector(this, index2, keyIndex){
                    private final /* synthetic */ int val$index2;
                    private final /* synthetic */ int val$keyIndex;
                    private final /* synthetic */ TablePropertyBundleListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$index2 = val$index2;
                        this.val$keyIndex = val$keyIndex;
                    }

                    public boolean doCancelEditing(int row, int column) {
                        if (row < 0 || row >= TablePropertyBundleListener.access$600(this.this$1).getRowCount() || column < 0 || column >= TablePropertyBundleListener.access$600(this.this$1).getColumnCount()) {
                            return false;
                        }
                        return column == this.val$index2 + 1 && row == this.val$keyIndex;
                    }
                });
                PropertiesTableModel.this.fireTableCellUpdated(keyIndex, index2 + 1);
            }
        }

        static /* synthetic */ void access$100(TablePropertyBundleListener x0, PropertyBundleEvent x1) {
            x0.doBundleChanged(x1);
        }

        static /* synthetic */ PropertiesTableModel access$600(TablePropertyBundleListener x0) {
            return x0.PropertiesTableModel.this;
        }
    }

    private static interface CancelSelector {
        public boolean doCancelEditing(int var1, int var2);
    }
}

