/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.util.EventObject;
import org.netbeans.modules.properties.BundleStructure;

public class PropertyBundleEvent
extends EventObject {
    public static final int CHANGE_STRUCT = 1;
    public static final int CHANGE_ALL = 2;
    public static final int CHANGE_FILE = 3;
    public static final int CHANGE_ITEM = 4;
    protected String entryName;
    protected String itemName;
    protected int changeType;
    static final long serialVersionUID = 1702449038200791321L;

    public PropertyBundleEvent(Object source, int changeType) {
        super(source);
        this.changeType = changeType;
    }

    public PropertyBundleEvent(Object source, String entryName) {
        super(source);
        this.entryName = entryName;
        this.changeType = 3;
    }

    public PropertyBundleEvent(Object source, String entryName, String itemName) {
        super(source);
        this.entryName = entryName;
        this.itemName = itemName;
        this.changeType = 4;
    }

    public int getChangeType() {
        return this.changeType;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String toString() {
        try {
            String doIdent = this.getSource() instanceof BundleStructure ? ((BundleStructure)this.getSource()).obj.getPrimaryFile().getName() : "";
            String ct = "?";
            switch (this.getChangeType()) {
                case 1: {
                    ct = "STRUCT";
                    break;
                }
                case 2: {
                    ct = "ALL";
                    break;
                }
                case 3: {
                    ct = "FILE";
                    break;
                }
                case 4: {
                    ct = "ITEM";
                }
            }
            return "PropertyBundleEvent: bundle " + doIdent + ", changeType " + ct + ", entry " + this.getEntryName() + ", item " + this.getItemName();
        }
        catch (Exception e) {
            return "some PropertyBundleEvent (" + e.toString() + ") occurred";
        }
    }
}

