/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.util.Locale;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public final class Util {
    public static final String HELP_ID_PROPERTIES = "propfiles.prop";
    public static final String HELP_ID_CREATING = "propfiles.creating";
    public static final String HELP_ID_ADDING = "propfiles.adding";
    public static final String HELP_ID_MODIFYING = "propfiles.modifying";
    public static final String HELP_ID_ADDLOCALE = "propfiles.addlocale";
    public static final String HELP_ID_EDITLOCALE = "propfiles.editlocale";
    public static final char PRB_SEPARATOR_CHAR = '_';
    public static final int LABEL_FIRST_PART_LENGTH = 10;
    static /* synthetic */ Class class$org$netbeans$modules$properties$Util;

    public static String stringToKey(String source) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char x = source.charAt(i);
            switch (x) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ':': 
                case '=': {
                    result.append('_');
                    break;
                }
                default: {
                    result.append(x);
                }
            }
            ++i;
        }
        return result.toString();
    }

    private static FileObject getPrimaryFileObject(MultiDataObject.Entry fe) {
        return fe.getDataObject().getPrimaryFile();
    }

    public static String assembleName(String baseName, String lang) {
        if (lang.length() == 0) {
            return baseName;
        }
        if (lang.charAt(0) != '_') {
            StringBuffer res = new StringBuffer().append(baseName).append('_').append(lang);
            return res.toString();
        }
        return baseName + lang;
    }

    public static String getLocalePartOfFileName(MultiDataObject.Entry fe) {
        String baseName;
        String myName = fe.getFile().getName();
        if (!myName.startsWith(baseName = Util.getPrimaryFileObject(fe).getName())) {
            throw new IllegalStateException("Resource Bundle: Should never happen -> " + myName + " doesn't start with " + baseName);
        }
        return myName.substring(baseName.length());
    }

    public static String getLanguage(MultiDataObject.Entry fe) {
        String part = Util.getLocalePartOfFileName(fe);
        return Util.getFirstPart(part);
    }

    public static String getCountry(MultiDataObject.Entry fe) {
        try {
            String part = Util.getLocalePartOfFileName(fe);
            int start = part.indexOf(95, 1);
            if (start == -1) {
                return null;
            }
            return Util.getFirstPart(part.substring(start));
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static String getVariant(MultiDataObject.Entry fe) {
        try {
            String part = Util.getLocalePartOfFileName(fe);
            int start = part.indexOf(95, 1);
            if (start == -1) {
                return null;
            }
            if ((start = part.indexOf(95, start + 1)) == -1) {
                return null;
            }
            return Util.getFirstPart(part.substring(start));
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    private static String getFirstPart(String part) {
        try {
            if (part.length() == 0) {
                return null;
            }
            if (part.charAt(0) != '_') {
                throw new IllegalStateException("Resource Bundle: Should never happen -> locale suffix " + part + " doesn't start with " + '_');
            }
            int end = part.indexOf(95, 1);
            String result = end == -1 ? part.substring(1) : part.substring(1, end);
            return result.length() == 0 ? "" : result;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static String getLocaleLabel(MultiDataObject.Entry fe) {
        String variant;
        String lang;
        String temp = Util.getLocalePartOfFileName(fe);
        if (temp.length() > 0 && temp.charAt(0) == '_') {
            temp = temp.substring(1);
        }
        StringBuffer result = new StringBuffer(temp);
        if (temp.length() > 0) {
            result.append(" - ");
        }
        if ((lang = Util.getLanguage(fe)) == null) {
            temp = NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$Util == null ? (class$org$netbeans$modules$properties$Util = Util.class$("org.netbeans.modules.properties.Util")) : class$org$netbeans$modules$properties$Util)).getString("LAB_DefaultBundle_Label");
        } else {
            temp = new Locale(lang, "").getDisplayLanguage();
            if (temp.length() == 0) {
                temp = lang;
            }
        }
        result.append(temp);
        String coun = Util.getCountry(fe);
        if (coun == null) {
            temp = "";
        } else {
            temp = new Locale(lang, coun).getDisplayCountry();
            if (temp.length() == 0) {
                temp = coun;
            }
        }
        if (temp.length() != 0) {
            result.append("/");
            result.append(temp);
        }
        if ((variant = Util.getVariant(fe)) == null) {
            temp = "";
        } else {
            temp = new Locale(lang, coun, variant).getDisplayVariant();
            if (temp.length() == 0) {
                temp = variant;
            }
        }
        if (temp.length() != 0) {
            result.append("/");
            result.append(temp);
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

