/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class UtilConvert {
    public static final String keyValueSeparators = "=: \t\r\n\f";
    public static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=:\t\r\n\f#!";
    public static final String whiteSpaceChars = " \t\r\n\f";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Hashtable load(InputStream inStream) throws IOException {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, "8859_1"));
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if (line.length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (UtilConvert.continueLine(line)) {
                String nextLine = in.readLine();
                if (nextLine == null) {
                    nextLine = new String("");
                }
                String loppedLine = line.substring(0, line.length() - 1);
                int startIndex = 0;
                startIndex = 0;
                while (startIndex < nextLine.length()) {
                    if (whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) == -1) break;
                    ++startIndex;
                }
                nextLine = nextLine.substring(startIndex, nextLine.length());
                line = new String(loppedLine + nextLine);
            }
            int len = line.length();
            int keyStart = 0;
            while (keyStart < len) {
                if (whiteSpaceChars.indexOf(line.charAt(keyStart)) == -1) break;
                ++keyStart;
            }
            int separatorIndex = keyStart;
            while (separatorIndex < len) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                } else if (keyValueSeparators.indexOf(currentChar) != -1) break;
                ++separatorIndex;
            }
            int valueIndex = separatorIndex + 1;
            while (valueIndex < len) {
                if (whiteSpaceChars.indexOf(line.charAt(valueIndex)) == -1) break;
                ++valueIndex;
            }
            if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                ++valueIndex;
            }
            while (valueIndex < len) {
                if (whiteSpaceChars.indexOf(line.charAt(valueIndex)) == -1) break;
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            key = UtilConvert.loadConvert(key);
            value = UtilConvert.loadConvert(value);
            ht.put(key, value);
        }
        return ht;
    }

    private static boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public static boolean continueLine(StringBuffer line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public static String loadConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public static String saveConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x++);
            switch (aChar) {
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    break;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    break;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    break;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    break;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    break;
                }
                default: {
                    if (aChar < '\u0014' || aChar > '\u007f') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(UtilConvert.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(UtilConvert.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(UtilConvert.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(UtilConvert.toHex(aChar >> 0 & 0xF));
                        break;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static String escapePropertiesSpecialChars(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char x = source.charAt(i);
            if ((x == ' ' || x == '=' || x == ':') && (i == 0 || i > 0 && source.charAt(i - 1) != '\\')) {
                result.append('\\');
            }
            if (i == source.length() - 1 && x == '\\' && i > 0 && source.charAt(i - 1) != '\\') {
                result.append('\\');
            }
            result.append(x);
            ++i;
        }
        return result.toString();
    }

    private static boolean onlySpaces(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String escapeOutsideSpaces(String source) {
        if (source == null || source.length() == 0) {
            return source;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (source.charAt(i) == ' ') {
            result.append('\\');
            result.append(' ');
            if (i + 1 == source.length()) {
                return result.toString();
            }
            ++i;
        }
        while (!UtilConvert.onlySpaces(source.substring(i))) {
            result.append(source.charAt(i));
            if (i + 1 == source.length()) {
                return result.toString();
            }
            ++i;
        }
        while (i < source.length()) {
            result.append('\\');
            result.append(' ');
            ++i;
        }
        return result.toString();
    }

    public static String escapeLineContinuationChar(String source) {
        if (source == null) {
            return null;
        }
        if (source.endsWith("\\") && source.length() > 1 && source.charAt(source.length() - 2) != '\\') {
            return new String(new StringBuffer(source).append('\\'));
        }
        return source;
    }

    public static String escapeJavaSpecialChars(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char ch = source.charAt(i);
            switch (ch) {
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\b': {
                    result.append("\\b");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\f': {
                    result.append("\\f");
                    break;
                }
                default: {
                    result.append(ch);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String unicodesToChars(String theString) {
        if (theString == null) {
            return null;
        }
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            block13: {
                char aChar = theString.charAt(x);
                if (x + 5 < len) {
                    char next = theString.charAt(x + 1);
                    try {
                        if (aChar == '\\' && next == 'u') {
                            int value = 0;
                            int i = 0;
                            while (i < 4) {
                                next = theString.charAt(x + 1 + i + 1);
                                switch (next) {
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        value = (value << 4) + next - 48;
                                        break;
                                    }
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': {
                                        value = (value << 4) + 10 + next - 97;
                                        break;
                                    }
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': {
                                        value = (value << 4) + 10 + next - 65;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                }
                                ++i;
                            }
                            outBuffer.append((char)value);
                            x += 5;
                            break block13;
                        }
                        outBuffer.append(aChar);
                    }
                    catch (IllegalArgumentException iae) {
                        outBuffer.append(aChar);
                    }
                } else {
                    outBuffer.append(aChar);
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    public static String escapeComment(String commentString) {
        return UtilConvert.charsToUnicodes(commentString, true);
    }

    public static String charsToUnicodes(String s) {
        return UtilConvert.charsToUnicodes(s, false);
    }

    public static String charsToUnicodes(String theString, boolean skipWhiteSpaces) {
        if (theString == null) {
            return null;
        }
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        int x = 0;
        while (x < len) {
            char aChar;
            if ((aChar = theString.charAt(x++)) < '\u0014' || aChar > '\u007f') {
                if (skipWhiteSpaces && Character.isWhitespace(aChar)) {
                    outBuffer.append(aChar);
                    continue;
                }
                outBuffer.append('\\');
                outBuffer.append('u');
                outBuffer.append(UtilConvert.toHex(aChar >> 12 & 0xF));
                outBuffer.append(UtilConvert.toHex(aChar >> 8 & 0xF));
                outBuffer.append(UtilConvert.toHex(aChar >> 4 & 0xF));
                outBuffer.append(UtilConvert.toHex(aChar >> 0 & 0xF));
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    public static synchronized void store(OutputStream out, String header, Hashtable ht) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            UtilConvert.writeln(awriter, "#" + header);
        }
        UtilConvert.writeln(awriter, "#" + new Date().toString());
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)ht.get(key);
            key = UtilConvert.saveConvert(key);
            val = UtilConvert.saveConvert(val);
            UtilConvert.writeln(awriter, key + "=" + val);
        }
        awriter.flush();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

