/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.form;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.i18n.I18nPanel;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.form.FormI18nInteger;
import org.netbeans.modules.i18n.form.FormI18nSupport;
import org.netbeans.modules.i18n.form.Util;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormI18nIntegerEditor
extends PropertyEditorSupport
implements FormAwareEditor,
NamedPropertyEditor,
XMLPropertyEditor {
    private FormI18nInteger formI18nInteger;
    private FormDataObject sourceDataObject;
    public static final String XML_RESOURCESTRING = "ResourceString";
    public static final String XML_ARGUMENT = "Argument";
    public static final String ATTR_BUNDLE = "bundle";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_IDENTIFIER = "identifier";
    public static final String ATTR_REPLACE_FORMAT = "replaceFormat";
    public static final String ATTR_INDEX = "index";
    public static final String ATTR_JAVACODE = "javacode";
    private static final int MAX_INDEX = 1000;
    private final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$form$FormI18nIntegerEditor == null ? (class$org$netbeans$modules$i18n$form$FormI18nIntegerEditor = FormI18nIntegerEditor.class$("org.netbeans.modules.i18n.form.FormI18nIntegerEditor")) : class$org$netbeans$modules$i18n$form$FormI18nIntegerEditor));
    static /* synthetic */ Class class$org$netbeans$modules$i18n$form$FormI18nIntegerEditor;

    public String[] getTags() {
        return null;
    }

    public void setAsText(String text) {
    }

    public String getAsText() {
        FormI18nInteger formI18nInteger = (FormI18nInteger)((Object)this.getValue());
        DataObject dataObject = formI18nInteger.getSupport().getResourceHolder().getResource();
        if (dataObject == null || formI18nInteger.getKey() == null) {
            return this.bundle.getString("TXT_InvalidValue");
        }
        return MessageFormat.format(this.bundle.getString("TXT_Key"), formI18nInteger.getKey(), dataObject.getPrimaryFile().getPackageName('/'));
    }

    public String getJavaInitializationString() {
        return ((FormI18nInteger)((Object)this.getValue())).getReplaceString();
    }

    public Component getCustomEditor() {
        return new CustomEditor((I18nString)new FormI18nInteger((FormI18nInteger)((Object)this.getValue())));
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Object getValue() {
        if (this.formI18nInteger == null) {
            this.formI18nInteger = this.createFormI18nInteger();
            if (I18nUtil.getOptions().getLastResource() != null) {
                this.formI18nInteger.getSupport().getResourceHolder().setResource(I18nUtil.getOptions().getLastResource());
            }
        }
        return this.formI18nInteger;
    }

    public void setValue(Object object) {
        if (object instanceof FormI18nInteger) {
            this.formI18nInteger = (FormI18nInteger)((Object)object);
        } else {
            this.formI18nInteger = this.createFormI18nInteger();
            if (I18nUtil.getOptions().getLastResource() != null) {
                this.formI18nInteger.getSupport().getResourceHolder().setResource(I18nUtil.getOptions().getLastResource());
            }
        }
    }

    private FormI18nInteger createFormI18nInteger() {
        return new FormI18nInteger(new FormI18nSupport.Factory().createI18nSupport((DataObject)this.sourceDataObject));
    }

    public void setFormModel(FormModel model) {
        this.sourceDataObject = model.getFormDataObject();
    }

    public String getDisplayName() {
        return Util.getString("PROP_IntegerEditor_name");
    }

    public void readFromXML(Node domNode) throws IOException {
        if (!XML_RESOURCESTRING.equals(domNode.getNodeName())) {
            throw new IOException();
        }
        FormI18nInteger formI18nInteger = this.createFormI18nInteger();
        NamedNodeMap namedNodes = domNode.getAttributes();
        try {
            FileObject fileObject;
            String key;
            Node node = namedNodes.getNamedItem(ATTR_BUNDLE);
            String bundleName = node == null ? null : node.getNodeValue();
            node = namedNodes.getNamedItem(ATTR_KEY);
            String string = key = node == null ? null : node.getNodeValue();
            if (bundleName != null && (fileObject = Repository.getDefault().findResource(bundleName)) != null) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    if (dataObject.getClass().equals(formI18nInteger.getSupport().getResourceHolder().getResourceClasses()[0])) {
                        formI18nInteger.getSupport().getResourceHolder().setResource(dataObject);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (key != null && key.length() > 0) {
                formI18nInteger.setKey(key);
                formI18nInteger.setValue(formI18nInteger.getSupport().getResourceHolder().getValueForKey(key));
                formI18nInteger.setComment(formI18nInteger.getSupport().getResourceHolder().getCommentForKey(key));
            }
            ((JavaI18nSupport)formI18nInteger.getSupport()).createIdentifier();
            node = namedNodes.getNamedItem(ATTR_IDENTIFIER);
            if (node != null) {
                String identifier;
                String string2 = identifier = node == null ? null : node.getNodeValue();
                if (identifier != null) {
                    ((JavaI18nSupport)formI18nInteger.getSupport()).setIdentifier(identifier);
                }
            }
            if ((node = namedNodes.getNamedItem(ATTR_REPLACE_FORMAT)) != null) {
                String replaceFormat = node.getNodeValue();
                if (replaceFormat != null && replaceFormat.length() > 0) {
                    HashMap<String, String> map = new HashMap<String, String>(6);
                    map.put("0", "{identifier}");
                    map.put("1", "{key}");
                    map.put("2", "{bundleNameSlashes}");
                    map.put("3", "{bundleNameDots}");
                    map.put("4", "{sourceFileName}");
                    map.put("fileName", "{sourceFileName}");
                    String newReplaceFormat = MapFormat.format((String)replaceFormat, map);
                    formI18nInteger.setReplaceFormat(newReplaceFormat);
                }
            } else {
                formI18nInteger.setReplaceFormat((String)I18nUtil.getReplaceFormatItems().get(2));
            }
        }
        catch (NullPointerException npe) {
            throw new IOException();
        }
        if (domNode instanceof Element) {
            Element domElement = (Element)domNode;
            NodeList argNodeList = domElement.getElementsByTagName(XML_ARGUMENT);
            int highest = -1;
            int i = 0;
            while (i < argNodeList.getLength()) {
                String indexString;
                NamedNodeMap attributes = argNodeList.item(i).getAttributes();
                Node indexNode = attributes.getNamedItem(ATTR_INDEX);
                String string = indexString = indexNode == null ? null : indexNode.getNodeValue();
                if (indexString != null) {
                    try {
                        int index = Integer.parseInt(indexString);
                        if (index > highest && index < 1000) {
                            highest = index;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i;
            }
            String[] parameters = new String[highest + 1];
            int i2 = 0;
            while (i2 < argNodeList.getLength()) {
                String indexString;
                NamedNodeMap attr = argNodeList.item(i2).getAttributes();
                Node indexNode = attr.getNamedItem(ATTR_INDEX);
                String string = indexString = indexNode == null ? null : indexNode.getNodeValue();
                if (indexString != null) {
                    try {
                        int index = Integer.parseInt(indexString);
                        if (index < 1000) {
                            String javaCode;
                            Node javaCodeNode = attr.getNamedItem(ATTR_JAVACODE);
                            parameters[index] = javaCode = javaCodeNode == null ? null : javaCodeNode.getNodeValue();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < parameters.length) {
                if (parameters[i3] == null) {
                    parameters[i3] = "";
                }
                ++i3;
            }
            formI18nInteger.setArguments(parameters);
        }
        this.setValue((Object)formI18nInteger);
    }

    public Node storeToXML(Document doc) {
        Element element = doc.createElement(XML_RESOURCESTRING);
        String bundleName = this.formI18nInteger.getSupport().getResourceHolder().getResource() == null ? "" : this.formI18nInteger.getSupport().getResourceHolder().getResource().getPrimaryFile().getPackageNameExt('/', '.');
        element.setAttribute(ATTR_BUNDLE, bundleName);
        element.setAttribute(ATTR_KEY, this.formI18nInteger.getKey() == null ? "" : this.formI18nInteger.getKey());
        JavaI18nSupport support = (JavaI18nSupport)this.formI18nInteger.getSupport();
        if (support.getIdentifier() == null) {
            support.createIdentifier();
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(ATTR_IDENTIFIER, support.getIdentifier());
        element.setAttribute(ATTR_REPLACE_FORMAT, this.formI18nInteger.getReplaceFormat() == null ? "" : MapFormat.format((String)this.formI18nInteger.getReplaceFormat(), map));
        String[] arguments = this.formI18nInteger.getArguments();
        int i = 0;
        while (i < arguments.length) {
            Element childElement = doc.createElement(XML_ARGUMENT);
            childElement.setAttribute(ATTR_INDEX, "" + i);
            childElement.setAttribute(ATTR_JAVACODE, arguments[i]);
            try {
                element.appendChild(childElement);
            }
            catch (DOMException de) {
                // empty catch block
            }
            ++i;
        }
        return element;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CustomEditor
    extends I18nPanel
    implements EnhancedCustomPropertyEditor {
        private final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$form$FormI18nIntegerEditor == null ? (class$org$netbeans$modules$i18n$form$FormI18nIntegerEditor = CustomEditor.class$("org.netbeans.modules.i18n.form.FormI18nIntegerEditor")) : class$org$netbeans$modules$i18n$form$FormI18nIntegerEditor));
        static /* synthetic */ Class class$org$netbeans$modules$i18n$form$FormI18nIntegerEditor;

        public CustomEditor(I18nString i18nString) {
            super(i18nString.getSupport().getPropertyPanel(), false);
            this.setI18nString(i18nString);
            HelpCtx.setHelpIDString((JComponent)((Object)this), (String)"internation.formed");
        }

        public Object getPropertyValue() throws IllegalStateException {
            I18nString i18nString = this.getI18nString();
            if (i18nString == null || !(i18nString instanceof FormI18nInteger) || i18nString.getSupport().getResourceHolder().getResource() == null || i18nString.getKey() == null) {
                IllegalStateException ise = new IllegalStateException();
                String message = this.bundle.getString("MSG_InvalidValue");
                ErrorManager.getDefault().annotate((Throwable)ise, 16, message, message, null, null);
                throw ise;
            }
            i18nString.getSupport().getResourceHolder().addProperty((Object)i18nString.getKey(), (Object)i18nString.getValue(), i18nString.getComment(), false);
            return i18nString;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

