/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.crimson.parser.AttributeDecl;
import org.apache.crimson.parser.AttributesExImpl;
import org.apache.crimson.parser.ContentModel;
import org.apache.crimson.parser.ElementDecl;
import org.apache.crimson.parser.ElementValidator;
import org.apache.crimson.parser.EndOfInputException;
import org.apache.crimson.parser.ExternalEntity;
import org.apache.crimson.parser.InputEntity;
import org.apache.crimson.parser.InternalEntity;
import org.apache.crimson.parser.Resolver;
import org.apache.crimson.parser.SimpleHashtable;
import org.apache.crimson.util.MessageCatalog;
import org.apache.crimson.util.XmlChars;
import org.apache.crimson.util.XmlNames;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class Parser2 {
    private InputEntity in;
    private AttributesExImpl attTmp;
    private StringBuffer strTmp;
    private char[] nameTmp;
    private NameCache nameCache;
    private char[] charTmp = new char[2];
    private String[] namePartsTmp = new String[3];
    private boolean seenNSDecl;
    private NamespaceSupport nsSupport;
    private Vector nsAttTmp;
    private boolean isValidating = false;
    private boolean fastStandalone = false;
    private boolean isInAttribute = false;
    private boolean namespaces;
    private boolean prefixes;
    private boolean inExternalPE;
    private boolean doLexicalPE;
    private boolean donePrologue;
    private boolean isStandalone;
    private String rootElementName;
    private boolean ignoreDeclarations;
    private SimpleHashtable elements = new SimpleHashtable(47);
    private SimpleHashtable params = new SimpleHashtable(7);
    Hashtable notations = new Hashtable(7);
    SimpleHashtable entities = new SimpleHashtable(17);
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver resolver;
    private ErrorHandler errHandler;
    private Locale locale;
    private Locator locator = new DocLocator();
    private DeclHandler declHandler;
    private LexicalHandler lexicalHandler;
    private static final boolean supportValidation = true;
    static final String strANY = "ANY";
    static final String strEMPTY = "EMPTY";
    private static final NullHandler nullHandler = new NullHandler();
    private static final String XmlLang = "xml:lang";
    static final Catalog messages = new Catalog();

    public Parser2() {
        this.setHandlers();
    }

    void setNamespaceFeatures(boolean namespaces, boolean prefixes) {
        this.namespaces = namespaces;
        this.prefixes = prefixes;
    }

    void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    void setErrorHandler(ErrorHandler handler) {
        this.errHandler = handler;
    }

    void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    void setDeclHandler(DeclHandler handler) {
        this.declHandler = handler;
    }

    public void setLocale(Locale l) throws SAXException {
        if (l != null && !messages.isLocaleSupported(l.toString())) {
            throw new SAXException(messages.getMessage(this.locale, "P-078", new Object[]{l}));
        }
        this.locale = l;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Locale chooseLocale(String[] languages) throws SAXException {
        Locale l = messages.chooseLocale(languages);
        if (l != null) {
            this.setLocale(l);
        }
        return l;
    }

    public void parse(InputSource in) throws SAXException, IOException {
        this.init();
        this.parseInternal(in);
    }

    public void setFastStandalone(boolean value) {
        this.fastStandalone = value && !this.isValidating;
    }

    public boolean isFastStandalone() {
        return this.fastStandalone;
    }

    public void pushInputBuffer(char[] buf, int offset, int len) throws SAXException {
        if (len <= 0) {
            return;
        }
        if (offset != 0 || len != buf.length) {
            char[] tmp = new char[len];
            System.arraycopy(buf, offset, tmp, 0, len);
            buf = tmp;
        }
        this.pushReader(buf, null, false);
    }

    void setIsValidating(boolean value) {
        this.isValidating = value;
        if (value) {
            this.fastStandalone = false;
        }
    }

    private void init() {
        this.in = null;
        this.attTmp = new AttributesExImpl();
        this.strTmp = new StringBuffer();
        this.nameTmp = new char[20];
        this.nameCache = new NameCache();
        if (this.namespaces) {
            this.nsSupport = new NamespaceSupport();
            if (this.isValidating && !this.prefixes) {
                this.nsAttTmp = new Vector();
            }
        }
        this.isStandalone = false;
        this.rootElementName = null;
        this.isInAttribute = false;
        this.inExternalPE = false;
        this.doLexicalPE = false;
        this.donePrologue = false;
        this.entities.clear();
        this.notations.clear();
        this.params.clear();
        this.elements.clear();
        this.ignoreDeclarations = false;
        this.builtin("amp", "&#38;");
        this.builtin("lt", "&#60;");
        this.builtin("gt", ">");
        this.builtin("quot", "\"");
        this.builtin("apos", "'");
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.resolver == null) {
            this.resolver = new Resolver();
        }
        this.setHandlers();
    }

    private void setHandlers() {
        if (this.contentHandler == null) {
            this.contentHandler = nullHandler;
        }
        if (this.errHandler == null) {
            this.errHandler = nullHandler;
        }
        if (this.dtdHandler == null) {
            this.dtdHandler = nullHandler;
        }
        if (this.lexicalHandler == null) {
            this.lexicalHandler = nullHandler;
        }
        if (this.declHandler == null) {
            this.declHandler = nullHandler;
        }
    }

    private void builtin(String entityName, String entityValue) {
        InternalEntity entity = new InternalEntity(entityName, entityValue.toCharArray());
        this.entities.put(entityName, entity);
    }

    private void parseInternal(InputSource input) throws SAXException, IOException {
        block15: {
            if (input == null) {
                this.fatal("P-000");
            }
            try {
                try {
                    this.in = InputEntity.getInputEntity(this.errHandler, this.locale);
                    this.in.init(input, null, null, false);
                    this.contentHandler.setDocumentLocator(this.locator);
                    this.contentHandler.startDocument();
                    this.maybeXmlDecl();
                    this.maybeMisc(false);
                    if (!this.maybeDoctypeDecl() && this.isValidating) {
                        this.warning("V-001", null);
                    }
                    this.maybeMisc(false);
                    this.donePrologue = true;
                    if (!this.in.peekc('<') || !this.maybeElement(null)) {
                        this.fatal("P-067");
                    }
                    this.afterRoot();
                    this.maybeMisc(true);
                    if (!this.in.isEOF()) {
                        this.fatal("P-001", new Object[]{Integer.toHexString(this.getc())});
                    }
                    this.contentHandler.endDocument();
                }
                catch (EndOfInputException e) {
                    if (!this.in.isDocument()) {
                        String name = this.in.getName();
                        do {
                            this.in = this.in.pop();
                        } while (this.in.isInternal());
                        this.fatal("P-002", new Object[]{name}, e);
                    } else {
                        this.fatal("P-003", null, e);
                    }
                    Object var5_3 = null;
                    this.strTmp = null;
                    this.attTmp = null;
                    this.nameTmp = null;
                    this.nameCache = null;
                    this.nsAttTmp = null;
                    if (this.in != null) {
                        this.in.close();
                        this.in = null;
                    }
                    this.params.clear();
                    this.entities.clear();
                    this.notations.clear();
                    this.elements.clear();
                    this.afterDocument();
                    break block15;
                }
                catch (RuntimeException e) {
                    throw new SAXParseException(e.getMessage() != null ? e.getMessage() : e.getClass().getName(), this.locator.getPublicId(), this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber(), e);
                }
                Object var5_2 = null;
                this.strTmp = null;
                this.attTmp = null;
                this.nameTmp = null;
                this.nameCache = null;
                this.nsAttTmp = null;
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                this.params.clear();
                this.entities.clear();
                this.notations.clear();
                this.elements.clear();
                this.afterDocument();
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                this.strTmp = null;
                this.attTmp = null;
                this.nameTmp = null;
                this.nameCache = null;
                this.nsAttTmp = null;
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                this.params.clear();
                this.entities.clear();
                this.notations.clear();
                this.elements.clear();
                this.afterDocument();
                throw throwable;
            }
        }
    }

    void afterRoot() throws SAXException {
    }

    void afterDocument() {
    }

    private void whitespace(String roleId) throws IOException, SAXException {
        if (!this.maybeWhitespace()) {
            this.fatal("P-004", new Object[]{messages.getMessage(this.locale, roleId)});
        }
    }

    private boolean maybeWhitespace() throws IOException, SAXException {
        if (!this.inExternalPE || !this.doLexicalPE) {
            return this.in.maybeWhitespace();
        }
        char c = this.getc();
        boolean saw = false;
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            saw = true;
            if (this.in.isEOF() && !this.in.isInternal()) {
                return saw;
            }
            c = this.getc();
        }
        this.ungetc();
        return saw;
    }

    private String maybeGetName() throws IOException, SAXException {
        NameCacheEntry entry = this.maybeGetNameCacheEntry();
        return entry == null ? null : entry.name;
    }

    private NameCacheEntry maybeGetNameCacheEntry() throws IOException, SAXException {
        char c = this.getc();
        if (!XmlChars.isLetter(c) && c != ':' && c != '_') {
            this.ungetc();
            return null;
        }
        return this.nameCharString(c);
    }

    private String getNmtoken() throws SAXException, IOException {
        char c = this.getc();
        if (!XmlChars.isNameChar(c)) {
            this.fatal("P-006", new Object[]{new Character(c)});
        }
        return this.nameCharString((char)c).name;
    }

    private NameCacheEntry nameCharString(char c) throws IOException, SAXException {
        int i = 1;
        this.nameTmp[0] = c;
        while ((c = this.in.getNameChar()) != '\u0000') {
            if (i >= this.nameTmp.length) {
                char[] tmp = new char[this.nameTmp.length + 10];
                System.arraycopy(this.nameTmp, 0, tmp, 0, this.nameTmp.length);
                this.nameTmp = tmp;
            }
            this.nameTmp[i++] = c;
        }
        return this.nameCache.lookupEntry(this.nameTmp, i);
    }

    private void parseLiteral(boolean isEntityValue) throws IOException, SAXException {
        boolean savedLexicalPE = this.doLexicalPE;
        char quote = this.getc();
        InputEntity source = this.in;
        if (quote != '\'' && quote != '\"') {
            this.fatal("P-007");
        }
        this.isInAttribute = !isEntityValue;
        this.strTmp = new StringBuffer();
        while (true) {
            String entityName;
            if (this.in != source && this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            char c = this.getc();
            if (c == quote && this.in == source) break;
            if (c == '&') {
                entityName = this.maybeGetName();
                if (entityName != null) {
                    this.nextChar(';', "F-020", entityName);
                    if (isEntityValue) {
                        this.strTmp.append('&');
                        this.strTmp.append(entityName);
                        this.strTmp.append(';');
                        continue;
                    }
                    this.expandEntityInLiteral(entityName, this.entities, isEntityValue);
                    continue;
                }
                c = this.getc();
                if (c == '#') {
                    int tmp = this.parseCharNumber();
                    if (tmp > 65535) {
                        tmp = this.surrogatesToCharTmp(tmp);
                        this.strTmp.append(this.charTmp[0]);
                        if (tmp != 2) continue;
                        this.strTmp.append(this.charTmp[1]);
                        continue;
                    }
                    this.strTmp.append((char)tmp);
                    continue;
                }
                this.fatal("P-009");
                continue;
            }
            if (c == '%' && isEntityValue) {
                entityName = this.maybeGetName();
                if (entityName != null) {
                    this.nextChar(';', "F-021", entityName);
                    if (this.inExternalPE) {
                        this.expandEntityInLiteral(entityName, this.params, isEntityValue);
                        continue;
                    }
                    this.fatal("P-010", new Object[]{entityName});
                    continue;
                }
                this.fatal("P-011");
            }
            if (!isEntityValue) {
                if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                    this.strTmp.append(' ');
                    continue;
                }
                if (c == '<') {
                    this.fatal("P-012");
                }
            }
            this.strTmp.append(c);
        }
        this.isInAttribute = false;
    }

    private void expandEntityInLiteral(String name, SimpleHashtable table, boolean isEntityValue) throws SAXException, IOException {
        Object entity = table.get(name);
        if (entity instanceof InternalEntity) {
            InternalEntity value = (InternalEntity)entity;
            if (this.isValidating && this.isStandalone && !value.isFromInternalSubset) {
                this.error("V-002", new Object[]{name});
            }
            this.pushReader(value.buf, name, !value.isPE);
        } else if (entity instanceof ExternalEntity) {
            if (!isEntityValue) {
                this.fatal("P-013", new Object[]{name});
            }
            this.pushReader((ExternalEntity)entity);
        } else if (entity == null) {
            this.fatal(table == this.params ? "V-022" : "P-014", new Object[]{name});
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getQuotedString(String type, String extra) throws IOException, SAXException {
        char c;
        char quote = this.in.getc();
        if (quote != '\'' && quote != '\"') {
            this.fatal("P-015", new Object[]{messages.getMessage(this.locale, type, new Object[]{extra})});
        }
        this.strTmp = new StringBuffer();
        while ((c = this.in.getc()) != quote) {
            void var4_4;
            this.strTmp.append((char)var4_4);
        }
        return this.strTmp.toString();
    }

    private String parsePublicId() throws IOException, SAXException {
        String retval = this.getQuotedString("F-033", null);
        int i = 0;
        while (i < retval.length()) {
            char c = retval.charAt(i);
            if (!(" \r\n-'()+,./:=?;!*#@$_%0123456789".indexOf(c) != -1 || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                this.fatal("P-016", new Object[]{new Character(c)});
            }
            ++i;
        }
        this.strTmp = new StringBuffer();
        this.strTmp.append(retval);
        return this.normalize(false);
    }

    /*
     * Unable to fully structure code
     */
    private boolean maybeComment(boolean skipStart) throws IOException, SAXException {
        if (!this.in.peek(skipStart != false ? "!--" : "<!--", null)) {
            return false;
        }
        savedLexicalPE = this.doLexicalPE;
        this.doLexicalPE = false;
        v0 = saveCommentText = this.lexicalHandler != Parser2.nullHandler;
        if (!saveCommentText) ** GOTO lbl-1000
        this.strTmp = new StringBuffer();
lbl-1000:
        // 2 sources

        {
            while (true) {
                if ((c = this.getc()) == '-') {
                    c = this.getc();
                    if (c != '-') {
                        if (saveCommentText) {
                            this.strTmp.append('-');
                        }
                        this.ungetc();
                        continue;
                    }
                    this.nextChar('>', "F-022", null);
                    break;
                }
                if (!saveCommentText) continue;
                this.strTmp.append(c);
            }
        }
        this.doLexicalPE = savedLexicalPE;
        if (saveCommentText) {
            length = this.strTmp.length();
            charArray = new char[length];
            if (length != 0) {
                this.strTmp.getChars(0, length, charArray, 0);
            }
            this.lexicalHandler.comment(charArray, 0, length);
        }
        return true;
    }

    private boolean maybePI(boolean skipStart) throws IOException, SAXException {
        boolean savedLexicalPE = this.doLexicalPE;
        if (!this.in.peek(skipStart ? "?" : "<?", null)) {
            return false;
        }
        this.doLexicalPE = false;
        String target = this.maybeGetName();
        if (target == null) {
            this.fatal("P-018");
        }
        if ("xml".equals(target)) {
            this.fatal("P-019");
        }
        if ("xml".equalsIgnoreCase(target)) {
            this.fatal("P-020", new Object[]{target});
        }
        if (this.maybeWhitespace()) {
            this.strTmp = new StringBuffer();
            try {
                char c;
                while ((c = this.in.getc()) != '?' || !this.in.peekc('>')) {
                    this.strTmp.append(c);
                }
            }
            catch (EndOfInputException e) {
                this.fatal("P-021");
            }
            this.contentHandler.processingInstruction(target, this.strTmp.toString());
        } else {
            if (!this.in.peek("?>", null)) {
                this.fatal("P-022");
            }
            this.contentHandler.processingInstruction(target, "");
        }
        this.doLexicalPE = savedLexicalPE;
        return true;
    }

    private void maybeXmlDecl() throws IOException, SAXException {
        if (!this.in.isXmlDeclOrTextDeclPrefix()) {
            return;
        }
        this.peek("<?xml");
        this.readVersion(true, "1.0");
        this.readEncoding(false);
        this.readStandalone();
        this.maybeWhitespace();
        if (!this.peek("?>")) {
            char c = this.getc();
            this.fatal("P-023", new Object[]{Integer.toHexString(c), new Character(c)});
        }
    }

    private String maybeReadAttribute(String name, boolean must) throws IOException, SAXException {
        if (!this.maybeWhitespace()) {
            if (!must) {
                return null;
            }
            this.fatal("P-024", new Object[]{name});
        }
        if (!this.peek(name)) {
            if (must) {
                this.fatal("P-024", new Object[]{name});
            } else {
                this.ungetc();
                return null;
            }
        }
        this.maybeWhitespace();
        this.nextChar('=', "F-023", null);
        this.maybeWhitespace();
        return this.getQuotedString("F-035", name);
    }

    private void readVersion(boolean must, String versionNum) throws IOException, SAXException {
        String value = this.maybeReadAttribute("version", must);
        if (must && value == null) {
            this.fatal("P-025", new Object[]{versionNum});
        }
        if (value != null) {
            int length = value.length();
            int i = 0;
            while (i < length) {
                char c = value.charAt(i);
                if (!(c >= '0' && c <= '9' || c == '_' || c == '.' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':' || c == '-')) {
                    this.fatal("P-026", new Object[]{value});
                }
                ++i;
            }
        }
        if (value != null && !value.equals(versionNum)) {
            this.error("P-027", new Object[]{versionNum, value});
        }
    }

    private void maybeMisc(boolean eofOK) throws IOException, SAXException {
        while (!eofOK || !this.in.isEOF()) {
            if (!this.maybeComment(false) && !this.maybePI(false) && !this.maybeWhitespace()) break;
        }
    }

    private String getMarkupDeclname(String roleId, boolean qname) throws IOException, SAXException {
        this.whitespace(roleId);
        String name = this.maybeGetName();
        if (name == null) {
            this.fatal("P-005", new Object[]{messages.getMessage(this.locale, roleId)});
        }
        return name;
    }

    private boolean maybeDoctypeDecl() throws IOException, SAXException {
        String name;
        if (!this.peek("<!DOCTYPE")) {
            return false;
        }
        ExternalEntity externalSubset = null;
        this.rootElementName = this.getMarkupDeclname("F-014", true);
        if (this.maybeWhitespace() && (externalSubset = this.maybeExternalID()) != null) {
            this.lexicalHandler.startDTD(this.rootElementName, externalSubset.publicId, externalSubset.verbatimSystemId);
            this.maybeWhitespace();
        } else {
            this.lexicalHandler.startDTD(this.rootElementName, null, null);
        }
        if (this.in.peekc('[')) {
            while (true) {
                if (this.in.isEOF() && !this.in.isDocument()) {
                    this.in = this.in.pop();
                    continue;
                }
                if (this.maybeMarkupDecl() || this.maybePEReference() || this.maybeWhitespace()) continue;
                if (!this.peek("<![")) break;
                this.fatal("P-028");
            }
            this.nextChar(']', "F-024", null);
            this.maybeWhitespace();
        }
        this.nextChar('>', "F-025", null);
        if (externalSubset != null) {
            externalSubset.name = "[dtd]";
            externalSubset.isPE = true;
            this.externalParameterEntity(externalSubset);
        }
        this.params.clear();
        this.lexicalHandler.endDTD();
        Vector<String> v = new Vector<String>();
        Enumeration e = this.notations.keys();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            Object value = this.notations.get(name);
            if (value == Boolean.TRUE) {
                if (this.isValidating) {
                    this.error("V-003", new Object[]{name});
                }
                v.addElement(name);
                continue;
            }
            if (!(value instanceof String)) continue;
            if (this.isValidating) {
                this.error("V-004", new Object[]{name});
            }
            v.addElement(name);
        }
        while (!v.isEmpty()) {
            name = v.firstElement();
            v.removeElement(name);
            this.notations.remove(name);
        }
        return true;
    }

    private boolean maybeMarkupDecl() throws IOException, SAXException {
        return this.maybeElementDecl() || this.maybeAttlistDecl() || this.maybeEntityDecl() || this.maybeNotationDecl() || this.maybePI(false) || this.maybeComment(false);
    }

    private void readStandalone() throws IOException, SAXException {
        String value = this.maybeReadAttribute("standalone", false);
        if (value == null || "no".equals(value)) {
            return;
        }
        if ("yes".equals(value)) {
            this.isStandalone = true;
            return;
        }
        this.fatal("P-029", new Object[]{value});
    }

    /*
     * Unable to fully structure code
     */
    private boolean isXmlLang(String value) {
        block6: {
            block5: {
                if (value.length() < 2) {
                    return false;
                }
                c = value.charAt(1);
                if (c != '-') break block5;
                c = value.charAt(0);
                if (c != 'i' && c != 'I' && c != 'x' && c != 'X') {
                    return false;
                }
                nextSuffix = 1;
                ** GOTO lbl24
            }
            if ((c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) break block6;
            c = value.charAt(0);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                return false;
            }
            nextSuffix = 2;
            if (true) ** GOTO lbl24
        }
        return false;
        do {
            if ((c = value.charAt(nextSuffix)) == '-') ** GOTO lbl-1000
            break;
            while ((c = value.charAt(nextSuffix)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') lbl-1000:
            // 2 sources

            {
                if (++nextSuffix < value.length()) continue;
            }
lbl24:
            // 4 sources

        } while (nextSuffix < value.length());
        return value.length() == nextSuffix && c != '-';
    }

    private boolean maybeElement(ElementValidator validator) throws IOException, SAXException {
        boolean haveAttributes = false;
        boolean hasContent = true;
        NameCacheEntry name = this.maybeGetNameCacheEntry();
        if (name == null) {
            return false;
        }
        if (validator != null) {
            validator.consume(name.name);
        }
        ElementDecl element = (ElementDecl)this.elements.get(name.name);
        if (this.isValidating) {
            if (element == null || element.contentType == null) {
                this.error("V-005", new Object[]{name.name});
                element = new ElementDecl(name.name);
                element.contentType = strANY;
                this.elements.put(name.name, element);
            }
            if (validator == null && this.rootElementName != null && !this.rootElementName.equals(name.name)) {
                this.error("V-006", new Object[]{name.name, this.rootElementName});
            }
        }
        int startLine = this.in.getLineNumber();
        boolean sawWhite = this.in.maybeWhitespace();
        Vector exceptions = null;
        if (this.namespaces) {
            this.nsSupport.pushContext();
            this.seenNSDecl = false;
        }
        while (!this.in.peekc('>')) {
            String defaultValue;
            String value;
            AttributeDecl info;
            String attQName;
            if (this.in.peekc('/')) {
                hasContent = false;
                break;
            }
            if (!sawWhite) {
                this.fatal("P-030");
            }
            if ((attQName = this.maybeGetName()) == null) {
                this.fatal("P-031", new Object[]{new Character(this.getc())});
            }
            if (this.attTmp.getValue(attQName) != null) {
                this.fatal("P-032", new Object[]{attQName});
            }
            this.in.maybeWhitespace();
            this.nextChar('=', "F-026", attQName);
            this.in.maybeWhitespace();
            this.doLexicalPE = false;
            this.parseLiteral(false);
            sawWhite = this.in.maybeWhitespace();
            AttributeDecl attributeDecl = info = element == null ? null : (AttributeDecl)element.attributes.get(attQName);
            if (info == null) {
                if (this.isValidating) {
                    this.error("V-007", new Object[]{attQName, name.name});
                }
                value = this.strTmp.toString();
            } else {
                if (!"CDATA".equals(info.type)) {
                    value = this.normalize(!info.isFromInternalSubset);
                    if (this.isValidating) {
                        this.validateAttributeSyntax(info, value);
                    }
                } else {
                    value = this.strTmp.toString();
                }
                if (this.isValidating && info.isFixed && !value.equals(info.defaultValue)) {
                    this.error("V-008", new Object[]{attQName, name.name, info.defaultValue});
                }
            }
            if (XmlLang.equals(attQName) && !this.isXmlLang(value)) {
                this.error("P-033", new Object[]{value});
            }
            String type = info == null ? "CDATA" : info.type;
            String string = defaultValue = info == null ? null : info.defaultValue;
            if (this.namespaces) {
                exceptions = this.processAttributeNS(attQName, type, value, defaultValue, true, false, exceptions);
            } else {
                this.attTmp.addAttribute("", "", attQName, type, value, defaultValue, true);
            }
            haveAttributes = true;
        }
        if (element != null) {
            this.attTmp.setIdAttributeName(element.id);
        }
        if (element != null && element.attributes.size() != 0) {
            boolean bl = haveAttributes = this.defaultAttributes(element) || haveAttributes;
        }
        if (this.seenNSDecl) {
            int length = this.attTmp.getLength();
            int i = 0;
            while (i < length) {
                String attQName = this.attTmp.getQName(i);
                if (!attQName.startsWith("xmlns") || attQName.length() != 5 && attQName.charAt(5) != ':') {
                    String[] attName = this.processName(attQName, true, false);
                    this.attTmp.setURI(i, attName[0]);
                    this.attTmp.setLocalName(i, attName[1]);
                }
                ++i;
            }
        } else if (exceptions != null && this.errHandler != null) {
            int i = 0;
            while (i < exceptions.size()) {
                this.errHandler.error((SAXParseException)exceptions.elementAt(i));
                ++i;
            }
        }
        if (this.namespaces) {
            String[] parts = this.processName(name.name, false, false);
            this.contentHandler.startElement(parts[0], parts[1], parts[2], this.attTmp);
        } else {
            this.contentHandler.startElement("", "", name.name, this.attTmp);
        }
        if (haveAttributes) {
            this.attTmp.clear();
            if (this.isValidating && this.namespaces && !this.prefixes) {
                this.nsAttTmp.removeAllElements();
            }
        }
        validator = this.newValidator(element);
        if (hasContent) {
            this.content(element, false, validator);
            if (!this.in.peek(name.name, name.chars)) {
                this.fatal("P-034", new Object[]{name.name, new Integer(startLine)});
            }
            this.in.maybeWhitespace();
        }
        this.nextChar('>', "F-027", name.name);
        validator.done();
        if (this.namespaces) {
            String[] parts = this.processName(name.name, false, false);
            this.contentHandler.endElement(parts[0], parts[1], parts[2]);
            Enumeration<String> prefixes = this.nsSupport.getDeclaredPrefixes();
            while (prefixes.hasMoreElements()) {
                String prefix = prefixes.nextElement();
                this.contentHandler.endPrefixMapping(prefix);
            }
            this.nsSupport.popContext();
        } else {
            this.contentHandler.endElement("", "", name.name);
        }
        return true;
    }

    private Vector processAttributeNS(String attQName, String type, String value, String defaultValue, boolean isSpecified, boolean isDefaulting, Vector exceptions) throws SAXException {
        if (attQName.startsWith("xmlns")) {
            boolean defaultNSDecl;
            boolean bl = defaultNSDecl = attQName.length() == 5;
            if (defaultNSDecl || attQName.charAt(5) == ':') {
                String prefix = defaultNSDecl ? "" : attQName.substring(6);
                if (!this.nsSupport.declarePrefix(prefix, value)) {
                    this.error("P-083", new Object[]{prefix});
                }
                this.contentHandler.startPrefixMapping(prefix, value);
                if (this.prefixes) {
                    this.attTmp.addAttribute("", prefix, attQName.intern(), type, value, defaultValue, isSpecified);
                } else if (this.isValidating && !isDefaulting) {
                    this.nsAttTmp.addElement(attQName);
                }
                this.seenNSDecl = true;
                return exceptions;
            }
        }
        try {
            String[] attName = this.processName(attQName, true, true);
            this.attTmp.addAttribute(attName[0], attName[1], attName[2], type, value, defaultValue, isSpecified);
        }
        catch (SAXException e) {
            if (exceptions == null) {
                exceptions = new Vector<SAXException>();
            }
            exceptions.addElement(e);
            this.attTmp.addAttribute("", attQName, attQName, type, value, defaultValue, isSpecified);
        }
        return exceptions;
    }

    private String[] processName(String qName, boolean isAttribute, boolean useException) throws SAXException {
        String[] parts = this.nsSupport.processName(qName, this.namePartsTmp, isAttribute);
        if (parts == null) {
            String localName = XmlNames.getLocalPart(qName);
            parts = new String[]{"", localName != null ? localName.intern() : "", qName.intern()};
            String messageId = "P-084";
            Object[] parameters = new Object[]{qName};
            if (useException) {
                throw new SAXParseException(messages.getMessage(this.locale, messageId, parameters), this.locator);
            }
            this.error(messageId, parameters);
        }
        return parts;
    }

    ElementValidator newValidator(ElementDecl element) {
        return ElementValidator.ANY;
    }

    void validateAttributeSyntax(AttributeDecl attr, String value) throws SAXException {
    }

    private boolean defaultAttributes(ElementDecl element) throws SAXException {
        boolean didDefault = false;
        Enumeration e = element.attributes.keys();
        while (e.hasMoreElements()) {
            String defaultValue;
            String declAttName = (String)e.nextElement();
            if (this.attTmp.getValue(declAttName) != null) continue;
            AttributeDecl info = (AttributeDecl)element.attributes.get(declAttName);
            if (this.isValidating && info.isRequired) {
                if (this.namespaces && !this.prefixes && this.nsAttTmp.contains(declAttName)) continue;
                this.error("V-009", new Object[]{declAttName});
            }
            if ((defaultValue = info.defaultValue) == null) continue;
            if (this.isValidating && this.isStandalone && !info.isFromInternalSubset) {
                this.error("V-010", new Object[]{declAttName});
            }
            if (this.namespaces) {
                this.processAttributeNS(declAttName, info.type, defaultValue, defaultValue, false, true, null);
            } else {
                this.attTmp.addAttribute("", "", declAttName, info.type, defaultValue, defaultValue, false);
            }
            didDefault = true;
        }
        return didDefault;
    }

    private void content(ElementDecl element, boolean allowEOF, ElementValidator validator) throws IOException, SAXException {
        block6: {
            while (true) {
                if (this.in.peekc('<')) {
                    if (this.maybeElement(validator)) continue;
                    if (this.in.peekc('/')) {
                        return;
                    }
                    if (this.maybeComment(true) || this.maybePI(true)) continue;
                    if (this.in.peek("![CDATA[", null)) {
                        this.lexicalHandler.startCDATA();
                        this.in.unparsedContent(this.contentHandler, validator, element != null && element.ignoreWhitespace, this.isStandalone && this.isValidating && !element.isFromInternalSubset ? "V-023" : null);
                        this.lexicalHandler.endCDATA();
                        continue;
                    }
                    char c = this.getc();
                    this.fatal("P-079", new Object[]{Integer.toHexString(c), new Character(c)});
                }
                if (element != null && element.ignoreWhitespace && this.in.ignorableWhitespace(this.contentHandler)) {
                    if (!this.isValidating || !this.isStandalone || element.isFromInternalSubset) continue;
                    this.error("V-011", new Object[]{element.name});
                    continue;
                }
                if (this.in.parsedContent(this.contentHandler, validator)) continue;
                if (this.in.isEOF()) break block6;
                if (!this.maybeReferenceInContent(element, validator)) break;
            }
            throw new InternalError();
        }
        if (!allowEOF) {
            this.fatal("P-035");
        }
    }

    private boolean maybeElementDecl() throws IOException, SAXException {
        InputEntity start = this.peekDeclaration("!ELEMENT");
        if (start == null) {
            return false;
        }
        String name = this.getMarkupDeclname("F-015", true);
        ElementDecl element = (ElementDecl)this.elements.get(name);
        boolean declEffective = false;
        if (element != null) {
            if (element.contentType != null) {
                if (this.isValidating && element.contentType != null) {
                    this.error("V-012", new Object[]{name});
                }
                element = new ElementDecl(name);
            }
        } else {
            element = new ElementDecl(name);
            if (!this.ignoreDeclarations) {
                this.elements.put(element.name, element);
                declEffective = true;
            }
        }
        element.isFromInternalSubset = !this.inExternalPE;
        this.whitespace("F-000");
        if (this.peek(strEMPTY)) {
            element.contentType = strEMPTY;
            element.ignoreWhitespace = true;
        } else if (this.peek(strANY)) {
            element.contentType = strANY;
            element.ignoreWhitespace = false;
        } else {
            element.contentType = this.getMixedOrChildren(element);
        }
        this.maybeWhitespace();
        char c = this.getc();
        if (c != '>') {
            this.fatal("P-036", new Object[]{name, new Character(c)});
        }
        if (this.isValidating && start != this.in) {
            this.error("V-013", null);
        }
        if (declEffective) {
            this.declHandler.elementDecl(element.name, element.contentType);
        }
        return true;
    }

    private String getMixedOrChildren(ElementDecl element) throws IOException, SAXException {
        this.strTmp = new StringBuffer();
        this.nextChar('(', "F-028", element.name);
        InputEntity start = this.in;
        this.maybeWhitespace();
        this.strTmp.append('(');
        if (this.peek("#PCDATA")) {
            this.strTmp.append("#PCDATA");
            this.getMixed(element.name, start);
            element.ignoreWhitespace = false;
        } else {
            element.model = this.getcps(element.name, start);
            element.ignoreWhitespace = true;
        }
        return this.strTmp.toString();
    }

    ContentModel newContentModel(String tag) {
        return null;
    }

    ContentModel newContentModel(char type, ContentModel next) {
        return null;
    }

    private ContentModel getcps(String element, InputEntity start) throws IOException, SAXException {
        boolean decided = false;
        char type = '\u0000';
        ContentModel temp = null;
        ContentModel current = null;
        ContentModel retval = null;
        do {
            String tag;
            if ((tag = this.maybeGetName()) != null) {
                this.strTmp.append(tag);
                temp = this.getFrequency(this.newContentModel(tag));
            } else if (this.peek("(")) {
                InputEntity next = this.in;
                this.strTmp.append('(');
                this.maybeWhitespace();
                temp = this.getFrequency(this.getcps(element, next));
            } else {
                this.fatal(type == '\u0000' ? "P-039" : (type == ',' ? "P-037" : "P-038"), new Object[]{new Character(this.getc())});
            }
            this.maybeWhitespace();
            if (decided) {
                char c = this.getc();
                if (current != null) {
                    current = current.next = this.newContentModel(type, temp);
                }
                if (c == type) {
                    this.strTmp.append(type);
                    this.maybeWhitespace();
                    continue;
                }
                if (c == ')') {
                    this.ungetc();
                    continue;
                }
                this.fatal(type == '\u0000' ? "P-041" : "P-040", new Object[]{new Character(c), new Character(type)});
            } else {
                type = this.getc();
                if (type != '|' && type != ',') {
                    retval = current = temp;
                    this.ungetc();
                    continue;
                }
                decided = true;
                retval = current = this.newContentModel(type, temp);
                this.strTmp.append(type);
            }
            this.maybeWhitespace();
        } while (!this.peek(")"));
        if (this.isValidating && this.in != start) {
            this.error("V-014", new Object[]{element});
        }
        this.strTmp.append(')');
        return this.getFrequency(retval);
    }

    private ContentModel getFrequency(ContentModel original) throws IOException, SAXException {
        char c = this.getc();
        if (c == '?' || c == '+' || c == '*') {
            this.strTmp.append(c);
            if (original == null) {
                return null;
            }
            if (original.type == '\u0000') {
                original.type = c;
                return original;
            }
            return this.newContentModel(c, original);
        }
        this.ungetc();
        return original;
    }

    private void getMixed(String element, InputEntity start) throws IOException, SAXException {
        this.maybeWhitespace();
        if (this.peek(")*") || this.peek(")")) {
            if (this.isValidating && this.in != start) {
                this.error("V-014", new Object[]{element});
            }
            this.strTmp.append(')');
            return;
        }
        Vector<String> v = null;
        if (this.isValidating) {
            v = new Vector<String>();
        }
        while (this.peek("|")) {
            this.strTmp.append('|');
            this.maybeWhitespace();
            String name = this.maybeGetName();
            if (name == null) {
                this.fatal("P-042", new Object[]{element, Integer.toHexString(this.getc())});
            }
            if (this.isValidating) {
                if (v.contains(name)) {
                    this.error("V-015", new Object[]{name});
                } else {
                    v.addElement(name);
                }
            }
            this.strTmp.append(name);
            this.maybeWhitespace();
        }
        if (!this.peek(")*")) {
            this.fatal("P-043", new Object[]{element, new Character(this.getc())});
        }
        if (this.isValidating && this.in != start) {
            this.error("V-014", new Object[]{element});
        }
        this.strTmp.append(')');
    }

    private boolean maybeAttlistDecl() throws IOException, SAXException {
        InputEntity start = this.peekDeclaration("!ATTLIST");
        if (start == null) {
            return false;
        }
        String name = this.getMarkupDeclname("F-016", true);
        ElementDecl element = (ElementDecl)this.elements.get(name);
        if (element == null) {
            element = new ElementDecl(name);
            if (!this.ignoreDeclarations) {
                this.elements.put(name, element);
            }
        }
        this.maybeWhitespace();
        while (!this.peek(">")) {
            Vector<String> v;
            name = this.maybeGetName();
            if (name == null) {
                this.fatal("P-044", new Object[]{new Character(this.getc())});
            }
            this.whitespace("F-001");
            AttributeDecl a = new AttributeDecl(name);
            boolean bl = a.isFromInternalSubset = !this.inExternalPE;
            if (this.peek("CDATA")) {
                a.type = "CDATA";
            } else if (this.peek("IDREFS")) {
                a.type = "IDREFS";
            } else if (this.peek("IDREF")) {
                a.type = "IDREF";
            } else if (this.peek("ID")) {
                a.type = "ID";
                if (element.id != null) {
                    if (this.isValidating) {
                        this.error("V-016", new Object[]{element.id});
                    }
                } else {
                    element.id = name;
                }
            } else if (this.peek("ENTITY")) {
                a.type = "ENTITY";
            } else if (this.peek("ENTITIES")) {
                a.type = "ENTITIES";
            } else if (this.peek("NMTOKENS")) {
                a.type = "NMTOKENS";
            } else if (this.peek("NMTOKEN")) {
                a.type = "NMTOKEN";
            } else if (this.peek("NOTATION")) {
                a.type = "NOTATION";
                this.whitespace("F-002");
                this.nextChar('(', "F-029", null);
                this.maybeWhitespace();
                v = new Vector();
                do {
                    if ((name = this.maybeGetName()) == null) {
                        this.fatal("P-068");
                    }
                    if (this.isValidating && this.notations.get(name) == null) {
                        this.notations.put(name, name);
                    }
                    v.addElement(name);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
                a.values = new String[v.size()];
                int i = 0;
                while (i < v.size()) {
                    a.values[i] = (String)v.elementAt(i);
                    ++i;
                }
            } else if (this.peek("(")) {
                a.type = "ENUMERATION";
                this.maybeWhitespace();
                v = new Vector<String>();
                do {
                    name = this.getNmtoken();
                    v.addElement(name);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
                a.values = new String[v.size()];
                int i = 0;
                while (i < v.size()) {
                    a.values[i] = (String)v.elementAt(i);
                    ++i;
                }
            } else {
                this.fatal("P-045", new Object[]{name, new Character(this.getc())});
            }
            this.whitespace("F-003");
            if (this.peek("#REQUIRED")) {
                a.valueDefault = "#REQUIRED";
                a.isRequired = true;
            } else if (this.peek("#FIXED")) {
                if (this.isValidating && a.type == "ID") {
                    this.error("V-017", new Object[]{a.name});
                }
                a.valueDefault = "#FIXED";
                a.isFixed = true;
                this.whitespace("F-004");
                this.doLexicalPE = false;
                this.parseLiteral(false);
                this.doLexicalPE = true;
                a.defaultValue = a.type != "CDATA" ? this.normalize(false) : this.strTmp.toString();
                if (a.type != "CDATA") {
                    this.validateAttributeSyntax(a, a.defaultValue);
                }
            } else if (this.peek("#IMPLIED")) {
                a.valueDefault = "#IMPLIED";
            } else {
                if (this.isValidating && a.type == "ID") {
                    this.error("V-018", new Object[]{a.name});
                }
                this.doLexicalPE = false;
                this.parseLiteral(false);
                this.doLexicalPE = true;
                a.defaultValue = a.type != "CDATA" ? this.normalize(false) : this.strTmp.toString();
                if (a.type != "CDATA") {
                    this.validateAttributeSyntax(a, a.defaultValue);
                }
            }
            if (XmlLang.equals(a.name) && a.defaultValue != null && !this.isXmlLang(a.defaultValue)) {
                this.error("P-033", new Object[]{a.defaultValue});
            }
            if (!this.ignoreDeclarations && element.attributes.get(a.name) == null) {
                String saxType;
                element.attributes.put(a.name, a);
                if (a.type == "ENUMERATION" || a.type == "NOTATION") {
                    StringBuffer fullType = new StringBuffer();
                    if (a.type == "NOTATION") {
                        fullType.append(a.type);
                        fullType.append(" ");
                    }
                    if (a.values.length > 1) {
                        fullType.append("(");
                    }
                    int i = 0;
                    while (i < a.values.length) {
                        fullType.append(a.values[i]);
                        if (i + 1 < a.values.length) {
                            fullType.append("|");
                        }
                        ++i;
                    }
                    if (a.values.length > 1) {
                        fullType.append(")");
                    }
                    saxType = fullType.toString();
                } else {
                    saxType = a.type;
                }
                this.declHandler.attributeDecl(element.name, a.name, saxType, a.valueDefault, a.defaultValue);
            }
            this.maybeWhitespace();
        }
        if (this.isValidating && start != this.in) {
            this.error("V-013", null);
        }
        return true;
    }

    private String normalize(boolean invalidIfNeeded) throws SAXException {
        String s = this.strTmp.toString();
        String s2 = s.trim();
        boolean didStrip = false;
        if (s != s2) {
            s = s2;
            s2 = null;
            didStrip = true;
        }
        this.strTmp = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!XmlChars.isSpace(c)) {
                this.strTmp.append(c);
            } else {
                this.strTmp.append(' ');
                while (++i < s.length() && XmlChars.isSpace(s.charAt(i))) {
                    didStrip = true;
                }
                --i;
            }
            ++i;
        }
        if (this.isValidating && this.isStandalone && invalidIfNeeded && (s2 == null || didStrip)) {
            this.error("V-019", null);
        }
        if (didStrip) {
            return this.strTmp.toString();
        }
        return s;
    }

    private boolean maybeConditionalSect() throws IOException, SAXException {
        if (!this.peek("<![")) {
            return false;
        }
        InputEntity start = this.in;
        this.maybeWhitespace();
        String keyword = this.maybeGetName();
        if (keyword == null) {
            this.fatal("P-046");
        }
        this.maybeWhitespace();
        this.nextChar('[', "F-030", null);
        if ("INCLUDE".equals(keyword)) {
            while (true) {
                if (this.in.isEOF() && this.in != start) {
                    this.in = this.in.pop();
                    continue;
                }
                if (this.in.isEOF()) {
                    if (this.isValidating) {
                        this.error("V-020", null);
                    }
                    this.in = this.in.pop();
                }
                if (!this.peek("]]>")) {
                    this.doLexicalPE = false;
                    if (this.maybeWhitespace() || this.maybePEReference()) continue;
                    this.doLexicalPE = true;
                    if (this.maybeMarkupDecl() || this.maybeConditionalSect()) continue;
                    this.fatal("P-047");
                    continue;
                }
                break;
            }
        } else if ("IGNORE".equals(keyword)) {
            int nestlevel = 1;
            this.doLexicalPE = false;
            while (nestlevel > 0) {
                char c = this.getc();
                if (c == '<') {
                    if (!this.peek("![")) continue;
                    ++nestlevel;
                    continue;
                }
                if (c != ']' || !this.peek("]>")) continue;
                --nestlevel;
            }
        } else {
            this.fatal("P-048", new Object[]{keyword});
        }
        return true;
    }

    private boolean maybeReferenceInContent(ElementDecl element, ElementValidator validator) throws IOException, SAXException {
        if (!this.in.peekc('&')) {
            return false;
        }
        if (!this.in.peekc('#')) {
            String name = this.maybeGetName();
            if (name == null) {
                this.fatal("P-009");
            }
            this.nextChar(';', "F-020", name);
            this.expandEntityInContent(element, name, validator);
            return true;
        }
        validator.text();
        this.contentHandler.characters(this.charTmp, 0, this.surrogatesToCharTmp(this.parseCharNumber()));
        return true;
    }

    private int parseCharNumber() throws SAXException, IOException {
        int retval = 0;
        if (this.getc() != 'x') {
            this.ungetc();
            while (true) {
                char c;
                if ((c = this.getc()) >= '0' && c <= '9') {
                    retval *= 10;
                    retval += c - 48;
                    continue;
                }
                if (c == ';') {
                    return retval;
                }
                this.fatal("P-049");
            }
        }
        while (true) {
            char c;
            if ((c = this.getc()) >= '0' && c <= '9') {
                retval <<= 4;
                retval += c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                retval <<= 4;
                retval += 10 + (c - 97);
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                retval <<= 4;
                retval += 10 + (c - 65);
                continue;
            }
            if (c == ';') {
                return retval;
            }
            this.fatal("P-050");
        }
    }

    private int surrogatesToCharTmp(int ucs4) throws SAXException {
        if (ucs4 <= 65535) {
            if (XmlChars.isChar(ucs4)) {
                this.charTmp[0] = (char)ucs4;
                return 1;
            }
        } else if (ucs4 <= 0x10FFFF) {
            this.charTmp[0] = (char)(0xD800 | (ucs4 -= 65536) >> 10 & 0x3FF);
            this.charTmp[1] = (char)(0xDC00 | ucs4 & 0x3FF);
            return 2;
        }
        this.fatal("P-051", new Object[]{Integer.toHexString(ucs4)});
        return -1;
    }

    private void expandEntityInContent(ElementDecl element, String name, ElementValidator validator) throws SAXException, IOException {
        Object entity = this.entities.get(name);
        InputEntity last = this.in;
        if (entity == null) {
            this.fatal("P-014", new Object[]{name});
        }
        if (entity instanceof InternalEntity) {
            InternalEntity e = (InternalEntity)entity;
            if (this.isValidating && this.isStandalone && !e.isFromInternalSubset) {
                this.error("V-002", new Object[]{name});
            }
            this.pushReader(e.buf, name, true);
            this.content(element, true, validator);
            if (this.in != last && !this.in.isEOF()) {
                while (this.in.isInternal()) {
                    this.in = this.in.pop();
                }
                this.fatal("P-052", new Object[]{name});
            }
            this.lexicalHandler.endEntity(name);
            this.in = this.in.pop();
        } else if (entity instanceof ExternalEntity) {
            ExternalEntity e = (ExternalEntity)entity;
            if (e.notation != null) {
                this.fatal("P-053", new Object[]{name});
            }
            if (this.isValidating && this.isStandalone && !e.isFromInternalSubset) {
                this.error("V-002", new Object[]{name});
            }
            this.externalParsedEntity(element, e, validator);
        } else {
            throw new InternalError(name);
        }
    }

    private boolean maybePEReference() throws IOException, SAXException {
        if (!this.in.peekc('%')) {
            return false;
        }
        String name = this.maybeGetName();
        if (name == null) {
            this.fatal("P-011");
        }
        this.nextChar(';', "F-021", name);
        Object entity = this.params.get(name);
        if (entity instanceof InternalEntity) {
            InternalEntity value = (InternalEntity)entity;
            this.pushReader(value.buf, name, false);
        } else if (entity instanceof ExternalEntity) {
            this.externalParameterEntity((ExternalEntity)entity);
        } else if (entity == null) {
            this.ignoreDeclarations = true;
            if (this.isValidating) {
                this.error("V-022", new Object[]{name});
            } else {
                this.warning("V-022", new Object[]{name});
            }
        }
        return true;
    }

    private boolean maybeEntityDecl() throws IOException, SAXException {
        boolean doStore;
        SimpleHashtable defns;
        InputEntity start = this.peekDeclaration("!ENTITY");
        if (start == null) {
            return false;
        }
        this.doLexicalPE = false;
        this.whitespace("F-005");
        if (this.in.peekc('%')) {
            this.whitespace("F-006");
            defns = this.params;
        } else {
            defns = this.entities;
        }
        this.ungetc();
        this.doLexicalPE = true;
        String entityName = this.getMarkupDeclname("F-017", false);
        this.whitespace("F-007");
        ExternalEntity externalId = this.maybeExternalID();
        boolean bl = doStore = defns.get(entityName) == null;
        if (!doStore && defns == this.entities) {
            this.warning("P-054", new Object[]{entityName});
        }
        doStore &= !this.ignoreDeclarations;
        if (externalId == null) {
            this.doLexicalPE = false;
            this.parseLiteral(true);
            this.doLexicalPE = true;
            if (doStore) {
                char[] value = new char[this.strTmp.length()];
                if (value.length != 0) {
                    this.strTmp.getChars(0, value.length, value, 0);
                }
                InternalEntity entity = new InternalEntity(entityName, value);
                entity.isPE = defns == this.params;
                entity.isFromInternalSubset = !this.inExternalPE;
                defns.put(entityName, entity);
                if (defns == this.params) {
                    entityName = "%" + entityName;
                }
                this.declHandler.internalEntityDecl(entityName, new String(value));
            }
        } else {
            if (defns == this.entities && this.maybeWhitespace() && this.peek("NDATA")) {
                externalId.notation = this.getMarkupDeclname("F-018", false);
                if (this.isValidating && this.notations.get(externalId.notation) == null) {
                    this.notations.put(externalId.notation, Boolean.TRUE);
                }
            }
            externalId.name = entityName;
            externalId.isPE = defns == this.params;
            boolean bl2 = externalId.isFromInternalSubset = !this.inExternalPE;
            if (doStore) {
                defns.put(entityName, externalId);
                if (externalId.notation != null) {
                    this.dtdHandler.unparsedEntityDecl(entityName, externalId.publicId, externalId.systemId, externalId.notation);
                } else {
                    if (defns == this.params) {
                        entityName = "%" + entityName;
                    }
                    this.declHandler.externalEntityDecl(entityName, externalId.publicId, externalId.systemId);
                }
            }
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-031", entityName);
        if (this.isValidating && start != this.in) {
            this.error("V-013", null);
        }
        return true;
    }

    private ExternalEntity maybeExternalID() throws IOException, SAXException {
        String temp = null;
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            temp = this.parsePublicId();
        } else if (!this.peek("SYSTEM")) {
            return null;
        }
        ExternalEntity retval = new ExternalEntity(this.in);
        retval.publicId = temp;
        this.whitespace("F-008");
        retval.verbatimSystemId = this.getQuotedString("F-034", null);
        retval.systemId = this.resolveURI(retval.verbatimSystemId);
        return retval;
    }

    private String parseSystemId() throws IOException, SAXException {
        String uri = this.getQuotedString("F-034", null);
        return this.resolveURI(uri);
    }

    private String resolveURI(String uri) throws SAXException {
        int temp = uri.indexOf(58);
        if (temp == -1 || uri.indexOf(47) < temp) {
            String baseURI = this.in.getSystemId();
            if (baseURI == null) {
                this.fatal("P-055", new Object[]{uri});
            }
            if (uri.length() == 0) {
                uri = ".";
            }
            baseURI = baseURI.substring(0, baseURI.lastIndexOf(47) + 1);
            if (uri.charAt(0) != '/') {
                uri = baseURI + uri;
            } else {
                int colonIndex = baseURI.indexOf(58);
                String baseURIScheme = colonIndex == -1 ? "file:" : baseURI.substring(0, colonIndex + 1);
                uri = baseURIScheme + uri;
            }
        }
        if (uri.indexOf(35) != -1) {
            this.error("P-056", new Object[]{uri});
        }
        return uri;
    }

    private void maybeTextDecl() throws IOException, SAXException {
        if (!this.in.isXmlDeclOrTextDeclPrefix()) {
            return;
        }
        this.peek("<?xml");
        this.readVersion(false, "1.0");
        this.readEncoding(true);
        this.maybeWhitespace();
        if (!this.peek("?>")) {
            this.fatal("P-057");
        }
    }

    private boolean externalParsedEntity(ElementDecl element, ExternalEntity next, ElementValidator validator) throws IOException, SAXException {
        if (!this.pushReader(next)) {
            if (!this.isInAttribute) {
                this.lexicalHandler.endEntity(next.name);
            }
            return false;
        }
        this.maybeTextDecl();
        this.content(element, true, validator);
        if (!this.in.isEOF()) {
            this.fatal("P-058", new Object[]{next.name});
        }
        this.in = this.in.pop();
        if (!this.isInAttribute) {
            this.lexicalHandler.endEntity(next.name);
        }
        return true;
    }

    private void externalParameterEntity(ExternalEntity next) throws IOException, SAXException {
        if (this.isStandalone && this.fastStandalone) {
            return;
        }
        this.inExternalPE = true;
        try {
            this.pushReader(next);
        }
        catch (IOException e) {
            this.fatal("P-082", new Object[]{next.systemId}, e);
        }
        InputEntity pe = this.in;
        try {
            this.maybeTextDecl();
        }
        catch (IOException e) {
            this.in = this.in.pop();
            this.fatal("P-082", new Object[]{next.systemId}, e);
        }
        while (!pe.isEOF()) {
            if (this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            this.doLexicalPE = false;
            if (this.maybeWhitespace() || this.maybePEReference()) continue;
            this.doLexicalPE = true;
            if (!this.maybeMarkupDecl() && !this.maybeConditionalSect()) break;
        }
        if (!pe.isEOF()) {
            this.fatal("P-059", new Object[]{this.in.getName()});
        }
        this.in = this.in.pop();
        this.inExternalPE = !this.in.isDocument();
        this.doLexicalPE = false;
    }

    private void readEncoding(boolean must) throws IOException, SAXException {
        String name = this.maybeReadAttribute("encoding", must);
        if (name == null) {
            return;
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || i != 0 && (c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.'))) {
                this.fatal("P-060", new Object[]{new Character(c)});
            }
            ++i;
        }
        String currentEncoding = this.in.getEncoding();
        if (currentEncoding != null && !name.equalsIgnoreCase(currentEncoding)) {
            this.warning("P-061", new Object[]{name, currentEncoding});
        }
    }

    private boolean maybeNotationDecl() throws IOException, SAXException {
        Object value;
        InputEntity start = this.peekDeclaration("!NOTATION");
        if (start == null) {
            return false;
        }
        String name = this.getMarkupDeclname("F-019", false);
        ExternalEntity entity = new ExternalEntity(this.in);
        this.whitespace("F-011");
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            entity.publicId = this.parsePublicId();
            if (this.maybeWhitespace()) {
                if (!this.peek(">")) {
                    entity.systemId = this.parseSystemId();
                } else {
                    this.ungetc();
                }
            }
        } else if (this.peek("SYSTEM")) {
            this.whitespace("F-008");
            entity.systemId = this.parseSystemId();
        } else {
            this.fatal("P-062");
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-032", name);
        if (this.isValidating && start != this.in) {
            this.error("V-013", null);
        }
        if (entity.systemId != null && entity.systemId.indexOf(35) != -1) {
            this.error("P-056", new Object[]{entity.systemId});
        }
        if ((value = this.notations.get(name)) != null && value instanceof ExternalEntity) {
            this.warning("P-063", new Object[]{name});
        } else if (!this.ignoreDeclarations) {
            this.notations.put(name, entity);
            this.dtdHandler.notationDecl(name, entity.publicId, entity.systemId);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private char getc() throws IOException, SAXException {
        if (this.inExternalPE && this.doLexicalPE) ** GOTO lbl10
        c = this.in.getc();
        if (c == '%' && this.doLexicalPE) {
            this.fatal("P-080");
        }
        return c;
lbl-1000:
        // 1 sources

        {
            if (this.in.isInternal() || this.doLexicalPE && !this.in.isDocument()) {
                this.in = this.in.pop();
                continue;
            }
            this.fatal("P-064", new Object[]{this.in.getName()});
lbl10:
            // 3 sources

            ** while (this.in.isEOF())
        }
lbl11:
        // 1 sources

        c = this.in.getc();
        if (c == '%' && this.doLexicalPE) {
            name = this.maybeGetName();
            if (name == null) {
                this.fatal("P-011");
            }
            this.nextChar(';', "F-021", name);
            entity = this.params.get(name);
            this.pushReader(" ".toCharArray(), null, false);
            if (entity instanceof InternalEntity) {
                this.pushReader(((InternalEntity)entity).buf, name, false);
            } else if (entity instanceof ExternalEntity) {
                this.pushReader((ExternalEntity)entity);
            } else if (entity == null) {
                this.fatal("V-022");
            } else {
                throw new InternalError();
            }
            this.pushReader(" ".toCharArray(), null, false);
            return this.in.getc();
        }
        return c;
    }

    private void ungetc() {
        this.in.ungetc();
    }

    private boolean peek(String s) throws IOException, SAXException {
        return this.in.peek(s, null);
    }

    private InputEntity peekDeclaration(String s) throws IOException, SAXException {
        if (!this.in.peekc('<')) {
            return null;
        }
        InputEntity start = this.in;
        if (this.in.peek(s, null)) {
            return start;
        }
        this.in.ungetc();
        return null;
    }

    private void nextChar(char c, String location, String near) throws IOException, SAXException {
        while (this.in.isEOF() && !this.in.isDocument()) {
            this.in = this.in.pop();
        }
        if (!this.in.peekc(c)) {
            this.fatal("P-008", new Object[]{new Character(c), messages.getMessage(this.locale, location), near == null ? "" : '\"' + near + '\"'});
        }
    }

    private void pushReader(char[] buf, String name, boolean isGeneral) throws SAXException {
        if (isGeneral && !this.isInAttribute) {
            this.lexicalHandler.startEntity(name);
        }
        InputEntity r = InputEntity.getInputEntity(this.errHandler, this.locale);
        r.init(buf, name, this.in, !isGeneral);
        this.in = r;
    }

    private boolean pushReader(ExternalEntity next) throws SAXException, IOException {
        if (!next.isPE && !this.isInAttribute) {
            this.lexicalHandler.startEntity(next.name);
        }
        InputEntity r = InputEntity.getInputEntity(this.errHandler, this.locale);
        InputSource s = next.getInputSource(this.resolver);
        r.init(s, next.name, this.in, next.isPE);
        this.in = r;
        return true;
    }

    private void warning(String messageId, Object[] parameters) throws SAXException {
        SAXParseException x = new SAXParseException(messages.getMessage(this.locale, messageId, parameters), this.locator);
        this.errHandler.warning(x);
    }

    void error(String messageId, Object[] parameters) throws SAXException {
        SAXParseException x = new SAXParseException(messages.getMessage(this.locale, messageId, parameters), this.locator);
        this.errHandler.error(x);
    }

    private void fatal(String message) throws SAXException {
        this.fatal(message, null, null);
    }

    private void fatal(String message, Object[] parameters) throws SAXException {
        this.fatal(message, parameters, null);
    }

    private void fatal(String messageId, Object[] parameters, Exception e) throws SAXException {
        SAXParseException x = new SAXParseException(messages.getMessage(this.locale, messageId, parameters), this.locator, e);
        this.errHandler.fatalError(x);
        throw x;
    }

    static final class Catalog
    extends MessageCatalog {
        static /* synthetic */ Class class$org$apache$crimson$parser$Parser2;

        Catalog() {
            super(class$org$apache$crimson$parser$Parser2 == null ? (class$org$apache$crimson$parser$Parser2 = Catalog.class$("org.apache.crimson.parser.Parser2")) : class$org$apache$crimson$parser$Parser2);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class NullHandler
    extends DefaultHandler
    implements LexicalHandler,
    DeclHandler {
        private NullHandler() {
        }

        public void startDTD(String name, String publicId, String systemId) {
        }

        public void endDTD() {
        }

        public void startEntity(String name) {
        }

        public void endEntity(String name) {
        }

        public void startCDATA() {
        }

        public void endCDATA() {
        }

        public void comment(char[] ch, int start, int length) {
        }

        public void elementDecl(String name, String model) {
        }

        public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) {
        }

        public void internalEntityDecl(String name, String value) {
        }

        public void externalEntityDecl(String name, String publicId, String systemId) {
        }
    }

    static class NameCacheEntry {
        String name;
        char[] chars;
        NameCacheEntry next;

        NameCacheEntry() {
        }

        boolean matches(char[] value, int len) {
            if (this.chars.length != len) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (value[i] != this.chars[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class NameCache {
        NameCacheEntry[] hashtable = new NameCacheEntry[541];

        NameCache() {
        }

        String lookup(char[] value, int len) {
            return this.lookupEntry((char[])value, (int)len).name;
        }

        NameCacheEntry lookupEntry(char[] value, int len) {
            int index = 0;
            int i = 0;
            while (i < len) {
                index = index * 31 + value[i];
                ++i;
            }
            index &= Integer.MAX_VALUE;
            NameCacheEntry entry = this.hashtable[index %= this.hashtable.length];
            while (entry != null) {
                if (entry.matches(value, len)) {
                    return entry;
                }
                entry = entry.next;
            }
            entry = new NameCacheEntry();
            entry.chars = new char[len];
            System.arraycopy(value, 0, entry.chars, 0, len);
            entry.name = new String(entry.chars);
            entry.name = entry.name.intern();
            entry.next = this.hashtable[index];
            this.hashtable[index] = entry;
            return entry;
        }
    }

    class DocLocator
    implements Locator {
        DocLocator() {
        }

        public String getPublicId() {
            return Parser2.this.in == null ? null : Parser2.this.in.getPublicId();
        }

        public String getSystemId() {
            return Parser2.this.in == null ? null : Parser2.this.in.getSystemId();
        }

        public int getLineNumber() {
            return Parser2.this.in == null ? -1 : Parser2.this.in.getLineNumber();
        }

        public int getColumnNumber() {
            return Parser2.this.in == null ? -1 : Parser2.this.in.getColumnNumber();
        }
    }
}

