/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.vcs;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.openide.filesystems.FileObject;

class DelegatingCommandInvocationHandler
implements InvocationHandler {
    private Command[] commands;
    private String cmdName;
    private Command metaCommand;

    public DelegatingCommandInvocationHandler(String cmdName, Command[] commands) {
        this.cmdName = cmdName;
        this.commands = commands;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if ("execute".equals(name)) {
            return this.execute();
        }
        if ("setFiles".equals(name)) {
            throw new UnsupportedOperationException(name);
        }
        if ("getFiles".equals(name)) {
            return this.getFiles();
        }
        Class[] parameterTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        Object ret = null;
        int i2 = 0;
        while (i2 < this.commands.length) {
            try {
                Method m = this.commands[i2].getClass().getMethod(name, parameterTypes);
                if (m != null) {
                    ret = m.invoke((Object)this.commands[i2], args);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            ++i2;
        }
        return ret;
    }

    void setMetaCommand(Command metaCommand) {
        this.metaCommand = metaCommand;
    }

    private FileObject[] getFiles() {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        int i = 0;
        while (i < this.commands.length) {
            files.addAll(Arrays.asList(this.commands[i].getFiles()));
            ++i;
        }
        return files.toArray(new FileObject[files.size()]);
    }

    private CommandTask execute() {
        CommandTask[] tasks = new CommandTask[this.commands.length];
        int i = 0;
        while (i < this.commands.length) {
            tasks[i] = this.commands[i].execute();
            ++i;
        }
        return new MultiCommandTask(tasks);
    }

    private class MultiCommandTask
    extends CommandTask {
        private CommandTask[] tasks;

        public MultiCommandTask(CommandTask[] tasks) {
            this.tasks = tasks;
        }

        public String getName() {
            return DelegatingCommandInvocationHandler.this.cmdName;
        }

        public String getDisplayName() {
            return DelegatingCommandInvocationHandler.this.metaCommand.getDisplayName();
        }

        public FileObject[] getFiles() {
            return DelegatingCommandInvocationHandler.this.getFiles();
        }

        protected int execute() {
            int exitStatus = 0;
            int i = 0;
            while (i < this.tasks.length) {
                this.tasks[i].waitFinished();
                int exit = this.tasks[i].getExitStatus();
                if (exit != 0) {
                    exitStatus = 1;
                }
                ++i;
            }
            return exitStatus;
        }
    }
}

