/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.vcs;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.vcs.DelegatingCommandInvocationHandler;
import org.netbeans.api.vcs.FileStatusInfo;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.modules.vcscore.commands.CommandProcessListener;
import org.netbeans.modules.vcscore.commands.CommandProcessor;
import org.netbeans.modules.vcscore.commands.CommandTaskInfo;
import org.netbeans.spi.vcs.VcsCommandsProvider;
import org.netbeans.spi.vcs.VcsStatusProvider;
import org.openide.filesystems.FileObject;

public class VcsManager {
    private static VcsManager manager;
    static /* synthetic */ Class class$org$netbeans$api$vcs$VcsManager;

    private VcsManager() {
    }

    public static synchronized VcsManager getDefault() {
        if (manager == null) {
            manager = new VcsManager();
        }
        return manager;
    }

    public String[] findCommands(FileObject[] files) {
        if (files.length == 0) {
            return new String[0];
        }
        Map filesByProviders = VcsManager.createFilesByCommandProvidersMap(files);
        ArrayList<String> commandNames = null;
        Iterator it = filesByProviders.keySet().iterator();
        while (it.hasNext()) {
            VcsCommandsProvider provider = (VcsCommandsProvider)it.next();
            String[] names = provider.getCommandNames();
            ArrayList<String> providerCommandNames = new ArrayList<String>();
            int i = 0;
            while (i < names.length) {
                Command cmd = provider.createCommand(names[i]);
                if (cmd.getApplicableFiles(((ArrayList)filesByProviders.get(provider)).toArray(new FileObject[0])) != null) {
                    providerCommandNames.add(names[i]);
                }
                ++i;
            }
            if (commandNames == null) {
                commandNames = providerCommandNames;
                continue;
            }
            ((AbstractCollection)commandNames).retainAll(providerCommandNames);
        }
        return commandNames.toArray(new String[commandNames.size()]);
    }

    private static Map createFilesByCommandProvidersMap(FileObject[] files) throws IllegalArgumentException {
        HashMap<VcsCommandsProvider, ArrayList<FileObject>> filesByProviders = new HashMap<VcsCommandsProvider, ArrayList<FileObject>>();
        int i = 0;
        while (i < files.length) {
            ArrayList<FileObject> fileList;
            VcsCommandsProvider provider = VcsCommandsProvider.findProvider(files[i]);
            if (provider != null) {
                fileList = (ArrayList<FileObject>)filesByProviders.get(provider);
                if (fileList == null) {
                    fileList = new ArrayList<FileObject>();
                    filesByProviders.put(provider, fileList);
                }
            } else {
                throw new IllegalArgumentException("There is no commands provider for file '" + files[i] + "'");
            }
            fileList.add(files[i]);
            ++i;
        }
        return filesByProviders;
    }

    public Command createCommand(String cmdName, FileObject[] files) throws IllegalArgumentException {
        Command cmd;
        if (files.length == 0) {
            return null;
        }
        Map filesByProviders = VcsManager.createFilesByCommandProvidersMap(files);
        if (filesByProviders.size() == 1) {
            VcsCommandsProvider provider = (VcsCommandsProvider)filesByProviders.keySet().iterator().next();
            cmd = provider.createCommand(cmdName);
            if (cmd != null) {
                cmd.setFiles(files);
            }
        } else {
            HashSet<Command> commands = new HashSet<Command>();
            Iterator it = filesByProviders.keySet().iterator();
            while (it.hasNext()) {
                VcsCommandsProvider provider = (VcsCommandsProvider)it.next();
                Command cmd1 = provider.createCommand(cmdName);
                if (cmd1 == null) continue;
                cmd1.setFiles(((ArrayList)filesByProviders.get(provider)).toArray(new FileObject[0]));
                commands.add(cmd1);
            }
            cmd = commands.size() == 0 ? null : (commands.size() == 1 ? (Command)commands.iterator().next() : VcsManager.createMetaCommand(cmdName, commands.toArray(new Command[commands.size()])));
        }
        return cmd;
    }

    public Command createCommand(Class cmdClass, FileObject[] files) throws IllegalArgumentException {
        Command cmd;
        if (files.length == 0) {
            return null;
        }
        Map filesByProviders = VcsManager.createFilesByCommandProvidersMap(files);
        if (filesByProviders.size() == 1) {
            VcsCommandsProvider provider = (VcsCommandsProvider)filesByProviders.keySet().iterator().next();
            cmd = provider.createCommand(cmdClass);
            if (cmd != null) {
                cmd.setFiles(files);
            }
        } else {
            HashSet<Command> commands = new HashSet<Command>();
            Iterator it = filesByProviders.keySet().iterator();
            while (it.hasNext()) {
                VcsCommandsProvider provider = (VcsCommandsProvider)it.next();
                Command cmd1 = provider.createCommand(cmdClass);
                if (cmd1 == null) continue;
                cmd1.setFiles(((ArrayList)filesByProviders.get(provider)).toArray(new FileObject[0]));
                commands.add(cmd1);
            }
            if (commands.size() == 0) {
                cmd = null;
            } else {
                String cmdName = ((Command)commands.iterator().next()).getName();
                cmd = VcsManager.createMetaCommand(cmdName, commands.toArray(new Command[commands.size()]));
            }
        }
        return cmd;
    }

    public boolean showCustomizer(Command cmd) {
        CommandProcessor processor = CommandProcessor.getInstance();
        CustomizationListener custListener = new CustomizationListener(cmd);
        processor.addCommandProcessListener(custListener);
        processor.preprocess(cmd);
        CustomizationListener customizationListener = custListener;
        synchronized (customizationListener) {
            if (custListener.isPreprocessed()) {
                processor.removeCommandProcessListener(custListener);
            } else {
                try {
                    try {
                        custListener.wait();
                    }
                    catch (InterruptedException iex) {
                        boolean bl = false;
                        Object var8_6 = null;
                        processor.removeCommandProcessListener(custListener);
                        return bl;
                    }
                    Object var8_5 = null;
                    processor.removeCommandProcessListener(custListener);
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    processor.removeCommandProcessListener(custListener);
                    throw throwable;
                }
            }
        }
        return custListener.isCustumizationSuccessfull();
    }

    public FileStatusInfo getFileStatus(FileObject file) {
        VcsStatusProvider status = VcsStatusProvider.findProvider(file);
        if (status != null) {
            return status.getStatus(file.getPackageNameExt('/', '.'));
        }
        return null;
    }

    private static Command createMetaCommand(String cmdName, Command[] commands) {
        HashSet commonInterfaces = null;
        int i = 0;
        while (i < commands.length) {
            HashSet intrs = VcsManager.findAllInterfaces(commands[i].getClass());
            if (commonInterfaces == null) {
                commonInterfaces = intrs;
            } else {
                commonInterfaces.retainAll(intrs);
            }
            ++i;
        }
        DelegatingCommandInvocationHandler handler = new DelegatingCommandInvocationHandler(cmdName, commands);
        Command command = (Command)Proxy.newProxyInstance((class$org$netbeans$api$vcs$VcsManager == null ? (class$org$netbeans$api$vcs$VcsManager = VcsManager.class$("org.netbeans.api.vcs.VcsManager")) : class$org$netbeans$api$vcs$VcsManager).getClassLoader(), ((AbstractCollection)commonInterfaces).toArray(new Class[commonInterfaces.size()]), (InvocationHandler)handler);
        return command;
    }

    private static HashSet findAllInterfaces(Class clazz) {
        HashSet interfaces = new HashSet();
        Class<?>[] intrs = clazz.getInterfaces();
        interfaces.addAll(Arrays.asList(intrs));
        int i = 0;
        while (i < intrs.length) {
            interfaces.addAll(VcsManager.findAllInterfaces(intrs[i]));
            ++i;
        }
        return interfaces;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CustomizationListener
    implements CommandProcessListener {
        private Command cmd;
        private boolean status;
        private boolean preprocessed = false;

        public CustomizationListener(Command cmd) {
            this.cmd = cmd;
        }

        public VcsCommandsProvider getProvider() {
            return null;
        }

        public void commandDone(CommandTaskInfo info) {
        }

        public void commandPreprocessed(Command cmd, boolean status) {
            if (this.cmd.equals(cmd)) {
                this.status = status;
                CustomizationListener customizationListener = this;
                synchronized (customizationListener) {
                    this.preprocessed = true;
                    this.notify();
                }
            }
        }

        public void commandPreprocessing(Command cmd) {
        }

        public void commandStarting(CommandTaskInfo info) {
        }

        public boolean isPreprocessed() {
            return this.preprocessed;
        }

        public boolean isCustumizationSuccessfull() {
            return this.status;
        }
    }
}

