/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.vcs.commands;

import org.netbeans.api.vcs.commands.CommandTaskInfoImpl;
import org.netbeans.modules.vcscore.commands.CommandProcessor;
import org.netbeans.modules.vcscore.commands.CommandTaskInfo;
import org.openide.filesystems.FileObject;
import org.openide.util.Task;

public abstract class CommandTask
extends Task {
    public static final int STATUS_NOT_STARTED = -2;
    public static final int STATUS_RUNNING = -1;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 1;
    public static final int STATUS_INTERRUPTED = 2;
    private volatile int status = -2;
    private final Object notifyLock = new Object();
    private CommandTaskInfo taskInfo;

    public abstract String getName();

    public abstract String getDisplayName();

    public abstract FileObject[] getFiles();

    protected boolean canExecute() {
        return true;
    }

    public final void run() {
        this.taskInfo = new CommandTaskInfoImpl(this);
        this.taskInfo.register();
    }

    final void runCommandTask() {
        block11: {
            this.status = -1;
            this.notifyRunning();
            try {
                this.status = this.execute();
                Object var2_1 = null;
                if (this.taskInfo.isInterrupted()) {
                    this.status = 2;
                    break block11;
                }
                if (this.status != -1) break block11;
                this.status = 1;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.taskInfo.isInterrupted()) {
                    this.status = 2;
                } else if (this.status == -1) {
                    this.status = 1;
                }
                this.notifyFinished();
                Object object = this.notifyLock;
                synchronized (object) {
                    this.notifyLock.notifyAll();
                }
                throw throwable;
            }
        }
        this.notifyFinished();
        Object object = this.notifyLock;
        synchronized (object) {
            this.notifyLock.notifyAll();
        }
    }

    protected abstract int execute();

    public final boolean isRunning() {
        return -1 == this.status;
    }

    public void stop() {
        this.killHard();
    }

    final void killHard() {
        CommandProcessor.getInstance().kill(this);
    }

    public final int getExitStatus() {
        return this.status;
    }

    public void waitFinished(int timeout) throws InterruptedException {
        Object object = this.notifyLock;
        synchronized (object) {
            if (!this.isFinished()) {
                this.notifyLock.wait(timeout);
            }
        }
    }
}

