/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.modules.vcscore.cmdline.UserCommandSupport;
import org.netbeans.modules.vcscore.commands.CommandsTree;
import org.netbeans.spi.vcs.VcsCommandsProvider;
import org.netbeans.spi.vcs.commands.CommandSupport;

public class DefaultVcsCommandsProvider
extends VcsCommandsProvider
implements CommandsTree.Provider {
    private CommandsTree commands;
    private Map commandSupportsByNames;
    private Map commandSupportsByClasses;
    private String[] commandNames;
    private boolean expertMode;

    public DefaultVcsCommandsProvider(CommandsTree commands) {
        this.setCommands(commands);
    }

    public void setExpertMode(boolean expertMode) {
        this.expertMode = expertMode;
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public Command createCommand(Class cmdClass) {
        CommandSupport support = (CommandSupport)this.commandSupportsByClasses.get(cmdClass);
        if (support != null) {
            return support.createCommand();
        }
        return null;
    }

    public Command createCommand(String cmdName) {
        CommandSupport support = (CommandSupport)this.commandSupportsByNames.get(cmdName);
        if (support != null) {
            return support.createCommand();
        }
        return null;
    }

    public String[] getCommandNames() {
        return this.commandNames;
    }

    public CommandsTree getCommands() {
        return this.commands;
    }

    public void setCommands(CommandsTree commands) {
        this.commands = commands;
        this.commandSupportsByNames = new HashMap();
        this.commandSupportsByClasses = new HashMap();
        this.fillCommands(commands);
        this.commandNames = this.commandSupportsByNames.keySet().toArray(new String[this.commandSupportsByNames.size()]);
    }

    private void fillCommands(CommandsTree commands) {
        CommandsTree[] subCommands = commands.children();
        int i = 0;
        while (i < subCommands.length) {
            CommandSupport support = subCommands[i].getCommandSupport();
            if (support != null) {
                this.commandSupportsByNames.put(support.getName(), support);
                if (support instanceof UserCommandSupport) {
                    Class commandClass = ((UserCommandSupport)support).getImplementedCommandClass();
                    this.commandSupportsByClasses.put(commandClass, support);
                }
            }
            if (subCommands[i].hasChildren()) {
                this.fillCommands(subCommands[i]);
            }
            ++i;
        }
    }
}

