/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.DirReaderListener;
import org.netbeans.modules.vcscore.VcsDirContainer;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.caching.RefreshCommandSupport;
import org.netbeans.modules.vcscore.caching.VcsCache;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RetrievingDialog
extends JDialog
implements Runnable,
DirReaderListener {
    private Debug E;
    private Debug D;
    private JLabel retrievingLabel;
    private JScrollPane listScrollPane;
    private JButton stopButton;
    private JList list;
    private DefaultListModel listData;
    private VcsFileSystem fileSystem;
    private String rootPath;
    private Vector queue;
    private boolean shouldStop;
    private boolean success;
    static final long serialVersionUID = -6441709213287922213L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$RetrievingDialog;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$caching$VcsFSCache;

    public RetrievingDialog(VcsFileSystem fileSystem, String rootPath, Frame parent, boolean modal) {
        super(parent, modal);
        this.D = this.E = new Debug("RetrievingDialog", true);
        this.fileSystem = null;
        this.rootPath = null;
        this.queue = new Vector(50);
        this.shouldStop = false;
        this.success = true;
        this.rootPath = rootPath;
        this.fileSystem = fileSystem;
        this.success = true;
        this.initComponents();
        this.initAccessibility();
        this.pack();
        HelpCtx.setHelpIDString((JComponent)this.getRootPane(), (String)(class$org$netbeans$modules$vcscore$RetrievingDialog == null ? (class$org$netbeans$modules$vcscore$RetrievingDialog = RetrievingDialog.class$("org.netbeans.modules.vcscore.RetrievingDialog")) : class$org$netbeans$modules$vcscore$RetrievingDialog).getName());
    }

    private void initComponents() {
        ((Component)this).setBackground(new Color(192, 192, 192));
        this.setTitle(this.g("CTL_Retrieving"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RetrievingDialog.this.closeDialog();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.retrievingLabel = new JLabel();
        this.retrievingLabel.setText(this.g("CTL_Retrieving_directories"));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.2;
        gridBagConstraints1.weighty = 0.05;
        this.getContentPane().add((Component)this.retrievingLabel, gridBagConstraints1);
        this.listScrollPane = new JScrollPane();
        this.listScrollPane.setPreferredSize(new Dimension(400, 70));
        this.listScrollPane.setVerticalScrollBarPolicy(22);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.listData = new DefaultListModel();
        this.list.setModel(this.listData);
        this.listScrollPane.add(this.list);
        this.listScrollPane.setViewportView(this.list);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 4;
        gridBagConstraints1.gridheight = 4;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 0.9;
        this.getContentPane().add((Component)this.listScrollPane, gridBagConstraints1);
        this.stopButton = new JButton();
        this.stopButton.setText(this.g("CTL_StopButtonLabel"));
        this.stopButton.setMnemonic(this.g("CTL_StopButtonLabel.mnemonic").charAt(0));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints1.anchor = 13;
        gridBagConstraints1.weightx = 1.0;
        this.getContentPane().add((Component)this.stopButton, gridBagConstraints1);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RetrievingDialog.this.stopButtonPressed(e);
            }
        });
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$RetrievingDialog == null ? (class$org$netbeans$modules$vcscore$RetrievingDialog = RetrievingDialog.class$("org.netbeans.modules.vcscore.RetrievingDialog")) : class$org$netbeans$modules$vcscore$RetrievingDialog), (String)"ACSD_Retrieving"));
        this.retrievingLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$RetrievingDialog == null ? (class$org$netbeans$modules$vcscore$RetrievingDialog = RetrievingDialog.class$("org.netbeans.modules.vcscore.RetrievingDialog")) : class$org$netbeans$modules$vcscore$RetrievingDialog), (String)"CTL_Retrieving_directories").charAt(0));
        this.retrievingLabel.setLabelFor(this.list);
        this.list.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$RetrievingDialog == null ? (class$org$netbeans$modules$vcscore$RetrievingDialog = RetrievingDialog.class$("org.netbeans.modules.vcscore.RetrievingDialog")) : class$org$netbeans$modules$vcscore$RetrievingDialog), (String)"ACSN_DirList"));
        this.list.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$RetrievingDialog == null ? (class$org$netbeans$modules$vcscore$RetrievingDialog = RetrievingDialog.class$("org.netbeans.modules.vcscore.RetrievingDialog")) : class$org$netbeans$modules$vcscore$RetrievingDialog), (String)"ACSD_DirList"));
        this.stopButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$RetrievingDialog == null ? (class$org$netbeans$modules$vcscore$RetrievingDialog = RetrievingDialog.class$("org.netbeans.modules.vcscore.RetrievingDialog")) : class$org$netbeans$modules$vcscore$RetrievingDialog), (String)"ACSD_StopButton"));
    }

    private void stopButtonPressed(ActionEvent e) {
        this.closeDialog();
    }

    private void closeDialog() {
        this.shouldStop = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void readDirFinished(String path, Collection rawData, boolean success) {
        Iterator it = rawData.iterator();
        while (it.hasNext()) {
            String fileName = RefreshCommandSupport.getFileName((String[])it.next());
            if (!fileName.endsWith("/")) continue;
            String d = path + "/" + fileName;
            if (success) {
                this.queue.addElement(d.substring(0, d.length() - 1));
                continue;
            }
            this.queue.removeAllElements();
            this.success = false;
        }
        this.success = this.success && success;
        ((VcsCache)CacheHandler.getInstance().getCache(this.fileSystem.getCacheIdStr())).readDirFinished(path, rawData, success, null);
    }

    public void readDirFinishedRecursive(String path, VcsDirContainer rawData, boolean success) {
    }

    private void printMessage(String message) {
        final String displayMessage = message;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RetrievingDialog.this.listData.addElement(displayMessage);
                int index = Math.max(0, RetrievingDialog.this.listData.size() - 1);
                RetrievingDialog.this.list.setSelectedIndex(index);
                RetrievingDialog.this.list.ensureIndexIsVisible(index);
                RetrievingDialog.this.list.validate();
            }
        });
    }

    public void run() {
        CommandSupport listSupport;
        String message = null;
        this.queue.addElement(this.rootPath);
        boolean cancel = false;
        if (this.fileSystem.isOffLine()) {
            listSupport = this.fileSystem.getCommandSupport("LIST_OFFLINE");
            if (listSupport == null && NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$caching$VcsFSCache == null ? (class$org$netbeans$modules$vcscore$caching$VcsFSCache = RetrievingDialog.class$("org.netbeans.modules.vcscore.caching.VcsFSCache")) : class$org$netbeans$modules$vcscore$caching$VcsFSCache), (String)"DLG_RefreshCommandDisabled"), 0)))) {
                this.fileSystem.setOffLine(false);
                listSupport = this.fileSystem.getCommandSupport("LIST");
            }
        } else {
            listSupport = this.fileSystem.getCommandSupport("LIST");
        }
        if (listSupport == null) {
            return;
        }
        Command cmd = listSupport.createCommand();
        if (!(cmd instanceof VcsDescribedCommand)) {
            return;
        }
        VcsDescribedCommand list = (VcsDescribedCommand)cmd;
        list.addDirReaderListener(this);
        this.show();
        while (!this.queue.isEmpty()) {
            String path = (String)this.queue.remove(0);
            this.D.deb("Retrieving recursively for path = " + path);
            this.fileSystem.debug(this.g("MSG_Recursively_retrieving_directory", path));
            String rootFolderLabel = this.g("MSG_Root_folder");
            message = path.equals("") ? rootFolderLabel : path;
            this.printMessage(message);
            list.setDiskFiles(new File[]{this.fileSystem.getFile(path)});
            VcsManager.getDefault().showCustomizer(list);
            CommandTask reader = list.execute();
            try {
                reader.waitFinished(0);
                this.shouldStop = this.shouldStop || reader.getExitStatus() == 2;
            }
            catch (InterruptedException iexc) {
                reader.stop();
                this.shouldStop = true;
            }
            if (!this.shouldStop) continue;
            message = this.g("MSG_Recursive_retrieving_interrupted_by_the_user");
            this.printMessage(message);
            this.fileSystem.debug(message);
            return;
        }
        this.stopButton.setText(this.g("CTL_CloseButtonLabel"));
        this.stopButton.setMnemonic(this.g("CTL_CloseButtonLabel.mnemonic").charAt(0));
        this.getRootPane().setDefaultButton(this.stopButton);
        message = cancel ? this.g("MSG_Recursive_retrieving_canceled") : (this.success ? this.g("MSG_Subtree_successfully_retrieved") : this.g("MSG_Recursive_retrieving_failed"));
        this.printMessage(message);
        this.fileSystem.debug(message);
    }

    String g(String s) {
        return NbBundle.getBundle((String)"org.netbeans.modules.vcscore.Bundle").getString(s);
    }

    String g(String s, Object obj) {
        return MessageFormat.format(this.g(s), obj);
    }

    String g(String s, Object obj1, Object obj2) {
        return MessageFormat.format(this.g(s), obj1, obj2);
    }

    String g(String s, Object obj1, Object obj2, Object obj3) {
        return MessageFormat.format(this.g(s), obj1, obj2, obj3);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

