/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.ErrorManager;

public class Variables {
    private static final Debug E;
    private static final Debug D;
    public static final String FILE = "FILE";
    public static final String QFILE = "QFILE";
    public static final String FILES = "FILES";
    public static final String QFILES = "QFILES";
    public static final String DIR = "DIR";
    public static final String PATH = "PATH";
    public static final String QPATH = "QPATH";
    public static final String PATHS = "PATHS";
    public static final String QPATHS = "QPATHS";
    public static final String MPATHS = "MPATHS";
    public static final String QMPATHS = "QMPATHS";
    public static final String MIMETYPE = "MIMETYPE";
    public static final String NUM_FILES = "NUM_FILES";
    public static final String NUM_IMPORTANT_FILES = "NUM_IMPORTANT_FILES";
    public static final String FILE_IS_FOLDER = "FILE_IS_FOLDER";
    public static final String FILES_IS_FOLDER = "FILES_IS_FOLDER";
    public static final String MULTIPLE_FILES = "MULTIPLE_FILES";
    public static final String TEMPORARY_FILE = "TEMPORARY_FILE";
    public static final String SHOW_DEAD_FILES = "SHOW_DEAD_FILES";
    public static final String MSG_PROMPT_FOR_AUTO_EDIT = "MSG_PROMPT_FOR_AUTO_EDIT";
    public static final String MSG_PROMPT_FOR_AUTO_LOCK = "MSG_PROMPT_FOR_AUTO_LOCK";
    public static final String MAX_CMD_LENGTH = "MAX_CMD_LENGTH";
    private static final String SUBSTRACT = "-";
    private static final String REPLACE = "_";
    private static Collection contextVariablesNames;

    private Variables() {
    }

    public static synchronized Collection getContextVariablesNames() {
        if (contextVariablesNames == null) {
            contextVariablesNames = Variables.createContextVariablesNames();
        }
        return contextVariablesNames;
    }

    private static Collection createContextVariablesNames() {
        HashSet<String> varNames = new HashSet<String>();
        varNames.addAll(Arrays.asList(FILE, QFILE, FILES, QFILES, DIR, PATH, QPATH, PATHS, QPATHS, MPATHS, QMPATHS, MIMETYPE, NUM_FILES, NUM_IMPORTANT_FILES, FILE_IS_FOLDER, FILES_IS_FOLDER, MULTIPLE_FILES));
        return Collections.unmodifiableSet(varNames);
    }

    public static String expand(Hashtable tab, String cmd, boolean warnUndefVars) {
        StringBuffer result = new StringBuffer();
        int begin = 0;
        do {
            int end;
            if ((end = cmd.indexOf("$", begin)) < 0) {
                result.append(cmd.substring(begin, cmd.length()));
                break;
            }
            boolean var = false;
            boolean cond = false;
            boolean escape = false;
            if (end > 0 && (escape = cmd.charAt(end - 1) == '\\') || end == cmd.length() - 1 || !(var = cmd.charAt(end + 1) == '{') && !(cond = cmd.charAt(end + 1) == '[')) {
                if (escape && end < cmd.length() - 1 && (cmd.charAt(end + 1) == '{' || cmd.charAt(end + 1) == '[')) {
                    result.append(cmd.substring(begin, end - 1));
                    result.append('$');
                } else {
                    result.append(cmd.substring(begin, end + 1));
                }
                begin = end + 1;
                continue;
            }
            result.append(cmd.substring(begin, end));
            begin = end + 2;
            if (var) {
                end = VcsUtilities.getPairIndex(cmd, begin, '{', '}');
                if (end < 0) {
                    ErrorManager.getDefault().notify(16, (Throwable)new IOException("Missing closing bracket '}'. Corresponding opening bracket '{' is at pos = " + (begin - 1)));
                    result.append("${");
                    continue;
                }
                String expansion = Variables.expandVariable(tab, cmd.substring(begin, end), warnUndefVars);
                if (expansion == null) {
                    if (warnUndefVars) {
                        ErrorManager.getDefault().notify(16, (Throwable)new IOException("Variable undefined '" + cmd.substring(begin, end) + "'. Expanding it to an empty string."));
                    }
                } else {
                    result.append(expansion);
                }
                begin = end + 1;
                continue;
            }
            if (!cond) continue;
            int[] expandEnd = new int[1];
            String expansion = Variables.expandConditional(tab, cmd.substring(begin - 2), warnUndefVars, expandEnd);
            if (expandEnd[0] < 0) {
                result.append("$[");
                continue;
            }
            result.append(expansion);
            begin += expandEnd[0] - 1;
        } while (begin < cmd.length());
        return result.toString();
    }

    public static String expandVariable(Hashtable tab, String name, boolean warnUndefVars) {
        int r;
        String value = (String)tab.get(name);
        char replC1 = '\uffff';
        char replC2 = '\uffff';
        if (value == null && (r = name.lastIndexOf(REPLACE)) > 0 && name.length() == r + 3 && (value = (String)tab.get(name.substring(0, r))) != null) {
            replC1 = name.charAt(r + 1);
            replC2 = name.charAt(r + 2);
        }
        if (value == null) {
            int substr;
            int begin = 0;
            while ((substr = name.indexOf(SUBSTRACT, begin)) > 0) {
                String svalue;
                String var = name.substring(begin, r);
                if (var != null) {
                    var = var.trim();
                }
                if ((svalue = Variables.expandVariable(tab, var, warnUndefVars)) == null) {
                    return null;
                }
                value = begin == 0 ? svalue : Variables.substractVariables(value, svalue);
                begin = r + SUBSTRACT.length();
            }
            if (begin == 0) {
                value = (String)tab.get(name);
            } else {
                String svalue = Variables.expandVariable(tab, name.substring(begin).trim(), warnUndefVars);
                if (svalue == null) {
                    return null;
                }
                value = Variables.substractVariables(value, svalue);
            }
        } else {
            value = Variables.expand(tab, value, warnUndefVars);
        }
        if (replC1 != '\uffff' && value != null) {
            value = value.replace(replC1, replC2);
        }
        return value;
    }

    private static String substractVariables(String value1, String value2) {
        if (value2 == null || value2.length() == 0) {
            return value1;
        }
        int index = value1.lastIndexOf(value2);
        if (index < 0) {
            return value1;
        }
        return value1.substring(0, index);
    }

    private static String expandConditional(Hashtable tab, String cmd, boolean warnUndefVars, int[] expandEnd) {
        int firstBegin;
        expandEnd[0] = -1;
        if (!cmd.startsWith("$[?")) {
            return null;
        }
        int begin = 3;
        int end = VcsUtilities.getPairIndex(cmd, begin, '[', ']');
        if (end < 0) {
            ErrorManager.getDefault().notify(16, (Throwable)new IOException("Missing closing bracket ']'. Corresponding opening bracket '[' is at pos = " + (begin - 1)));
            return null;
        }
        String var = cmd.substring(begin, end).trim();
        String value = Variables.expandVariable(tab, var, warnUndefVars);
        if (value == null && warnUndefVars) {
            ErrorManager.getDefault().notify(16, (Throwable)new IOException("Variable undefined '" + var + "'. Expanding it to an empty string."));
        }
        if ((firstBegin = cmd.indexOf("[", end + 1)) < 0) {
            return null;
        }
        int firstEnd = VcsUtilities.getPairIndex(cmd, firstBegin + 1, '[', ']');
        if (firstEnd < 0) {
            return null;
        }
        String first = cmd.substring(firstBegin + 1, firstEnd);
        int secondBegin = cmd.indexOf("[", firstEnd);
        if (secondBegin < 0) {
            return null;
        }
        int secondEnd = VcsUtilities.getPairIndex(cmd, secondBegin + 1, '[', ']');
        if (secondEnd < 0) {
            return null;
        }
        String second = cmd.substring(secondBegin + 1, secondEnd);
        expandEnd[0] = secondEnd;
        String result = value == null || value.length() == 0 ? second : first;
        return Variables.expand(tab, result, warnUndefVars);
    }

    public static String expandFast(Hashtable tab, String cmd, boolean warnUndefVars) {
        D.deb("expandFast (" + cmd + ")");
        String cmd_cond = "";
        boolean expanded = false;
        cmd_cond = Variables.expandConditional(tab, cmd, warnUndefVars);
        cmd = Variables.expandOnce(tab, cmd_cond, warnUndefVars);
        D.deb("after expansion (" + cmd + ")");
        return VcsUtilities.replaceBackslashDollars(cmd);
    }

    public static String expandConditional(Hashtable tab, String cmd, boolean warnUndefVars) {
        int index = 0;
        int size = cmd.length();
        int begin = 0;
        int end = 0;
        boolean nextBegin = false;
        StringBuffer result = new StringBuffer(size + 20);
        while (true) {
            int firstBegin;
            if ((begin = cmd.indexOf("$[?", index)) < 0) {
                result.append(cmd.substring(index));
                break;
            }
            result.append(cmd.substring(index, begin));
            int fake = cmd.indexOf("\\$[?", index);
            if (fake >= 0 && fake + 1 == begin) {
                index = begin + 1;
                result.append('$');
                continue;
            }
            end = VcsUtilities.getPairIndex(cmd, begin + 3, '[', ']');
            if (end < 0) {
                index = begin + 1;
                continue;
            }
            String var = cmd.substring(begin + 3, end).trim();
            String value = Variables.getVarValue(tab, var);
            if (value == null) {
                if (warnUndefVars) {
                    // empty if block
                }
                if (var.indexOf("$[?") >= 0) {
                    E.err("Missing closing bracket ']' ?");
                }
            }
            if ((firstBegin = cmd.indexOf("[", index = end + 1)) < 0) {
                result.append(cmd.substring(index));
                break;
            }
            fake = cmd.indexOf("\\[", index);
            if (fake >= 0 && fake + 1 == firstBegin) {
                index = firstBegin + 1;
                result.append('[');
                continue;
            }
            int firstEnd = VcsUtilities.getPairIndex(cmd, firstBegin + 1, '[', ']');
            if (firstEnd < 0) {
                index = firstBegin + 1;
                continue;
            }
            String first = cmd.substring(firstBegin + 1, firstEnd);
            index = firstEnd;
            int secondBegin = cmd.indexOf("[", index);
            if (secondBegin < 0) {
                result.append(cmd.substring(index));
                break;
            }
            fake = cmd.indexOf("\\[", index);
            if (fake >= 0 && fake + 1 == secondBegin) {
                index = secondBegin + 1;
                result.append('[');
                continue;
            }
            int secondEnd = VcsUtilities.getPairIndex(cmd, secondBegin + 1, '[', ']');
            if (secondEnd < 0) {
                index = secondBegin + 1;
                continue;
            }
            String second = cmd.substring(secondBegin + 1, secondEnd);
            index = secondEnd + 1;
            if (value == null || value.equals("")) {
                result.append(second);
                continue;
            }
            result.append(first);
        }
        return new String(result);
    }

    public static boolean needFurtherExpansion(String cmd) {
        int begin = cmd.indexOf("${");
        int fake = cmd.indexOf("\\${");
        if (begin < 0) {
            return false;
        }
        if (fake >= 0 && fake + 1 == begin) {
            return Variables.needFurtherExpansion(cmd.substring(begin + 1));
        }
        return true;
    }

    public static String expandOnce(Hashtable tab, String cmd, boolean warnUndefVars) {
        int index = 0;
        int size = cmd.length();
        int begin = 0;
        int end = 0;
        boolean nextBegin = false;
        StringBuffer result = new StringBuffer(size + 20);
        while (true) {
            if ((begin = cmd.indexOf("${", index)) < 0) break;
            result.append(cmd.substring(index, begin));
            int fake = cmd.indexOf("\\${", index);
            if (fake >= 0 && fake + 1 == begin) {
                index = begin + 1;
                result.append('$');
                continue;
            }
            end = VcsUtilities.getPairIndex(cmd, begin + 2, '{', '}');
            if (end < 0) {
                index = begin + 1;
                continue;
            }
            String var = cmd.substring(begin + 2, end);
            String value = Variables.getVarValue(tab, var);
            if (value != null) {
                result.append(value);
            } else {
                if (warnUndefVars) {
                    // empty if block
                }
                if (var.indexOf("${") >= 0) {
                    // empty if block
                }
            }
            index = end + 1;
        }
        result.append(cmd.substring(index));
        return new String(result);
    }

    public static String expandKnownOnly(Hashtable tab, String cmd) {
        int index = 0;
        int size = cmd.length();
        int begin = 0;
        int end = 0;
        boolean nextBegin = false;
        StringBuffer result = new StringBuffer(size + 20);
        while (true) {
            if ((begin = cmd.indexOf("${", index)) < 0) break;
            result.append(cmd.substring(index, begin));
            int fake = cmd.indexOf("\\${", index);
            if (fake < 0) {
                fake = -5;
            }
            if (fake + 1 == begin) {
                index = begin + 1;
                result.append('$');
                continue;
            }
            end = VcsUtilities.getPairIndex(cmd, begin + 2, '{', '}');
            if (end < 0) {
                index = begin + 1;
                continue;
            }
            String var = cmd.substring(begin + 2, end);
            String value = Variables.getVarValue(tab, var);
            if (value != null) {
                result.append(value);
            } else {
                result.append(cmd.substring(begin, end + 1));
            }
            index = end + 1;
        }
        result.append(cmd.substring(index));
        return new String(result);
    }

    private static String getReplaceVarValue(Hashtable tab, String name) {
        int r;
        if (name == null) {
            return null;
        }
        String value = (String)tab.get(name);
        if (value == null && (r = name.lastIndexOf(REPLACE)) > 0 && (value = (String)tab.get(name.substring(0, r))) != null && name.length() >= r + 3) {
            char c1 = name.charAt(r + 1);
            char c2 = name.charAt(r + 2);
            value = value.replace(c1, c2);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    private static String getVarValue(Hashtable tab, String name) {
        int begin = 0;
        String value = Variables.getReplaceVarValue(tab, name);
        if (value == null) {
            int substr;
            while ((substr = name.indexOf(SUBSTRACT, begin)) > 0) {
                String svalue;
                void var2_4;
                String var = name.substring(begin, (int)var2_4);
                if (var != null) {
                    var = var.trim();
                }
                if ((svalue = Variables.getReplaceVarValue(tab, var)) == null) {
                    return null;
                }
                value = begin == 0 ? svalue : VcsFileSystem.substractRootDir(value, svalue);
                begin = var2_4 + SUBSTRACT.length();
            }
            value = begin == 0 ? (String)tab.get(name) : VcsFileSystem.substractRootDir(value, Variables.getReplaceVarValue(tab, name.substring(begin).trim()));
        }
        return value;
    }

    static {
        D = E = new Debug("Variables", true);
        contextVariablesNames = null;
    }
}

