/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.caching.FileCacheProvider;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.UserCommandSupport;
import org.netbeans.modules.vcscore.cmdline.UserCommandTask;
import org.netbeans.modules.vcscore.cmdline.WrappingCommandTask;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandExecutorSupport;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.RegexErrorListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.util.Table;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

public class VcsAction {
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    private VcsAction() {
    }

    public static void doList(VcsFileSystem fileSystem, String path) {
        FileStatusProvider statusProvider = fileSystem.getStatusProvider();
        FileCacheProvider cache = fileSystem.getCacheProvider();
        if (statusProvider == null) {
            return;
        }
        if (cache == null || cache.isDir(path)) {
            statusProvider.refreshDir(path);
        } else {
            String dirName = VcsUtilities.getDirNamePart(path);
            statusProvider.refreshDir(dirName);
        }
    }

    public static VcsCommandExecutor[] doLock(Table files, VcsFileSystem fileSystem) {
        VcsCommand cmd = fileSystem.getCommand("LOCK");
        if (cmd != null) {
            return VcsAction.doCommand(files, cmd, null, fileSystem, null, null, null, null, false);
        }
        return null;
    }

    public static void doUnlock(Table files, VcsFileSystem fileSystem) {
        VcsCommand cmd = fileSystem.getCommand("UNLOCK");
        if (cmd != null) {
            VcsAction.doCommand(files, cmd, null, fileSystem);
        }
    }

    public static VcsCommandExecutor[] doEdit(Table files, VcsFileSystem fileSystem) {
        VcsCommand cmd = fileSystem.getCommand("EDIT");
        if (cmd != null) {
            VcsCommandExecutor[] executors = VcsAction.doCommand(files, cmd, null, fileSystem, null, null, null, null, false);
            return executors;
        }
        return null;
    }

    public static VcsCommandExecutor[] doCommand(Table files, VcsCommand cmd, Hashtable additionalVars, VcsFileSystem fileSystem) {
        return VcsAction.doCommand(files, cmd, additionalVars, fileSystem, null, null, null, null);
    }

    public static VcsCommandExecutor[] doCommand(Table files, VcsCommand cmd, Hashtable additionalVars, VcsFileSystem fileSystem, CommandOutputListener stdoutListener, CommandOutputListener stderrListener, CommandDataOutputListener stdoutDataListener, CommandDataOutputListener stderrDataListener) {
        return VcsAction.doCommand(files, cmd, additionalVars, fileSystem, stdoutListener, stderrListener, stdoutDataListener, stderrDataListener, true);
    }

    public static VcsCommandExecutor[] doCommand(Table files, VcsCommand cmd, Hashtable additionalVars, VcsFileSystem fileSystem, CommandOutputListener stdoutListener, CommandOutputListener stderrListener, CommandDataOutputListener stdoutDataListener, CommandDataOutputListener stderrDataListener, boolean saveProcessingFiles) {
        Command command;
        if (files.size() == 0) {
            return new VcsCommandExecutor[0];
        }
        if (saveProcessingFiles) {
            VcsAction.assureFilesSaved(files.values());
        }
        UserCommand ucmd = (UserCommand)cmd;
        CommandSupport cmdSupp = fileSystem.getCommandSupport(cmd.getName());
        if (cmdSupp == null || !cmd.equals(fileSystem.getCommand(cmd.getName()))) {
            cmdSupp = new UserCommandSupport(ucmd, fileSystem);
        }
        if ((command = cmdSupp.createCommand()) instanceof VcsDescribedCommand) {
            VcsDescribedCommand dcmd = (VcsDescribedCommand)command;
            if (additionalVars != null) {
                dcmd.setAdditionalVariables(additionalVars);
            }
            if (stdoutListener != null) {
                dcmd.addTextOutputListener(stdoutListener);
            }
            if (stderrListener != null) {
                dcmd.addTextErrorListener(stderrListener);
            }
            if (stdoutDataListener != null) {
                dcmd.addRegexOutputListener(new RegexDataListenerBridge(stdoutDataListener));
            }
            if (stderrDataListener != null) {
                dcmd.addRegexErrorListener(new RegexDataListenerBridge(stderrDataListener));
            }
        }
        UserCommandSupport.setCommandFilesFromTable(command, files, fileSystem);
        if (!VcsManager.getDefault().showCustomizer(command)) {
            return new VcsCommandExecutor[0];
        }
        CommandTask task = command.execute();
        if (task instanceof UserCommandTask) {
            return new VcsCommandExecutor[]{((UserCommandTask)task).getExecutor()};
        }
        if (task instanceof WrappingCommandTask) {
            UserCommandTask[] tasks = ((WrappingCommandTask)task).getTasks();
            VcsCommandExecutor[] executors = new VcsCommandExecutor[tasks.length];
            int i = 0;
            while (i < executors.length) {
                executors[i] = tasks[i].getExecutor();
                ++i;
            }
            return executors;
        }
        return new VcsCommandExecutor[0];
    }

    public static void assureFilesSaved(Collection fos) {
        LinkedList<FileObject> folders = new LinkedList<FileObject>();
        Iterator it = fos.iterator();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            if (fo == null) continue;
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException exc) {
                // empty catch block
            }
            if (fo.isFolder()) {
                folders.add(fo);
            }
            if (dobj == null || !dobj.isModified()) continue;
            Node.Cookie cake = dobj.getCookie(class$org$openide$cookies$SaveCookie == null ? VcsAction.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
            try {
                if (cake == null) continue;
                ((SaveCookie)cake).save();
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        }
        if (!folders.isEmpty()) {
            DataObject[] modified = DataObject.getRegistry().getModified();
            int i = 0;
            while (i < modified.length) {
                Set files;
                DataObject dobj = modified[i];
                SaveCookie sc = (SaveCookie)dobj.getCookie(class$org$openide$cookies$SaveCookie == null ? VcsAction.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                if (sc != null && VcsAction.isAFileInAFolder(folders, files = dobj.files())) {
                    try {
                        sc.save();
                    }
                    catch (IOException exc) {
                        ErrorManager.getDefault().notify((Throwable)exc);
                    }
                }
                ++i;
            }
        }
    }

    private static boolean isAFileInAFolder(Collection foldersCollection, Collection filesCollection) {
        boolean isIn = false;
        FileObject[] folders = foldersCollection.toArray(new FileObject[foldersCollection.size()]);
        FileObject[] files = filesCollection.toArray(new FileObject[filesCollection.size()]);
        boolean canBeIn = true;
        while (!isIn && canBeIn) {
            canBeIn = false;
            int i = 0;
            while (i < folders.length && !isIn) {
                int j = 0;
                while (j < files.length) {
                    if (files[j] != null) {
                        files[j] = files[j].getParent();
                        if (files[j] != null) {
                            if (folders[i].equals(files[j])) {
                                isIn = true;
                                break;
                            }
                            if (files[j].getPath().startsWith(folders[i].getPath())) {
                                canBeIn = true;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return isIn;
    }

    public static void addImportantFiles(Collection fos, Table res, boolean all, VcsFileSystem fileSystem) {
        VcsAction.addImportantFiles(fos, res, all, fileSystem, false);
    }

    public static void addImportantFiles(Collection fos, Table res, boolean all, VcsFileSystem fileSystem, boolean doNotTestFS) {
        Iterator it = fos.iterator();
        while (it.hasNext()) {
            Set[] scheduled;
            FileObject ff = (FileObject)it.next();
            try {
                if (ff.getFileSystem() instanceof VersioningFileSystem) {
                    res.put(ff.getPackageNameExt('/', '.'), ff);
                    continue;
                }
                if (!doNotTestFS && ff.getFileSystem() != fileSystem) {
                }
            }
            catch (FileStateInvalidException exc) {}
            continue;
            String fileName = ff.getPackageNameExt('/', '.');
            if (all || fileSystem.isImportant(fileName)) {
                res.put(fileName, ff);
            }
            if ((scheduled = (Set[])ff.getAttribute("VCS_SCHEDULED_FILES")) == null || scheduled[0] == null) continue;
            Iterator sit = scheduled[0].iterator();
            while (sit.hasNext()) {
                String name = (String)sit.next();
                res.put(name, (Object)null);
            }
        }
    }

    private static Table removeDisabled(FileStatusProvider statusProvider, Table files, VcsCommand cmd) {
        if (statusProvider == null) {
            return files;
        }
        String disabledStatus = (String)cmd.getProperty("disabledOnStatus");
        if (disabledStatus == null) {
            return files;
        }
        Table remaining = new Table();
        Enumeration enumeration = files.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String status = statusProvider.getFileStatus(name);
            boolean disabled = VcsUtilities.isSetContainedInQuotedStrings(disabledStatus, Collections.singleton(status));
            if (disabled) continue;
            remaining.put(name, files.get(name));
        }
        return remaining;
    }

    public static void performVcsCommand(VcsCommand cmd, VcsFileSystem fileSystem, Collection fileObjects, boolean isExpert) {
        VcsAction.performVcsCommand(cmd, fileSystem, fileObjects, isExpert, null);
    }

    public static void performVcsCommand(VcsCommand cmd, VcsFileSystem fileSystem, Collection fileObjects, boolean isExpert, Hashtable additionalVars) {
        boolean processAll = VcsCommandIO.getBooleanPropertyAssumeDefault(cmd, "processAllFiles") || fileSystem.isProcessUnimportantFiles();
        Table files = new Table();
        VcsAction.addImportantFiles(fileObjects, files, processAll, fileSystem, true);
        files = VcsAction.removeDisabled(fileSystem.getStatusProvider(), files, cmd);
        if ("LIST".equals(cmd.getName()) || "LIST_OFFLINE".equals(cmd.getName())) {
            ArrayList<String> paths = new ArrayList<String>();
            Iterator it = files.values().iterator();
            while (it.hasNext()) {
                String path;
                FileObject fo = (FileObject)it.next();
                if (fo == null || paths.contains(path = fo.getPackageName('/'))) continue;
                VcsAction.doList(fileSystem, path);
                paths.add(path);
            }
        } else if ("LIST_SUB".equals(cmd.getName()) || "LIST_SUB_OFFLINE".equals(cmd.getName())) {
            ArrayList<String> paths = new ArrayList<String>();
            Iterator it = files.values().iterator();
            while (it.hasNext()) {
                String path;
                FileObject fo = (FileObject)it.next();
                if (fo == null || paths.contains(path = fo.getPackageName('/'))) continue;
                CommandExecutorSupport.doRefresh(fileSystem, path, true);
                paths.add(path);
            }
        } else if (files.size() > 0) {
            if (isExpert && !fileSystem.isExpertMode()) {
                if (additionalVars == null) {
                    additionalVars = new Hashtable<String, Boolean>();
                }
                additionalVars.put("CTRL_DOWN_IN_ACTION", Boolean.TRUE);
            }
            VcsAction.doCommand(files, cmd, additionalVars, fileSystem);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RegexDataListenerBridge
    implements RegexErrorListener {
        private CommandDataOutputListener dataListener;

        public RegexDataListenerBridge(CommandDataOutputListener dataListener) {
            this.dataListener = dataListener;
        }

        public void outputMatchedGroups(String[] elements) {
            this.dataListener.outputData(elements);
        }
    }
}

