/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.beans.FeatureDescriptor;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.VcsActionSupporter;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheReference;
import org.netbeans.modules.vcscore.caching.FileCacheProvider;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.runtime.RuntimeCommandsProvider;
import org.netbeans.spi.vcs.VcsCommandsProvider;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;

public class VcsAttributes
extends DefaultAttributes {
    public static final String FILE_ATTRIBUTE = "java.io.File";
    public static final String VCS_NATIVE_FS = "VcsFileSystemAttributeIdentifier";
    public static final String VCS_NATIVE_PACKAGE_NAME_EXT = "VcsFileSystemNativeFOPath";
    private static final String VCS_COMMANDS_PROVIDER_ATTRIBUTE = "org.netbeans.spi.vcs.VcsCommandsProvider";
    public static final String RUNTIME_PROVIDER = "org.netbeans.modules.vcscore.runtime.RuntimeCommandsProvider";
    public static final String VCS_ACTION = "VCS_ACTION";
    public static final String VCS_REFRESH = "VCS_REFRESH";
    public static final String VCS_MKDIR_ACTION = "VCS_MKDIR_ACTION";
    public static final String CMD_NAME_MKDIR = "MKDIR_CMD";
    public static final String VCS_SCHEDULING_SECONDARY_FO_ACTION = "VCS_SCHEDULING_SECONDARY_FO_ACTION";
    public static final String VCS_SCHEDULING_ADD = "ADD";
    public static final String VCS_SCHEDULING_REMOVE = "REMOVE";
    public static final String VCS_SCHEDULED_FILES_ATTR = "VCS_SCHEDULED_FILES";
    public static final String VCS_SCHEDULED_FILE_ATTR = "VCS_SCHEDULED_FILE";
    public static final String VCS_SCHEDULING_MASTER_FILE_NAME_ATTR = "VCS_SCHEDULING_MASTER_FILE_NAME";
    public static final String VCS_ACTION_ADD = "VCS_ADD";
    public static final String VCS_ACTION_REMOVE = "VCS_REMOVE";
    public static final String VCS_ACTION_DONE = "VCS_ACTION_DONE";
    public static final String VCS_ACTION_DESCRIPTION = "VCS_ACTION_DESCRIPTION";
    public static String VCS_STATUS = "VCS_STATUS";
    public static String VCS_STATUS_LOCAL = "VCS_STATUS_LOCAL";
    public static String VCS_STATUS_MISSING = "VCS_STATUS_MISSING";
    public static String VCS_STATUS_UP_TO_DATE = "VCS_STATUS_UP_TO_DATE";
    public static String VCS_STATUS_UNKNOWN = "VCS_STATUS_UNKNOWN";
    private transient VcsActionSupporter supporter;
    private transient VcsCommandsProvider commandsProvider;
    private transient RuntimeCommandsProvider runtimeProvider;
    private VcsFileSystem fileSystem;
    static final long serialVersionUID = 8084585278800267078L;
    private transient Map schedulingFilesByFolders;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader;

    public VcsAttributes(AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list, VcsFileSystem fileSystem, VcsActionSupporter supp) {
        super(info, change, list);
        this.fileSystem = fileSystem;
        this.supporter = supp;
        this.commandsProvider = fileSystem.getCommandsProvider();
    }

    public VcsActionSupporter getCurrentSupporter() {
        return this.supporter;
    }

    public void setCurrentSupporter(VcsActionSupporter supporter) {
        this.supporter = supporter;
    }

    public VcsCommandsProvider getCommandsProvider() {
        return this.commandsProvider;
    }

    public void setCommandsProvider(VcsCommandsProvider commandsProvider) {
        this.commandsProvider = commandsProvider;
    }

    public RuntimeCommandsProvider getRuntimeCommandsProvider() {
        return this.runtimeProvider;
    }

    public void setRuntimeCommandsProvider(RuntimeCommandsProvider provider) {
        this.runtimeProvider = provider;
    }

    public Object readAttribute(String name, String attrName) {
        CacheReference ref;
        if (FILE_ATTRIBUTE.equals(attrName)) {
            File file = this.fileSystem.getFile(name);
            if (!file.isAbsolute()) {
                return null;
            }
            return file;
        }
        if (RUNTIME_PROVIDER.equals(attrName)) {
            return this.runtimeProvider;
        }
        if (VCS_STATUS.equals(attrName)) {
            if (!this.fileSystem.getFile(name).exists()) {
                return VCS_STATUS_MISSING;
            }
            FileStatusProvider statusProvider = this.fileSystem.getStatusProvider();
            if (statusProvider != null) {
                String status = statusProvider.getFileStatus(name);
                if (statusProvider.getLocalFileStatus().equals(status)) {
                    return VCS_STATUS_LOCAL;
                }
                return VCS_STATUS_UP_TO_DATE;
            }
            return VCS_STATUS_UNKNOWN;
        }
        if ("VcsActionAttributeCookie".equals(attrName)) {
            return this.supporter;
        }
        if (VCS_NATIVE_FS.equals(attrName)) {
            return this.fileSystem;
        }
        if (VCS_NATIVE_PACKAGE_NAME_EXT.equals(attrName)) {
            return name;
        }
        if (VCS_COMMANDS_PROVIDER_ATTRIBUTE.equals(attrName)) {
            return this.commandsProvider;
        }
        if ("org.netbeans.modules.vcscore.search.VcsSearchTypeFileSystem".equals(attrName)) {
            return this.fileSystem;
        }
        if ("FS_DISPLAY_NAME".equals(attrName)) {
            return this.fileSystem.getVariablesAsHashtable().get("FS_DISPLAY_NAME");
        }
        if ("NetBeansAttrAssignedLoader".equals(attrName)) {
            CacheReference ref2 = this.fileSystem.getCacheReference(name);
            if (ref2 != null && ref2.isVirtual()) {
                return (class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader == null ? (class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader = VcsAttributes.class$("org.netbeans.modules.vcscore.util.virtuals.VirtualsDataLoader")) : class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader).getName();
            }
        } else if ("NetBeansAttrAssignedLoaderModule".equals(attrName) && (ref = this.fileSystem.getCacheReference(name)) != null && ref.isVirtual()) {
            return "org.netbeans.modules.vcscore";
        }
        return super.readAttribute(name, attrName);
    }

    public void writeAttribute(final String name, String attrName, final Object value) throws IOException, UnknownServiceException {
        if (VCS_ACTION.equals(attrName) && value instanceof FeatureDescriptor) {
            this.performVcsAction(name, (FeatureDescriptor)value);
        } else if (VCS_REFRESH.equals(attrName)) {
            this.performRefresh(name, value);
        } else if (VCS_MKDIR_ACTION.equals(attrName)) {
            if (value instanceof String) {
                this.performMkDirAction(name, (String)value);
            }
        } else if (VCS_SCHEDULING_SECONDARY_FO_ACTION.equals(attrName) && value instanceof String) {
            FileObject primary;
            final FileObject fo = this.fileSystem.findFileObject(name);
            if (fo == null) {
                return;
            }
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                primary = dobj.getPrimaryFile();
                if (primary.equals(fo)) {
                    return;
                }
            }
            catch (DataObjectNotFoundException exc) {
                exc.printStackTrace();
                return;
            }
            this.startFileScheduling(name);
            final FileObject primaryFO = primary;
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    VcsAttributes.this.scheduleSecondaryFOVcsAction(name, (String)value, fo, primaryFO);
                }
            });
            super.writeAttribute(name, VCS_SCHEDULED_FILE_ATTR, value);
        } else {
            if ("NetBeansAttrAssignedLoader".equals(attrName)) {
                if (value == null) {
                    CacheReference ref = this.fileSystem.getCacheReference(name);
                    if (ref != null) {
                        ref.setVirtual(false);
                        try {
                            DataObject.find((FileObject)this.fileSystem.findFileObject(name)).setValid(false);
                        }
                        catch (PropertyVetoException pve) {}
                    }
                } else if ((class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader == null ? (class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader = VcsAttributes.class$("org.netbeans.modules.vcscore.util.virtuals.VirtualsDataLoader")) : class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader).getName().equals(value)) {
                    CacheReference ref = this.fileSystem.getCacheReference(name);
                    if (ref != null) {
                        ref.setVirtual(true);
                    }
                    return;
                }
            }
            if ("NetBeansAttrAssignedLoaderModule".equals(attrName) && value != null && "org.netbeans.modules.vcscore".equals(value.toString()) && this.fileSystem.checkVirtual(name)) {
                return;
            }
            super.writeAttribute(name, attrName, value);
        }
    }

    private void performVcsAction(String name, final FeatureDescriptor descriptor) throws UnknownServiceException {
        String cmdName = descriptor.getName();
        CommandSupport cmdSupport = this.fileSystem.getCommandSupport(cmdName);
        if (cmdSupport == null) {
            throw new UnknownServiceException(cmdName);
        }
        final Command cmd = cmdSupport.createCommand();
        FileObject[] files = new FileObject[]{this.fileSystem.findResource(name)};
        cmd.setFiles(files);
        Hashtable<String, Object> additionalVars = new Hashtable<String, Object>();
        Enumeration<String> varNames = descriptor.attributeNames();
        while (varNames.hasMoreElements()) {
            String varName = varNames.nextElement();
            additionalVars.put(varName, descriptor.getValue(varName));
        }
        if (cmd instanceof VcsDescribedCommand) {
            ((VcsDescribedCommand)cmd).setAdditionalVariables(additionalVars);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CommandTask task = cmd.execute();
                task.waitFinished();
                boolean status = task.getExitStatus() == 0;
                descriptor.setValue(VcsAttributes.VCS_ACTION_DONE, new Boolean(status));
            }
        });
    }

    private void performRefresh(final String name, final Object recursive) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                boolean rec = Boolean.TRUE.equals(recursive);
                FileCacheProvider cache = VcsAttributes.this.fileSystem.getCacheProvider();
                if (cache != null) {
                    if (rec) {
                        cache.refreshCacheDirRecursive(name);
                    } else {
                        cache.refreshCacheDir(name);
                    }
                }
            }
        });
    }

    private void performMkDirAction(String name, String dir) throws UnknownServiceException {
        CommandSupport cmdSupport = this.fileSystem.getCommandSupport(CMD_NAME_MKDIR);
        if (cmdSupport == null) {
            throw new UnknownServiceException(CMD_NAME_MKDIR);
        }
        Command cmd = cmdSupport.createCommand();
        if (!(cmd instanceof VcsDescribedCommand)) {
            throw new UnknownServiceException(CMD_NAME_MKDIR);
        }
        VcsDescribedCommand vcscmd = (VcsDescribedCommand)cmd;
        File file = this.fileSystem.getFile(name);
        file = new File(file, dir);
        vcscmd.setDiskFiles(new File[]{file});
        boolean success = VcsManager.getDefault().showCustomizer(vcscmd);
        if (success) {
            CommandTask task = vcscmd.execute();
            try {
                task.waitFinished(0);
            }
            catch (InterruptedException iex) {
                // empty catch block
            }
        }
    }

    private boolean scheduleSecondaryFOVcsAction(final String name, String actionName, FileObject fo, FileObject primary) {
        int id;
        if (VCS_STATUS_LOCAL.equals(primary.getAttribute(VCS_STATUS))) {
            this.endFileScheduling(name);
            return false;
        }
        FeatureDescriptor descriptor = new FeatureDescriptor(){

            public void setValue(String attrName, Object value) {
                if (VcsAttributes.VCS_ACTION_DONE.equals(attrName)) {
                    VcsAttributes.this.fileSystem.removeScheduledFileToBeProcessed(name);
                    VcsAttributes.this.endFileScheduling(name);
                }
                super.setValue(attrName, value);
            }
        };
        boolean endOfScheduling = false;
        if (VCS_SCHEDULING_ADD.equals(actionName)) {
            descriptor.setName("SCHEDULE_ADD");
            try {
                this.fileSystem.addScheduledFileToBeProcessed(name);
                this.performVcsAction(name, descriptor);
            }
            catch (UnknownServiceException unsExc) {
                this.fileSystem.removeScheduledFileToBeProcessed(name);
                endOfScheduling = true;
            }
            id = 1;
        } else if (VCS_SCHEDULING_REMOVE.equals(actionName)) {
            descriptor.setName("SCHEDULE_REMOVE");
            try {
                this.fileSystem.addScheduledFileToBeProcessed(name);
                this.performVcsAction(name, descriptor);
            }
            catch (UnknownServiceException unsExc) {
                this.fileSystem.removeScheduledFileToBeProcessed(name);
                endOfScheduling = true;
            }
            id = 0;
        } else {
            this.endFileScheduling(name);
            return false;
        }
        Set[] scheduled = (Set[])primary.getAttribute(VCS_SCHEDULED_FILES_ATTR);
        if (scheduled == null) {
            scheduled = new HashSet[2];
        }
        if (scheduled[id] == null) {
            scheduled[id] = new HashSet();
        }
        scheduled[id].add(name);
        try {
            primary.setAttribute(VCS_SCHEDULED_FILES_ATTR, (Object)scheduled);
            File file = FileUtil.toFile((FileObject)primary);
            if (file != null) {
                primary.setAttribute(VCS_SCHEDULING_MASTER_FILE_NAME_ATTR, (Object)file.getAbsolutePath());
            }
        }
        catch (IOException ioExc) {
            if (endOfScheduling) {
                this.endFileScheduling(name);
            }
            return false;
        }
        if (endOfScheduling) {
            this.endFileScheduling(name);
        }
        return true;
    }

    private void startFileScheduling(String name) {
        VcsAttributes vcsAttributes = this;
        synchronized (vcsAttributes) {
            int index;
            String dir;
            if (this.schedulingFilesByFolders == null) {
                this.schedulingFilesByFolders = new HashMap();
            }
            String string = dir = (index = name.lastIndexOf(47)) < 0 ? "" : name.substring(0, index);
            String file = index < 0 ? name : (index < name.length() - 1 ? name.substring(index + 1) : "");
            HashSet<String> files = (HashSet<String>)this.schedulingFilesByFolders.get(dir);
            if (files == null) {
                files = new HashSet<String>();
            }
            files.add(file);
            this.schedulingFilesByFolders.put(dir, files);
        }
    }

    private void endFileScheduling(String name) {
        Set files;
        String dir;
        VcsAttributes vcsAttributes = this;
        synchronized (vcsAttributes) {
            int index;
            if (this.schedulingFilesByFolders == null) {
                this.schedulingFilesByFolders = new HashMap();
            }
            String string = dir = (index = name.lastIndexOf(47)) < 0 ? "" : name.substring(0, index);
            String file = index < 0 ? name : (index < name.length() - 1 ? name.substring(index + 1) : "");
            files = (Set)this.schedulingFilesByFolders.get(dir);
            if (files != null) {
                files.remove(file);
                if (files.size() == 0) {
                    files = null;
                }
            }
            if (files == null) {
                this.schedulingFilesByFolders.remove(dir);
            }
        }
        if (files == null) {
            this.performRefresh(dir, Boolean.FALSE);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

