/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.util.Vector;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;

public class VcsDirContainer {
    private Debug D = new Debug("VcsDirContainer", true);
    private Vector subdirs = new Vector();
    private Object element = null;
    private String path = "";
    private String name = "";

    public VcsDirContainer() {
    }

    public VcsDirContainer(String path) {
        this.path = path;
        this.name = VcsUtilities.getFileNamePart(path);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        this.name = VcsUtilities.getFileNamePart(path);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setElement(Object element) {
        this.element = element;
    }

    public Object getElement() {
        return this.element;
    }

    public VcsDirContainer getSubdir(String path) {
        int subdirsLen = this.subdirs.size();
        VcsDirContainer subdir = null;
        int i = 0;
        while (i < subdirsLen) {
            VcsDirContainer dir = (VcsDirContainer)this.subdirs.elementAt(i);
            if (path.equals(dir.getPath())) {
                subdir = dir;
            }
            ++i;
        }
        return subdir;
    }

    public VcsDirContainer[] getSubdirContainers() {
        int subdirsLen = this.subdirs.size();
        VcsDirContainer[] subDirs = new VcsDirContainer[subdirsLen];
        int i = 0;
        while (i < subdirsLen) {
            subDirs[i] = (VcsDirContainer)this.subdirs.elementAt(i);
            ++i;
        }
        return subDirs;
    }

    public VcsDirContainer addSubdir(String path) {
        VcsDirContainer dir = this.getSubdir(path);
        if (dir == null) {
            dir = new VcsDirContainer(path);
            this.subdirs.addElement(dir);
        }
        return dir;
    }

    public VcsDirContainer addSubdirRecursive(String path) {
        int index;
        if (this.path.equals(path)) {
            return this;
        }
        if (this.path.length() > 0) {
            index = path.indexOf(this.path);
            if (index < 0) {
                this.D.deb("addSubdirRecursive(" + path + "): indexOf(" + this.path + ") = " + index + " => RETURN null !!!");
                return null;
            }
            index += this.path.length() + 1;
        } else {
            index = 0;
        }
        int index2 = path.indexOf(47, index);
        if (index2 < 0) {
            index2 = path.length();
        }
        if (index2 < index) {
            return this;
        }
        String next = path.substring(index, index2);
        String subPath = this.path.length() > 0 ? this.path + "/" + next : next;
        VcsDirContainer subdir = this.getDirContainer(next);
        if (subdir == null) {
            this.D.deb("addSubdirRecursive(" + path + "): creating subdir " + subPath + " under " + this.path);
            subdir = this.addSubdir(subPath);
        } else {
            this.D.deb("addSubdirRecursive(" + path + "): exist subdir " + subPath + " under " + this.path);
        }
        return subdir.addSubdirRecursive(path);
    }

    public String[] getSubdirs() {
        int subdirsLen = this.subdirs.size();
        String[] res = new String[subdirsLen];
        int i = 0;
        while (i < subdirsLen) {
            VcsDirContainer dir = (VcsDirContainer)this.subdirs.elementAt(i);
            res[i] = dir.getName();
            ++i;
        }
        return res;
    }

    public VcsDirContainer getDirContainer(String name) {
        VcsDirContainer dir = null;
        int i = 0;
        while (i < this.subdirs.size()) {
            dir = (VcsDirContainer)this.subdirs.elementAt(i);
            if (dir.getName().equals(name)) {
                return dir;
            }
            ++i;
        }
        return null;
    }

    public VcsDirContainer getContainerWithPath(String path) {
        int indexSep;
        this.D.deb("getContainerWithPath(" + path + ")");
        VcsDirContainer container = this;
        if (path.length() == 0) {
            return container;
        }
        String rootPath = container.getPath();
        if (rootPath.length() > 0 && path.indexOf(rootPath) < 0) {
            return null;
        }
        if (path.length() > 0 && path.equals(rootPath)) {
            return this;
        }
        this.D.deb("getContainerWithPath: rootPath = '" + rootPath + "'");
        int index = rootPath.length();
        if (index > 0) {
            ++index;
        }
        if ((indexSep = path.indexOf(47, index)) < 0) {
            indexSep = path.length();
        }
        while (indexSep >= 0 && container != null) {
            String name = path.substring(index, indexSep);
            container = container.getDirContainer(name);
            index = indexSep + 1;
            if (index >= path.length()) {
                indexSep = -1;
                continue;
            }
            indexSep = path.indexOf(47, index);
            if (indexSep >= 0) continue;
            indexSep = path.length();
        }
        this.D.deb("getContainerWithPath(" + path + ") returning " + (container == null ? null : container.getPath()));
        return container;
    }

    public VcsDirContainer getParent(String path) {
        String parentPath = VcsUtilities.getDirNamePart(path);
        VcsDirContainer container = this.getContainerWithPath(parentPath);
        this.D.deb("getParent(" + path + ") returning " + (container == null ? null : container.getPath()));
        return container;
    }
}

