/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.vcscore.VcsAction;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.cmdline.UserCommandSupport;
import org.netbeans.modules.vcscore.commands.CommandsTree;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.util.Table;
import org.netbeans.modules.vcscore.util.WeakList;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.awt.Actions;
import org.openide.awt.JInlineMenu;
import org.openide.awt.JMenuPlus;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class VcsRevisionAction
extends NodeAction
implements ActionListener {
    protected WeakReference fileSystem = new WeakReference<Object>(null);
    protected WeakReference fileObject = new WeakReference<Object>(null);
    protected Collection selectedRevisionItems = null;
    private static final long serialVersionUID = 8803248742536265293L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsRevisionAction;

    public void setFileSystem(VcsFileSystem fileSystem) {
        this.fileSystem = new WeakReference<VcsFileSystem>(fileSystem);
    }

    public void setFileObject(FileObject fileObject) {
        this.fileObject = new WeakReference<FileObject>(fileObject);
    }

    public void setSelectedRevisionItems(Collection items) {
        if (items == null) {
            this.selectedRevisionItems = null;
            return;
        }
        this.selectedRevisionItems = new WeakList(items);
    }

    public String getName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$VcsRevisionAction == null ? (class$org$netbeans$modules$vcscore$VcsRevisionAction = VcsRevisionAction.class$("org.netbeans.modules.vcscore.VcsRevisionAction")) : class$org$netbeans$modules$vcscore$VcsRevisionAction), (String)"CTL_Revision_Action");
    }

    public void performAction(Node[] nodes) {
    }

    public boolean enable(Node[] nodes) {
        return nodes.length > 0;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$vcscore$VcsRevisionAction == null ? (class$org$netbeans$modules$vcscore$VcsRevisionAction = VcsRevisionAction.class$("org.netbeans.modules.vcscore.VcsRevisionAction")) : class$org$netbeans$modules$vcscore$VcsRevisionAction);
    }

    protected JMenuItem createItem(VcsCommand cmd) {
        JMenuItem item = null;
        item = new JMenuItem();
        Actions.setMenuText((AbstractButton)item, (String)cmd.getDisplayName(), (boolean)false);
        String[] props = cmd.getPropertyNames();
        if (props != null && props.length > 0) {
            item.setActionCommand(cmd.getName());
            item.addActionListener(this);
        }
        return item;
    }

    private void addMenu(CommandsTree commands, JMenu parent, int numSelected) {
        CommandsTree[] subCommands = commands.children();
        int i = 0;
        while (i < subCommands.length) {
            CommandSupport cmdSupp = subCommands[i].getCommandSupport();
            if (cmdSupp instanceof UserCommandSupport) {
                UserCommand cmd = ((UserCommandSupport)cmdSupp).getVcsCommand();
                if (cmd == null) {
                    parent.addSeparator();
                } else {
                    int numRev = VcsCommandIO.getIntegerPropertyAssumeZero(cmd, "numRevisions");
                    if (numRev == numSelected && !VcsCommandIO.getBooleanPropertyAssumeDefault(cmd, "hidden") && cmd.getDisplayName() != null) {
                        if (subCommands[i].hasChildren()) {
                            String[] props = cmd.getPropertyNames();
                            JMenuPlus submenu = new JMenuPlus();
                            Actions.setMenuText((AbstractButton)submenu, (String)cmd.getDisplayName(), (boolean)false);
                            this.addMenu(subCommands[i], (JMenu)submenu, numSelected);
                            parent.add((JMenuItem)submenu);
                        } else {
                            JMenuItem item = this.createItem(cmd);
                            parent.add(item);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public JMenuItem getPopupPresenter() {
        JInlineMenu inlineMenu = new JInlineMenu();
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        VcsFileSystem fileSystem = (VcsFileSystem)this.fileSystem.get();
        if (fileSystem == null) {
            return null;
        }
        CommandsTree commands = fileSystem.getCommands();
        CommandsTree[] commandRoots = commands.children();
        int numRevisions = this.selectedRevisionItems.size();
        int i = 0;
        while (i < commandRoots.length) {
            JMenuItem menuItem;
            UserCommand cmd;
            CommandSupport cmdSupp = commandRoots[i].getCommandSupport();
            if (cmdSupp instanceof UserCommandSupport && (cmd = ((UserCommandSupport)cmdSupp).getVcsCommand()) != null && VcsCommandIO.getIntegerPropertyAssumeZero(cmd, "numRevisions") == numRevisions && !VcsCommandIO.getBooleanPropertyAssumeDefault(cmd, "hidden") && cmd.getDisplayName() != null && (menuItem = this.getPopupPresenter(commandRoots[i], cmd, numRevisions)) != null) {
                menuItems.add(menuItem);
            }
            ++i;
        }
        inlineMenu.setMenuItems(menuItems.toArray(new JMenuItem[menuItems.size()]));
        return inlineMenu;
    }

    private JMenuItem getPopupPresenter(CommandsTree commandRoot, VcsCommand cmd, int numSelected) {
        Object menu = new JMenuPlus();
        Actions.setMenuText((AbstractButton)menu, (String)commandRoot.getCommandSupport().getDisplayName(), (boolean)false);
        this.addMenu(commandRoot, (JMenu)menu, numSelected);
        if (menu.getSubElements().length == 0) {
            menu = this.createItem(cmd);
        }
        return menu;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        VcsFileSystem fileSystem = (VcsFileSystem)this.fileSystem.get();
        FileObject fo = (FileObject)this.fileObject.get();
        if (fileSystem == null || fo == null) {
            return;
        }
        RevisionItem[] items = this.selectedRevisionItems.toArray(new RevisionItem[0]);
        Table files = new Table();
        String mimeType = fo.getMIMEType();
        String fileName = fo.getPackageNameExt('/', '.');
        files.put(fileName, fo);
        Hashtable<String, String> additionalVars = new Hashtable<String, String>();
        if (mimeType != null) {
            additionalVars.put("MIMETYPE", mimeType);
        }
        if (items.length > 0) {
            additionalVars.put("REVISION", items[0].getRevisionVCS());
        }
        int i = 0;
        while (i < items.length) {
            additionalVars.put("REVISION" + (i + 1), items[i].getRevisionVCS());
            ++i;
        }
        additionalVars.put("BRANCH", this.getBranch(items));
        VcsAction.doCommand(files, fileSystem.getCommand(cmd), additionalVars, fileSystem);
    }

    private String getBranch(RevisionItem[] items) {
        String branchTag = "";
        int i = 0;
        while (i < items.length) {
            String[] tags;
            if (items[0] != null && items[0].isBranch() && (tags = items[0].getTagNames()).length > 0) {
                branchTag = tags[0];
            }
            ++i;
        }
        return branchTag;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

