/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.lang.ref.Reference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.VcsRevisionAction;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;
import org.netbeans.modules.vcscore.caching.FileCacheProvider;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.commands.RegexOutputCommand;
import org.netbeans.modules.vcscore.commands.RegexOutputListener;
import org.netbeans.modules.vcscore.commands.TextOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.versioning.RevisionEvent;
import org.netbeans.modules.vcscore.versioning.RevisionItem;
import org.netbeans.modules.vcscore.versioning.RevisionList;
import org.netbeans.modules.vcscore.versioning.RevisionListener;
import org.netbeans.modules.vcscore.versioning.VcsFileStatusEvent;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

class VcsVersioningSystem
extends VersioningFileSystem
implements CacheHandlerListener {
    private VcsFileSystem fileSystem;
    private VersioningFileSystem.Versions versions;
    private Hashtable revisionListsByName;
    private boolean showMessages = true;
    private boolean showUnimportantFiles = false;
    private boolean showLocalFiles = true;
    private String ignoredGarbageFiles = "";
    private transient RE ignoredGarbageRE = null;
    private int messageLength = 50;
    private transient FSPropertyChangeListener propListener;
    public static final String PROP_SHOW_DEAD_FILES = "showDeadFiles";
    public static final String PROP_SHOW_MESSAGES = "showMessages";
    public static final String PROP_MESSAGE_LENGTH = "messageLength";
    public static final String PROP_SHOW_UNIMPORTANT_FILES = "showUnimportantFiles";
    public static final String PROP_SHOW_LOCAL_FILES = "showLocalFiles";
    public static final String PROP_IGNORED_GARBAGE_FILES = "ignoredGarbageFiles";
    private static final long serialVersionUID = 6349205836150345436L;
    private static Object vsActionAccessLock = new Object();
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsRevisionAction;

    public VcsVersioningSystem(VcsFileSystem fileSystem) {
        super(fileSystem);
        this.fileSystem = fileSystem;
        try {
            this.setSystemName(fileSystem.getSystemName());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.list = new VersioningList();
        this.info = fileSystem.getVcsInfo();
        this.change = new VersioningFileSystem.VersioningFSChange(this);
        this.attr = new VcsVersioningAttrs();
        this.versions = new VersioningVersions();
        this.revisionListsByName = new Hashtable();
        this.initListeners();
        this.setCapability(null);
    }

    public void addNotify() {
        this.propagatePropertyChange(new String[]{PROP_IGNORED_GARBAGE_FILES, PROP_SHOW_MESSAGES, PROP_MESSAGE_LENGTH, PROP_SHOW_LOCAL_FILES, PROP_SHOW_UNIMPORTANT_FILES, PROP_SHOW_DEAD_FILES});
    }

    private void initListeners() {
        this.propListener = new FSPropertyChangeListener();
        this.fileSystem.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.propListener, (Object)this.fileSystem));
        this.addPropertyChangeListener(this.propListener);
    }

    protected Reference createReference(FileObject fo) {
        FileCacheProvider cache = this.fileSystem.getCacheProvider();
        Reference ref = cache != null ? cache.createReference(fo) : super.createReference(fo);
        return ref;
    }

    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public VersioningFileSystem.Versions getVersions() {
        return this.versions;
    }

    public FileSystem.Status getStatus() {
        return this.fileSystem.getStatus();
    }

    public FileStatusProvider getFileStatusProvider() {
        return this.fileSystem.getStatusProvider();
    }

    public String[] getStates(DataObject dobj) {
        return this.fileSystem.getStates(dobj);
    }

    public boolean isShowDeadFiles() {
        return this.fileSystem.isShowDeadFiles();
    }

    public void setShowDeadFiles(boolean showDeadFiles) {
        this.fileSystem.setShowDeadFiles(showDeadFiles);
        this.firePropertyChange(PROP_SHOW_DEAD_FILES, !showDeadFiles ? Boolean.TRUE : Boolean.FALSE, showDeadFiles ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isShowUnimportantFiles() {
        return this.showUnimportantFiles;
    }

    public void setShowUnimportantFiles(boolean showUnimportantFiles) {
        if (this.showUnimportantFiles != showUnimportantFiles) {
            this.showUnimportantFiles = showUnimportantFiles;
            this.firePropertyChange(PROP_SHOW_UNIMPORTANT_FILES, !showUnimportantFiles ? Boolean.TRUE : Boolean.FALSE, showUnimportantFiles ? Boolean.TRUE : Boolean.FALSE);
            this.refreshExistingFolders();
        }
    }

    public boolean isShowLocalFiles() {
        return this.showLocalFiles;
    }

    public void setShowLocalFiles(boolean showLocalFiles) {
        if (this.showLocalFiles != showLocalFiles) {
            this.showLocalFiles = showLocalFiles;
            this.firePropertyChange(PROP_SHOW_LOCAL_FILES, !showLocalFiles ? Boolean.TRUE : Boolean.FALSE, showLocalFiles ? Boolean.TRUE : Boolean.FALSE);
            this.refreshExistingFolders();
        }
    }

    public String getIgnoredGarbageFiles() {
        return this.ignoredGarbageFiles;
    }

    public synchronized void setIgnoredGarbageFiles(String nue) throws IllegalArgumentException {
        if (!nue.equals(this.ignoredGarbageFiles)) {
            if (nue.length() > 0) {
                try {
                    this.ignoredGarbageRE = new RE(nue);
                }
                catch (RESyntaxException rese) {
                    IllegalArgumentException iae = new IllegalArgumentException();
                    ErrorManager.getDefault().annotate((Throwable)iae, (Throwable)rese);
                    throw iae;
                }
            } else {
                this.ignoredGarbageRE = null;
            }
            this.ignoredGarbageFiles = nue;
            this.firePropertyChange(PROP_IGNORED_GARBAGE_FILES, null, nue);
            this.refreshExistingFolders();
        }
    }

    public boolean isShowMessages() {
        return this.showMessages;
    }

    public void setShowMessages(boolean showMessages) {
        if (this.showMessages != showMessages) {
            this.showMessages = showMessages;
            this.firePropertyChange(PROP_SHOW_MESSAGES, !showMessages ? Boolean.TRUE : Boolean.FALSE, showMessages ? Boolean.TRUE : Boolean.FALSE);
            this.redisplayRevisions();
        }
    }

    private void redisplayRevisions() {
        Iterator it = this.revisionListsByName.values().iterator();
        while (it.hasNext()) {
            RevisionList list = (RevisionList)it.next();
            this.displayRevisions(list);
        }
    }

    private void displayRevisions(RevisionList list) {
        Iterator it2 = list.iterator();
        while (it2.hasNext()) {
            RevisionItem item = (RevisionItem)it2.next();
            if (this.isShowMessages()) {
                String messageString = item.getMessage();
                if (messageString == null) continue;
                item.setDisplayName(item.getRevisionVCS() + "  " + this.cutMessageString(messageString));
                continue;
            }
            if (item.getMessage() == null) continue;
            item.setDisplayName(item.getRevisionVCS());
        }
    }

    private String cutMessageString(String message) {
        String toReturn = message;
        if (message != null && message.length() > this.getMessageLength() + 3) {
            toReturn = message.substring(0, this.getMessageLength()) + "...";
        }
        if (toReturn != null) {
            toReturn = toReturn.replace('\n', ' ');
        }
        return toReturn;
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public void setMessageLength(int messageLength) {
        int oldLength = this.messageLength;
        this.messageLength = messageLength;
        if (messageLength < 0) {
            this.messageLength = 0;
        }
        this.firePropertyChange(PROP_MESSAGE_LENGTH, new Integer(oldLength), new Integer(messageLength));
        this.redisplayRevisions();
    }

    public boolean isReadOnly() {
        return false;
    }

    public SystemAction[] getRevisionActions(FileObject fo, Set revisionItems) {
        VcsRevisionAction action = (VcsRevisionAction)SystemAction.get((Class)(class$org$netbeans$modules$vcscore$VcsRevisionAction == null ? (class$org$netbeans$modules$vcscore$VcsRevisionAction = VcsVersioningSystem.class$("org.netbeans.modules.vcscore.VcsRevisionAction")) : class$org$netbeans$modules$vcscore$VcsRevisionAction));
        Object object = vsActionAccessLock;
        synchronized (object) {
            action.setFileSystem(this.fileSystem);
            action.setFileObject(fo);
            action.setSelectedRevisionItems(revisionItems);
        }
        return new SystemAction[]{action};
    }

    private void vcsStatusChanged(String path, boolean recursively) {
        FileObject fo = this.findExistingResource(path);
        if (fo == null) {
            return;
        }
        Enumeration enumeration = this.existingFileObjects(fo);
        HashSet hs = new HashSet();
        if (enumeration.hasMoreElements()) {
            hs.add(enumeration.nextElement());
        }
        while (enumeration.hasMoreElements()) {
            FileObject chfo = (FileObject)enumeration.nextElement();
            if (!recursively && !fo.equals(chfo.getParent())) break;
            hs.add(chfo);
        }
        Set s = Collections.synchronizedSet(hs);
        this.fireVcsFileStatusChanged(new VcsFileStatusEvent(this, s));
    }

    private void vcsStatusChanged(String name) {
        FileObject fo = this.findExistingResource(name);
        if (fo == null) {
            return;
        }
        this.fireVcsFileStatusChanged(new VcsFileStatusEvent(this, Collections.singleton(fo)));
    }

    public void statusChanged(final CacheHandlerEvent event) {
        final String root = this.fileSystem.getRootDirectory().getAbsolutePath();
        final String absPath = event.getCacheFile().getAbsolutePath();
        if (absPath.startsWith(root)) {
            VcsFileSystem.getStatusChangeRequestProcessor().post(new Runnable(){

                public void run() {
                    String path = root.length() == absPath.length() ? "" : absPath.substring(root.length() + 1, absPath.length());
                    path = path.replace(File.separatorChar, '/');
                    if (event.getCacheFile() instanceof CacheDir) {
                        VcsVersioningSystem.this.vcsStatusChanged(path, event.isRecursive());
                    } else {
                        VcsVersioningSystem.this.vcsStatusChanged(path);
                    }
                }
            });
        }
    }

    public void cacheRemoved(CacheHandlerEvent event) {
    }

    public void cacheAdded(CacheHandlerEvent event) {
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException, NotActiveException {
        in.defaultReadObject();
        if (this.ignoredGarbageFiles == null) {
            this.ignoredGarbageFiles = "";
        } else if (this.ignoredGarbageFiles.length() > 0) {
            try {
                this.ignoredGarbageRE = new RE(this.ignoredGarbageFiles);
            }
            catch (RESyntaxException rese) {
                ErrorManager.getDefault().notify((Throwable)rese);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FSPropertyChangeListener
    implements PropertyChangeListener {
        private FSPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            FileObject root;
            String propName = event.getPropertyName();
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if ("annotationPattern".equals(propName)) {
                root = VcsVersioningSystem.this.findResource("");
                HashSet foSet = new HashSet();
                Enumeration enumeration = VcsVersioningSystem.super.existingFileObjects(root);
                while (enumeration.hasMoreElements()) {
                    foSet.add(enumeration.nextElement());
                }
                VcsVersioningSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)VcsVersioningSystem.this, foSet, false, true));
            }
            if (VcsVersioningSystem.PROP_SHOW_DEAD_FILES.equals(propName)) {
                root = VcsVersioningSystem.this.findResource("");
                this.heyDoRefreshFolderRecursive(root);
            }
            if ("root".equals(propName) && !event.getSource().equals(VcsVersioningSystem.this)) {
                try {
                    String oldSystName = VcsVersioningSystem.this.getSystemName();
                    VcsVersioningSystem.super.setSystemName(VcsVersioningSystem.this.fileSystem.getSystemName());
                    VcsVersioningSystem.super.firePropertyChange("systemName", oldSystName, VcsVersioningSystem.this.getSystemName());
                }
                catch (PropertyVetoException vExc) {
                    ErrorManager.getDefault().notify(16, (Throwable)vExc);
                }
                FileObject fo = VcsVersioningSystem.super.refreshRoot();
                VcsVersioningSystem.super.firePropertyChange("root", null, fo);
                return;
            }
            if ("displayName".equals(propName)) {
                if (newValue == null) {
                    return;
                }
                VcsVersioningSystem.super.firePropertyChange("displayName", null, null);
            }
        }

        private void heyDoRefreshFolderRecursive(FileObject fo) {
            Enumeration enumeration = VcsVersioningSystem.super.existingFileObjects(fo);
            while (enumeration.hasMoreElements()) {
                ((FileObject)enumeration.nextElement()).refresh();
            }
        }
    }

    private class VersioningVersions
    implements VersioningFileSystem.Versions {
        private static final long serialVersionUID = -8842749866809190554L;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsVersioningSystem;

        public VersioningVersions() {
            VcsVersioningSystem.this.fileSystem.addRevisionListener(new RevisionListener(this){
                private final /* synthetic */ VersioningVersions this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent ev) {
                    if (!(ev instanceof RevisionEvent)) {
                        return;
                    }
                    RevisionEvent event = (RevisionEvent)ev;
                    String name = event.getFilePath();
                    RevisionList oldList = (RevisionList)VcsVersioningSystem.access$800(VersioningVersions.access$700(this.this$1)).get(name);
                    if (oldList != null) {
                        RevisionList newList = VersioningVersions.access$900(this.this$1, name);
                        ArrayList<E> workNew = new ArrayList<E>(newList);
                        RevisionList revisionList = oldList;
                        synchronized (revisionList) {
                            String revision;
                            ArrayList<E> workOld = new ArrayList<E>(oldList);
                            ((AbstractCollection)workNew).removeAll(oldList);
                            oldList.addAll(workNew);
                            ((AbstractCollection)workOld).removeAll(newList);
                            oldList.removeAll(workOld);
                            FileStatusProvider status = VersioningVersions.access$700(this.this$1).getFileStatusProvider();
                            if (status != null && (revision = status.getFileRevision(name)) != null) {
                                Iterator<E> it = oldList.iterator();
                                while (it.hasNext()) {
                                    RevisionItem item = (RevisionItem)it.next();
                                    item.setCurrent(revision.equals(item.getRevision()));
                                }
                            }
                        }
                    }
                }
            });
        }

        public RevisionList getRevisions(String name, boolean refresh) {
            RevisionList list = (RevisionList)VcsVersioningSystem.this.revisionListsByName.get(name);
            if ((list == null || refresh) && (list = this.createRevisionList(name)) != null) {
                VcsVersioningSystem.this.revisionListsByName.put(name, list);
            }
            return list;
        }

        private RevisionList createRevisionList(String name) {
            CommandSupport cmdSupport = VcsVersioningSystem.this.fileSystem.getCommandSupport("REVISION_LIST");
            if (cmdSupport == null) {
                return null;
            }
            Command cmd = cmdSupport.createCommand();
            if (cmd == null || !(cmd instanceof RegexOutputCommand)) {
                return null;
            }
            FileObject fo = VcsVersioningSystem.this.fileSystem.findFileObject(name);
            if (fo == null) {
                fo = VcsVersioningSystem.this.findResource(name);
            }
            if (fo != null) {
                FileObject[] files = new FileObject[]{fo};
                cmd.setFiles(files);
            } else if (cmd instanceof VcsDescribedCommand) {
                ((VcsDescribedCommand)cmd).setDiskFiles(new File[]{VcsVersioningSystem.this.fileSystem.getFile(name)});
            }
            StringBuffer dataBuffer = new StringBuffer();
            RegexOutputListener dataListener = new RegexOutputListener(this, dataBuffer){
                private final /* synthetic */ StringBuffer val$dataBuffer;
                private final /* synthetic */ VersioningVersions this$1;
                {
                    this.this$1 = this$1;
                    this.val$dataBuffer = val$dataBuffer;
                }

                public void outputMatchedGroups(String[] data) {
                    if (data != null && data.length > 0 && data[0] != null) {
                        this.val$dataBuffer.append(data[0]);
                    }
                }
            };
            ((RegexOutputCommand)cmd).addRegexOutputListener(dataListener);
            cmd.execute().waitFinished();
            RevisionList list = this.getEncodedRevisionList(name, dataBuffer.toString());
            if (list != null) {
                VcsVersioningSystem.this.displayRevisions(list);
            }
            return list;
        }

        private RevisionList getEncodedRevisionList(String name, String encodedRL) {
            if (encodedRL.length() == 0) {
                return null;
            }
            RevisionList list = null;
            try {
                list = (RevisionList)VcsUtilities.decodeValue(encodedRL);
            }
            catch (IOException ioExc) {
                list = null;
            }
            return list;
        }

        public InputStream inputStream(String name, String revision) throws FileNotFoundException {
            boolean success;
            CommandSupport cmdSupport = VcsVersioningSystem.this.fileSystem.getCommandSupport("REVISION_OPEN");
            if (cmdSupport == null) {
                return null;
            }
            Command command = cmdSupport.createCommand();
            if (command == null || !(command instanceof VcsDescribedCommand)) {
                return null;
            }
            VcsDescribedCommand cmd = (VcsDescribedCommand)command;
            Hashtable<String, String> additionalVars = new Hashtable<String, String>();
            additionalVars.put("REVISION", revision);
            cmd.setAdditionalVariables(additionalVars);
            FileObject[] files = new FileObject[]{VcsVersioningSystem.this.fileSystem.findFileObject(name)};
            cmd.setFiles(files);
            StringBuffer fileBuffer = new StringBuffer();
            TextOutputListener fileListener = new TextOutputListener(this, fileBuffer){
                private final /* synthetic */ StringBuffer val$fileBuffer;
                private final /* synthetic */ VersioningVersions this$1;
                {
                    this.this$1 = this$1;
                    this.val$fileBuffer = val$fileBuffer;
                }

                public void outputLine(String line) {
                    if (line != null) {
                        this.val$fileBuffer.append(line + "\n");
                    }
                }
            };
            cmd.addTextOutputListener(fileListener);
            CommandTask task = cmd.execute();
            task.waitFinished();
            boolean bl = success = task.getExitStatus() == 0;
            if (VcsCommandIO.getBooleanProperty(cmd.getVcsCommand(), "ignoreFail")) {
                success = true;
            }
            if (!success) {
                throw (FileNotFoundException)ErrorManager.getDefault().annotate((Throwable)new FileNotFoundException(), NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$VcsVersioningSystem == null ? (class$org$netbeans$modules$vcscore$VcsVersioningSystem = VersioningVersions.class$("org.netbeans.modules.vcscore.VcsVersioningSystem")) : class$org$netbeans$modules$vcscore$VcsVersioningSystem), (String)"MSG_RevisionOpenCommandFailed", (Object)name, (Object)revision));
            }
            if (fileBuffer.length() == 0) {
                throw (FileNotFoundException)ErrorManager.getDefault().annotate((Throwable)new FileNotFoundException(), NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$VcsVersioningSystem == null ? (class$org$netbeans$modules$vcscore$VcsVersioningSystem = VersioningVersions.class$("org.netbeans.modules.vcscore.VcsVersioningSystem")) : class$org$netbeans$modules$vcscore$VcsVersioningSystem), (String)"MSG_FileRevisionIsEmpty", (Object)name, (Object)revision));
            }
            return new ByteArrayInputStream(fileBuffer.toString().getBytes());
        }

        static /* synthetic */ VcsVersioningSystem access$700(VersioningVersions x0) {
            return x0.VcsVersioningSystem.this;
        }

        static /* synthetic */ RevisionList access$900(VersioningVersions x0, String x1) {
            return x0.createRevisionList(x1);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class VcsVersioningAttrs
    extends VersioningFileSystem.VersioningAttrs {
        public VcsVersioningAttrs() {
            super(VcsVersioningSystem.this.info);
        }

        public Object readAttribute(String name, String attrName) {
            Object value = super.readAttribute(name, attrName);
            if (value == null) {
                value = VcsVersioningSystem.this.fileSystem.getVcsAttributes().readAttribute(name, attrName);
            }
            return value;
        }
    }

    private class VersioningList
    implements AbstractFileSystem.List {
        private static final long serialVersionUID = 107435350712853937L;

        private VersioningList() {
        }

        public String[] children(String name) {
            String[] vcsFiles = null;
            String[] files = null;
            FileCacheProvider cache = VcsVersioningSystem.this.fileSystem.getCacheProvider();
            HashMap removedFilesScheduledForRemove = new HashMap();
            if (cache != null) {
                cache.readDirFromDiskCache(name);
                vcsFiles = cache.getFilesAndSubdirs(name);
                if (!VcsVersioningSystem.this.fileSystem.isShowDeadFiles()) {
                    vcsFiles = VcsVersioningSystem.this.fileSystem.filterDeadFilesOut(name, vcsFiles);
                }
            }
            files = vcsFiles == null ? VcsVersioningSystem.this.fileSystem.getLocalFiles(name) : VcsVersioningSystem.this.fileSystem.addLocalFiles(name, vcsFiles, removedFilesScheduledForRemove);
            if (cache != null) {
                VcsCacheDir cacheDir = (VcsCacheDir)cache.getDir(name);
                if (files.length == 0 && (cacheDir == null || !cacheDir.isLoaded() && !cacheDir.isLocal()) || (cacheDir == null || !cacheDir.isLoaded() && !cacheDir.isLocal()) && VcsVersioningSystem.this.fileSystem.areOnlyHiddenFiles(files)) {
                    cache.readDir(name);
                }
            }
            int i = 0;
            while (i < files.length) {
                if (VcsVersioningSystem.this.fileSystem.isFilterBackupFiles() && files[i].endsWith(VcsVersioningSystem.this.fileSystem.getBackupExtension()) || !VcsVersioningSystem.this.isShowUnimportantFiles() && !VcsVersioningSystem.this.fileSystem.isImportant(name.length() == 0 ? files[i] : name + "/" + files[i]) || VcsVersioningSystem.this.ignoredGarbageRE != null && VcsVersioningSystem.this.ignoredGarbageRE.match(files[i])) {
                    files[i] = null;
                }
                ++i;
            }
            return files;
        }
    }
}

