/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import org.netbeans.modules.vcscore.actions.ClusterItemVisualizer;
import org.netbeans.modules.vcscore.actions.GeneralCommandAction;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ClusteringAction
extends GeneralCommandAction {
    public static final String POPUP_DEFINITION_FOLDER = "Popup_Definition_Folder";
    public static final String IS_SWITCHABLE_POPUP = "IsSwitchable";
    protected static final String CLIENT_PROP_ACTION = "SELECTED_COMMAND_ACTION";
    protected transient boolean CTRL_Down = false;
    private transient ArrayList switchableList;
    protected transient boolean isMenu;
    static final long serialVersionUID = 0L;
    private transient JMenu lazyMenu = null;
    private transient MenuListener menuListener = new MenuListener(){

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }

        public void menuSelected(MenuEvent e) {
            ClusteringAction.this.deselectedMenu();
        }
    };
    private transient MenuKeyListener menuKeyListener = new MenuKeyListener(){

        public void menuKeyTyped(MenuKeyEvent p1) {
        }

        public void menuKeyPressed(MenuKeyEvent p1) {
            boolean newCTRL_Down = "Ctrl".equals(KeyEvent.getKeyText(p1.getKeyCode())) || !p1.isControlDown();
            ClusteringAction.this.changeCtrlSigns(newCTRL_Down);
            ClusteringAction.this.CTRL_Down = newCTRL_Down;
        }

        public void menuKeyReleased(MenuKeyEvent p1) {
            boolean newCTRL_Down = "Ctrl".equals(KeyEvent.getKeyText(p1.getKeyCode())) || !p1.isControlDown();
            ClusteringAction.this.changeCtrlSigns(!newCTRL_Down);
            ClusteringAction.this.CTRL_Down = !newCTRL_Down;
        }
    };
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$ClusteringAction;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie$Of;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$ClusterItemVisualizer;
    static /* synthetic */ Class class$javax$swing$JSeparator;

    protected String iconResource() {
        return null;
    }

    public String getName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$actions$ClusteringAction == null ? (class$org$netbeans$modules$vcscore$actions$ClusteringAction = ClusteringAction.class$("org.netbeans.modules.vcscore.actions.ClusteringAction")) : class$org$netbeans$modules$vcscore$actions$ClusteringAction)).getString("ClusteringAction.displayName");
    }

    protected String getClusterRootPath() {
        return this.getValue(POPUP_DEFINITION_FOLDER).toString();
    }

    protected boolean isSwitchingEnabled() {
        Boolean toReturn = (Boolean)this.getValue(IS_SWITCHABLE_POPUP);
        if (toReturn != null) {
            return toReturn;
        }
        return false;
    }

    protected boolean isCTRLDown() {
        return this.CTRL_Down;
    }

    public JMenuItem getMenuPresenter() {
        if (this.lazyMenu != null) {
            this.lazyMenu.removeMenuListener(this.menuListener);
            this.lazyMenu.removeMenuKeyListener(this.menuKeyListener);
        }
        this.lazyMenu = new LazyPopup(true);
        return this.lazyMenu;
    }

    public JMenuItem getPopupPresenter() {
        if (this.lazyMenu != null) {
            this.lazyMenu.removeMenuListener(this.menuListener);
            this.lazyMenu.removeMenuKeyListener(this.menuKeyListener);
        }
        this.lazyMenu = new LazyPopup(false);
        return this.lazyMenu;
    }

    void createPresenter(boolean isMenu, JMenu menu) {
        this.switchableList = new ArrayList();
        this.isMenu = isMenu;
        menu.addMenuKeyListener(this.menuKeyListener);
        menu.addMenuListener(this.menuListener);
        this.createPresenter(menu, this.getClusterRootPath());
    }

    protected void createPresenter(JMenu menu, String menuPath) {
        JMenuItem item = null;
        JMenu submenu = null;
        FileSystem defFs = Repository.getDefault().getDefaultFileSystem();
        FileObject menuRoot = defFs.findResource(menuPath);
        if (menuRoot == null) {
            return;
        }
        DataFolder dataFolder = null;
        try {
            dataFolder = (DataFolder)DataObject.find((FileObject)menuRoot);
        }
        catch (DataObjectNotFoundException exc) {
            return;
        }
        DataObject[] children = dataFolder.getChildren();
        if (children != null && children.length > 0) {
            boolean lastWasSeparator = false;
            int i = 0;
            while (i < children.length) {
                InstanceCookie.Of cookie;
                if (children[i] instanceof DataFolder) {
                    submenu = new JMenu();
                    Actions.setMenuText((AbstractButton)submenu, (String)children[i].getName(), (boolean)this.isMenu);
                    String path = menuPath + "/" + children[i].getPrimaryFile().getName();
                    this.createPresenter(submenu, path);
                    if (submenu.getItemCount() > 0) {
                        submenu.addActionListener((ActionListener)((Object)this));
                        menu.add(submenu);
                    }
                    lastWasSeparator = false;
                }
                if ((cookie = (InstanceCookie.Of)children[i].getCookie(class$org$openide$cookies$InstanceCookie$Of == null ? ClusteringAction.class$("org.openide.cookies.InstanceCookie$Of") : class$org$openide$cookies$InstanceCookie$Of)) != null) {
                    try {
                        ClusterItemVisualizer act;
                        Object obj;
                        if (cookie.instanceOf(class$org$netbeans$modules$vcscore$actions$ClusterItemVisualizer == null ? ClusteringAction.class$("org.netbeans.modules.vcscore.actions.ClusterItemVisualizer") : class$org$netbeans$modules$vcscore$actions$ClusterItemVisualizer) && (obj = cookie.instanceCreate()) != null && this.checkItemEnable(act = (ClusterItemVisualizer)obj)) {
                            item = this.createItem(act);
                            menu.add(item);
                            lastWasSeparator = false;
                        }
                        if (cookie.instanceOf(class$javax$swing$JSeparator == null ? ClusteringAction.class$("javax.swing.JSeparator") : class$javax$swing$JSeparator) && !lastWasSeparator) {
                            menu.addSeparator();
                            lastWasSeparator = true;
                        }
                    }
                    catch (Exception exc) {
                        ErrorManager.getDefault().notify(65536, (Throwable)exc);
                    }
                }
                ++i;
            }
        }
    }

    protected boolean checkItemEnable(ClusterItemVisualizer item) {
        return item.isItemEnabled(this);
    }

    private JMenuItem createItem(ClusterItemVisualizer action) {
        JMenuItem item = new JMenuItem();
        String nm = action.getName();
        if (!this.isSwitchingEnabled() && action.isSwitchable()) {
            nm = nm + NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$actions$ClusteringAction == null ? (class$org$netbeans$modules$vcscore$actions$ClusteringAction = ClusteringAction.class$("org.netbeans.modules.vcscore.actions.ClusteringAction")) : class$org$netbeans$modules$vcscore$actions$ClusteringAction)).getString("ClusteringAction.DialogDots");
        }
        Actions.setMenuText((AbstractButton)item, (String)nm, (boolean)this.isMenu);
        if (this.isMenu) {
            item.setIcon(action.getIcon());
        }
        item.putClientProperty(CLIENT_PROP_ACTION, action);
        item.addActionListener((ActionListener)((Object)this));
        this.assignHelp(item, action.getClass().getName());
        if (this.isSwitchingEnabled() && action.isSwitchable()) {
            this.switchableList.add(item);
        }
        return item;
    }

    private void assignHelp(JMenuItem item, String commandName) {
        HelpCtx.setHelpIDString((JComponent)item, (String)((class$org$netbeans$modules$vcscore$actions$ClusteringAction == null ? (class$org$netbeans$modules$vcscore$actions$ClusteringAction = ClusteringAction.class$("org.netbeans.modules.vcscore.actions.ClusteringAction")) : class$org$netbeans$modules$vcscore$actions$ClusteringAction).getName() + "." + commandName));
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)obj;
            ClusterItemVisualizer action = (ClusterItemVisualizer)item.getClientProperty(CLIENT_PROP_ACTION);
            action.setSwitched(this.CTRL_Down);
            action.performAction(this.getActivatedNodes(), this);
        }
    }

    private void deselectedMenu() {
        this.changeCtrlSigns(false);
        this.CTRL_Down = false;
    }

    private void changeCtrlSigns(boolean newValue) {
        if (newValue == this.CTRL_Down) {
            return;
        }
        String plusValue = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$actions$ClusteringAction == null ? (class$org$netbeans$modules$vcscore$actions$ClusteringAction = ClusteringAction.class$("org.netbeans.modules.vcscore.actions.ClusteringAction")) : class$org$netbeans$modules$vcscore$actions$ClusteringAction)).getString("ClusteringAction.DialogDots");
        Iterator it = ((AbstractList)this.switchableList).iterator();
        while (it.hasNext()) {
            JMenuItem item = (JMenuItem)it.next();
            String text = item.getText();
            if (newValue) {
                if (!text.endsWith(plusValue)) {
                    text = text + plusValue;
                }
            } else if (text.endsWith(plusValue)) {
                text = text.substring(0, text.length() - plusValue.length());
            }
            item.setText(text);
        }
    }

    protected boolean clearSharedData() {
        if (this.lazyMenu != null) {
            this.lazyMenu.removeMenuListener(this.menuListener);
            this.lazyMenu.removeMenuKeyListener(this.menuKeyListener);
        }
        this.lazyMenu = null;
        this.menuListener = null;
        return super.clearSharedData();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LazyPopup
    extends JMenuPlus {
        private Icon icon = null;
        private boolean isMenu;
        private boolean created = false;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$ClusteringAction;

        LazyPopup(boolean isMenu) {
            this.isMenu = isMenu;
            Actions.setMenuText((AbstractButton)((Object)this), (String)ClusteringAction.this.getName(), (boolean)isMenu);
            if (isMenu) {
                ((AbstractButton)((Object)this)).setIcon(ClusteringAction.this.getIcon());
            }
            HelpCtx.setHelpIDString((JComponent)((Object)this), (String)(class$org$netbeans$modules$vcscore$actions$ClusteringAction == null ? (class$org$netbeans$modules$vcscore$actions$ClusteringAction = LazyPopup.class$("org.netbeans.modules.vcscore.actions.ClusteringAction")) : class$org$netbeans$modules$vcscore$actions$ClusteringAction).getName());
        }

        public JPopupMenu getPopupMenu() {
            if (!this.created) {
                this.createMenuItems();
            }
            return super.getPopupMenu();
        }

        private void createMenuItems() {
            this.created = true;
            ((JMenu)((Object)this)).removeAll();
            ClusteringAction.this.createPresenter(this.isMenu, (JMenu)((Object)this));
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

