/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.api.vcs.commands.MessagingCommand;
import org.netbeans.modules.vcscore.VcsFSCommandsAction;
import org.netbeans.modules.vcscore.commands.CommandsTree;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CommandMenu
extends JMenuPlus {
    public static final String DEFAULT_ADVANCED_OPTIONS_SIGN = NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$actions$CommandMenu == null ? (class$org$netbeans$modules$vcscore$actions$CommandMenu = CommandMenu.class$("org.netbeans.modules.vcscore.actions.CommandMenu")) : class$org$netbeans$modules$vcscore$actions$CommandMenu), (String)"CTL_AdvancedOptionsSign");
    private CommandsTree commandRoot;
    private Map filesWithMessages;
    private List switchableList;
    private String advancedOptionsSign;
    private boolean removeDisabled;
    private boolean inMenu;
    private boolean globalExpertMode;
    private ActionListener listener;
    private Map actionCommandMap;
    private boolean popupCreated = false;
    private boolean[] CTRL_Down = new boolean[]{false, false};
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$CommandMenu;

    public CommandMenu(CommandsTree commandRoot, Map filesWithMessages, boolean removeDisabled, boolean inMenu, boolean globalExpertMode) {
        this(commandRoot, filesWithMessages, DEFAULT_ADVANCED_OPTIONS_SIGN, removeDisabled, inMenu, globalExpertMode, null, new HashMap());
    }

    private CommandMenu(CommandsTree commandRoot, Map filesWithMessages, String advancedOptionsSign, boolean removeDisabled, boolean inMenu, boolean globalExpertMode, ActionListener listener, Map actionCommandMap) {
        this(commandRoot, filesWithMessages, new ArrayList(), advancedOptionsSign, removeDisabled, inMenu, globalExpertMode, listener, actionCommandMap);
    }

    private CommandMenu(CommandsTree commandRoot, Map filesWithMessages, List switchableList, String advancedOptionsSign, boolean removeDisabled, boolean inMenu, boolean globalExpertMode, ActionListener listener, Map actionCommandMap) {
        this.commandRoot = commandRoot;
        this.filesWithMessages = filesWithMessages;
        this.switchableList = switchableList;
        this.advancedOptionsSign = advancedOptionsSign;
        this.removeDisabled = removeDisabled;
        this.inMenu = inMenu;
        this.globalExpertMode = globalExpertMode;
        this.CTRL_Down[1] = globalExpertMode;
        this.listener = listener != null ? listener : new CommandActionListener(this.CTRL_Down, actionCommandMap, filesWithMessages);
        this.actionCommandMap = actionCommandMap;
        CommandSupport cmd = commandRoot.getCommandSupport();
        if (cmd != null) {
            Actions.setMenuText((AbstractButton)((Object)this), (String)cmd.getDisplayName(), (boolean)inMenu);
        }
        if (advancedOptionsSign != null) {
            ((JMenuItem)((Object)this)).addMenuKeyListener(new CtrlMenuKeyListener(this.CTRL_Down, switchableList, advancedOptionsSign));
        }
    }

    public JPopupMenu getPopupMenu() {
        if (!this.popupCreated) {
            this.createPopup();
        }
        return super.getPopupMenu();
    }

    private void createPopup() {
        FileObject[] allFiles;
        boolean wasSeparator = false;
        boolean wasNullCommand = false;
        CommandsTree[] children = this.commandRoot.children();
        if (this.filesWithMessages.size() == 1) {
            allFiles = (FileObject[])this.filesWithMessages.keySet().iterator().next();
        } else {
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            Iterator it = this.filesWithMessages.keySet().iterator();
            while (it.hasNext()) {
                files.addAll(Arrays.asList((FileObject[])it.next()));
            }
            allFiles = files.toArray(new FileObject[files.size()]);
        }
        Map multiCommandsByDisplayName = CommandMenu.getMultiCommandsByDisplayName(children, allFiles);
        HashSet<String> addedDisplayNames = new HashSet<String>();
        int i = 0;
        while (i < children.length) {
            block11: {
                Object item;
                CommandSupport cmd;
                block13: {
                    JMenuItem cmdMenu;
                    String displayName;
                    block12: {
                        block10: {
                            cmd = children[i].getCommandSupport();
                            if (cmd != null) break block10;
                            if (!wasSeparator || wasNullCommand) {
                                ((JMenu)((Object)this)).addSeparator();
                            }
                            wasSeparator = true;
                            wasNullCommand = true;
                            break block11;
                        }
                        wasNullCommand = false;
                        displayName = cmd.getDisplayName();
                        if (displayName == null || this.removeDisabled && cmd.getApplicableFiles(allFiles) == null || (cmdMenu = CommandMenu.createItem(cmd, this.globalExpertMode, this.switchableList, this.advancedOptionsSign, this.inMenu, this.listener, this.actionCommandMap)) == null) break block11;
                        wasSeparator = false;
                        if (!children[i].hasChildren()) break block12;
                        CommandMenu submenu = new CommandMenu(children[i], this.filesWithMessages, this.switchableList, this.advancedOptionsSign, this.removeDisabled, this.inMenu, this.globalExpertMode, this.listener, this.actionCommandMap);
                        ((JMenu)((Object)this)).add((JMenuItem)((Object)submenu));
                        item = submenu;
                        break block13;
                    }
                    if (addedDisplayNames.contains(displayName) && multiCommandsByDisplayName.containsKey(displayName)) break block11;
                    item = cmdMenu;
                    List cmdList = (List)multiCommandsByDisplayName.get(cmd.getDisplayName());
                    if (cmdList != null) {
                        item = CommandMenu.createItem(cmdList.toArray(new CommandSupport[cmdList.size()]), displayName, this.globalExpertMode, this.switchableList, this.advancedOptionsSign, this.inMenu, this.listener, this.actionCommandMap);
                        addedDisplayNames.add(displayName);
                    }
                    ((JMenu)((Object)this)).add((JMenuItem)item);
                }
                if (!this.removeDisabled && cmd.getApplicableFiles(allFiles) == null) {
                    item.setEnabled(false);
                }
            }
            ++i;
        }
        this.popupCreated = true;
    }

    private static Map getMultiCommandsByDisplayName(CommandsTree[] children, FileObject[] allFiles) {
        HashMap<String, CommandSupport> commandsByDisplayNames = new HashMap<String, CommandSupport>();
        HashMap<String, LinkedList<CommandSupport>> multiCommandsByDisplayName = new HashMap<String, LinkedList<CommandSupport>>();
        int i = 0;
        while (i < children.length) {
            String dn;
            CommandSupport cmd = children[i].getCommandSupport();
            if (cmd != null && !children[i].hasChildren() && (dn = cmd.getDisplayName()) != null) {
                if (commandsByDisplayNames.containsKey(dn)) {
                    LinkedList<CommandSupport> cmdList = (LinkedList<CommandSupport>)multiCommandsByDisplayName.get(dn);
                    if (cmdList == null) {
                        cmdList = new LinkedList<CommandSupport>();
                        cmdList.add((CommandSupport)commandsByDisplayNames.get(dn));
                        multiCommandsByDisplayName.put(dn, cmdList);
                    }
                    cmdList.add(cmd);
                }
                commandsByDisplayNames.put(dn, cmd);
            }
            ++i;
        }
        return multiCommandsByDisplayName;
    }

    private static JMenuItem createItem(CommandSupport cmd, boolean expertMode, List switchableList, String advancedOptionsSign, boolean inMenu, ActionListener listener, Map actionCommandMap) {
        String label = cmd.getDisplayName();
        if (label == null) {
            return null;
        }
        boolean hasExpert = cmd.hasExpertMode();
        if (hasExpert && expertMode && advancedOptionsSign != null) {
            label = label + advancedOptionsSign;
        }
        JMenuItem item = new JMenuItem();
        Actions.setMenuText((AbstractButton)item, (String)label, (boolean)inMenu);
        String commandStr = cmd.getName();
        if (actionCommandMap != null) {
            String base = commandStr;
            int i = 0;
            while (actionCommandMap.containsKey(commandStr)) {
                commandStr = base + ++i;
            }
            actionCommandMap.put(commandStr, cmd);
        }
        item.setActionCommand(commandStr);
        item.addActionListener(listener);
        if (hasExpert) {
            switchableList.add(item);
        }
        return item;
    }

    private static JMenuItem createItem(CommandSupport[] cmds, String label, boolean expertMode, List switchableList, String advancedOptionsSign, boolean inMenu, ActionListener listener, Map actionCommandMap) {
        boolean hasExpert;
        boolean bl = hasExpert = expertMode && advancedOptionsSign != null;
        if (hasExpert) {
            int i = 0;
            while (i < cmds.length && hasExpert) {
                hasExpert = hasExpert && cmds[i].hasExpertMode();
                ++i;
            }
            if (hasExpert) {
                label = label + advancedOptionsSign;
            }
        }
        JMenuItem item = new JMenuItem();
        Actions.setMenuText((AbstractButton)item, (String)label, (boolean)inMenu);
        String commandStr = cmds[0].getName();
        if (actionCommandMap != null) {
            String base = commandStr;
            int i = 0;
            while (actionCommandMap.containsKey(commandStr)) {
                commandStr = base + ++i;
            }
            actionCommandMap.put(commandStr, cmds);
        }
        item.setActionCommand(commandStr);
        item.addActionListener(listener);
        if (hasExpert) {
            switchableList.add(item);
        }
        return item;
    }

    public static JMenuItem createItem(CommandSupport cmd, boolean expertMode, String advancedOptionsSign, boolean inMenu, Map filesWithMessages) {
        String label = cmd.getDisplayName();
        if (label == null) {
            return null;
        }
        boolean hasExpert = cmd.hasExpertMode();
        if (hasExpert && expertMode && advancedOptionsSign != null) {
            label = label + advancedOptionsSign;
        }
        boolean[] CTRL_Down = new boolean[]{false, expertMode};
        HashMap<String, CommandSupport> actionCommandMap = new HashMap<String, CommandSupport>();
        ArrayList<JMenuItem> switchableList = new ArrayList<JMenuItem>();
        CommandActionListener listener = new CommandActionListener(CTRL_Down, actionCommandMap, filesWithMessages);
        JMenuItem item = new JMenuItem();
        Actions.setMenuText((AbstractButton)item, (String)label, (boolean)inMenu);
        String commandStr = cmd.getName();
        actionCommandMap.put(commandStr, cmd);
        item.setActionCommand(commandStr);
        item.addActionListener(listener);
        if (advancedOptionsSign != null) {
            item.addMenuKeyListener(new CtrlMenuKeyListener(CTRL_Down, switchableList, advancedOptionsSign));
        }
        if (hasExpert) {
            switchableList.add(item);
        }
        return item;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CtrlMenuKeyListener
    implements MenuKeyListener {
        private boolean[] CTRL_Down;
        private List switchableList;
        private String advancedOptionsSign;

        public CtrlMenuKeyListener(boolean[] CTRL_Down, List switchableList, String advancedOptionsSign) {
            this.CTRL_Down = CTRL_Down;
            this.switchableList = switchableList;
            this.advancedOptionsSign = advancedOptionsSign;
        }

        public void menuKeyTyped(MenuKeyEvent p1) {
        }

        public void menuKeyPressed(MenuKeyEvent p1) {
            boolean newCTRL_Down = "Ctrl".equals(KeyEvent.getKeyText(p1.getKeyCode())) || p1.isControlDown();
            this.changeCtrlSigns(newCTRL_Down);
            this.CTRL_Down[0] = newCTRL_Down;
        }

        public void menuKeyReleased(MenuKeyEvent p1) {
            boolean newCTRL_Down = "Ctrl".equals(KeyEvent.getKeyText(p1.getKeyCode())) || !p1.isControlDown();
            this.changeCtrlSigns(!newCTRL_Down);
            this.CTRL_Down[0] = !newCTRL_Down;
        }

        private void changeCtrlSigns(boolean newValue) {
            if (newValue == this.CTRL_Down[0]) {
                return;
            }
            Iterator it = this.switchableList.iterator();
            while (it.hasNext()) {
                JMenuItem item = (JMenuItem)it.next();
                String text = item.getText();
                if (newValue ^ this.CTRL_Down[1]) {
                    if (!text.endsWith(this.advancedOptionsSign)) {
                        text = text + this.advancedOptionsSign;
                    }
                } else if (text.endsWith(this.advancedOptionsSign)) {
                    text = text.substring(0, text.length() - this.advancedOptionsSign.length());
                }
                item.setText(text);
            }
        }
    }

    private static class CommandActionListener
    implements ActionListener {
        private boolean[] CTRL_Down;
        private Map actionCommandMap;
        private Map filesWithMessages;

        public CommandActionListener(boolean[] CTRL_Down, Map actionCommandMap, Map filesWithMessages) {
            this.CTRL_Down = CTRL_Down;
            this.actionCommandMap = actionCommandMap;
            this.filesWithMessages = filesWithMessages;
        }

        public void actionPerformed(ActionEvent e) {
            Object cmd;
            String cmdName = e.getActionCommand();
            CommandSupport[] cmdSupports = this.actionCommandMap != null ? ((cmd = this.actionCommandMap.get(cmdName)) instanceof CommandSupport[] ? (CommandSupport[])cmd : new CommandSupport[]{(CommandSupport)cmd}) : null;
            RequestProcessor.getDefault().post(new Runnable(this, cmdSupports, cmdName){
                private final /* synthetic */ CommandSupport[] val$cmdSupports;
                private final /* synthetic */ String val$cmdName;
                private final /* synthetic */ CommandActionListener this$0;
                {
                    this.this$0 = this$0;
                    this.val$cmdSupports = val$cmdSupports;
                    this.val$cmdName = val$cmdName;
                }

                public void run() {
                    Iterator<K> it = CommandActionListener.access$000(this.this$0).keySet().iterator();
                    block4: while (it.hasNext()) {
                        int i;
                        Command[] cmds;
                        FileObject[] files = (FileObject[])it.next();
                        String message = (String)CommandActionListener.access$000(this.this$0).get(files);
                        if (this.val$cmdSupports != null) {
                            cmds = new Command[this.val$cmdSupports.length];
                            i = 0;
                            while (i < this.val$cmdSupports.length) {
                                cmds[i] = this.val$cmdSupports[i].createCommand();
                                ++i;
                            }
                        } else {
                            Command cmd = null;
                            try {
                                cmd = VcsManager.getDefault().createCommand(this.val$cmdName, files);
                            }
                            catch (IllegalArgumentException iaex) {
                                // empty catch block
                            }
                            cmds = cmd != null ? new Command[]{cmd} : new Command[]{};
                        }
                        i = 0;
                        while (i < cmds.length) {
                            Command cmd = cmds[i];
                            if (cmd.getApplicableFiles(files) != null) {
                                CommandTask task;
                                if (message != null && cmd instanceof MessagingCommand) {
                                    ((MessagingCommand)cmd).setMessage(message);
                                }
                                cmd.setGUIMode(true);
                                if (CommandActionListener.access$100(this.this$0)[0]) {
                                    cmd.setExpertMode(CommandActionListener.access$100(this.this$0)[0] ^ CommandActionListener.access$100(this.this$0)[1]);
                                }
                                if ((task = VcsFSCommandsAction.executeCommand(cmd, files)) == null) continue block4;
                                try {
                                    task.waitFinished(0);
                                }
                                catch (InterruptedException iex) {
                                    continue block4;
                                }
                            }
                            ++i;
                        }
                    }
                }
            });
        }

        static /* synthetic */ Map access$000(CommandActionListener x0) {
            return x0.filesWithMessages;
        }

        static /* synthetic */ boolean[] access$100(CommandActionListener x0) {
            return x0.CTRL_Down;
        }
    }
}

