/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.actions;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.netbeans.modules.vcscore.actions.CommandActionSupporter;
import org.netbeans.modules.vcscore.grouping.VcsGroupNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;

public class GeneralCommandAction
extends NodeAction {
    public static final String VCS_ACTION_ATTRIBUTE = "VcsActionAttributeCookie";
    public static final String GROUP_DESCRIPTION_PROP = "GROUP_DESCRIPTION";
    public static final String GROUP_NAME_PROP = "GROUP_NAME";
    private transient JMenuItem menuPresent;
    private transient JMenuItem popupPresent;
    private transient Component toolBarPresent;
    private Set menuNamesSet;
    private Set toolBarNamesSet;
    private Set popupNamesSet;
    private boolean wasReset;
    static final long serialVersionUID = 5771601379701397185L;
    private static transient HashMap suppMap;
    private static transient WeakReference nodesRef;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$GeneralCommandAction;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    protected GeneralCommandAction() {
    }

    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        suppMap = this.getSupporterMap(nodes);
        if (suppMap == null) {
            return;
        }
        Iterator it = suppMap.keySet().iterator();
        while (it.hasNext()) {
            CommandActionSupporter support = (CommandActionSupporter)it.next();
            Set files = (Set)suppMap.get(support);
            FileObject[] filesArr = new FileObject[files.size()];
            filesArr = files.toArray(filesArr);
            support.performAction(this, filesArr);
        }
    }

    protected boolean enable(Node[] nodes) {
        this.toolBarNamesSet = new HashSet();
        this.menuNamesSet = new HashSet();
        this.popupNamesSet = new HashSet();
        if (nodes == null || nodes.length == 0) {
            if (!this.wasReset) {
                this.resetDisplayNames();
            }
            this.wasReset = true;
            return false;
        }
        suppMap = this.getSupporterMap(nodes);
        if (suppMap == null) {
            if (!this.wasReset) {
                this.resetDisplayNames();
            }
            this.wasReset = true;
            return false;
        }
        Iterator it = suppMap.keySet().iterator();
        boolean enabled = true;
        while (it.hasNext() && enabled) {
            CommandActionSupporter support = (CommandActionSupporter)it.next();
            Set files = (Set)suppMap.get(support);
            FileObject[] filesArr = new FileObject[files.size()];
            enabled = support.isEnabled(this, filesArr = files.toArray(filesArr));
            if (!enabled) continue;
            this.addDisplayName(support.getToolBarDisplayName(this));
        }
        this.wasReset = false;
        this.resetDisplayNames();
        return enabled;
    }

    private void resetDisplayNames() {
        String oldBar;
        String toolBarName = "";
        Iterator it = this.toolBarNamesSet.iterator();
        boolean atLeastOne = false;
        while (it.hasNext()) {
            String next = (String)it.next();
            if (next.equals(this.getName())) continue;
            if (atLeastOne) {
                toolBarName = toolBarName + "," + next;
                continue;
            }
            toolBarName = next;
            atLeastOne = true;
        }
        if (!atLeastOne) {
            toolBarName = this.getName();
        }
        if (this.toolBarPresent != null && this.toolBarPresent instanceof JComponent && ((oldBar = ((JComponent)this.toolBarPresent).getToolTipText()) == null || !oldBar.equals(toolBarName))) {
            ((JComponent)this.toolBarPresent).setToolTipText(toolBarName);
        }
    }

    private void addDisplayName(String name) {
        this.toolBarNamesSet.add(name);
    }

    public String getName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$actions$GeneralCommandAction == null ? (class$org$netbeans$modules$vcscore$actions$GeneralCommandAction = GeneralCommandAction.class$("org.netbeans.modules.vcscore.actions.GeneralCommandAction")) : class$org$netbeans$modules$vcscore$actions$GeneralCommandAction), (String)"LBL_Action");
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Component getToolbarPresenter() {
        Component retValue;
        this.toolBarPresent = retValue = super.getToolbarPresenter();
        return retValue;
    }

    public JMenuItem getPopupPresenter() {
        JMenuItem retValue;
        this.popupPresent = retValue = super.getPopupPresenter();
        return retValue;
    }

    public JMenuItem getMenuPresenter() {
        JMenuItem retValue;
        this.menuPresent = retValue = super.getMenuPresenter();
        return retValue;
    }

    public HashMap getSupporterMap(Node[] activatedNodes) {
        Object array;
        if (nodesRef == null) {
            this.createSupporterMap(activatedNodes);
            nodesRef = new WeakReference<Node[]>(activatedNodes);
        }
        if ((array = nodesRef.get()) == null) {
            this.createSupporterMap(activatedNodes);
            nodesRef = new WeakReference<Node[]>(activatedNodes);
        } else {
            Node[] nods = (Node[])array;
            boolean hasAnyGroups = false;
            int i = 0;
            while (i < nods.length) {
                if (nods[i] != null && nods[i] instanceof VcsGroupNode) {
                    hasAnyGroups = true;
                    break;
                }
                ++i;
            }
            boolean equal = Utilities.compareObjects(array, (Object)activatedNodes);
            if (!equal || hasAnyGroups) {
                this.createSupporterMap(activatedNodes);
                nodesRef = new WeakReference<Node[]>(activatedNodes);
            }
        }
        return suppMap;
    }

    private boolean createSupporterMap(Node[] nodes) {
        if (this.getValue(GROUP_NAME_PROP) != null) {
            this.putValue(GROUP_NAME_PROP, null);
        }
        if (this.getValue(GROUP_DESCRIPTION_PROP) != null) {
            this.putValue(GROUP_DESCRIPTION_PROP, null);
        }
        if (nodes == null || nodes.length == 0) {
            suppMap = null;
            return false;
        }
        suppMap = new HashMap();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof VcsGroupNode) {
                VcsGroupNode grNode = (VcsGroupNode)nodes[i];
                this.putValue(GROUP_DESCRIPTION_PROP, grNode.getShortDescription());
                this.putValue(GROUP_NAME_PROP, grNode.getDisplayName());
                Enumeration childs = nodes[i].getChildren().nodes();
                while (childs.hasMoreElements()) {
                    Node nd = (Node)childs.nextElement();
                    DataObject dobj = (DataObject)nd.getCookie(class$org$openide$loaders$DataObject == null ? GeneralCommandAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                    while (dobj != null && dobj instanceof DataShadow) {
                        dobj = ((DataShadow)dobj).getOriginal();
                    }
                    if (dobj == null || this.checkDataObject(dobj)) continue;
                    return false;
                }
            } else {
                DataObject dataObj = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? GeneralCommandAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                while (dataObj != null && dataObj instanceof DataShadow) {
                    dataObj = ((DataShadow)dataObj).getOriginal();
                }
                if (!this.checkDataObject(dataObj)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean checkDataObject(DataObject dataObj) {
        if (dataObj == null) {
            suppMap = null;
            return false;
        }
        FileObject fileOb = dataObj.getPrimaryFile();
        if (fileOb == null) {
            suppMap = null;
            return false;
        }
        FileSystem primaryFS = (FileSystem)fileOb.getAttribute("VcsFileSystemAttributeIdentifier");
        CommandActionSupporter supp = (CommandActionSupporter)fileOb.getAttribute(VCS_ACTION_ATTRIBUTE);
        if (supp != null) {
            HashSet<FileObject> fileSet = new HashSet<FileObject>();
            Iterator it = dataObj.files().iterator();
            while (it.hasNext()) {
                FileSystem fs;
                FileObject fo = (FileObject)it.next();
                supp = (CommandActionSupporter)fileOb.getAttribute(VCS_ACTION_ATTRIBUTE);
                if (supp == null || primaryFS != null && !primaryFS.equals(fs = (FileSystem)fo.getAttribute("VcsFileSystemAttributeIdentifier"))) continue;
                fileSet.clear();
                fileSet.add(fo);
                this.addToMap(suppMap, supp, fileSet);
            }
        } else {
            suppMap = null;
            return false;
        }
        return true;
    }

    private void addToMap(HashMap map, CommandActionSupporter supporter, Set files) {
        HashSet set = (HashSet)map.get(supporter);
        if (set == null) {
            set = new HashSet();
        }
        if (files != null) {
            Iterator it = files.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj == null) continue;
                set.add(obj);
            }
        }
        map.put(supporter, set);
    }

    public void performAction() {
        this.performAction(this.getActivatedNodes());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

