/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.actions;

import java.awt.Component;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JMenuItem;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.explorer.view.MenuView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

public class VcsMountFromTemplateAction
extends NodeAction {
    static final long serialVersionUID = 1537855553229904521L;
    private static final String ATTR_MNEMONIC = "VcsMountAction.mnemonic";
    private static Reference where = new WeakReference<Object>(null);
    private static TemplateWizard defaultWizard;
    private static Reference standardWizardRef;
    private static DataFolder targetFolder;
    private static DataFolder vcsFolder;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction$Cookie;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction;

    private static DataFolder getVCSFolder() {
        if (vcsFolder == null) {
            vcsFolder = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("Templates/Mount/VCS"));
        }
        return vcsFolder;
    }

    private static DataFolder getTargetFolder() {
        if (targetFolder == null) {
            targetFolder = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("Mount"));
        }
        return targetFolder;
    }

    static TemplateWizard getWizard(Node n) {
        TemplateWizard t;
        Cookie c;
        if (n == null) {
            DataFolder vcs = VcsMountFromTemplateAction.getVCSFolder();
            n = vcs.getNodeDelegate();
        }
        Cookie cookie = n == null ? null : (c = (Cookie)n.getCookie(class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction$Cookie == null ? (class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction$Cookie = VcsMountFromTemplateAction.class$("org.netbeans.modules.vcscore.actions.VcsMountFromTemplateAction$Cookie")) : class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction$Cookie));
        if (c != null && (t = c.getTemplateWizard()) != null) {
            return t;
        }
        if (defaultWizard == null) {
            defaultWizard = VcsMountFromTemplateAction.getStandardWizard();
        }
        return defaultWizard;
    }

    static TemplateWizard getStandardWizard() {
        TemplateWizard standardWizard;
        TemplateWizard templateWizard = standardWizard = standardWizardRef == null ? null : (TemplateWizard)standardWizardRef.get();
        if (standardWizard == null) {
            standardWizard = new TW();
            standardWizardRef = new SoftReference<TemplateWizard>(standardWizard);
        }
        standardWizard.setTemplatesFolder(VcsMountFromTemplateAction.getVCSFolder());
        standardWizard.setTargetFolder(VcsMountFromTemplateAction.getTargetFolder());
        return standardWizard;
    }

    protected void performAction(Node[] activatedNodes) {
        try {
            Node n = activatedNodes.length == 1 ? activatedNodes[0] : null;
            TemplateWizard wizard = VcsMountFromTemplateAction.getWizard(n);
            wizard.setTargetName(null);
            wizard.instantiate();
        }
        catch (IOException e) {
            ErrorManager em = ErrorManager.getDefault();
            Throwable e1 = em.annotate((Throwable)e, "Creating from template did not succeed.");
            em.notify(1, e1);
            String msg = e.getMessage();
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction == null ? (class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction = VcsMountFromTemplateAction.class$("org.netbeans.modules.vcscore.actions.VcsMountFromTemplateAction")) : class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction)).getString("CTL_MountActionName");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction == null ? (class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction = VcsMountFromTemplateAction.class$("org.netbeans.modules.vcscore.actions.VcsMountFromTemplateAction")) : class$org$netbeans$modules$vcscore$actions$VcsMountFromTemplateAction);
    }

    protected String iconResource() {
        return "org/netbeans/modules/vcscore/actions/mountNewVCS.gif";
    }

    public JMenuItem getMenuPresenter() {
        MountMenu menu = new MountMenu(VcsMountFromTemplateAction.getTemplateRoot(), new TemplateActionListener(), false, false);
        Actions.connect((JMenuItem)((Object)menu), (SystemAction)this, (boolean)false);
        return menu;
    }

    public Component getToolbarPresenter() {
        return new Actions.ToolbarButton((SystemAction)this){

            public void setEnabled(boolean e) {
                super.setEnabled(true);
            }
        };
    }

    public JMenuItem getPopupPresenter() {
        MountMenu menu = new MountMenu(VcsMountFromTemplateAction.getTemplateRoot(), new TemplateActionListener(), false, true);
        Actions.connect((JMenuItem)((Object)menu), (SystemAction)this, (boolean)true);
        return menu;
    }

    public static Node getTemplateRoot() {
        return VcsMountFromTemplateAction.getWizard(null).getTemplatesFolder().getNodeDelegate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class TW
    extends TemplateWizard
    implements FileSystem.AtomicAction {
        private Set retValue;

        private TW() {
        }

        protected synchronized Set handleInstantiate() throws IOException {
            Repository.getDefault().getDefaultFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
            return this.retValue;
        }

        public void run() throws IOException {
            this.retValue = super.handleInstantiate();
            Iterator it = this.retValue.iterator();
            while (it.hasNext()) {
                DataObject obj = (DataObject)it.next();
                DataFolder parent = obj.getFolder();
                ArrayList<DataObject> children = new ArrayList<DataObject>(Arrays.asList(parent.getChildren()));
                children.remove(obj);
                children.add(obj);
                parent.setOrder(children.toArray(new DataObject[0]));
            }
        }
    }

    private static class TemplateActionListener
    implements NodeAcceptor,
    DataFilter {
        static final long serialVersionUID = 4733270452576543255L;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        private TemplateActionListener() {
        }

        public boolean acceptNodes(Node[] nodes) {
            if (nodes == null || nodes.length != 1) {
                return false;
            }
            Node n = nodes[0];
            DataObject obj = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplateActionListener.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (obj == null || !obj.isTemplate()) {
                return false;
            }
            TemplateWizard wizard = VcsMountFromTemplateAction.getWizard(null);
            try {
                wizard.setTargetName(null);
                wizard.instantiate(obj, targetFolder);
            }
            catch (IOException e) {
                ErrorManager em = ErrorManager.getDefault();
                Throwable e1 = em.annotate((Throwable)e, "Creating from template did not succeed.");
                em.notify(1, e1);
                String msg = e.getMessage();
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
            }
            return true;
        }

        public boolean acceptDataObject(DataObject obj) {
            return obj.isTemplate() || obj instanceof DataFolder;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class MountMenu
    extends MenuView.Menu {
        private boolean popupMenu;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;
        static /* synthetic */ Class class$java$lang$ClassLoader;

        public MountMenu(Node node, NodeAcceptor action, boolean setName, boolean popupMenu) {
            super(node, action, setName);
            this.popupMenu = popupMenu;
        }

        protected JMenuItem createMenuItem(Node n) {
            JMenuItem item = super.createMenuItem(n);
            if (!this.popupMenu) {
                FileObject fo;
                String bundleName;
                String mnemonic = null;
                DataObject obj = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = MountMenu.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                if (obj != null && (bundleName = (String)(fo = obj.getPrimaryFile()).getAttribute(VcsMountFromTemplateAction.ATTR_MNEMONIC)) != null) {
                    try {
                        bundleName = Utilities.translate((String)bundleName);
                        ResourceBundle b = NbBundle.getBundle((String)bundleName, (Locale)Locale.getDefault(), (ClassLoader)((ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = MountMenu.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader)));
                        mnemonic = b.getString(fo.getPackageNameExt('/', '.') + "_m");
                    }
                    catch (MissingResourceException ex) {
                        // empty catch block
                    }
                }
                if (mnemonic != null && mnemonic.length() > 0) {
                    item.setMnemonic(mnemonic.charAt(0));
                }
            }
            return item;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static interface Cookie
    extends Node.Cookie {
        public TemplateWizard getTemplateWizard();
    }
}

