/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.actions;

import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vcscore.actions.GeneralCommandAction;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.modules.vcscore.versioning.VersioningRepository;
import org.netbeans.modules.vcscore.versioning.impl.VersioningExplorer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class VersioningExplorerAction
extends GeneralCommandAction {
    private static final long serialVersionUID = -4949229720968764504L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction;

    public String getName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction == null ? (class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction = VersioningExplorerAction.class$("org.netbeans.modules.vcscore.actions.VersioningExplorerAction")) : class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction), (String)"LBL_VersioningExplorer");
    }

    protected String iconResource() {
        return "org/netbeans/modules/vcscore/versioning/impl/versioningExplorer.gif";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected void performAction(Node[] nodes) {
        VersioningExplorer.Panel explorer = VersioningExplorer.getRevisionExplorer();
        explorer.open();
        HashMap filesByFS = this.getFilesByFS(nodes);
        if (Boolean.getBoolean("netbeans.vcsdebug")) {
            System.out.println("\nVersioningExplorer.performAction()");
            System.out.println("SELECTED NODES = " + new HashSet<Node>(Arrays.asList(nodes)));
            System.out.println("FILES BY FS (size = " + filesByFS.size() + "):");
            Iterator it = filesByFS.keySet().iterator();
            while (it.hasNext()) {
                String foPath = (String)it.next();
                String fsSystemName = (String)filesByFS.get(foPath);
                System.out.println("  file '" + foPath + "' from '" + fsSystemName + "'");
            }
            VersioningRepository repository = VersioningRepository.getRepository();
            List vfsl = repository.getVersioningFileSystems();
            System.out.println("\nList of versioning filesystems (size = " + vfsl.size() + "):");
            Iterator it2 = vfsl.iterator();
            while (it2.hasNext()) {
                VersioningFileSystem vfs = (VersioningFileSystem)it2.next();
                System.out.println(vfs + " with system name = '" + vfs.getSystemName() + "'");
            }
        }
        VersioningExplorerAction.selectVersioningFiles(explorer, filesByFS);
        explorer.requestFocus();
    }

    private HashMap getFilesByFS(Node[] nodes) {
        HashMap<String, String> filesByFS = new HashMap<String, String>();
        HashMap map = this.getSupporterMap(nodes);
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            Set foSet = (Set)it.next();
            FileObject[] origFos = new FileObject[foSet.size()];
            if (origFos == null || origFos.length == 0) continue;
            origFos = foSet.toArray(origFos);
            FileObject[] correctFos = VcsUtilities.convertFileObjects(origFos);
            int i = 0;
            while (i < correctFos.length) {
                FileObject fo = correctFos[i];
                try {
                    FileSystem fs = fo.getFileSystem();
                    if (fs != null) {
                        filesByFS.put(fo.getPackageNameExt('/', '.'), fs.getSystemName());
                    }
                }
                catch (FileStateInvalidException exc) {
                    // empty catch block
                }
                ++i;
            }
        }
        return filesByFS;
    }

    private Node[] getVersioningNodes(Map filesByFS) {
        VersioningRepository repository = VersioningRepository.getRepository();
        LinkedList<Node> nodes = new LinkedList<Node>();
        Iterator it = filesByFS.entrySet().iterator();
        while (it.hasNext()) {
            FileObject fo;
            Map.Entry entry = it.next();
            String fileName = (String)entry.getKey();
            String fsName = (String)entry.getValue();
            VersioningFileSystem vs = repository.getSystem(fsName);
            if (vs == null || (fo = vs.findResource(fileName)) == null) continue;
            try {
                nodes.add(DataObject.find((FileObject)fo).getNodeDelegate());
            }
            catch (DataObjectNotFoundException exc) {
                // empty catch block
            }
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    private static void selectVersioningFiles(ExplorerPanel explorer, Map filesByFS) {
        VersioningRepository repository = VersioningRepository.getRepository();
        final ExplorerManager manager = explorer.getExplorerManager();
        LinkedList<Node> nodes = new LinkedList<Node>();
        Iterator it = filesByFS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String fileName = (String)entry.getKey();
            String fsName = (String)entry.getValue();
            VersioningFileSystem vs = repository.getSystem(fsName);
            if (Boolean.getBoolean("netbeans.vcsdebug")) {
                System.out.println("Versioning FS of name '" + fsName + "' = " + vs);
            }
            if (vs == null) continue;
            FileObject fo = vs.findResource(fileName);
            if (Boolean.getBoolean("netbeans.vcsdebug")) {
                System.out.println("  resource of name '" + fileName + "' = " + fo);
            }
            if (fo == null) continue;
            Node fsRoot = manager.getRootContext().getChildren().findChild(vs.getSystemName());
            if (Boolean.getBoolean("netbeans.vcsdebug")) {
                System.out.println("  filesystem root = " + fsRoot);
            }
            nodes.add(VersioningExplorerAction.selectVersioningFile(explorer, fsRoot, fileName));
        }
        final Node[] nodeArray = nodes.toArray(new Node[nodes.size()]);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i = 0;
                while (i < nodeArray.length) {
                    manager.setExploredContext(nodeArray[i]);
                    ++i;
                }
                try {
                    manager.setSelectedNodes(nodeArray);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
    }

    private static Node selectVersioningFile(ExplorerPanel explorer, Node root, String fileName) {
        StringTokenizer files = new StringTokenizer(fileName, "/");
        Node node = root;
        while (files.hasMoreTokens()) {
            String file = files.nextToken();
            Node subNode = node.getChildren().findChild(file);
            if (subNode == null) break;
            node = subNode;
        }
        if (Boolean.getBoolean("netbeans.vcsdebug")) {
            System.out.println("  node for versioning file '" + fileName + "' = " + node);
        }
        return node;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

