/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.annotation.AnnotationProvider;

public class AnnotationSupport {
    public static final String ANNOTATION_PATTERN_FILE_NAME = "fileName";
    public static final String ANNOTATION_PATTERN_STATUS = "status";
    public static final String ANNOTATION_PATTERN_LOCKER = "locker";
    public static final String ANNOTATION_PATTERN_REVISION = "revision";
    public static final String ANNOTATION_PATTERN_STICKY = "sticky";
    public static final String ANNOTATION_PATTERN_ATTR = "attribute";
    public static final String ANNOTATION_PATTERN_SIZE = "size";
    public static final String ANNOTATION_PATTERN_DATE = "date";
    public static final String ANNOTATION_PATTERN_TIME = "time";
    public static final int MULTI_FILES_ANNOTATION_EMPTY = 0;
    private static final Integer MULTI_FILES_PATT_ANN_EMPTY = new Integer(0);
    public static final int MULTI_FILES_ANNOTATION_LIST = 1;
    private static final Integer MULTI_FILES_PATT_ANN_LIST = new Integer(1);
    public static final int MULTI_FILES_ANNOTATION_NOT_SYNCH_ATTR = 2;
    private static final Integer MULTI_FILES_PATT_ANN_NOT_SYNCH = new Integer(2);
    private HashMap annotationPatterns = new HashMap();
    private static AnnotationSupport instance = null;

    private AnnotationSupport() {
    }

    public static AnnotationSupport getInstance() {
        if (instance == null) {
            instance = new AnnotationSupport();
        }
        return instance;
    }

    public PatternType registerPatternType(String id) {
        PatternType pattType = (PatternType)this.annotationPatterns.get(id);
        if (pattType == null) {
            pattType = new PatternType(id);
            this.annotationPatterns.put(id, pattType);
        }
        return pattType;
    }

    public void unregisterPatternType(String id) {
        Object v = this.annotationPatterns.remove(id);
    }

    public String getStatusAnnotation(String name, String fullName, AnnotationProvider statusProvider, String annTypeId) {
        return this.getStatusAnnotation(name, fullName, statusProvider, null, annTypeId);
    }

    public String getStatusAnnotation(String name, String fullName, AnnotationProvider statusProvider, Hashtable additionalVars, String annTypeId) {
        PatternType patternType = (PatternType)this.annotationPatterns.get(annTypeId);
        if (patternType == null) {
            System.out.println("error.");
            return name;
        }
        String annotationPattern = patternType.getStringPattern();
        Hashtable<String, String> vars = new Hashtable<String, String>();
        if (additionalVars != null) {
            vars.putAll(additionalVars);
        }
        vars.put(ANNOTATION_PATTERN_FILE_NAME, name);
        String[] pattArray = patternType.getPatternsAsArray();
        int j = 0;
        while (j < pattArray.length) {
            String pat = pattArray[j];
            if (!pat.equals(ANNOTATION_PATTERN_FILE_NAME)) {
                int patIndex = patternType.getPatternIndex(pat);
                String delimOrSynch = patternType.getMultiFileDelimiterAt(patIndex);
                int multiFileAnn = patternType.getMultiFileAnnotationAt(patIndex);
                String status = statusProvider.getAttributeValue(fullName, pat);
                if (status != null) {
                    vars.put(pat, status);
                }
            }
            ++j;
        }
        return Variables.expand(vars, annotationPattern, false);
    }

    public String getStatusAnnotation(String name, ArrayList files, AnnotationProvider statusProvider, String annTypeId) {
        PatternType patternType = (PatternType)this.annotationPatterns.get(annTypeId);
        if (patternType == null) {
            System.out.println("error.");
            return name;
        }
        String annotationPattern = patternType.getStringPattern();
        Hashtable<String, String> vars = new Hashtable<String, String>();
        ArrayList<String> attributes = new ArrayList<String>();
        int n = files.size();
        if (n == 0) {
            return name;
        }
        vars.put(ANNOTATION_PATTERN_FILE_NAME, name);
        Object trans = null;
        String[] pattArray = patternType.getPatternsAsArray();
        int j = 0;
        while (j < pattArray.length) {
            attributes.clear();
            String pat = pattArray[j];
            if (!pat.equals(ANNOTATION_PATTERN_FILE_NAME)) {
                int patIndex = patternType.getPatternIndex(pat);
                String delimOrSynch = patternType.getMultiFileDelimiterAt(patIndex);
                int multiFileAnn = patternType.getMultiFileAnnotationAt(patIndex);
                int i = 0;
                while (i < n) {
                    String value = statusProvider.getAttributeValue((String)files.get(i), pat);
                    attributes.add(value);
                    ++i;
                }
                String attr = AnnotationSupport.getAttribute(attributes, multiFileAnn, delimOrSynch);
                if (attr != null) {
                    vars.put(pat, attr);
                }
            }
            ++j;
        }
        return Variables.expand(vars, annotationPattern, false);
    }

    private static String getAttribute(ArrayList attributes, int annotationType, String nSynch) {
        Object firstObj = attributes.get(0);
        if (firstObj == null) {
            return null;
        }
        String first = (String)firstObj;
        int n = attributes.size();
        int i = 1;
        i = 1;
        while (i < n) {
            if (!firstObj.equals(attributes.get(i))) break;
            ++i;
        }
        boolean differ = i < n;
        switch (annotationType) {
            case 0: {
                if (differ) {
                    return "";
                }
                return first;
            }
            case 2: {
                if (differ) {
                    return nSynch;
                }
                return first;
            }
            case 1: {
                if (!differ) {
                    return first;
                }
                StringBuffer buf = new StringBuffer(first);
                int j = 1;
                while (j < n) {
                    buf.append(nSynch + (String)attributes.get(j));
                    ++j;
                }
                return buf.toString();
            }
        }
        return "";
    }

    public class PatternType {
        private String stringPattern;
        private String id;
        private List patternList;
        private List multiFileList;
        private List multiDelimitList;

        PatternType(String id) {
            this.id = id;
            this.patternList = new ArrayList();
            this.multiFileList = new ArrayList();
            this.multiDelimitList = new ArrayList();
        }

        public String getStringPattern() {
            return this.stringPattern;
        }

        public void setStringPattern(String stringPattern) {
            this.stringPattern = stringPattern;
        }

        public synchronized void addMultiEmptyPattern(String patternName) {
            this.patternList.add(patternName);
            this.multiFileList.add(MULTI_FILES_PATT_ANN_EMPTY);
            this.multiDelimitList.add("");
        }

        public synchronized void addMultiListPattern(String patternName, String multiPatternDelimiter) {
            this.patternList.add(patternName);
            this.multiFileList.add(MULTI_FILES_PATT_ANN_LIST);
            this.multiDelimitList.add(multiPatternDelimiter);
        }

        public synchronized void addMultiSynchPattern(String patternName, String synchLabel) {
            this.patternList.add(patternName);
            this.multiFileList.add(MULTI_FILES_PATT_ANN_NOT_SYNCH);
            this.multiDelimitList.add(synchLabel);
        }

        public synchronized void removePattern(String patternName) {
            int count = this.patternList.size();
            int i = 0;
            while (i < count) {
                String patt = this.patternList.get(i).toString();
                if (patt.equals(patternName)) {
                    this.patternList.remove(i);
                    this.multiFileList.remove(i);
                    this.multiDelimitList.remove(i);
                    return;
                }
                ++i;
            }
        }

        public synchronized boolean hasPattern(String patternName) {
            return true;
        }

        public String[] getPatternsAsArray() {
            String[] arr = new String[this.patternList.size()];
            arr = this.patternList.toArray(arr);
            return arr;
        }

        int getPatternIndex(String pattern) {
            return this.patternList.indexOf(pattern);
        }

        String getMultiFileDelimiterAt(int index) {
            return (String)this.multiDelimitList.get(index);
        }

        int getMultiFileAnnotationAt(int index) {
            return (Integer)this.multiFileList.get(index);
        }

        public String getId() {
            return this.id;
        }
    }
}

