/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.lang.ref.Reference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.CacheReference;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.ErrorManager;

public abstract class CacheDir
extends CacheFile {
    private int strategy;
    protected File dirFile;
    private boolean modified = false;
    private Map childDirs = null;
    private Map childFiles;
    protected FileSystemCache cacheObject;
    private ArrayList ignoreList;
    private boolean ignoreListWasSet = false;
    private RE regExp;
    private Object ignoreLock = new Object();
    protected final Object CHILD_FILES_LOCK;
    private Object createIgnoreListLock = new Object();

    public CacheDir(String cacheName, File dirFile, CacheFile.PersistentData data) {
        super(cacheName, data);
        this.setAppliedLevel(-1);
        this.childFiles = new HashMap(20);
        this.childDirs = new HashMap(10);
        this.CHILD_FILES_LOCK = this.childFiles;
        this.modified = false;
        this.dirFile = dirFile;
        this.setName(dirFile.getName());
        this.cacheObject = CacheHandler.getInstance().getCache(this.getCacheName());
    }

    protected final void addChildNames(String[] fileNames, String[] dirNames) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            int i = 0;
            while (i < fileNames.length) {
                if (!this.childFiles.containsKey(fileNames[i])) {
                    this.childFiles.put(fileNames[i], this.createReference(null));
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < dirNames.length) {
                if (!this.childDirs.containsKey(dirNames[i2])) {
                    this.childDirs.put(dirNames[i2], this.createReference(null));
                }
                ++i2;
            }
        }
    }

    public CacheDir[] getSubDirs() {
        LinkedList<CacheDir> col = new LinkedList<CacheDir>();
        CacheHandler handler = CacheHandler.getInstance();
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Iterator it = ((AbstractList)new ArrayList(this.childDirs.keySet())).iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                Reference rDir = (Reference)this.childDirs.get(name);
                CacheDir cDir = (CacheDir)rDir.get();
                if (cDir == null) {
                    CacheFile.PersistentData data = handler.getReferencedData(rDir);
                    cDir = data != null ? (CacheDir)this.createChildFromData(data) : this.readDirFromDisk(name);
                    cDir.setParent(this);
                    this.childDirs.put(name, this.createReference(cDir));
                }
                col.add(cDir);
            }
        }
        return col.toArray(new CacheDir[col.size()]);
    }

    public String[] getSubDirNames() {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            String[] stringArray = this.childDirs.keySet().toArray(new String[0]);
            return stringArray;
        }
    }

    public CacheDir getSubDir(String name) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Reference rDir = (Reference)this.childDirs.get(name);
            if (rDir == null) {
                CacheDir cacheDir = null;
                return cacheDir;
            }
            CacheDir cDir = (CacheDir)rDir.get();
            if (cDir == null) {
                CacheFile.PersistentData data = CacheHandler.getInstance().getReferencedData(rDir);
                cDir = data != null ? (CacheDir)this.createChildFromData(data) : this.readDirFromDisk(name);
                cDir.setParent(this);
                this.childDirs.put(name, this.createReference(cDir));
                this.getCacheObject().registerDir(cDir);
            }
            CacheDir cacheDir = cDir;
            return cacheDir;
        }
    }

    protected CacheDir getSubDirIfExists(String name) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Reference rDir = (Reference)this.childDirs.get(name);
            if (rDir == null) {
                CacheDir cacheDir = null;
                return cacheDir;
            }
            CacheDir cacheDir = (CacheDir)rDir.get();
            return cacheDir;
        }
    }

    public CacheDir addChildDir(CacheDir subDir, boolean fireEvent) {
        CacheDir dir = this.getCacheObject().getDir(subDir.getAbsolutePath());
        if (dir != null && dir.getCacheName().equals(this.getCacheName())) {
            subDir = dir;
        } else {
            this.getCacheObject().registerDir(subDir);
        }
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            this.setModifiedContent(true);
            this.childDirs.put(subDir.getName(), this.createReference(subDir));
            subDir.setParent(this);
        }
        if (fireEvent) {
            this.getCacheObject().fireCacheHandlerEvent(0, subDir);
        }
        return subDir;
    }

    public void removeChildDir(String subdirName, boolean fireEvent) {
        CacheDir subDir = this.getSubDir(subdirName);
        if (subDir != null) {
            Object object = this.CHILD_FILES_LOCK;
            synchronized (object) {
                this.setModifiedContent(true);
                this.childDirs.remove(subDir.getName());
            }
            this.getCacheObject().unregisterDir(subDir);
            if (fireEvent) {
                this.getCacheObject().fireCacheHandlerEvent(1, subDir);
            }
            subDir.setParent(null);
            subDir.setModifiedContent(false);
            subDir.getPersistentData().setModified(false);
        }
    }

    public void renameChild(String oldName, String newName, boolean fireEvent) {
        CacheFile file = this.getFile(oldName);
        if (file != null) {
            Object object = this.CHILD_FILES_LOCK;
            synchronized (object) {
                file.setName(newName);
                this.childFiles.put(newName, this.childFiles.remove(oldName));
            }
        } else {
            CacheDir dir = this.getSubDir(oldName);
            if (dir != null) {
                Object object = this.CHILD_FILES_LOCK;
                synchronized (object) {
                    this.getCacheObject().unregisterDir(dir);
                    dir.setName(newName);
                    this.childDirs.remove(oldName);
                    this.childDirs.put(newName, this.createReference(dir));
                    this.getCacheObject().registerDir(dir);
                }
            } else {
                fireEvent = false;
            }
        }
        if (fireEvent) {
            this.getCacheObject().fireCacheHandlerEvent(2, this);
        }
    }

    public void renameChildDirs(CacheDir newParent, boolean fireEvent) {
        CacheDir[] dirs = this.getSubDirs();
        int index = 0;
        while (index < dirs.length) {
            CacheDir childDir = dirs[index];
            this.removeChildDir(childDir.getName(), fireEvent);
            childDir.rename(new File(newParent.getAbsolutePath() + File.separator + childDir.getName()));
            newParent.addChildDir(childDir, fireEvent);
            childDir.renameChildDirs(childDir, false);
            ++index;
        }
    }

    public void rename(File newLocation) {
        this.getCacheObject().unregisterDir(this);
        this.dirFile = newLocation;
        this.setName(this.dirFile.getName());
        this.getCacheObject().registerDir(this);
    }

    public CacheFile[] getFiles() {
        LinkedList<CacheFile> col = new LinkedList<CacheFile>();
        CacheHandler handler = CacheHandler.getInstance();
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Iterator it = ((AbstractList)new ArrayList(this.childFiles.keySet())).iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                Reference rFile = (Reference)this.childFiles.get(name);
                CacheFile cFile = (CacheFile)rFile.get();
                if (cFile == null) {
                    CacheFile.PersistentData data = handler.getReferencedData(rFile);
                    cFile = data != null ? this.createChildFromData(data) : this.readFileFromDisk(name);
                    cFile.setParent(this);
                    this.childFiles.put(name, this.createReference(cFile));
                }
                col.add(cFile);
            }
        }
        return col.toArray(new CacheFile[col.size()]);
    }

    public String[] getFileNames() {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            String[] stringArray = this.childFiles.keySet().toArray(new String[0]);
            return stringArray;
        }
    }

    public String[] getDirNames() {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            String[] stringArray = this.childDirs.keySet().toArray(new String[0]);
            return stringArray;
        }
    }

    public CacheFile getFile(String name) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Reference rFile = (Reference)this.childFiles.get(name);
            if (rFile == null) {
                CacheFile cacheFile = null;
                return cacheFile;
            }
            CacheFile cFile = (CacheFile)rFile.get();
            if (cFile == null) {
                CacheFile.PersistentData data = CacheHandler.getInstance().getReferencedData(rFile);
                cFile = data != null ? this.createChildFromData(data) : this.readFileFromDisk(name);
                cFile.setParent(this);
                this.childFiles.put(name, this.createReference(cFile));
            }
            CacheFile cacheFile = cFile;
            return cacheFile;
        }
    }

    protected CacheFile getFileIfExists(String name) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Reference rFile = (Reference)this.childFiles.get(name);
            if (rFile == null) {
                CacheFile cacheFile = null;
                return cacheFile;
            }
            CacheFile cacheFile = (CacheFile)rFile.get();
            return cacheFile;
        }
    }

    public void addFile(CacheFile fl, boolean fireEvent) {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            this.setModifiedContent(true);
            this.childFiles.put(fl.getName(), this.createReference(fl));
            fl.setParent(this);
        }
        if (fireEvent) {
            this.getCacheObject().fireCacheHandlerEvent(0, fl);
        }
    }

    public void removeFile(String flName, boolean fireEvent) {
        CacheFile fl = this.getFile(flName);
        if (fl != null) {
            Object object = this.CHILD_FILES_LOCK;
            synchronized (object) {
                this.setModifiedContent(true);
                this.childFiles.remove(flName);
            }
            if (fireEvent) {
                this.getCacheObject().fireCacheHandlerEvent(1, fl);
            }
            fl.setParent(null);
            fl.getPersistentData().setModified(false);
        }
    }

    public void removeFiles() {
        Object object = this.CHILD_FILES_LOCK;
        synchronized (object) {
            Iterator it = this.childFiles.values().iterator();
            while (it.hasNext()) {
                Reference ref = (Reference)it.next();
                CacheFile file = (CacheFile)ref.get();
                if (file == null) continue;
                file.setParent(null);
            }
            if (this.childFiles.size() > 0) {
                this.setModifiedContent(true);
            }
            this.childFiles.clear();
        }
    }

    public void removeAll(boolean recursively) {
        this.removeFiles();
        CacheDir[] dirs = this.getSubDirs();
        int i = 0;
        while (i < dirs.length) {
            if (recursively) {
                dirs[i].removeAll(true);
            }
            this.removeChildDir(dirs[i].getName(), false);
            ++i;
        }
    }

    protected abstract CacheFile createChildFromData(CacheFile.PersistentData var1);

    public final void setAppliedLevel(int strat) {
        this.strategy = strat;
    }

    public final int getAppliedLevel() {
        return this.strategy;
    }

    public String getName() {
        return this.dirFile.getName();
    }

    public void setName(String name) {
        super.setName(name);
        File parent = this.dirFile.getParentFile();
        if (parent != null) {
            this.dirFile = new File(parent, name);
        }
    }

    public String getAbsolutePath() {
        return this.dirFile.getAbsolutePath();
    }

    public String getFilePath() {
        return this.dirFile.getPath();
    }

    public String toString() {
        return this.getName();
    }

    public final void setModifiedContent(boolean modified) {
        this.modified = modified;
    }

    public boolean isEmpty() {
        return this.childDirs.size() == 0 && this.childFiles.size() == 0;
    }

    public final boolean isLocal() {
        return this.getPersistentData().isLocal();
    }

    public final void setLocal(boolean local) {
        this.getPersistentData().setLocal(local);
    }

    public FileSystemCache getCacheObject() {
        return this.cacheObject;
    }

    protected abstract String getCacheFileName();

    public void writeToDiskRecursively() {
        this.writeToDisk();
        CacheDir[] dirs = this.getSubDirs();
        int i = 0;
        while (i < dirs.length) {
            dirs[i].writeToDiskRecursively();
            ++i;
        }
    }

    public final void setIgnoreList(ArrayList ignoreList) {
        Object object = this.ignoreLock;
        synchronized (object) {
            this.ignoreList = ignoreList;
            this.regExp = null;
            this.ignoreListWasSet = true;
        }
        this.getCacheObject().fireCacheHandlerEvent(4, this);
    }

    public final ArrayList getIgnoreList() {
        return this.ignoreList;
    }

    public final boolean isIgnoreListSet() {
        return this.ignoreListWasSet;
    }

    protected void createIgnoreList() {
    }

    public final boolean isIgnored(String name) {
        Object object;
        if (!this.isIgnoreListSet()) {
            object = this.createIgnoreListLock;
            synchronized (object) {
                this.createIgnoreList();
            }
        }
        object = this.ignoreLock;
        synchronized (object) {
            if (this.ignoreList == null) {
                boolean bl = false;
                return bl;
            }
            if (this.regExp == null) {
                String unionExp = CacheDir.computeRegularExpressionFromIgnoreList(this.ignoreList);
                try {
                    this.regExp = new RE(unionExp);
                }
                catch (RESyntaxException malformedRE) {
                    try {
                        this.regExp = new RE("");
                    }
                    catch (RESyntaxException innerMalformedRE) {
                        // empty catch block
                    }
                }
            }
            try {
                boolean unionExp = this.regExp.match(name);
                return unionExp;
            }
            catch (StringIndexOutOfBoundsException sioofex) {
                throw (StringIndexOutOfBoundsException)ErrorManager.getDefault().annotate((Throwable)sioofex, "If this exception happens to you, please add this debugging message to the issue #19481:\nthe ignore list = " + this.ignoreListToString() + "\n" + "regular expression = " + CacheDir.computeRegularExpressionFromIgnoreList(this.ignoreList) + "\n" + "regular expression compiled = " + new String(this.regExp.getProgram().getInstructions()) + "\n" + "match(" + name + ")");
            }
        }
    }

    private String ignoreListToString() {
        if (this.ignoreList == null) {
            return "null";
        }
        StringBuffer list = new StringBuffer();
        int i = 0;
        while (i < this.ignoreList.size()) {
            list.append("'" + this.ignoreList.get(i) + "', ");
            ++i;
        }
        return list.toString();
    }

    private static String computeRegularExpressionFromIgnoreList(List ignoreList) {
        StringBuffer unionExp = new StringBuffer();
        int i = 0;
        while (i < ignoreList.size()) {
            if (i != 0) {
                unionExp.append("|");
            }
            StringBuffer regEntry = new StringBuffer((String)ignoreList.get(i));
            int j = 0;
            while (j < regEntry.length()) {
                switch (regEntry.charAt(j)) {
                    case '.': {
                        regEntry = regEntry.replace(j, j + 1, "\\.");
                        ++j;
                        break;
                    }
                    case '*': {
                        regEntry = regEntry.replace(j, j + 1, ".*");
                        ++j;
                        break;
                    }
                    case '$': {
                        regEntry = regEntry.replace(j, j + 1, "\\$");
                        ++j;
                        break;
                    }
                    case '\\': {
                        regEntry = regEntry.replace(j, j + 1, "\\\\");
                        ++j;
                        break;
                    }
                    case '+': {
                        regEntry = regEntry.replace(j, j + 1, "\\+");
                        ++j;
                        break;
                    }
                    case '?': {
                        regEntry = regEntry.replace(j, j + 1, "\\?");
                        ++j;
                        break;
                    }
                    case '^': {
                        regEntry = regEntry.replace(j, j + 1, "\\^");
                        ++j;
                        break;
                    }
                    case '|': {
                        regEntry = regEntry.replace(j, j + 1, "\\|");
                        ++j;
                        break;
                    }
                }
                ++j;
            }
            unionExp.append(regEntry.toString());
            ++i;
        }
        unionExp.insert(0, "^(");
        unionExp.append(")$");
        return unionExp.toString();
    }

    private Reference createReference(CacheFile cFile) {
        CacheHandler handler = CacheHandler.getInstance();
        CacheReference ref = new CacheReference(cFile, handler.getCacheFileReferenceQueue(), null, null);
        if (cFile != null) {
            handler.addReferencedData(ref, cFile.getPersistentData());
        }
        return ref;
    }

    public abstract void writeToDisk();

    public abstract void populateWithLocal(Object var1);

    public abstract boolean readFromDisk(Object var1);

    protected abstract CacheFile readFileFromDisk(String var1);

    protected abstract CacheDir readDirFromDisk(String var1);

    public abstract void checkServer(Object var1);

    public abstract void checkServerRecursive(Object var1);
}

