/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.vcscore.cache.CacheDir;

public class CacheFile {
    private PersistentData data;
    protected String parentCache;
    private CacheDir parent;

    public CacheFile(String memberOfCache, PersistentData data) {
        this.setCacheName(memberOfCache);
        this.data = data;
    }

    public CacheFile(String memberOfCache, String name, PersistentData data) {
        this(memberOfCache, data);
        data.setName(name);
    }

    public final PersistentData getPersistentData() {
        return this.data;
    }

    protected void setParent(CacheDir par) {
        this.parent = par;
    }

    public CacheDir getParent() {
        return this.parent;
    }

    public String getName() {
        return this.data.getName();
    }

    public void setName(String name) {
        this.data.setName(name);
    }

    public boolean isLocal() {
        return this.data.isLocal();
    }

    public String getStatus() {
        return this.data.getStatus();
    }

    public void setStatus(String status) {
        this.data.setStatus(status);
    }

    public String getRevision() {
        return this.data.getRevision();
    }

    public void setRevision(String revision) {
        this.data.setRevision(revision);
    }

    public String getSticky() {
        return this.data.getSticky();
    }

    public void setSticky(String sticky) {
        this.data.setSticky(sticky);
    }

    public String getDate() {
        return this.data.getDate();
    }

    public void setDate(String date) {
        this.data.setDate(date);
    }

    public String getTime() {
        return this.data.getTime();
    }

    public void setTime(String time) {
        this.data.setTime(time);
    }

    public String getLocker() {
        return this.data.getLocker();
    }

    public void setLocker(String locker) {
        this.data.setLocker(locker);
    }

    public String getAttr() {
        return this.data.getAttr();
    }

    public void setAttr(String attr) {
        this.data.setAttr(attr);
    }

    public int getSize() {
        return this.data.getSize();
    }

    public void setSize(int size) {
        this.data.setSize(size);
    }

    public String getCacheName() {
        return this.parentCache;
    }

    public void setCacheName(String cacheName) {
        this.parentCache = cacheName;
    }

    public String getAbsolutePath() {
        if (this.parent != null) {
            return this.parent.getAbsolutePath() + File.separator + this.data.getName();
        }
        return null;
    }

    protected static abstract class PersistentData {
        private boolean directory;
        private String name = "";
        private String status = "";
        private String locker = "";
        private String revision = "";
        private String sticky = "";
        private String attr = "";
        private String date = "";
        private String time = "";
        private int size = 0;
        private boolean modified = false;
        private boolean local = false;

        public PersistentData(boolean directory) {
            this.directory = directory;
        }

        public final void writeToDisk() throws IOException {
            if (this.isModified()) {
                this.doWriteToDisk();
                this.setModified(false);
            }
        }

        protected abstract void doWriteToDisk() throws IOException;

        public final boolean isDirectory() {
            return this.directory;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            if (!this.name.equals(name)) {
                this.setModified(true);
                this.name = name;
            }
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            if (this.status == null && status != null || this.status != null && !this.status.equals(status)) {
                this.setModified(true);
                this.status = status;
            }
        }

        public final String getLocker() {
            return this.locker;
        }

        public final void setLocker(String locker) {
            if (this.locker == null && locker != null || this.locker != null && !this.locker.equals(locker)) {
                this.setModified(true);
                this.locker = locker;
            }
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            if (this.revision == null && revision != null || this.revision != null && !this.revision.equals(revision)) {
                this.setModified(true);
                this.revision = revision;
            }
        }

        public final String getSticky() {
            return this.sticky;
        }

        public final void setSticky(String sticky) {
            if (this.sticky == null && sticky != null || this.sticky != null && !this.sticky.equals(sticky)) {
                this.setModified(true);
                this.sticky = sticky;
            }
        }

        public final String getAttr() {
            return this.attr;
        }

        public final void setAttr(String attr) {
            if (this.attr == null && attr != null || this.attr != null && !this.attr.equals(attr)) {
                this.setModified(true);
                this.attr = attr;
            }
        }

        public final String getDate() {
            return this.date;
        }

        public final void setDate(String date) {
            if (this.date == null && date != null || this.date != null && !this.date.equals(date)) {
                this.setModified(true);
                this.date = date;
            }
        }

        public final String getTime() {
            return this.time;
        }

        public final void setTime(String time) {
            if (this.time == null && time != null || this.time != null && !this.time.equals(time)) {
                this.setModified(true);
                this.time = time;
            }
        }

        public final int getSize() {
            return this.size;
        }

        public final void setSize(int size) {
            if (this.size != size) {
                this.setModified(true);
                this.size = size;
            }
        }

        public final boolean isModified() {
            return this.modified;
        }

        public final void setModified(boolean modified) {
            this.modified = modified;
        }

        public final boolean isLocal() {
            return this.local;
        }

        public final void setLocal(boolean local) {
            this.local = local;
        }

        public String toString() {
            return (this.directory ? "DIR[" : "FILE[") + this.name + ", " + (this.modified ? "MODIFIED, " : "NON-MODIFIED, ") + this.status + ", " + this.locker + ", " + this.revision + ", " + this.sticky + ", " + this.attr + ", " + this.date + ", " + this.time + ", " + this.size + "]" + (this.isLocal() ? " IS LOCAL." : " NON Local");
        }
    }
}

