/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheReference;
import org.netbeans.modules.vcscore.cache.CachedFileSystem;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.openide.util.Utilities;

public class CacheHandler {
    public static final int STRAT_LOCAL = 0;
    public static final int STRAT_DISK = 3;
    public static final int STRAT_NONE = -1;
    public static final int STRAT_REFRESH = 11;
    public static final int STRAT_REFRESH_RECURS = 12;
    public static final int STRAT_REFRESHING = 10;
    public static final int STRAT_DISK_AND_LOCAL_REFRESH = 4;
    public static final int STRAT_DISK_OR_REFRESH = 5;
    public static final int STRAT_DISK_OR_REFRESH_RECURS = 6;
    private static CacheHandler instance = null;
    private ArrayList listeners = new ArrayList();
    private Map cacheMap = new Hashtable();
    private Map persistentData = new Hashtable();
    private ReferenceQueue cacheQueue;
    private Map cacheFilesHolder = Collections.synchronizedMap(new WeakHashMap());

    private CacheHandler() {
        this.cacheQueue = Utilities.activeReferenceQueue();
    }

    public static synchronized CacheHandler getInstance() {
        if (instance == null) {
            instance = new CacheHandler();
        }
        return instance;
    }

    ReferenceQueue getCacheFileReferenceQueue() {
        return this.cacheQueue;
    }

    void addReferencedData(Reference ref, CacheFile.PersistentData data) {
        this.persistentData.put(ref, data);
    }

    CacheFile.PersistentData getReferencedData(Reference ref) {
        return (CacheFile.PersistentData)this.persistentData.get(ref);
    }

    void removeReferencedData(Reference ref) {
        this.persistentData.remove(ref);
    }

    public Reference createReference(Object obj, File file, String cacheId) {
        CacheFile cFile = this.getCacheFile(file, -1, cacheId);
        if (cFile != null) {
            this.addCacheLocker(obj, cFile);
        }
        CacheReference ref = new CacheReference(obj, this.cacheQueue, file, cacheId);
        return ref;
    }

    public final void addCacheLocker(Object lock, CacheFile file) {
        if (lock == null) {
            return;
        }
        HashSet<CacheFile> s = (HashSet<CacheFile>)this.cacheFilesHolder.get(lock);
        if (s == null) {
            s = new HashSet<CacheFile>();
            this.cacheFilesHolder.put(lock, s);
        }
        s.add(file);
    }

    public final void removeCacheLocker(Object lock, CacheFile file) {
        Set s = (Set)this.cacheFilesHolder.get(lock);
        if (s != null) {
            s.remove(file);
            if (s.isEmpty()) {
                this.cacheFilesHolder.remove(lock);
            }
        }
    }

    public CacheFile getCacheFile(File toFind, int strategy, CachedFileSystem cacheFs) {
        return this.getCacheFile(toFind, strategy, cacheFs.getCacheId());
    }

    public CacheFile getCacheFile(File toFind, int strategy, String type) {
        return this.getCacheFile(toFind, strategy, type, null);
    }

    public CacheFile getCacheFile(File toFind, int strategy, String type, Object locker) {
        FileSystemCache cache = this.getCache(type);
        if (cache == null) {
            return null;
        }
        return cache.getCacheFile(toFind, strategy, locker);
    }

    public void registerCacheType(String type, FileSystemCache cacheObject) {
        this.cacheMap.put(type, cacheObject);
    }

    public void unregistedType(String type) {
        this.cacheMap.remove(type);
    }

    public FileSystemCache getCache(CachedFileSystem type) {
        FileSystemCache cache = (FileSystemCache)this.cacheMap.get(type.getCacheId());
        return cache;
    }

    public FileSystemCache getCache(String type) {
        FileSystemCache cache = (FileSystemCache)this.cacheMap.get(type);
        return cache;
    }

    public void uninstall() {
        if (this.cacheMap != null) {
            Iterator it = this.cacheMap.values().iterator();
            while (it.hasNext()) {
                FileSystemCache cch = (FileSystemCache)it.next();
                cch.removeAllListeners();
            }
            this.cacheMap.clear();
            this.cacheMap = null;
        }
        instance = null;
    }
}

