/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.util.Collections;
import java.util.EventObject;
import java.util.Set;
import org.netbeans.modules.vcscore.cache.CacheFile;

public class CacheHandlerEvent
extends EventObject {
    private boolean recursive = false;
    private boolean ignoreList = false;
    private static final long serialVersionUID = 385684866008914174L;

    public CacheHandlerEvent(CacheFile cacheFile) {
        this(cacheFile, false);
    }

    public CacheHandlerEvent(CacheFile cacheFile, boolean recursive) {
        this(cacheFile, recursive, false);
    }

    public CacheHandlerEvent(CacheFile cacheFile, boolean recursive, boolean ignoreList) {
        super(cacheFile);
        this.recursive = recursive;
        this.ignoreList = ignoreList;
    }

    public CacheHandlerEvent(Set cacheFiles) {
        this(cacheFiles, false);
    }

    public CacheHandlerEvent(Set cacheFiles, boolean recursive) {
        this(cacheFiles, recursive, false);
    }

    public CacheHandlerEvent(Set cacheFiles, boolean recursive, boolean ignoreList) {
        super(Collections.unmodifiableSet(cacheFiles));
        this.recursive = recursive;
        this.ignoreList = ignoreList;
    }

    public CacheFile getCacheFile() {
        Object source = this.getSource();
        if (source instanceof CacheFile) {
            return (CacheFile)source;
        }
        Set sources = (Set)source;
        if (sources.size() > 0) {
            return (CacheFile)sources.iterator().next();
        }
        return null;
    }

    public Set getCacheFiles() {
        Object source = this.getSource();
        if (source instanceof Set) {
            return (Set)source;
        }
        return Collections.singleton(source);
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isIgnoreListChange() {
        return this.ignoreList;
    }
}

