/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.openide.ErrorManager;

public class CacheReference
extends WeakReference
implements Runnable {
    private File cacheFile;
    private String name;
    private boolean important;
    private boolean virtual;

    public CacheReference(Object referent, ReferenceQueue q, File file, String cacheName) {
        super(referent, q);
        this.cacheFile = file;
        this.name = cacheName;
        this.important = true;
        this.virtual = false;
    }

    public File getCacheFile() {
        return this.cacheFile;
    }

    public String getCacheName() {
        return this.name;
    }

    public void markUnimportant() {
        this.important = false;
    }

    public void markImportant() {
        this.important = true;
    }

    public boolean isImportant() {
        return this.important;
    }

    public void setVirtual(boolean virt) {
        this.virtual = virt;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void run() {
        CacheHandler handler = CacheHandler.getInstance();
        CacheFile.PersistentData data = handler.getReferencedData(this);
        if (data != null) {
            try {
                data.writeToDisk();
            }
            catch (IOException ioex) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)ioex, "Data can not be written to the disk cache."));
            }
            handler.removeReferencedData(this);
        }
    }
}

